/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.Referencia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ArquivoComplementarVazioException;
import br.gov.rs.tce.pad.excecao.ArquivoContabilNaoEncontradoException;
import br.gov.rs.tce.pad.excecao.ArquivoVazioException;
import br.gov.rs.tce.pad.excecao.CNPJInvalidoException;
import br.gov.rs.tce.pad.excecao.ChaveEstrangeiraException;
import br.gov.rs.tce.pad.excecao.ChavePrimariaException;
import br.gov.rs.tce.pad.excecao.FinalizadorException;
import br.gov.rs.tce.pad.excecao.FormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.ImportacaoException;
import br.gov.rs.tce.pad.excecao.LinhaFormatoInvalidoException;
import br.gov.rs.tce.pad.excecao.NumeroMaximoMensagemException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.importacao.ArquivoContabilReader;
import br.gov.rs.tce.pad.modelo.importacao.BaseRepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.DadosArquivoFactory;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoArquivoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.importacao.RepositorioArquivosControle;
import br.gov.rs.tce.pad.modelo.mensagem.MensagemFactory;
import br.gov.rs.tce.pad.modelo.verificacao.ExecutorRegras;
import br.gov.rs.tce.pad.modelo.verificacao.Regra;
import br.gov.rs.tce.pad.util.ImportacaoHelper;
import br.gov.rs.tce.pad.util.ProcessaArquivoHelper;
import br.gov.rs.tce.pad.util.PropertiesUtil;
import br.gov.rs.tce.pad.util.VersaoUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImportacaoArquivoControleImpl
implements ImportacaoArquivoControle {
    protected MetadadosArquivoContabil _metadadosArquivo;
    private Campo[] _campos;
    private String[] _nomesCampo;
    private String[] _colunasTemporarias;
    private int _tamanhoLinha;
    private int _tamanhoLinhaMinimo;
    private Arquivo _arquivo;
    private boolean _permiteAvancarComErros = PropertiesUtil.getPropertyPermiteAvancarComErros();
    static MensagemFactory msgFactory = MensagemFactory.getInstancia();
    protected static final Log log = LogFactory.getLog(ImportacaoArquivoControleImpl.class);
    private static boolean LOG_DEBUG_ENABLED = log.isDebugEnabled();
    private RepositorioArquivosControle _repositorioControle;
    private ImportacaoListener _importacaoListener;
    private ExecutorRegras _executorRegras;
    private static final int TAMANHO_MINIMO_LINHA_CABECALHO = 42;

    private void preparaContextCargaArquivo(MetadadosArquivoContabil metadados) {
        this._metadadosArquivo = metadados;
        this._campos = ImportacaoHelper.buscaCampos(this._metadadosArquivo);
        ArrayList<String> colunasTemp = new ArrayList<String>(this._campos.length);
        this._nomesCampo = new String[this._campos.length];
        this._arquivo = metadados.getArquivo();
        for (int i = 0; i < this._campos.length; ++i) {
            this._nomesCampo[i] = this._campos[i].getNome();
            if (!this._campos[i].isTemporario()) continue;
            colunasTemp.add(this._nomesCampo[i]);
        }
        this._colunasTemporarias = new String[colunasTemp.size()];
        for (int j = 0; j < colunasTemp.size(); ++j) {
            this._colunasTemporarias[j] = (String)colunasTemp.get(j);
        }
        this._tamanhoLinha = this._metadadosArquivo.getArquivo().getTamanhoLinha();
        this._tamanhoLinhaMinimo = this._metadadosArquivo.getArquivo().getTamanhoLinhaMinimo();
        if (this._tamanhoLinhaMinimo <= 0) {
            this._tamanhoLinhaMinimo = this._tamanhoLinha;
        }
    }

    @Override
    public final void carregaArquivo(ArquivoContabilReader arquivoContabilReader, ContextoVerificacao contexto, SituacaoVerificacao situacao) {
        Arquivo arquivo = null;
        try {
            block33: {
                ChaveEstrangeiraException excecaoFK;
                ImportacaoEvento evento;
                block32: {
                    this.preparaContextCargaArquivo(arquivoContabilReader.getMetadadosArquivo());
                    arquivo = this._metadadosArquivo.getArquivo();
                    String nomeArquivo = arquivo.getNome();
                    evento = this.disparaEvento(contexto, situacao, 0);
                    this.processaCarregamentoArquivo(arquivoContabilReader, arquivo, contexto, situacao, nomeArquivo);
                    if (arquivo.isPossuiTabelaAuxiliar()) {
                        this._repositorioControle.criaTabelaAuxiliar(arquivo);
                    }
                    if (arquivo.isPossuiChavePrimaria()) {
                        this.criaChavePrimaria(situacao);
                    }
                    excecaoFK = null;
                    if (arquivo.isPossuiChaveEstrangeira()) {
                        Tabela tabela = this._metadadosArquivo.getArquivo().getTabela();
                        Referencia[] referencias = tabela.getReferencia();
                        for (int index = 0; index < referencias.length; ++index) {
                            try {
                                if (!this.validaDependencias(situacao, referencias[index])) continue;
                                this.criaChaveEstrangeira(situacao, tabela, referencias[index]);
                                continue;
                            }
                            catch (ChaveEstrangeiraException fke) {
                                excecaoFK = fke;
                                continue;
                            }
                            catch (PersistenciaException pe) {
                                if (this._permiteAvancarComErros) continue;
                                throw pe;
                            }
                        }
                    }
                    evento = this.disparaEvento(contexto, situacao, 8);
                    try {
                        this._executorRegras.executaRegrasVerificacao(arquivo, evento);
                    }
                    catch (NumeroMaximoMensagemException nmme) {
                        if (this.ehMensagemAviso(nmme)) break block32;
                        throw new NumeroMaximoMensagemException(nmme.getTipoMensagem(), nmme.getQuantidade());
                    }
                }
                if (excecaoFK != null && !this._permiteAvancarComErros) {
                    throw excecaoFK;
                }
                evento = this.disparaEvento(contexto, situacao, 1);
                try {
                    if (this._metadadosArquivo.getSituacao() != 2 || VersaoUtils.isDebugModeEnabled()) {
                        this._executorRegras.executaRegrasVerificacao(arquivo, evento);
                    } else {
                        log.info((Object)("regras 'APOS_CARGA' de " + this._metadadosArquivo.getArquivo().getNome() + " n\u00e3o ser\u00e3o validadas devido a erros anteriores"));
                    }
                }
                catch (NumeroMaximoMensagemException nmme) {
                    if (this.ehMensagemAviso(nmme)) break block33;
                    throw new NumeroMaximoMensagemException(nmme.getTipoMensagem(), nmme.getQuantidade());
                }
            }
            if (ProcessaArquivoHelper.todosIdsArqComplem().contains(arquivo.getIdentificador().toString()) && this._arquivo.hasArquivoVazioCodigoMensagem() && this._metadadosArquivo.getLinhasLidas() == 2L) {
                throw new ArquivoComplementarVazioException(arquivo.getIdentificador().toString());
            }
            try {
                if (this._metadadosArquivo.getSituacao() != 2) {
                    this._metadadosArquivo.setSituacao(1);
                }
            }
            catch (NumeroMaximoMensagemException nmme) {
                if (!this.ehMensagemAviso(nmme)) {
                    throw new NumeroMaximoMensagemException(nmme.getTipoMensagem(), nmme.getQuantidade());
                }
            }
        }
        catch (NumeroMaximoMensagemException ne) {
            if (!this.ehMensagemAviso(ne)) {
                this.informaLimiteErrosPorArquivoExcedido(situacao, arquivo);
            } else {
                this.informativoLimiteAvisosPorArquivoExcedido(situacao, arquivo);
            }
        }
        catch (ChavePrimariaException pke) {
            this.informaArquivoCarregadoComErro(situacao, arquivo);
        }
        catch (ChaveEstrangeiraException fke) {
            this.informaArquivoCarregadoComErro(situacao, arquivo);
        }
        catch (FinalizadorException e) {
            ImportacaoArquivoControleImpl.trataFinalizadorException(situacao, arquivo, e);
        }
        catch (ArquivoComplementarVazioException e) {
            String tipoMensagem = null;
            IdentificadorArquivo identificadorArquivoAtual = this._metadadosArquivo.getArquivo().getIdentificador();
            if (ImportacaoArquivoControleImpl.arquivosFolhaSet().contains(identificadorArquivoAtual)) {
                tipoMensagem = "J";
            }
            situacao.adicionaMensagem(msgFactory.constroiMensagem(this._metadadosArquivo.getArquivo().getArquivoVazioCodigoMensagem(), null, null, arquivo, new Object[]{arquivo.getNome()}, tipoMensagem));
            situacao.getArquivoPorIdentificador(arquivo.getIdentificador()).setSituacao(3);
        }
        catch (ArquivoContabilNaoEncontradoException acnee) {
            log.warn((Object)("ArquivoContabilNaoEncontradoException: " + acnee.getMessage()));
            situacao.adicionaMensagem(msgFactory.constroiMensagem("VER_03", arquivo, new Object[]{arquivo.getNome()}));
            situacao.getArquivoPorIdentificador(arquivo.getIdentificador()).setSituacao(3);
        }
        catch (ArquivoVazioException ave) {
            this._metadadosArquivo.setSituacao(2);
            if (!situacao.getRemessa().isRegraDesabilitada(this._arquivo.getArquivoVazioCodigoMensagem())) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem(this._arquivo.getArquivoVazioCodigoMensagem(), this._arquivo));
            }
        }
        catch (RuntimeException e) {
            log.warn((Object)("Erro processando arquivo [" + arquivo + "]: " + e), (Throwable)e);
            this.informaArquivoCarregadoComErro(situacao, arquivo);
            throw e;
        }
    }

    boolean ehMensagemAviso(NumeroMaximoMensagemException ne) {
        return Mensagem.ehMensagemAviso(ne.getTipoMensagem());
    }

    private void informativoLimiteAvisosPorArquivoExcedido(SituacaoVerificacao situacao, Arquivo arquivo) {
        try {
            System.out.println("tam ==> " + situacao.getMensagens().size());
            List<MensagemInstancia> lista = situacao.getMensagens();
            MensagemInstancia mensagem = lista.get(lista.size() - 1);
            System.out.println("cod ==>" + mensagem.getCodigoMensagem());
            situacao.adicionaMensagem(msgFactory.constroiMensagem("ARQ_03", arquivo, new Object[]{mensagem.getCodigoMensagem()}));
        }
        catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {
            // empty catch block
        }
    }

    private void informaLimiteErrosPorArquivoExcedido(SituacaoVerificacao situacao, Arquivo arquivo) {
        try {
            this._metadadosArquivo.setSituacao(2);
            situacao.adicionaMensagem(msgFactory.constroiMensagem("ARQ_01", arquivo, new Object[]{arquivo.getNome()}));
        }
        catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {
            // empty catch block
        }
    }

    private void informaArquivoCarregadoComErro(SituacaoVerificacao situacao, Arquivo arquivo) {
        this._metadadosArquivo.setSituacao(2);
        try {
            if (arquivo.getLei() == null || arquivo.getLei().indexOf("UC048") == -1) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("VER_05", arquivo, new Object[]{arquivo.getNome()}));
            }
        }
        catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processaCarregamentoArquivo(ArquivoContabilReader arquivoContabilReader, Arquivo arquivo, ContextoVerificacao contexto, SituacaoVerificacao situacao, String nomeArquivo) throws ImportacaoException {
        try {
            arquivoContabilReader.abreArquivo(contexto, situacao);
        }
        finally {
            arquivoContabilReader.fechaArquivo();
        }
    }

    private final ImportacaoEvento disparaEvento(ContextoVerificacao contexto, SituacaoVerificacao situacao, int tipoEvento) {
        ImportacaoEvento evento = new ImportacaoEvento(this._metadadosArquivo, contexto, situacao, tipoEvento);
        if (this._importacaoListener != null) {
            this._importacaoListener.trataEvento(evento);
        }
        return evento;
    }

    protected final List<Object[]> extraiDadosLinha(ImportacaoEvento evento, ContextoVerificacao contexto, Remessa remessa, StringBuilder linha, long numeroLinhaAtual) throws LinhaFormatoInvalidoException {
        Object[] valorCampos = null;
        valorCampos = new Object[this._campos.length];
        ValoresCampos valoresCampos = new ValoresCampos(this._metadadosArquivo, this._campos.length);
        ArrayList<Object[]> linhasValor = new ArrayList(1);
        try {
            contexto.adicionaAtributo("verificacao.arquivo.linhaAtual.valores", valoresCampos);
            contexto.adicionaAtributo("verificacao.arquivoAtual.linhaAtual", numeroLinhaAtual);
            LinhaFormatoInvalidoException linhaFormatoInvalido = null;
            for (int i = 0; i < this._campos.length; ++i) {
                Object valor;
                boolean erroSintaxeCampo = false;
                try {
                    Object valorCampo = ImportacaoHelper.parseValorCampo(this._metadadosArquivo, remessa, linha, this._campos[i]);
                    if (this._campos[i].getTipoDadoId() == 1 && this._campos[i].isNumerico()) {
                        valorCampos[i] = valor = (String)valorCampo;
                        for (int j = 0; j < ((String)valor).length(); ++j) {
                            if (Character.isDigit(((String)valor).charAt(j))) continue;
                            throw new FormatoInvalidoException(valor, this._campos[i].getTipoDadoId(), new Object[]{valor, this._campos[i].getTipoDado() + " - num\u00e9rico"});
                        }
                    } else {
                        valorCampos[i] = DadosArquivoFactory.criaValor((String)valorCampo, this._campos[i]);
                    }
                }
                catch (FormatoInvalidoException fie) {
                    log.info((Object)("   LFI: fie: " + (Object)((Object)fie) + " ; linha: " + numeroLinhaAtual));
                    log.info((Object)("   LFI: nome: " + this._campos[i].getNome() + " ; tipoDado: " + this._campos[i].getTipoDado() + " ; inicio-fim: " + this._campos[i].getInicio() + "-" + this._campos[i].getFinal() + " ; valida: " + this._campos[i].isValida() + " ; mensagem: " + fie.getMessage()));
                    erroSintaxeCampo = true;
                    if (linhaFormatoInvalido == null) {
                        linhaFormatoInvalido = new LinhaFormatoInvalidoException(this._arquivo.getNome());
                    }
                    valor = fie.getValor();
                    if (fie.getTipoDado() == 2) {
                        String valorStr = (String)valor;
                        try {
                            char sinal = valorStr.charAt(0);
                            if (sinal == '+') {
                                valorStr = valorStr.substring(1, valorStr.length());
                            }
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                        valor = valorStr;
                    }
                    linhaFormatoInvalido.setException(fie);
                    linhaFormatoInvalido.adicionaDadosInvalidos(valor, this._campos[i], i + 1);
                }
                if (erroSintaxeCampo) continue;
                valoresCampos.adicionaValorCampo(this._nomesCampo[i], valorCampos[i], this._campos[i].getTipoDadoId());
                for (int j = 0; j < this._campos[i].getBaseRegrasCampo().size(); ++j) {
                    this.executaRegraValidacaoCampo(evento, contexto, this._campos[i].getBaseRegrasCampo().get(j), this._campos[i], i + 1);
                }
            }
            if (linhaFormatoInvalido != null) {
                throw linhaFormatoInvalido;
            }
            try {
                linhasValor = this.processaDados(valoresCampos, this._colunasTemporarias, contexto);
            }
            catch (RuntimeException e) {
                log.warn((Object)("Erro em processaDados: " + e.getMessage()), (Throwable)e);
            }
        }
        catch (ImportacaoException e) {
            log.error((Object)e);
            throw e;
        }
        return linhasValor;
    }

    private final void executaRegraValidacaoCampo(ImportacaoEvento evento, ContextoVerificacao contexto, Regra regra, Campo campoAtual, Integer coluna) {
        try {
            contexto.adicionaAtributo("arquivo.definicao.campo", campoAtual);
            contexto.adicionaAtributo("verificacao.arquivoAtual.colunaAtual", coluna);
            regra.executaRegra(evento);
        }
        catch (VerificacaoException ve) {
            log.error((Object)ve);
        }
    }

    protected List<Object[]> processaDados(ValoresCampos valoresCamposExtraidos, String[] colunasTemporarias, ContextoVerificacao contexto) {
        for (int index = 0; index < colunasTemporarias.length; ++index) {
            valoresCamposExtraidos.removeValorCampo(colunasTemporarias[index]);
        }
        ArrayList<Object[]> linhasValor = new ArrayList<Object[]>(1);
        linhasValor.add(valoresCamposExtraidos.getValoresCamposArray());
        return linhasValor;
    }

    @Override
    public final void setRepositorioArquivosControle(RepositorioArquivosControle reposControle) {
        this._repositorioControle = reposControle;
    }

    @Override
    public final void trataFinalizador(StringBuilder linhaFinal, long qtdLinhasEncontradas, ContextoVerificacao contexto, SituacaoVerificacao situacao) {
        long numeroLinhasArquivo = this.parseNumeroLinhasArquivo(linhaFinal);
        this._metadadosArquivo.incrementaBytesLidos(linhaFinal.length());
        if (LOG_DEBUG_ENABLED) {
            log.debug((Object)(this._arquivo.getNomeCompleto() + " - Linhas lidas: " + qtdLinhasEncontradas + " - Finalizador: " + numeroLinhasArquivo));
        }
        if (numeroLinhasArquivo == -1L) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("FIM_02", this._arquivo));
        } else if (qtdLinhasEncontradas != numeroLinhasArquivo) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("FIM_03", this._arquivo, new Object[]{qtdLinhasEncontradas + 1L, numeroLinhasArquivo, qtdLinhasEncontradas}));
        }
        this._repositorioControle.processamentoAposCargaArquivo();
    }

    @Override
    public final void trataCabecalho(ContextoVerificacao contexto, SituacaoVerificacao situacao, StringBuilder linhaCabecalho) {
        Arquivo arquivo = this._metadadosArquivo.getArquivo();
        this._repositorioControle.inicializaArquivo(arquivo);
        if (linhaCabecalho == null || linhaCabecalho.length() < 42) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_04", arquivo));
        } else {
            CabecalhoArquivo cabecalho = this._metadadosArquivo.getCabecalho();
            this.realizaParseLinhaCabecalho(cabecalho, situacao, linhaCabecalho, arquivo);
            this._metadadosArquivo.incrementaBytesLidos(linhaCabecalho.length());
            this.validaCabecalho(situacao);
        }
    }

    private void validaCabecalho(SituacaoVerificacao situacao) {
        Remessa remessa = situacao.getRemessa();
        CabecalhoArquivo cabecalho = this._metadadosArquivo.getCabecalho();
        String cnpjArquivo = cabecalho.getCnpj();
        if (cnpjArquivo != null && !cnpjArquivo.equals(remessa.getCnpjEntidade())) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_06", this._arquivo));
        }
        if (cabecalho.getNomeSetorGoverno() == null || cabecalho.getNomeSetorGoverno().trim().length() == 0) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_07", this._arquivo));
        }
        if (cabecalho.getAnoExercicio() != remessa.getAnoExercicio()) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_08", this._arquivo));
        }
        GregorianCalendar cal = new GregorianCalendar();
        if (cabecalho.getDataInicial() != null) {
            cal.setTime(cabecalho.getDataInicial());
            if (cal.get(5) != 1) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_10", this._arquivo));
            }
            if (cal.get(2) != 0) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_09", this._arquivo));
            }
        }
        if (cabecalho.getDataFinal() != null) {
            cal.setTime(cabecalho.getDataFinal());
            int mesFinal = cal.get(2);
            int periodoRemessa = remessa.getPeriodoInformacoes();
            Integer mes = remessa.getMes();
            int tipoOperacaoRemessa = remessa.getTipoOperacao();
            Date dataFinalRemessa = remessa.getDataFinal();
            if (tipoOperacaoRemessa == 1 && mes != null && mes != mesFinal + 1) {
                log.info((Object)("- [CAB_12] tipoOperacaoRemessa=" + tipoOperacaoRemessa + "; periodoRemessa=" + periodoRemessa + "; mesFinal=" + mesFinal + "; mes=" + mes));
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_12", this._arquivo));
            }
            if (tipoOperacaoRemessa == 6 && !cal.getTime().equals(dataFinalRemessa)) {
                log.info((Object)("- [CAB_14] cal.getTime() = " + cal.getTime() + " ; dataFinalRemessa = " + dataFinalRemessa));
                Object[] javaObjectArray = new Object[]{cal.getTime(), dataFinalRemessa};
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_14", this._arquivo, javaObjectArray));
            }
        }
        if (cabecalho.getDataInicial() != null && cabecalho.getDataFinal() != null) {
            if (cabecalho.getDataGeracao().before(cabecalho.getDataInicial()) || cabecalho.getDataGeracao().before(cabecalho.getDataFinal())) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_11", this._arquivo));
            }
            if (cabecalho.getDataFinal().before(cabecalho.getDataInicial())) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_13", this._arquivo));
            }
        }
    }

    @Override
    public final void setImportacaoListener(ImportacaoListener impListener) {
        this._importacaoListener = impListener;
    }

    @Override
    public final void processaLinha(long numeroLinhaAtual, StringBuilder linha, ContextoVerificacao contexto, SituacaoVerificacao situacao) {
        List<Object> linhasValor = Collections.emptyList();
        this._metadadosArquivo.incrementaBytesLidos(linha.length());
        ImportacaoEvento evento = this.disparaEvento(contexto, situacao, 2);
        int tamanhoLinha = 0;
        if (linha != null) {
            tamanhoLinha = linha.length();
        }
        int posCaracterInvalido = this.posicaoCaracteresInvalidos(linha, numeroLinhaAtual);
        int posCaracterInvalidoAviso = this.posicaoCaracteresInvalidosAviso(linha, numeroLinhaAtual);
        if (tamanhoLinha > this._tamanhoLinha) {
            log.debug((Object)("   [ARQ_02,arq=" + this._arquivo.getIdentificadorNome() + "] erro tamanho linha: layout=" + this._tamanhoLinha + " doarq=" + tamanhoLinha + " nrLinha=" + numeroLinhaAtual));
            MensagemInstancia mi = msgFactory.constroiMensagem("ARQ_02", this._arquivo, new Object[]{numeroLinhaAtual});
            situacao.adicionaMensagem(mi);
            if (Mensagem.ehMensagemErro(mi.getTipo())) {
                this._metadadosArquivo.setSituacao(2);
            }
        } else {
            MensagemInstancia mi;
            if (posCaracterInvalido >= 0) {
                log.debug((Object)("   [ARQ_07,arq=" + this._arquivo.getIdentificadorNome() + "] erro caracteres invalidos"));
                mi = msgFactory.constroiMensagem("ARQ_07", this._arquivo, new Object[]{numeroLinhaAtual, posCaracterInvalido + 1});
                situacao.adicionaMensagem(mi);
                if (Mensagem.ehMensagemErro(mi.getTipo())) {
                    this._metadadosArquivo.setSituacao(2);
                    return;
                }
                this.removeCaracteresInvalidos(linha);
            }
            if (posCaracterInvalidoAviso >= 0) {
                log.debug((Object)("   [ARQ_08,arq=" + this._arquivo.getIdentificadorNome() + "] erro caracteres invalidos"));
                mi = msgFactory.constroiMensagem("ARQ_08", this._arquivo, new Object[]{numeroLinhaAtual, posCaracterInvalidoAviso + 1});
                situacao.adicionaMensagem(mi);
                this.removeCaracteresInvalidos(linha);
            }
            if (tamanhoLinha < this._tamanhoLinhaMinimo && !situacao.getRemessa().isRegraDesabilitada("ARQ_06")) {
                situacao.adicionaMensagem(msgFactory.constroiMensagem("ARQ_06", this._arquivo, new Object[]{numeroLinhaAtual}));
            }
            try {
                linhasValor = this.extraiDadosLinha(evento, contexto, situacao.getRemessa(), linha, numeroLinhaAtual);
                for (int index = 0; index < linhasValor.size(); ++index) {
                    Object[] valores = (Object[])linhasValor.get(index);
                    this._repositorioControle.armazenaLinha(valores, numeroLinhaAtual);
                }
                evento = this.disparaEvento(contexto, situacao, 3);
                this._executorRegras.executaRegrasVerificacao(evento.getArquivo(), evento);
                linhasValor.clear();
            }
            catch (LinhaFormatoInvalidoException lfe) {
                for (int i = 0; i < lfe.getQuantidadeErros(); ++i) {
                    String[] codigoMensagens;
                    Campo campo = lfe.getCampoErro(i);
                    if (!campo.isValida()) continue;
                    Object valorCampo = lfe.getValorErro(i);
                    String codigoMensagem = campo.getCodigoMensagem();
                    if (codigoMensagem == null || codigoMensagem.trim().equals("")) {
                        situacao.adicionaMensagem(msgFactory.constroiMensagem("GEN_01", this._arquivo, new Object[]{numeroLinhaAtual, campo.getLabelOuNome(), this._arquivo.getNome(), valorCampo}));
                        continue;
                    }
                    if (campo.getTipoDadoId() == 6 && lfe.getException() instanceof CNPJInvalidoException) {
                        codigoMensagens = codigoMensagem.split(",");
                        if (codigoMensagens != null && codigoMensagens.length > 1) {
                            codigoMensagem = codigoMensagens[1];
                        }
                    } else {
                        codigoMensagens = codigoMensagem.split(",");
                        if (codigoMensagens != null && codigoMensagens.length > 0) {
                            codigoMensagem = codigoMensagens[0];
                        }
                    }
                    situacao.adicionaMensagem(msgFactory.constroiMensagem(codigoMensagem, lfe.getColunaErro(i), numeroLinhaAtual, this._arquivo, new Object[]{numeroLinhaAtual, valorCampo, campo.getLabelOuNome()}));
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                log.warn((Object)("ex: " + e + " ; " + Arrays.toString(this._campos)));
                throw e;
            }
        }
    }

    int posicaoCaracteresInvalidos(StringBuilder sb, long numeroLinhaAtual) {
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            if (c == '\u0000') {
                log.debug((Object)("   [posicaoCaracteresInvalidos: x00][i=" + i + ";linha=" + numeroLinhaAtual + "]: char " + c));
                return i;
            }
            if (c <= '\u00ff') continue;
            log.debug((Object)("   [posicaoCaracteresInvalidos: >255][i=" + i + ";linha=" + numeroLinhaAtual + "]: char " + c));
            return i;
        }
        return -1;
    }

    int posicaoCaracteresInvalidosAviso(StringBuilder sb, long numeroLinhaAtual) {
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            if (c < '\t') {
                log.debug((Object)("   [posicaoCaracteresInvalidosAviso: controle1][i=" + i + ";linha=" + numeroLinhaAtual + "]: char " + c));
                return i;
            }
            if (c <= '\r' || c >= ' ') continue;
            log.debug((Object)("   [posicaoCaracteresInvalidosAviso: controle2][i=" + i + ";linha=" + numeroLinhaAtual + "]: char " + c));
            return i;
        }
        return -1;
    }

    void removeCaracteresInvalidos(StringBuilder sb) {
        int len = sb.length();
        for (int i = 0; i < len; ++i) {
            char c = sb.charAt(i);
            if (c == '\u0000') {
                sb.setCharAt(i, ' ');
            }
            if (c <= '\u00ff') continue;
        }
    }

    private final long parseNumeroLinhasArquivo(StringBuilder linha) {
        long numeroLinhasArquivo = 0L;
        try {
            String substr;
            if (linha != null && linha.length() > 11 && (substr = linha.substring(11)) != null) {
                substr = substr.trim();
                numeroLinhasArquivo = Long.parseLong(substr);
            }
        }
        catch (NumberFormatException e) {
            numeroLinhasArquivo = -1L;
        }
        return numeroLinhasArquivo;
    }

    private final void criaChavePrimaria(SituacaoVerificacao situacaoVerificacao) throws NumeroMaximoMensagemException, ChavePrimariaException {
        List<BaseRepositorioArquivosControle.ValoresPK> col = Collections.emptyList();
        Tabela tabela = this._arquivo.getTabela();
        boolean tabelaNormalizada = false;
        if (tabela != null) {
            String[] colunasPK = tabela.getChavePrimaria();
            String[] colunasMensagemPK = tabela.getColunasMensagemChavePrimaria();
            if (colunasPK != null) {
                if (tabela.getColuna() != null && tabela.getColuna().length > 0) {
                    tabelaNormalizada = true;
                }
                col = this._repositorioControle.criaChavePrimaria(tabela.getNome(), colunasPK, colunasMensagemPK, tabelaNormalizada);
                this.constroiMensagensChavePrimaria(tabela, col, situacaoVerificacao);
                if (col.size() > 0) {
                    throw ChavePrimariaException.constroiExcecao(tabela.getNome(), colunasPK);
                }
            }
        }
    }

    private final void criaChaveEstrangeira(SituacaoVerificacao situacaoVerificacao, Tabela tabelaOrigem, Referencia referencia) throws NumeroMaximoMensagemException, ChaveEstrangeiraException {
        List<Object> col = Collections.emptyList();
        col = this._repositorioControle.criaChaveEstrangeira(tabelaOrigem.getNome(), referencia);
        if (col != null && col.size() > 0) {
            this.constroiMensagensChaveEstrangeira(referencia, col, situacaoVerificacao);
            throw ChaveEstrangeiraException.controiExcecao(tabelaOrigem.getNome(), referencia);
        }
    }

    private final void constroiMensagensChaveEstrangeira(Referencia referencia, List<BaseRepositorioArquivosControle.ValoresFK> col, SituacaoVerificacao situacaoVerificacao) throws NumeroMaximoMensagemException {
        MensagemInstancia msg = null;
        Iterator<BaseRepositorioArquivosControle.ValoresFK> ite = null;
        for (BaseRepositorioArquivosControle.ValoresFK valFK : col) {
            Object[] valores = valFK.getValoresColunas();
            Object[] argumentos = new Object[1 + valores.length];
            argumentos[0] = valFK.getNumeroLinha();
            for (int i = 0; i < valores.length; ++i) {
                argumentos[i + 1] = valores[i];
            }
            msg = msgFactory.constroiMensagem(referencia.getCodigoMensagem(), 0, valFK.getNumeroLinha(), this._metadadosArquivo.getArquivo(), argumentos);
            situacaoVerificacao.adicionaMensagem(msg);
        }
    }

    private final void constroiMensagensChavePrimaria(Tabela tabela, List<BaseRepositorioArquivosControle.ValoresPK> col, SituacaoVerificacao situacaoVerificacao) throws NumeroMaximoMensagemException {
        MensagemInstancia msg = null;
        Iterator<BaseRepositorioArquivosControle.ValoresPK> ite = null;
        for (BaseRepositorioArquivosControle.ValoresPK valPK : col) {
            Object[] valores = valPK.getValoresColunas();
            Object[] argumentos = new Object[1 + valores.length];
            argumentos[0] = valPK.getNumeroLinha();
            for (int i = 0; i < valores.length; ++i) {
                argumentos[i + 1] = valores[i];
            }
            msg = msgFactory.constroiMensagem(tabela.getCodigoMensagemPK(), tabela.getNumeroColuna(), valPK.getNumeroLinha(), this._metadadosArquivo.getArquivo(), argumentos);
            try {
                situacaoVerificacao.adicionaMensagem(msg);
                log.warn((Object)("   [Erro PK]: " + this._metadadosArquivo.getArquivo() + " , argumentos=" + Arrays.asList(argumentos) + " , linha=" + valPK.getNumeroLinha()));
            }
            catch (NumeroMaximoMensagemException e) {
                log.warn((Object)("   [Erro PK]: " + this._metadadosArquivo.getArquivo() + " , linha=" + valPK.getNumeroLinha() + " [NumeroMaximoMensagemException]"));
                this._metadadosArquivo.setErroChavePrimaria(true);
                throw e;
            }
        }
    }

    public final void realizaParseLinhaCabecalho(CabecalhoArquivo cabecalho, SituacaoVerificacao situacao, StringBuilder linhaCabecalho, Arquivo arquivo) throws NumeroMaximoMensagemException {
        Date data;
        String valorData;
        MetadadosArquivoContabil metadados = situacao.getArquivoPorIdentificador(arquivo.getIdentificador());
        try {
            cabecalho.setCnpj((String)DadosArquivoFactory.criaValor(linhaCabecalho.substring(0, 14), 6));
        }
        catch (FormatoInvalidoException e) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_05", arquivo));
            metadados.setSituacao(2);
        }
        try {
            valorData = linhaCabecalho.substring(14, 22);
            data = (Date)DadosArquivoFactory.criaValor(valorData, 5);
            cabecalho.setDataInicial(data);
        }
        catch (FormatoInvalidoException e) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_01", arquivo));
            metadados.setSituacao(2);
        }
        try {
            valorData = linhaCabecalho.substring(22, 30);
            data = (Date)DadosArquivoFactory.criaValor(valorData, 5);
            cabecalho.setDataFinal(data);
        }
        catch (FormatoInvalidoException e) {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("CAB_02", arquivo));
            metadados.setSituacao(2);
        }
        try {
            valorData = linhaCabecalho.substring(30, 38);
            data = (Date)DadosArquivoFactory.criaValor(valorData, 5);
            cabecalho.setDataGeracao(data);
        }
        catch (FormatoInvalidoException e) {
            cabecalho.setDataGeracao(new Date(0L));
        }
        String linhaCab = null;
        if (linhaCabecalho.length() >= 118) {
            cabecalho.setNomeSetorGoverno(linhaCabecalho.toString().substring(38, 117).trim());
            linhaCab = linhaCabecalho.substring(0, 117).trim();
        } else {
            cabecalho.setNomeSetorGoverno(linhaCabecalho.toString().substring(38).trim());
            linhaCab = linhaCabecalho.toString().trim();
        }
        CRC32 crc32 = new CRC32();
        crc32.update(linhaCab.getBytes());
        cabecalho.setCrc32(crc32.getValue());
    }

    @Override
    public final void setExecutorRegras(ExecutorRegras executorRegras) {
        this._executorRegras = executorRegras;
    }

    public static void trataFinalizadorException(SituacaoVerificacao situacao, Arquivo arquivo, FinalizadorException fe) {
        try {
            situacao.adicionaMensagem(msgFactory.constroiMensagem("FIM_01", arquivo, new Object[]{fe.getLinha()}));
        }
        catch (NumeroMaximoMensagemException numeroMaximoMensagemException) {
            // empty catch block
        }
    }

    private boolean validaDependencias(SituacaoVerificacao verificacao, Referencia referencia) {
        boolean dependenciaOk = true;
        if (referencia.getDependencias() != null) {
            IdentificadorArquivo[] dependencias = referencia.getDependencias();
            for (int index = 0; index < dependencias.length; ++index) {
                MetadadosArquivoContabil metadadosArquivoContabil = verificacao.getArquivoPorIdentificador(dependencias[index]);
                if (metadadosArquivoContabil != null) {
                    if (metadadosArquivoContabil.getSituacao() != 2 && metadadosArquivoContabil.getSituacao() != 3) continue;
                    dependenciaOk = false;
                    break;
                }
                dependenciaOk = false;
                break;
            }
        }
        return dependenciaOk;
    }

    public static void main(String[] args) {
        String text = "01612918000154010120093108200931082009P. M. de Ararica                                                               000000000001";
        text = text.substring(0, 118).replaceAll("\\s+$", "");
        System.out.println("Text: " + text);
    }

    public static Set<IdentificadorArquivo> arquivosFolhaSet() {
        HashSet<IdentificadorArquivo> arqsFolha = new HashSet<IdentificadorArquivo>();
        arqsFolha.add(new IdentificadorArquivo("TCE_4820"));
        arqsFolha.add(new IdentificadorArquivo("TCE_4820_6404"));
        arqsFolha.add(new IdentificadorArquivo("TCE_4810"));
        arqsFolha.add(new IdentificadorArquivo("TCE_4810_6404"));
        arqsFolha.add(new IdentificadorArquivo("TCE_4960"));
        arqsFolha.add(new IdentificadorArquivo("TCE_4960_6404"));
        arqsFolha.add(new IdentificadorArquivo("PAGTO_POS"));
        arqsFolha.add(new IdentificadorArquivo("PENSIONISTA"));
        arqsFolha.add(new IdentificadorArquivo("DEPENDENTE"));
        return arqsFolha;
    }

    public static MensagemFactory getMensagemFactory() {
        return msgFactory;
    }
}

