/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.exportacao.test;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.ConsultaExtracao;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.exportacao.ExportacaoDados;
import br.gov.rs.tce.pad.modelo.test.ADFContextTestFixture;
import java.io.File;
import java.util.Date;
import java.util.List;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ApplicationModule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class ExportacaoDadosTest {
    ADFContextTestFixture fixture1 = new ADFContextTestFixture();
    ConsultasExtracaoList consultas = null;
    Remessa rem;
    CabecalhoArquivo cab;

    @Test
    public void testmontaXMLsaida() {
        Assert.assertNotNull((String)"N\u00e3o foi possivel ler as consultas XML para extracao", (Object)this.consultas);
        Assert.assertNotNull((String)"elemento pai deve ser definido", (Object)this.consultas.getElementoPai());
        Assert.assertNotNull((String)"\u00e9 preciso q exista pelo menos 1 consulta", this.consultas.getConsultasExtracao());
        DCDataControl dc = this.fixture1.getBindingContext().findDataControl("ServicoPADDataControl");
        Assert.assertNotNull((Object)"N\u00e3o foi possivel obter o AM: ServicoPADDataControl");
        ApplicationModule app = (ApplicationModule)dc.getDataProvider();
        TipoBancoDados TP_DATABASE = TipoBancoDados.DERBY_DB;
        List<ConsultaExtracao> listaConsultas = this.consultas.getConsultasExtracao();
        for (int i = 0; i < listaConsultas.size(); ++i) {
            ConsultaExtracao c = listaConsultas.get(i);
            this.verificaConsultas(this.rem, this.cab, c, TP_DATABASE);
        }
        ExportacaoDados exp = null;
        try {
            exp = new ExportacaoDados(app);
        }
        catch (Exception e) {
            Assert.fail((String)("N\u00e3o deveria ter lan\u00e7ado uma exce\u00e7\u00e3o !" + e.getMessage()));
        }
        try {
            exp.montaXMLsaida(this.consultas, new File("test/modelo9.xml"), this.rem, TP_DATABASE);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Houve um problema na execucao da exportacao de dados: " + e.getMessage()));
        }
        try {
            exp.montaXMLsaida(null, null, null, null);
            Assert.fail((String)"Deveria ter lan\u00e7ado IllegalArgumentException");
            exp.montaXMLsaida(this.consultas, new File("./test/test.file"), null, null);
            Assert.fail((String)"Deveria ter lan\u00e7ado IllegalArgumentException");
            exp.montaXMLsaida(this.consultas, new File("./test/test.file"), this.rem, null);
            Assert.fail((String)"Deveria ter lan\u00e7ado IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
        }
        catch (Throwable th) {
            th.printStackTrace();
            Assert.fail((String)("N\u00e3o deveria ter lan\u00e7ado esta exce\u00e7\u00e3o: " + th.getClass()));
        }
    }

    private void verificaConsultas(Remessa remessa, CabecalhoArquivo cabecalho, ConsultaExtracao consulta, TipoBancoDados tpBanco) {
        Assert.assertNotNull((String)"elemento n\u00e3o pode ser nulo", (Object)consulta.getElemento());
        List consultas = consulta.getConsultas();
        if (consultas == null || consultas.size() == 0) {
            ConsultaSQL consultaSQL = consulta.recuperaConsultaSQL(remessa, cabecalho, tpBanco);
            Assert.assertNotNull((String)("elemento " + consulta.getElemento() + " deve possui uma consulta SQL associada"), (Object)consultaSQL);
            Assert.assertNotNull((String)("elemento " + consulta.getElemento() + " deve possui uma consulta SQL associada"), (Object)consultaSQL.getSql());
            Assert.assertTrue((String)"ConsultaSQl nao pode ser vazia", (consultaSQL.getSql().length() > 0 ? 1 : 0) != 0);
        } else {
            for (int i = 0; i < consultas.size(); ++i) {
                ConsultaExtracao cons = (ConsultaExtracao)consultas.get(i);
                this.verificaConsultas(remessa, cabecalho, cons, tpBanco);
            }
        }
    }

    @Test
    public void testmontaElementos() {
    }

    @Test
    public void testextraiDadosViaSQL() {
    }

    @Test
    @Ignore
    public void testParametrosList() {
        List<ConsultaExtracao> listaConsultas = this.consultas.getConsultasExtracao();
        for (int i = 0; i < listaConsultas.size(); ++i) {
            int j;
            ConsultaExtracao c = listaConsultas.get(i);
            Assert.assertEquals((Object)c.getElemento(), (Object)"Teste");
            ConsultaSQL consultaSql = c.recuperaConsultaSQL(this.rem, this.cab, TipoBancoDados.ORACLE_DB);
            Assert.assertEquals((Object)consultaSql.getSql(), (Object)"select * from remessas where '1234'=? and '4321'=?");
            Object[] params = consultaSql.getValoresParametros();
            block11: for (j = 0; j < params.length; ++j) {
                switch (j) {
                    case 0: {
                        Assert.assertEquals((String)"Valor do parametro \u00e9 incorreto", (Object)params[j], (Object)"1234");
                        continue block11;
                    }
                    case 1: {
                        Assert.assertEquals((String)"Valor do parametro \u00e9 incorreto", (Object)params[j], (Object)"4321");
                        continue block11;
                    }
                    case 2: {
                        Assert.fail((String)"Para o banco de dados Oracle este parametro nao deve ser retornado");
                        continue block11;
                    }
                    default: {
                        Assert.fail((String)"TestCase nao espera mais de 3 parametros");
                    }
                }
            }
            consultaSql = c.recuperaConsultaSQL(this.rem, this.cab, TipoBancoDados.DERBY_DB);
            Assert.assertEquals((Object)consultaSql.getSql(), (Object)"select cd_remessa from remessas where '1234'=? and '4321'=? and '7890'=?");
            params = consultaSql.getValoresParametros();
            block12: for (j = 0; j < params.length; ++j) {
                switch (j) {
                    case 0: {
                        Assert.assertEquals((String)"Valor do parametro \u00e9 incorreto", (Object)params[j], (Object)"1234");
                        continue block12;
                    }
                    case 1: {
                        Assert.assertEquals((String)"Valor do parametro \u00e9 incorreto", (Object)params[j], (Object)"4321");
                        continue block12;
                    }
                    case 2: {
                        Assert.assertEquals((String)"Valor do parametro \u00e9 incorreto", (Object)params[j], (Object)"7890");
                        continue block12;
                    }
                    default: {
                        Assert.fail((String)"TestCase nao espera mais de 3 parametros");
                    }
                }
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fixture1.setUp();
        if (this.consultas == null) {
            this.consultas = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File("src/consultas-modelo9.xml"));
        }
        this.rem = new Remessa();
        this.rem.setAnoExercicio(2005);
        this.rem.setPeriodoInformacoes(1);
        this.cab = new CabecalhoArquivo();
        this.cab.setDataFinal(new Date());
        this.cab.setDataGeracao(new Date());
        this.cab.setDataInicial(new Date());
    }

    @After
    public void tearDown() throws Exception {
        this.fixture1.tearDown();
        this.rem = null;
        this.cab = null;
    }
}

