/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.consolidacao;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaCodBarras;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaConsorcios;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaContasRemessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaContasRemessaContrapartida;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaEntidadesIndiretas;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaHistoricoVerificacao;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaJustificativas;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaPrestadoraServico;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaPublicacoes;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRemessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRemessaCamara;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRemessaEmpresa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRespostasRemessa;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaRpRecurso;
import br.gov.rs.tce.pad.modelo.consolidacao.ProcessaCargaSubsidioVereadores;
import br.gov.rs.tce.pad.modelo.consolidacao.RecuperaArquivos;
import br.gov.rs.tce.pad.modelo.importacao.ImportaDados;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import oracle.jbo.ApplicationModule;
import oracle.jbo.ViewObject;

public class RecuperaArquivosConsolidacaoPio
extends RecuperaArquivos {
    ApplicationModule _app;
    Map _processadores;
    private Integer entidade;

    public RecuperaArquivosConsolidacaoPio(ApplicationModule app) {
        this._app = app;
        this._processadores = new TreeMap();
        this._processadores.put("Remessas", new ProcessaCargaRemessa(app));
        this._processadores.put("ContasRemessa", new ProcessaCargaContasRemessa(app));
        this._processadores.put("ContasRemessaContrapartida", new ProcessaCargaContasRemessaContrapartida(app));
        this._processadores.put("RpRecurso", new ProcessaCargaRpRecurso(app));
        this._processadores.put("Justificativas", new ProcessaCargaJustificativas(app));
    }

    public void recuperaArquivoPrefeitura(File arquivo, Remessa remessa, int commitType) {
        this._processadores.put("EntidadesIndiretas", new ProcessaCargaEntidadesIndiretas(this._app));
        this._processadores.put("RemessaCamara", new ProcessaCargaRemessaCamara(this._app));
        this._processadores.put("RemessaEmpresa", new ProcessaCargaRemessaEmpresa(this._app));
        this._processadores.put("RespostasDaRemessa", new ProcessaCargaRespostasRemessa(this._app));
        this._processadores.put("Publicacoes", new ProcessaCargaPublicacoes(this._app));
        this._processadores.put("SubsidioVereadores", new ProcessaCargaSubsidioVereadores(this._app));
        this._processadores.put("HistoricoVerificacao", new ProcessaCargaHistoricoVerificacao(this._app));
        this._processadores.put("PrestadoraServico", new ProcessaCargaPrestadoraServico(this._app));
        this._processadores.put("CodBarrasRemessa", new ProcessaCargaCodBarras(this._app));
        this._processadores.put("Consorcios", new ProcessaCargaConsorcios(this._app));
        ImportaDados imp = new ImportaDados(this._app);
        imp.setProcessadores(this._processadores);
        this.limpaFiltrosVO();
        imp.importaArquivoPrefeitura(arquivo, remessa, "UTF-8");
        if (commitType != 1) {
            this._app.getTransaction().commit();
        }
    }

    public void recuperaConsolidacao(File arquivo, Remessa remessa, int commitType) {
        ImportaDados imp = new ImportaDados(this._app);
        imp.setProcessadores(this._processadores);
        imp.importaArquivo(arquivo, remessa);
        this._app.getTransaction().commit();
        if (commitType != 1) {
            this._app.getTransaction().commit();
        }
    }

    private void limpaFiltrosVO() {
        ViewObject vo = this._app.findViewObject("RemessasDaEntidade");
        System.out.println(vo.getWhereClause());
        System.out.println(vo.getWhereClauseParams());
        vo.setWhereClause(null);
        vo.setWhereClauseParams(null);
        vo.executeQuery();
    }
}

