/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.consolidacao;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.modelo.importacao.ProcessaCarga;
import oracle.jbo.ApplicationModule;
import oracle.jbo.JboException;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProcessaCargaRemessa
extends ProcessaCarga {
    private static Log log = LogFactory.getLog(ProcessaCargaRemessa.class);
    public static final String VO_IMPLEMENTATION = "br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasView";

    public ProcessaCargaRemessa(ApplicationModule app) {
        super(app);
    }

    @Override
    public void processaNodo(Element nodo, Remessa remessa) {
        try {
            if (!this.verificaEntidade(nodo, remessa) && !this.verificaDadosIndiretas(remessa)) {
                throw new PADRuntimeException("Dados n\u00e3o pertencem a nenhuma das Entidades de Administra\u00e7\u00e3o Indireta listadas");
            }
            if (!this.verificaPeriodo(nodo, remessa)) {
                throw new PADRuntimeException("Periodicidade de uma das Entidades que comp\u00f5em \u00e9 diferente da periodicidade da tabela PCDI_REMESSAS");
            }
            this.criaViewObject(nodo, "Remessas", VO_IMPLEMENTATION, 0);
        }
        catch (JboException e) {
            e.printStackTrace();
            throw new PADRuntimeException(e);
        }
        finally {
            ViewObject vo = this._app.findViewObject("Remessas");
            if (vo != null) {
                vo.remove();
            }
        }
    }

    private boolean verificaEntidade(Element nodo, Remessa remessa) {
        NodeList n = nodo.getElementsByTagName("CD_ENTIDADE").item(0).getChildNodes();
        log.info((Object)("verificaEntidade: getNodeValue: " + n.item(0).getNodeValue()));
        return remessa.getCdEntidade().toString().equals(n.item(0).getNodeValue());
    }

    private boolean verificaPeriodo(Element nodo, Remessa remessa) {
        NodeList n = nodo.getElementsByTagName("PERIODO_INFORMACOES").item(0).getChildNodes();
        boolean ret = ("" + remessa.getPeriodoInformacoes()).equals(n.item(0).getNodeValue());
        if (!ret) {
            log.warn((Object)("Erro verificaPeriodo:: remessa.getPeriodoInformacoes(): " + remessa.getPeriodoInformacoes() + " ; n.item(0).getNodeValue(): " + n.item(0).getNodeValue()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verificaDadosIndiretas(Remessa remessa) {
        boolean retorno = false;
        try {
            ViewObject vo = this._app.createViewObjectFromQueryStmt("ValidaEntidade", "Select * from ent_indiretas");
            vo.setWhereClause("CNPJ = '" + remessa.getCnpjEntidade() + "'");
            vo.executeQuery();
            Row r = null;
            while (vo.hasNext()) {
                r = vo.next();
                System.out.println(remessa.getCnpjEntidade() + " == " + r.getAttribute("CNPJ").toString());
                if (!remessa.getCnpjEntidade().equals(r.getAttribute("CNPJ").toString())) continue;
                retorno = true;
                break;
            }
        }
        catch (Exception e) {
            retorno = false;
            e.printStackTrace();
        }
        finally {
            if (this._app.findViewObject("ValidaEntidade") != null) {
                this._app.findViewObject("ValidaEntidade").remove();
            }
        }
        return retorno;
    }
}

