/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultasExtracaoList;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.exportacao.ExportacaoDados;
import java.io.File;
import oracle.jbo.ApplicationModule;

public class GeraArquivoRemessa {
    private ConsultasExtracaoList consultas = null;
    private ApplicationModule app = null;
    private File arquivoSaida = null;
    private Remessa remessa = null;
    private TipoBancoDados tpBanco = null;
    private static final String ARQUIVO_EXTRACAO = "consultas-extracao.xml";

    public GeraArquivoRemessa(ApplicationModule appModule, File arquivoSaida, Remessa remessa, TipoBancoDados tpBanco) {
        if (appModule == null) {
            throw new IllegalArgumentException("ApplicationModule n\u00e3o pode ser nulo");
        }
        if (arquivoSaida == null) {
            throw new IllegalArgumentException("O arquivo de destino n\u00e3o pode ser nulo");
        }
        if (tpBanco == null) {
            throw new IllegalArgumentException("O tipo de banco de dados n\u00e3o pode ser nulo");
        }
        if (remessa == null) {
            throw new IllegalArgumentException("A Remessa n\u00e3o pode ser nula");
        }
        this.app = appModule;
        this.arquivoSaida = arquivoSaida;
        this.remessa = remessa;
        this.tpBanco = tpBanco;
    }

    private void getConsultas() throws Exception {
        if (this.consultas == null) {
            this.consultas = (ConsultasExtracaoList)ConfiguracaoControle.carregaDadosArquivoXML("extracao", new File(ARQUIVO_EXTRACAO), true);
        }
    }

    public void geraArquivo() throws PADRuntimeException {
        try {
            this.getConsultas();
            ExportacaoDados exp = new ExportacaoDados(this.app);
            exp.montaXMLsaida(this.consultas, this.arquivoSaida, this.remessa, this.tpBanco);
        }
        catch (Exception e) {
            throw new PADRuntimeException("Erro na gera\u00e7\u00e3o do xml de Consolida\u00e7\u00e3o " + e.getMessage());
        }
    }
}

