/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.geracao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.Campo;
import br.gov.rs.tce.pad.beans.Formato;
import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.beans.Mensagens;
import br.gov.rs.tce.pad.beans.Referencia;
import br.gov.rs.tce.pad.beans.RegraConfig;
import br.gov.rs.tce.pad.beans.RegraEvento;
import br.gov.rs.tce.pad.beans.Regras;
import br.gov.rs.tce.pad.beans.RegrasAssociadas;
import br.gov.rs.tce.pad.beans.Tabela;
import br.gov.rs.tce.pad.excecao.VerificacaoException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.verificacao.regras.BaseRegraCampo;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeraAjuda {
    static final Log log = LogFactory.getLog(GeraAjuda.class);
    static final String LF = "\r\n";
    static final Pattern LETTER = Pattern.compile("[^0-9]");
    static final String filePrepend = "<HTML>\r\n<HEAD>\r\n   <script language=\"JavaScript\">\r\n\r\n     function abrir(url)\r\n     {   window.open(url,\"\",\"menubar=no,location=no,resizable=yes,scrollbars=yes,status=no,width=850,height=200,left=100,top=200\");\r\n      }\r\n\r\n   </script>\r\n<link REL=\"stylesheet\" href=\"style.css\" type=\"text/css\">\r\n</HEAD>\r\n<BODY>\r\n<CENTER>\r\n <TABLE border=1 width=\"70%\">\r\n";
    static final String fileAppend = "</TABLE>\r\n</CENTER>\r\n</BODY>\r\n</HTML>\r\n";

    public static void main(String[] args) throws IOException {
        GeraAjuda gera = new GeraAjuda();
        String path = "../PAD-Modelo/ajuda/html/avisos/";
        if (!new File(path).exists()) {
            log.error((Object)("Caminho " + path + " nao exite"));
            return;
        }
        log.info((Object)("path: " + path));
        Map<String, Boolean> regras = gera.getTodasRegras();
        log.info((Object)("#regras=" + regras.size()));
        gera.geraAjuda(regras, path);
    }

    public Map<String, Boolean> getTodasRegras() throws IOException {
        HashSet<String> regrasAtivas = new HashSet<String>();
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-complementares");
        for (Arquivo arq : arquivos.getTodosArquivos()) {
            Referencia[] refs;
            Tabela tab;
            Campo[] campos;
            Formato f;
            int n;
            RegraEvento[] reArr;
            RegrasAssociadas ra = arq.getRegrasAssociadas();
            if (ra != null && (reArr = ra.getRegraEvento()) != null) {
                RegraEvento[] regraEventoArray = reArr;
                int n2 = regraEventoArray.length;
                for (n = 0; n < n2; ++n) {
                    String[] codRegra;
                    RegraEvento re = regraEventoArray[n];
                    String nomeRegra = re.getNomeRegra();
                    log.debug((Object)("arq [" + arq.getIdentificadorNome() + "]: regraEvento: " + nomeRegra));
                    String[] stringArray = codRegra = nomeRegra.split(",");
                    int n3 = stringArray.length;
                    for (int i = 0; i < n3; ++i) {
                        String s = stringArray[i];
                        regrasAtivas.add(s.trim());
                    }
                }
            }
            if ((f = arq.getFormato()) == null) continue;
            Campo[] campoArray = campos = f.getCampo();
            n = campoArray.length;
            for (int re = 0; re < n; ++re) {
                Campo c = campoArray[re];
                String codigos = c.getCodigoMensagem();
                if (codigos != null) {
                    String[] codRegra;
                    for (String s : codRegra = codigos.split(",")) {
                        regrasAtivas.add(s.trim());
                    }
                    log.debug((Object)("CAMPO>> " + codigos));
                }
                List<BaseRegraCampo> brcList = c.getBaseRegrasCampo();
                for (int i = 0; i < brcList.size(); ++i) {
                    String[] codRegra;
                    BaseRegraCampo brc = brcList.get(i);
                    if (brc == null) continue;
                    String codigosBrc = brc.getCodigoMensagem();
                    if (codigosBrc == null) {
                        log.warn((Object)("BaseRegraCampo sem c\u00f3digo... arq = " + arq.getIdentificadorNome() + " ; campo = " + c.getNome() + " ; c\u00f3digos campo = " + codigos));
                        continue;
                    }
                    for (String s : codRegra = codigosBrc.split(",")) {
                        regrasAtivas.add(s.trim());
                    }
                    log.debug((Object)("BRC>> " + codigosBrc + " [" + brc.getClass().getSimpleName() + "]"));
                }
            }
            String arqVazioCodigo = arq.getArquivoVazioCodigoMensagem();
            if (arqVazioCodigo != null) {
                regrasAtivas.add(arqVazioCodigo);
                log.debug((Object)("ArqVazio>> " + arqVazioCodigo));
            }
            if ((tab = arq.getTabela()) == null) continue;
            String codigo = tab.getCodigoMensagemPK();
            if (codigo != null) {
                regrasAtivas.add(codigo);
                log.debug((Object)("PK>> " + codigo));
            }
            for (Referencia r : refs = tab.getReferencia()) {
                String rcod = r.getCodigoMensagem();
                if (rcod == null) continue;
                regrasAtivas.add(rcod);
                log.debug((Object)("FK>> " + rcod));
            }
        }
        Regras regras = (Regras)ConfiguracaoControle.carregaDadosArquivoXML("regras");
        HashSet<String> novasRegras = new HashSet<String>();
        LinkedHashSet<String> codigosMensagems = new LinkedHashSet<String>();
        for (String codigo : regrasAtivas) {
            try {
                RegraConfig rc = regras.getRegraPorNome(codigo);
                if (rc != null) {
                    String codigoMsg = rc.getCodigoMensagem();
                    codigosMensagems.add(codigoMsg);
                    if (regrasAtivas.contains(codigoMsg)) continue;
                    boolean jaExiste = novasRegras.contains(codigoMsg);
                    log.debug((Object)("NovaRegra>> " + codigoMsg + " [existe=" + jaExiste + "]"));
                    if (jaExiste) continue;
                    novasRegras.add(codigoMsg);
                    continue;
                }
                log.warn((Object)("RegraConfig null! codigo = " + codigo));
            }
            catch (VerificacaoException verificacaoException) {}
        }
        if (novasRegras.size() > 0) {
            regrasAtivas.addAll(novasRegras);
        }
        Mensagens mensagens = (Mensagens)ConfiguracaoControle.carregaDadosArquivoXML("mensagens");
        TreeMap<String, Boolean> todasRegras = new TreeMap<String, Boolean>(new CodigoRegraComparator());
        for (Mensagem m : mensagens.getMensagem()) {
            String codigo = m.getCodigo();
            codigosMensagems.remove(codigo);
            if (this.ignorarRegra(codigo)) {
                log.debug((Object)("regra [" + codigo + "] ignorada"));
                continue;
            }
            boolean ativa = regrasAtivas.contains(codigo);
            todasRegras.put(codigo, ativa);
            log.debug((Object)("regra [" + codigo + "]: ativa: " + ativa));
        }
        for (String s : codigosMensagems) {
            log.debug((Object)("> regra [" + s + "] sem mensagem?"));
        }
        return todasRegras;
    }

    boolean ignorarRegra(String codigo) {
        if (codigo.endsWith("enc")) {
            return true;
        }
        if (codigo.startsWith("CAB_")) {
            return true;
        }
        if (codigo.startsWith("ErroArq_")) {
            return true;
        }
        if (codigo.startsWith("FIM_")) {
            return true;
        }
        if (codigo.startsWith("MODELO")) {
            return true;
        }
        if (codigo.startsWith("MSG_")) {
            return true;
        }
        if (codigo.startsWith("ROT_")) {
            return true;
        }
        if (codigo.startsWith("SPR_")) {
            return true;
        }
        return codigo.startsWith("UC048");
    }

    public void geraAjuda(Map<String, Boolean> todasRegras, String path) throws IOException {
        char lastLetter = '\u0000';
        int colCount = 0;
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Boolean> e : todasRegras.entrySet()) {
            String codigo = e.getKey();
            if (codigo.charAt(0) != lastLetter) {
                if (!sb.toString().equals("")) {
                    sb.append("      </TR>\r\n");
                    sb.append(fileAppend);
                    this.writeLetter(path + lastLetter + ".html", sb);
                }
                sb = new StringBuilder();
                sb.append(filePrepend);
                lastLetter = codigo.charAt(0);
                colCount = 0;
            }
            if (colCount == 10) {
                sb.append("      </TR>\r\n");
                colCount = 0;
            }
            if (colCount == 0) {
                sb.append("      <TR>\r\n");
            }
            boolean ativo = e.getValue() == null || e.getValue() != false;
            String textColor = "blue";
            textColor = ativo ? "blue" : "gray";
            String td = "          <TD>\r\n              <OBJECT CLASSID=\"java:com.sun.java.help.impl.JHSecondaryViewer\">\r\n                  <param name=\"content\" value=\"" + codigo + ".html\">" + LF + "                  <param name=\"viewerActivator\" value=\"javax.help.LinkLabel\">" + LF + "                  <param name=\"viewerStyle\" value=\"javax.help.Popup\">" + LF + "                  <param name=\"viewerSize\" value=\"400,250\">" + LF + "                  <param name=\"text\" value=\"" + codigo + "\">" + LF + "                  <param name=\"textColor\" value=\"" + textColor + "\">" + LF + "                  <param name=\"viewerName\" value=\"glossary\">" + LF + "              </OBJECT>" + LF + "          </TD>" + LF;
            sb.append(td);
            ++colCount;
        }
        if (!sb.toString().equals("")) {
            sb.append("      </TR>\r\n");
            sb.append(fileAppend);
            this.writeLetter(path + lastLetter + ".html", sb);
        }
    }

    void writeLetter(String path, StringBuilder sb) throws IOException {
        File f = new File(path);
        if (f.exists()) {
            // empty if block
        }
        log.info((Object)("criando arquivo: " + path));
        FileWriter fw = new FileWriter(path);
        fw.write(sb.toString());
        fw.close();
    }

    public static class CodigoRegraComparator
    implements Comparator<String> {
        @Override
        public int compare(String o1, String o2) {
            String[] s2a;
            String c2;
            String[] s1a = o1.split("_");
            String c1 = s1a[0];
            int comp = c1.compareTo(c2 = (s2a = o2.split("_"))[0]);
            if (comp != 0) {
                return comp;
            }
            if (s1a.length <= 1 || s2a.length <= 1) {
                return o1.compareTo(o2);
            }
            try {
                String n1s = s1a[1];
                String n2s = s2a[1];
                Matcher l1 = LETTER.matcher(n1s);
                Matcher l2 = LETTER.matcher(n2s);
                int n1 = -1;
                int n2 = -1;
                n1 = l1.find() ? Integer.parseInt(n1s.substring(0, l1.start())) : Integer.parseInt(n1s);
                n2 = l2.find() ? Integer.parseInt(n2s.substring(0, l2.start())) : Integer.parseInt(n2s);
                int ret = n1 - n2;
                if (ret != 0) {
                    return ret;
                }
                return o1.compareTo(o2);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("NFE: " + e + " [o1=" + o1 + ";o2=" + o2 + "]"));
                return o1.compareTo(o2);
            }
        }
    }
}

