/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.IdentificadorArquivo;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.ParametrosList;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import java.io.Serializable;

public final class RegraConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String _nome;
    private String _codigoMensagem;
    private String _javaClass;
    private String _extende;
    private char[] _entidades;
    private int[] _periodos;
    private int[] _meses;
    private ParametrosList _parametrosMap = new ParametrosList();
    private String _depende;
    private IdentificadorArquivo[] _dependencias;

    public RegraConfig() {
        this._entidades = new char[0];
        this._periodos = new int[0];
        this._meses = new int[0];
    }

    public void addParametro(Parametro vParametro) throws IndexOutOfBoundsException {
        this._parametrosMap.adicionaParametro(vParametro);
    }

    public String getCodigoMensagem() {
        return this._codigoMensagem;
    }

    public String getEntidades() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._entidades.length; ++i) {
            buf.append(this._entidades[i]);
            if (i + 1 >= this._entidades.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String getJavaClass() {
        return this._javaClass;
    }

    public String getNome() {
        return this._nome;
    }

    public Parametro getParametro(String nome) {
        return this._parametrosMap.getParametroPorNome(nome.toLowerCase());
    }

    public ParametrosList getParametros() {
        return this._parametrosMap;
    }

    public void setParametros(ParametrosList parametros) {
        this._parametrosMap = parametros;
    }

    public String getPeriodos() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._periodos.length; ++i) {
            buf.append(this._periodos[i]);
            if (i + 1 >= this._periodos.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public String getMeses() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this._meses.length; ++i) {
            buf.append(this._meses[i]);
            if (i + 1 >= this._meses.length) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public void setCodigoMensagem(String codigoMensagem) {
        this._codigoMensagem = codigoMensagem;
    }

    public void setEntidades(String entidades) {
        if (entidades != null && !entidades.equals("")) {
            String[] listaEntidades = entidades.toUpperCase().split(",");
            this._entidades = new char[listaEntidades.length];
            for (int i = 0; i < listaEntidades.length; ++i) {
                this._entidades[i] = listaEntidades[i].charAt(0);
            }
        }
    }

    public boolean isAssociadaEntidade(String abreviaturaEntidade) {
        char tipoSetor = abreviaturaEntidade.toUpperCase().charAt(0);
        boolean isAssociada = false;
        if (this._entidades.length > 0) {
            for (int i = 0; i < this._entidades.length; ++i) {
                if (this._entidades[i] != tipoSetor) continue;
                isAssociada = true;
                break;
            }
        } else {
            isAssociada = true;
        }
        return isAssociada;
    }

    public void setJavaClass(String javaClass) {
        this._javaClass = javaClass;
    }

    public void setNome(String nome) {
        this._nome = nome;
    }

    public void setPeriodos(String periodos) {
        if (periodos != null && !periodos.equals("")) {
            String[] listaPeriodos = periodos.toUpperCase().split(",");
            this._periodos = new int[listaPeriodos.length];
            for (int i = 0; i < listaPeriodos.length; ++i) {
                this._periodos[i] = Integer.parseInt(listaPeriodos[i].trim());
            }
        }
    }

    public void setMeses(String meses) {
        if (meses != null && !meses.equals("")) {
            String[] listaMeses = meses.toUpperCase().split(",");
            this._meses = new int[listaMeses.length];
            for (int i = 0; i < listaMeses.length; ++i) {
                this._meses[i] = Integer.parseInt(listaMeses[i].trim());
            }
        }
    }

    public boolean isAssociadaPeriodo(int periodo) {
        boolean isAssociada = false;
        if (this._periodos.length > 0) {
            for (int i = 0; i < this._periodos.length; ++i) {
                if (this._periodos[i] != periodo) continue;
                isAssociada = true;
                break;
            }
        } else {
            isAssociada = true;
        }
        return isAssociada;
    }

    public boolean isAssociadaMes(int mes) {
        boolean isAssociada = false;
        if (this._meses.length > 0) {
            for (int i = 0; i < this._meses.length; ++i) {
                if (this._meses[i] != mes) continue;
                isAssociada = true;
                break;
            }
        } else {
            isAssociada = true;
        }
        return isAssociada;
    }

    public void setDepende(String depende) {
        this._depende = depende;
        if (depende != null && !depende.equals("")) {
            String[] nomesArquivo = this._depende.split(",");
            this._dependencias = new IdentificadorArquivo[nomesArquivo.length];
            for (int i = 0; i < nomesArquivo.length; ++i) {
                this._dependencias[i] = Arquivo.criaIdenficadorArquivo(nomesArquivo[i].trim());
            }
        }
    }

    public IdentificadorArquivo[] getDependencias() {
        return this._dependencias;
    }

    public String getDepende() {
        return this._depende;
    }

    public ConsultaSQL recuperaConsultaSQL(Remessa remessa, CabecalhoArquivo cabecalhoArquivo, TipoBancoDados tpBanco) {
        return this._parametrosMap.recuperaConsultaSQL(remessa, cabecalhoArquivo, "consulta.parametro", tpBanco);
    }

    public void setExtende(String extende) {
        this._extende = extende;
    }

    public String getExtende() {
        return this._extende;
    }
}

