/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.CabecalhoArquivo;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasQuadrosList;
import br.gov.rs.tce.pad.beans.Parametro;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.ConfiguracaoException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.util.ResolveStringConstantes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ParametrosList
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_CONSULTA_SQL = "consulta-sql";
    public static final String PARAM_CONSULTA_SQL_DERBY = "consulta-sql-derby";
    public static final String PARAMS_CONSULTA_SQL = "consulta.parametro";
    public static final String PARAMS_SUBSTITUIR = "consulta.substituir.";
    public static final String REF_CONSULTAS_QUADROS = "quadros";
    public static final String REF_CONSULTAS_REGRAS = "regras";
    private Map<String, Parametro> _parametrosMap = new LinkedHashMap<String, Parametro>();

    public void adicionaParametro(Parametro vParametro) throws IndexOutOfBoundsException {
        this._parametrosMap.put(vParametro.getNome(), vParametro);
    }

    public Parametro getParametroPorNome(String nome) {
        if (nome == null) {
            throw new IllegalArgumentException("O nome do parametro n\u00e3o pode ser nulo");
        }
        return this._parametrosMap.get(nome.toLowerCase());
    }

    public Map<String, Parametro> getParametroMap() {
        return this._parametrosMap;
    }

    public List<String> buscaParametros(String nomeParametro, TipoBancoDados tpBanco) {
        ArrayList<String> valores = new ArrayList<String>();
        for (Parametro param : this._parametrosMap.values()) {
            String banco = param.getBanco();
            if (!param.getNome().startsWith(nomeParametro)) continue;
            if (banco == null) {
                valores.add(param.getValor());
                continue;
            }
            if (!TipoBancoDados.valueOf(banco).equals(tpBanco)) continue;
            valores.add(param.getValor());
        }
        return valores;
    }

    public List<String> buscaNomesParametros(String nomeParametro) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Parametro param : this._parametrosMap.values()) {
            if (!param.getNome().startsWith(nomeParametro)) continue;
            ret.add(param.getNome());
        }
        return ret;
    }

    public ConsultaSQL recuperaConsultaSQL(Remessa remessa, String nomeParametro, TipoBancoDados tpBanco) {
        return this.recuperaConsultaSQL(remessa, null, nomeParametro, tpBanco);
    }

    public ConsultaSQL recuperaConsultaSQL(Remessa remessa, CabecalhoArquivo cabecalhoArquivo, String nomeParametro, TipoBancoDados tpBanco) {
        ConsultaSQL consultaSQL = null;
        Parametro param = null;
        String nomePar = null;
        if (tpBanco.equals(TipoBancoDados.ORACLE_DB)) {
            nomePar = PARAM_CONSULTA_SQL;
            param = this.getParametroPorNome(PARAM_CONSULTA_SQL);
        } else if (tpBanco.equals(TipoBancoDados.DERBY_DB)) {
            nomePar = PARAM_CONSULTA_SQL_DERBY;
            param = this.getParametroPorNome(PARAM_CONSULTA_SQL_DERBY);
            if (param == null) {
                nomePar = PARAM_CONSULTA_SQL;
                param = this.getParametroPorNome(PARAM_CONSULTA_SQL);
            }
        }
        if (param == null) {
            throw new ConfiguracaoException("N\u00e3o foi localizado um parametro de consulta neste quadro [" + nomePar + "].");
        }
        String refExterna = param.getReferenciaExterna();
        if (refExterna != null) {
            consultaSQL = ParametrosList.resolveReferenciaSQL(param.getValor(), refExterna);
            List<String> nomesParametros = this.buscaParametros(nomeParametro, tpBanco);
            Object[] valores = this.recuperaValorParametros(nomesParametros, remessa, cabecalhoArquivo);
            consultaSQL.setValores(valores);
        } else {
            String sql = null;
            if (param == null) {
                throw new IllegalArgumentException("N\u00e3o foi possivel localizar nenhuma consulta SQL nesta lista de parametros");
            }
            sql = param.getValor();
            List<String> nomesParametros = this.buscaParametros(nomeParametro, tpBanco);
            Object[] valores = this.recuperaValorParametros(nomesParametros, remessa, cabecalhoArquivo);
            consultaSQL = new ConsultaSQL(sql, valores);
        }
        return consultaSQL;
    }

    private static ConsultaSQL resolveReferenciaSQL(String valor, String refExterna) {
        ConsultaSQL sql = null;
        if (refExterna == null) {
            throw new IllegalArgumentException("RefExterna n\u00e3o pode ser nulo");
        }
        if (valor == null) {
            throw new IllegalArgumentException("Valor n\u00e3o pode ser nulo");
        }
        if (refExterna.equals(REF_CONSULTAS_QUADROS)) {
            ConsultasQuadrosList sqlQuadros = (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros");
            sql = sqlQuadros.getConsultaPorCodigo(valor);
            if (sql == null) {
                throw new IllegalStateException("N\u00e3o foi possivel localizar uma consulta com o nome: " + valor + " [refExterna=" + refExterna + "]");
            }
        } else if (refExterna.equals(REF_CONSULTAS_REGRAS)) {
            ConsultasQuadrosList sqlQuadros = (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-regras");
            sql = sqlQuadros.getConsultaPorCodigo(valor);
            if (sql == null) {
                throw new IllegalStateException("N\u00e3o foi possivel localizar uma consulta com o nome: " + valor + " [refExterna=" + refExterna + "]");
            }
        } else {
            throw new IllegalArgumentException("Tipo de referencia externa n\u00e3o reconhecido");
        }
        return sql;
    }

    protected Object[] recuperaValorParametros(List<String> nomeParametros, Remessa remessa) {
        return this.recuperaValorParametros(nomeParametros, remessa, null);
    }

    protected Object[] recuperaValorParametros(List<String> nomeParametros, Remessa remessa, CabecalhoArquivo cabecalhoArquivo) {
        int qtdParametros = nomeParametros.size();
        Object[] retorno = new Object[qtdParametros];
        for (int i = 0; i < qtdParametros; ++i) {
            String valorParametro = nomeParametros.get(i);
            retorno[i] = ResolveStringConstantes.getValorString(valorParametro, remessa, cabecalhoArquivo);
            if (retorno[i] != null) continue;
            retorno[i] = valorParametro;
        }
        return retorno;
    }

    public int size() {
        return this._parametrosMap.size();
    }

    public boolean isEmpty() {
        return this._parametrosMap.isEmpty();
    }
}

