/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Mensagem;
import br.gov.rs.tce.pad.excecao.MensagemInvalidaException;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class Mensagens
implements Serializable {
    private Map<String, Mensagem> _mapaMensagens = new TreeMap<String, Mensagem>(new MensagemComparator());

    public void addMensagem(Mensagem vMensagem) throws IndexOutOfBoundsException {
        if (vMensagem.getExtende() != null) {
            this.trataExtensao(vMensagem);
        }
        this._mapaMensagens.put(vMensagem.getCodigo(), vMensagem);
    }

    public void clearMensagem() {
        this._mapaMensagens.clear();
    }

    public Mensagem getMensagemPorCodigo(String codigoMensagem) {
        Mensagem msg = null;
        if (codigoMensagem != null) {
            msg = this._mapaMensagens.get(codigoMensagem);
        }
        if (msg == null) {
            throw new MensagemInvalidaException(codigoMensagem);
        }
        return msg;
    }

    public int getMensagemCount() {
        return this._mapaMensagens.size();
    }

    public Mensagem[] getMensagem() {
        int size = this._mapaMensagens.size();
        Mensagem[] mArray = new Mensagem[size];
        int index = 0;
        Iterator<Mensagem> it = this._mapaMensagens.values().iterator();
        while (it.hasNext()) {
            mArray[index] = it.next();
            ++index;
        }
        return mArray;
    }

    private void trataExtensao(Mensagem message) {
        String extensao = message.getExtende();
        Mensagem msgExtensao = this._mapaMensagens.get(extensao);
        if (msgExtensao == null) {
            throw new IllegalArgumentException("Mensagem " + extensao + " n\u00e3o localiza para extender " + message.getCodigo());
        }
        message.setTexto(message.getTexto() == null ? msgExtensao.getTexto() : message.getTexto());
        message.setTipo(message.getTipo() == null ? msgExtensao.getTipo() : message.getTipo());
    }

    private static final class MensagemComparator
    implements Comparator<String>,
    Serializable {
        transient Collator col = Collator.getInstance();

        private MensagemComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (!(o1 instanceof String) && !(o2 instanceof String)) {
                throw new IllegalArgumentException("Este comparador s\u00f3 pode ser usado com objetos String");
            }
            return this.col.compare(o1, o2);
        }
    }
}

