/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.beans;

import br.gov.rs.tce.pad.beans.Campo;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.exolab.castor.util.IteratorEnumeration;

public final class Formato
implements Serializable {
    private List<Campo> _campoList = new LinkedList<Campo>();
    private Set<String> _nomeCampos = new HashSet<String>();

    public void addCampo(Campo vCampo) throws IndexOutOfBoundsException {
        this._campoList.add(vCampo);
        this._nomeCampos.add(vCampo.getNome());
    }

    public void addCampo(int index, Campo vCampo) throws IndexOutOfBoundsException {
        this._campoList.add(index, vCampo);
        this._nomeCampos.add(vCampo.getNome());
    }

    public void clearCampo() {
        this._campoList.clear();
    }

    public Enumeration enumerateCampo() {
        return new IteratorEnumeration(this._campoList.iterator());
    }

    public Campo getCampo(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index > this._campoList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this._campoList.get(index);
    }

    public Campo[] getCampo() {
        int size = this._campoList.size();
        Campo[] mArray = new Campo[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = this._campoList.get(index);
        }
        return mArray;
    }

    public int getNumeroCampoPorColuna(String nomeColuna) {
        Campo campo = null;
        int numeroCampo = 0;
        if (nomeColuna != null && !nomeColuna.equals("")) {
            for (int index = 0; index < this._campoList.size(); ++index) {
                campo = this._campoList.get(index);
                if (!campo.getNome().equalsIgnoreCase(nomeColuna)) continue;
                numeroCampo = index + 1;
                break;
            }
        }
        return numeroCampo;
    }

    public int getCampoCount() {
        return this._campoList.size();
    }

    public boolean removeCampo(Campo vCampo) {
        boolean removed = this._campoList.remove(vCampo);
        return removed;
    }

    public boolean verificaNomeCampo(String nomeCampo) {
        return this._nomeCampos.contains(nomeCampo);
    }

    public String getNomeCampo(int i) {
        return this._campoList.get(i).getNome();
    }
}

