/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mail;

import br.gov.rs.tce.mail.MailContext;
import br.gov.rs.tce.mail.exception.MailException;
import java.io.File;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.velocity.Template;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TemplateMail {
    private static final String MAIL_RESOURCES = "mail.properties";
    private static final String VELOCITY_RESOURCES = "/velocity.properties";
    private static final String CONFIG_MAIL_SMTP_SERVER = "mail.server.host";
    private static final String CONFIG_MAIL_SERVER_PORT = "mail.server.port";
    private static final String CONFIG_MAIL_SERVER_USES_SSL = "mail.server.ssl";
    private static final String CONFIG_SERVER_USERNAME_TO_SEND = "mail.server.username";
    private static final String CONFIG_SERVER_PASSWORD_TO_SEND = "mail.server.password";
    private static final String CONFIG_MAIL_FROM_ADDRESS = "mail.message.from";
    private static final String CONFIG_MAIL_FROM_NAME = "mail.message.fromName";
    private static final String CONFIG_MAIL_SUBJECT = "mail.message.subject";
    private static Log LOG = LogFactory.getLog(TemplateMail.class.getClass());
    private HtmlEmail mail = new HtmlEmail();
    private static CompositeConfiguration config = null;
    private static Pattern mailFilter = Pattern.compile("[^\\s,;@]+@[^\\s,;@]+");

    public TemplateMail() throws MailException {
        if (config == null) {
            this.loadConfig();
        }
    }

    public void setSubject(String subject) {
        this.mail.setSubject(subject);
        LOG.info((Object)("Subject '" + subject));
    }

    public void setSubject(String subject, MailContext ctx) {
        try {
            VelocityEngine ve = new VelocityEngine();
            ve.init();
            StringWriter w = new StringWriter();
            ve.evaluate((Context)ctx, (Writer)w, "SetSubject", subject);
            this.mail.setSubject(w.toString());
        }
        catch (Exception e) {
            LOG.error((Object)("Error when set subject using ctx:" + e.getMessage()), (Throwable)e);
        }
    }

    public void setSender(String email, String name) {
        try {
            this.mail.setFrom(email, name);
        }
        catch (EmailException e) {
            LOG.error((Object)("Error when set sender using mail '" + email + "' and name '" + name + "'"));
        }
    }

    public void addTo(String emailAddress) throws IllegalArgumentException, MailException {
        try {
            Matcher matcher = mailFilter.matcher(emailAddress);
            while (matcher.find()) {
                this.mail.addTo(matcher.group());
            }
        }
        catch (EmailException e) {
            LOG.warn((Object)("Error when add email address:" + emailAddress), (Throwable)e);
            if (emailAddress == null) {
                throw new IllegalArgumentException("The mail cannot be null!");
            }
            if (emailAddress.equals("")) {
                throw new IllegalArgumentException("The mail cannot be empty!");
            }
            throw new MailException("The mail is not well formed:" + emailAddress, (Exception)((Object)e));
        }
    }

    public void addCc(String emailAddress) throws IllegalArgumentException, MailException {
        try {
            Matcher matcher = mailFilter.matcher(emailAddress);
            while (matcher.find()) {
                this.mail.addCc(matcher.group());
            }
        }
        catch (EmailException e) {
            LOG.warn((Object)("Error when add email address:" + emailAddress), (Throwable)e);
            if (emailAddress == null) {
                throw new IllegalArgumentException("The mail cannot be null!");
            }
            if (emailAddress.equals("")) {
                throw new IllegalArgumentException("The mail cannot be empty!");
            }
            throw new MailException("The mail is not well formed:" + emailAddress, (Exception)((Object)e));
        }
    }

    public void addReplyTo(String emailAddress) throws IllegalArgumentException, MailException {
        try {
            Matcher matcher = mailFilter.matcher(emailAddress);
            while (matcher.find()) {
                this.mail.addReplyTo(matcher.group());
            }
        }
        catch (EmailException e) {
            LOG.warn((Object)("Error when add email address:" + emailAddress), (Throwable)e);
            if (emailAddress == null) {
                throw new IllegalArgumentException("The mail cannot be null!");
            }
            if (emailAddress.equals("")) {
                throw new IllegalArgumentException("The mail cannot be empty!");
            }
            throw new MailException("The mail is not well formed:" + emailAddress, (Exception)((Object)e));
        }
    }

    public void addAttachment(File attachmentFile) throws MailException {
        this.addAttachment(attachmentFile, attachmentFile.getName());
    }

    public void addAttachment(File attachmentFile, String attachmentName) throws MailException {
        LOG.info((Object)("Added file attachment to mail:" + attachmentFile.getAbsolutePath()));
        EmailAttachment attachment = new EmailAttachment();
        attachment.setPath(attachmentFile.getAbsolutePath());
        attachment.setDisposition("attachment");
        attachment.setName(attachmentName);
        try {
            this.mail.attach(attachment);
        }
        catch (EmailException e) {
            String filename = attachmentFile.getAbsolutePath();
            if (filename == null) {
                LOG.warn((Object)"Could not attach the file to mail. Filename is null!", (Throwable)e);
                throw new MailException("Could not attach the file to mail. Filename is null!", (Exception)((Object)e));
            }
            LOG.warn((Object)("Could not attach the file to mail:" + filename), (Throwable)e);
            throw new MailException("Could not attach the file to mail:" + filename, (Exception)((Object)e));
        }
    }

    public void send() throws MailException {
        LOG.info((Object)"Trying to send email");
        try {
            this.mail.send();
            LOG.info((Object)"Mail sent");
        }
        catch (EmailException e) {
            LOG.warn((Object)"Error when send a mail", (Throwable)e);
            throw new MailException("Error when send a mail", (Exception)((Object)e));
        }
    }

    public void loadConfig() throws MailException {
        this.loadConfig(MAIL_RESOURCES);
    }

    public void loadConfig(String configFilename) throws MailException {
        LOG.info((Object)("Loading configuration to mail:" + configFilename));
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new PropertiesConfiguration(configFilename));
            this.mail.setHostName(config.getString(CONFIG_MAIL_SMTP_SERVER));
            String porta = config.getString(CONFIG_MAIL_SERVER_PORT);
            if (porta != null && !porta.equals("")) {
                this.mail.setSmtpPort(Integer.parseInt(porta));
            }
            this.mail.setSSL(config.getBoolean(CONFIG_MAIL_SERVER_USES_SSL));
            String username = config.getString(CONFIG_SERVER_USERNAME_TO_SEND);
            String password = config.getString(CONFIG_SERVER_PASSWORD_TO_SEND);
            if (username != null && password != null && !username.equals("") && !password.equals("")) {
                this.mail.setAuthentication(username, password);
            }
            this.mail.setFrom(config.getString(CONFIG_MAIL_FROM_ADDRESS), config.getString(CONFIG_MAIL_FROM_NAME));
            this.mail.setSubject(config.getString(CONFIG_MAIL_SUBJECT));
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when load configurations file '" + configFilename + "': " + e.getMessage()), (Throwable)e);
            throw new MailException("Error when load configurations file '" + configFilename + "': " + e.getMessage(), e);
        }
    }

    public void loadTemplate(String templateFile) throws MailException {
        this.loadTemplate(templateFile, new MailContext());
    }

    public void loadTemplate(String templateFile, MailContext context) throws MailException {
        LOG.info((Object)("Loading template:" + templateFile));
        try {
            VelocityEngine ve = new VelocityEngine();
            Properties prop = new Properties();
            InputStream is = this.getClass().getResourceAsStream(VELOCITY_RESOURCES);
            prop.load(is);
            ve.init(prop);
            Template t = ve.getTemplate(templateFile);
            this.mail.setCharset(t.getEncoding());
            LOG.info((Object)("Encoding: " + t.getEncoding()));
            StringWriter writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
            this.setHtmlMessage(writer.toString());
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when load template '" + templateFile + "': " + e.getMessage()), (Throwable)e);
            throw new MailException("Error when load template '" + templateFile + "': " + e.getMessage(), e);
        }
    }

    public void setHtmlMessage(String html) throws MailException {
        this.setHtmlMessage(html, "Cp1252");
    }

    public void setHtmlMessage(String html, String encoding) throws MailException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            dbf.setIgnoringComments(true);
            html = TemplateMail.removeComments(html);
            DocumentBuilder docBuilder = dbf.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(html)));
            this.setHtmlMessage(doc, encoding);
        }
        catch (Exception e) {
            LOG.warn((Object)("Error when setting html message:" + html), (Throwable)e);
            throw new MailException("Error when setting html message:" + html, e);
        }
    }

    private static String removeComments(String html) {
        int beginComment = html.indexOf("<!--");
        int endComment = html.indexOf("-->");
        while (beginComment < endComment && beginComment > 0) {
            html = html.substring(0, beginComment) + html.substring(endComment + 3, html.length());
            beginComment = html.indexOf("<!--");
            endComment = html.indexOf("-->");
        }
        return html;
    }

    private void setHtmlMessage(Document xmlDoc, String encoding) throws EmailException, TransformerConfigurationException, TransformerException {
        NodeList nodes = xmlDoc.getElementsByTagName("img");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            NamedNodeMap att = n.getAttributes();
            String imagem = att.getNamedItem("src").getNodeValue();
            File img = new File(imagem);
            String cid = this.mail.embed(img);
            n.getAttributes().getNamedItem("src").setNodeValue("cid:" + cid);
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", encoding);
        StreamResult result = new StreamResult(new StringWriter());
        DOMSource source = new DOMSource(xmlDoc);
        transformer.transform(source, result);
        String xmlString = result.getWriter().toString();
        this.mail.setHtmlMsg(xmlString);
    }

    public void setMessage(String message) throws MailException {
        try {
            this.mail.setMsg(message);
        }
        catch (EmailException e) {
            LOG.warn((Object)("Error when setting mail message:" + message), (Throwable)e);
            throw new MailException("Error when setting mail message:" + message, (Exception)((Object)e));
        }
    }
}

