/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.mail;

import br.gov.rs.tce.mail.exception.MailException;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;

public class MailContext
extends VelocityContext {
    private static Log LOG = LogFactory.getLog(MailContext.class.getClass());

    public void putBean(Object bean) {
        String beanName = bean.getClass().getSimpleName();
        this.put(beanName, bean);
    }

    public void putBeanProperties(Object bean) throws MailException {
        Method[] methods;
        PropertyUtilsBean beanUtil = new PropertyUtilsBean();
        for (Method m : methods = bean.getClass().getMethods()) {
            String property = m.getName();
            if (!property.startsWith("get")) continue;
            property = property.replaceFirst("get", "");
            char[] p = property.toCharArray();
            p[0] = Character.toLowerCase(p[0]);
            property = new String(p);
            Object value = null;
            try {
                value = beanUtil.getProperty(bean, property);
            }
            catch (Exception e) {
                LOG.warn((Object)("Error when getting property from bean:" + property), (Throwable)e);
                throw new MailException("Error when getting property from bean: " + property, e);
            }
            this.put(property, value);
        }
    }
}

