/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.validacao;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adf.view.faces.component.UIXEditableValue;
import oracle.jbo.domain.ClobDomain;
import oracle.jbo.domain.Date;
import oracle.jbo.domain.Number;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ValidacaoCampoHelper {
    static Log LOG = LogFactory.getLog(ValidacaoCampoHelper.class);
    private static NumberFormat nfCPF = null;
    private static Pattern mailRegex = null;

    private ValidacaoCampoHelper() {
    }

    public static boolean validateNome(String nome) {
        if (nome == null || nome.length() == 0) {
            return false;
        }
        String[] particulas = nome.trim().split("[ ]+");
        if (particulas.length <= 1) {
            LOG.debug((Object)("Nome invalido: [" + nome + "]"));
            return false;
        }
        return true;
    }

    public static boolean validateCPF(Object cpf) {
        if (cpf == null) {
            return false;
        }
        String auxCpf = cpf.toString().replace(".", "").replace("-", "").replace("\\", "").replace("/", "");
        long valorCPF = Long.valueOf(auxCpf);
        if (valorCPF == 0L) {
            return false;
        }
        if (valorCPF > 99999999999L) {
            return false;
        }
        return ValidacaoCampoHelper.validateCPF(auxCpf);
    }

    public static boolean validateCPF(java.lang.Number cpf) {
        if (cpf == null) {
            return false;
        }
        long valorCPF = cpf.longValue();
        if (valorCPF == 0L) {
            return false;
        }
        if (valorCPF > 99999999999L) {
            return false;
        }
        String cpfStr = ValidacaoCampoHelper.getCpfFormat().format(valorCPF);
        return ValidacaoCampoHelper.validateCPF(cpfStr);
    }

    public static boolean validateCPF(String cpf) {
        for (int i = 0; i < cpf.length(); ++i) {
            if (Character.isDigit(cpf.charAt(i))) continue;
            return false;
        }
        while (cpf.length() < 11) {
            cpf = "0" + cpf;
        }
        int soma = 0;
        if (cpf.length() == 11) {
            int i;
            for (i = 0; i < 9; ++i) {
                soma += (10 - i) * (cpf.charAt(i) - 48);
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == cpf.charAt(9) - 48) {
                soma = 0;
                for (i = 0; i < 10; ++i) {
                    soma += (11 - i) * (cpf.charAt(i) - 48);
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == cpf.charAt(10) - 48) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean validateRG(String rg) {
        int DCD;
        if (rg == null) {
            return false;
        }
        if (rg.length() > 10) {
            return false;
        }
        String NRU = StringUtils.leftPad((String)rg, (int)10, (char)'0');
        int D0 = Integer.parseInt(NRU.substring(0, 1));
        int D1 = Integer.parseInt(NRU.substring(1, 2));
        int D2 = Integer.parseInt(NRU.substring(2, 3));
        int D3 = Integer.parseInt(NRU.substring(3, 4));
        int D4 = Integer.parseInt(NRU.substring(4, 5));
        int D5 = Integer.parseInt(NRU.substring(5, 6));
        int D6 = Integer.parseInt(NRU.substring(6, 7));
        int D7 = Integer.parseInt(NRU.substring(7, 8));
        int D8 = Integer.parseInt(NRU.substring(8, 9));
        int D9 = Integer.parseInt(NRU.substring(9, 10));
        int TOTAL = D1 * 2 + D2 * 3 + D3 * 4 + D4 * 5 + D5 * 6 + D6 * 7 + D7 * 8 + D8 * 9;
        int RESTO = TOTAL % 11;
        int DCE = RESTO == 0 || RESTO == 1 ? 1 : 11 - RESTO;
        if (D0 != DCE) {
            return D0 == DCE;
        }
        TOTAL = D0 * 2 % 9 + D1 + D2 * 2 % 9 + D3 + D4 * 2 % 9 + D5;
        TOTAL = TOTAL + D6 * 2 % 9 + D7 + D8 * 2 % 9;
        if (D0 == 9) {
            TOTAL += 9;
        }
        if (D2 == 9) {
            TOTAL += 9;
        }
        if (D4 == 9) {
            TOTAL += 9;
        }
        if (D6 == 9) {
            TOTAL += 9;
        }
        if (D8 == 9) {
            TOTAL += 9;
        }
        if (D9 != (DCD = (RESTO = TOTAL % 10) == 0 ? 1 : 10 - RESTO)) {
            return D9 == DCD;
        }
        return D9 == DCD;
    }

    public static boolean validateNumber(String number) {
        if (number == null || number.equals("")) {
            return false;
        }
        try {
            Integer.parseInt(number);
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return false;
        }
        return true;
    }

    private static NumberFormat getCpfFormat() {
        if (nfCPF == null) {
            nfCPF = new DecimalFormat("00000000000");
        }
        return nfCPF;
    }

    public static boolean validateEmail(String email) {
        if (email == null) {
            return false;
        }
        email = email.trim();
        Matcher matcher = ValidacaoCampoHelper.getMailRegex().matcher(email);
        if (!matcher.find(0)) {
            return false;
        }
        return email.length() == matcher.end();
    }

    private static Pattern getMailRegex() {
        if (mailRegex == null) {
            mailRegex = Pattern.compile("[\\x41-\\x5A\\x61-\\x7A0-9._%+-]+@(?:[\\x41-\\x5A\\x61-\\x7A0-9-]+\\.)+[\\x41-\\x5A\\x61-\\x7A]{2,4}");
        }
        return mailRegex;
    }

    public static boolean validateCargo(String cargo) {
        if (cargo.length() == 0) {
            return true;
        }
        return cargo.length() >= 3;
    }

    public static boolean validateEndereco(String end) {
        if (end.length() == 0) {
            return true;
        }
        return end.length() >= 3;
    }

    public static boolean validateTelefone(String fone) {
        return fone != null && fone.length() >= 8;
    }

    public static boolean validateNr(BigDecimal nr) {
        String num = String.valueOf(nr.intValue());
        return !num.equals("");
    }

    public static boolean validateLong(String s) {
        if (s == null) {
            return false;
        }
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean validateMinimoSequenciasCaracter(String nome) {
        if (nome.length() == 0) {
            return false;
        }
        return nome.indexOf(" ") != -1;
    }

    public static boolean validateMinimoSequenciasCaracter(String nome, int seq) {
        if (nome == null) {
            return false;
        }
        if ((nome = nome.trim()).length() == 0) {
            return false;
        }
        return nome.length() > seq;
    }

    public static boolean isVazio(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().length() == 0;
    }

    public static boolean isVazio(ClobDomain clob) {
        if (clob == null) {
            return true;
        }
        if (clob.getLength() == 0L) {
            return true;
        }
        try {
            int n;
            char[] buffer = new char[10];
            Reader clobReader = clob.getCharacterStream();
            while ((n = clobReader.read(buffer)) != -1) {
                for (int i = 0; i < n; ++i) {
                    if (Character.isWhitespace(buffer[i])) continue;
                    return false;
                }
            }
        }
        catch (IOException ex) {
            LOG.debug((Object)ex.toString());
        }
        return true;
    }

    public static boolean isVazio(Date date) {
        if (date == null) {
            return true;
        }
        String s = date.toString();
        return ValidacaoCampoHelper.isVazio(s);
    }

    public static boolean isVazio(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            return ValidacaoCampoHelper.isVazio((String)o);
        }
        if (o instanceof ClobDomain) {
            return ValidacaoCampoHelper.isVazio((ClobDomain)o);
        }
        if (o instanceof Date) {
            return ValidacaoCampoHelper.isVazio((Date)o);
        }
        LOG.warn((Object)("isVazio nao definido para classe: " + o.getClass()));
        return false;
    }

    public static boolean isSOCSelected(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Integer) {
            return true;
        }
        if (o instanceof String) {
            return !o.equals("");
        }
        return false;
    }

    public static boolean isPreenchido(UIXEditableValue uev) {
        LOG.debug((Object)("isPreenchido:: submitted:[" + uev.getSubmittedValue() + "] / value: [" + uev.getValue() + "] / local: [" + uev.getLocalValue() + "]"));
        return uev.getSubmittedValue() != null && !"".equals(uev.getSubmittedValue());
    }

    public static boolean isInteiroPositivo(Object o) {
        if (o == null) {
            return false;
        }
        LOG.debug((Object)("classe: " + o.getClass()));
        Integer i = ValidacaoCampoHelper.getInteger(o);
        if (i == null) {
            return false;
        }
        LOG.debug((Object)("parametro: " + i + " /  " + o.getClass() + " / " + (i > 0)));
        return i > 0;
    }

    public static boolean isNumeroPositivo(Object o) {
        Double d = ValidacaoCampoHelper.getDouble(o);
        if (d == null) {
            return false;
        }
        return d > 0.0;
    }

    public static Double getDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        if (o instanceof String) {
            try {
                String s = ValidacaoCampoHelper.replaceControlCharsBR((String)o);
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        LOG.warn((Object)("getDouble(): valor nao suportado: [" + o + "] clase: " + o.getClass()));
        return null;
    }

    public static Integer getInteger(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            Number on = (Number)o;
            return on.intValue();
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof String) {
            try {
                String s = ValidacaoCampoHelper.replaceControlCharsBR((String)o);
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        LOG.warn((Object)("getInteger(): valor n\u00e3o suportado: " + o + " classe: " + o.getClass().getName()));
        return null;
    }

    static String replaceControlCharsBR(String s) {
        s = s.replaceAll("\\.", "");
        return s.replaceAll(",", ".");
    }

    public static boolean validateTituloEleitor(long tituloDigito) {
        int iSoma2;
        int iResto2;
        long max = 999999999999L;
        if (tituloDigito <= 0L || tituloDigito > 999999999999L) {
            return false;
        }
        String sTituloDigito = String.valueOf(tituloDigito);
        int len = sTituloDigito.length();
        String sTitulo = sTituloDigito.substring(0, len - 3);
        sTitulo = ValidacaoCampoHelper.lpad(sTitulo, '0', 10);
        String sDigVer = sTituloDigito.substring(len - 3, len - 1);
        int iDig1 = 0;
        int iDig2 = 0;
        int iSoma = Integer.parseInt(sTitulo.substring(1, 2)) * 9 + Integer.parseInt(sTitulo.substring(2, 3)) * 8 + Integer.parseInt(sTitulo.substring(3, 4)) * 7 + Integer.parseInt(sTitulo.substring(4, 5)) * 6 + Integer.parseInt(sTitulo.substring(5, 6)) * 5 + Integer.parseInt(sTitulo.substring(6, 7)) * 4 + Integer.parseInt(sTitulo.substring(7, 8)) * 3 + Integer.parseInt(sTitulo.substring(8, 9)) * 2;
        int iResto = iSoma % 11;
        iDig1 = iResto <= 1 ? 0 : 11 - iResto;
        return iDig1 * 10 + (iDig2 = (iResto2 = (iSoma2 = Integer.parseInt(sTitulo.substring(9, 10)) * 4 + Integer.parseInt(sTitulo.substring(10, 11)) * 3 + iDig1 * 2) % 11) <= 1 ? 0 : 11 - iResto2) == Integer.parseInt(sDigVer);
    }

    public static String lpad(String valueToPad, char filler, int size) {
        char[] array = new char[size];
        int len = size - valueToPad.length();
        for (int i = 0; i < len; ++i) {
            array[i] = filler;
        }
        valueToPad.getChars(0, valueToPad.length(), array, size - valueToPad.length());
        return String.valueOf(array);
    }

    public static void main(String[] args) {
    }
}

