/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.commons.ldap;

import java.util.Hashtable;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapConfig {
    private static final String LDAP_SERVER_NAME = "certificado.ldapServerName";
    private static final String LDAP_SERVER_PORT = "certificado.port";
    private static final String LDAP_ROOT_USERNAME = "certificado.rootDN";
    private static final String LDAP_ROOT_PASSWORD = "certificado.rootPass";
    private static final String LDAP_DIRECTORY = "certificado.dirConnect";
    private static String RESOURCES = null;
    private static LdapConfig instance = null;
    private CompositeConfiguration config = null;
    private static Log LOG = LogFactory.getLog(LdapConfig.class.getClass());

    private LdapConfig(String arquivoConfiguracao) {
        RESOURCES = arquivoConfiguracao;
        try {
            char defaultListDelimiter = PropertiesConfiguration.getDefaultListDelimiter();
            PropertiesConfiguration.setDefaultListDelimiter((char)';');
            this.config = new CompositeConfiguration();
            this.config.addConfiguration((Configuration)new PropertiesConfiguration(arquivoConfiguracao));
            PropertiesConfiguration.setDefaultListDelimiter((char)defaultListDelimiter);
            LOG.info((Object)("Using config file '" + arquivoConfiguracao + "'"));
        }
        catch (ConfigurationException ex) {
            LOG.error((Object)("Erro ao inicializar configura\u00e7\u00f5es do LDAP com o resources '" + arquivoConfiguracao + "'"), (Throwable)ex);
            throw new RuntimeException("Erro ao inicializar configura\u00e7\u00f5es do LDAP com o resources '" + arquivoConfiguracao + "'", ex);
        }
    }

    public static LdapConfig getInstance() {
        return LdapConfig.getInstance("ldap.properties");
    }

    public static LdapConfig getInstance(String arquivoConfiguracao) {
        if (instance == null) {
            LdapConfig.createInstance(arquivoConfiguracao);
        }
        return instance;
    }

    private static synchronized void createInstance(String arquivoConfiguracao) {
        if (instance == null) {
            instance = new LdapConfig(arquivoConfiguracao);
        }
    }

    public Hashtable getRootEnvironmentProperties(String user, String password) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String dirConnect = this.config.getString(LDAP_DIRECTORY);
        String ldapServerName = this.config.getString(LDAP_SERVER_NAME);
        String ldapServerPort = this.config.getString(LDAP_SERVER_PORT);
        user = user == null ? "CN=" + this.config.getString(LDAP_ROOT_USERNAME) : user + "," + dirConnect;
        if (password == null) {
            password = this.config.getString(LDAP_ROOT_PASSWORD);
        }
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + ldapServerName + ":" + ldapServerPort + "/" + dirConnect);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", user);
        env.put("java.naming.security.credentials", password);
        return env;
    }

    public String getLdapDirectory() {
        return this.config.getString(LDAP_DIRECTORY);
    }
}

