/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.resource.UtilBundle;
import oracle.dss.util.xml.BIIOException;
import oracle.dss.util.xml.BIParseException;
import oracle.dss.util.xml.BISAXException;
import oracle.dss.util.xml.CharacterMap;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.DTD;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XMLObjectReader
extends Reader {
    private XMLDocument m_doc;
    private DTD m_dtd;
    private Reader m_reader;
    private boolean m_isValidate;
    private String m_xml;
    private DOMParser m_parser;
    public static ThreadLocal s_tls;
    protected ResourceBundle m_Resources;

    public XMLObjectReader(String string) {
        this.m_xml = string;
        this.initialize();
    }

    public XMLObjectReader(Reader reader) {
        this.m_reader = reader;
        this.initialize();
    }

    public XMLObjectReader(InputStream inputStream) {
        try {
            this.m_reader = new InputStreamReader(inputStream, "UTF8");
        }
        catch (Exception exception) {
            this.m_reader = new InputStreamReader(inputStream);
        }
        this.initialize();
    }

    private void initialize() {
        if (s_tls != null) {
            Object t = s_tls.get();
            try {
                if (t != null && t instanceof DOMParser) {
                    this.m_parser = (DOMParser)t;
                }
            }
            catch (Exception exception) {
                this.m_parser = null;
            }
        }
        if (this.m_parser == null) {
            this.m_parser = new DOMParser();
            this.m_parser.setPreserveWhitespace(false);
            this.m_parser.showWarnings(false);
        }
        if (this.m_Resources == null) {
            try {
                this.m_Resources = ResourceBundle.getBundle("oracle.dss.util.resource.UtilBundle");
            }
            catch (MissingResourceException missingResourceException) {
                missingResourceException.printStackTrace();
                this.m_Resources = null;
            }
        }
    }

    public void setValidationMode(boolean bl) {
        this.m_isValidate = bl;
    }

    public void setDTD(String string, String string2) throws BISAXException, BIParseException, BIIOException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new BIIOException(UtilBundle.getResourceString("DTD cannot be found", this.m_Resources), null);
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                try {
                    this.m_parser.setValidationMode(false);
                    this.m_parser.parseDTD(inputStream, string2);
                    this.m_dtd = this.m_parser.getDoctype();
                    Object var6_8 = null;
                }
                catch (Throwable throwable) {
                    Object var6_9 = null;
                    throw throwable;
                }
            }
        }
        catch (IOException iOException) {
            throw new BIIOException(iOException.getLocalizedMessage(), null);
        }
        catch (XMLParseException xMLParseException) {
            throw new BIParseException(xMLParseException.getMessage(0), xMLParseException.getPublicId(), xMLParseException.getSystemId(), xMLParseException.getLineNumber(0), xMLParseException.getColumnNumber(0), xMLParseException.getMessageType(0), null);
        }
        catch (SAXException sAXException) {
            throw new BISAXException(sAXException.getLocalizedMessage(), null);
        }
    }

    public ObjectNode readObjectNode() throws BISAXException, BIParseException, BIIOException {
        return this.readObjectNode(null);
    }

    public ObjectNode readObjectNode(CharacterMap characterMap) throws BISAXException, BIParseException, BIIOException {
        if (this.m_xml != null) {
            this.m_reader = new StringReader(this.convertCharacters(this.m_xml, characterMap));
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                try {
                    this.m_parser.setValidationMode(this.m_isValidate);
                    if (this.m_isValidate && this.m_dtd != null) {
                        this.m_parser.setDoctype(this.m_dtd);
                    }
                    this.m_parser.parse(this.m_reader);
                    this.m_doc = this.m_parser.getDocument();
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            Element element = (Element)this.m_doc.removeChild((Node)this.m_doc.getDocumentElement());
            ObjectNode objectNode = new ObjectNode(new ObjectScope(), element);
            this.close();
            ObjectNode objectNode2 = objectNode;
            return objectNode2;
        }
        catch (IOException iOException) {
            throw new BIIOException(iOException.getLocalizedMessage(), null);
        }
        catch (XMLParseException xMLParseException) {
            throw new BIParseException(xMLParseException.getLocalizedMessage(), xMLParseException.getPublicId(), xMLParseException.getSystemId(), xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getMessageType(0), null);
        }
        catch (SAXException sAXException) {
            throw new BISAXException(sAXException.getLocalizedMessage(), null);
        }
    }

    public ContainerNode readContainerNode() throws BISAXException, BIParseException, BIIOException {
        return this.readContainerNode(null);
    }

    public ContainerNode readContainerNode(CharacterMap characterMap) throws BISAXException, BIParseException, BIIOException {
        if (this.m_xml != null) {
            this.m_reader = new StringReader(this.convertCharacters(this.m_xml, characterMap));
        }
        try {
            XMLObjectReader xMLObjectReader = this;
            synchronized (xMLObjectReader) {
                try {
                    this.m_parser.setValidationMode(this.m_isValidate);
                    if (this.m_isValidate && this.m_dtd != null) {
                        this.m_parser.setDoctype(this.m_dtd);
                    }
                    this.m_parser.parse(this.m_reader);
                    Object var4_6 = null;
                }
                catch (Throwable throwable) {
                    Object var4_7 = null;
                    throw throwable;
                }
            }
            this.m_doc = this.m_parser.getDocument();
            Element element = (Element)this.m_doc.removeChild((Node)this.m_doc.getDocumentElement());
            ContainerNode containerNode = new ContainerNode(new ObjectScope(), element);
            this.close();
            ContainerNode containerNode2 = containerNode;
            return containerNode2;
        }
        catch (IOException iOException) {
            throw new BIIOException(iOException.getLocalizedMessage(), null);
        }
        catch (XMLParseException xMLParseException) {
            throw new BIParseException(xMLParseException.getLocalizedMessage(), xMLParseException.getPublicId(), xMLParseException.getSystemId(), xMLParseException.getLineNumber(), xMLParseException.getColumnNumber(), xMLParseException.getMessageType(0), null);
        }
        catch (SAXException sAXException) {
            throw new BISAXException(sAXException.getLocalizedMessage(), null);
        }
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        return this.m_reader.read(cArray, n, n2);
    }

    public void close() throws IOException {
        this.m_reader.close();
    }

    private String convertCharacters(String string, CharacterMap characterMap) {
        if (characterMap != null) {
            Vector vector = characterMap.getMappings();
            if (vector != null) {
                int n = vector.size() - 1;
                while (n > -1) {
                    Object object;
                    Object e = vector.elementAt(n);
                    if (e instanceof CharacterMap.CharHolder) {
                        object = (CharacterMap.CharHolder)vector.elementAt(n);
                        string = string.replace(((CharacterMap.CharHolder)object).getValue(), ((CharacterMap.CharHolder)object).getKey());
                    } else if (e instanceof CharacterMap.StringHolder) {
                        object = (CharacterMap.StringHolder)vector.elementAt(n);
                        string = this.replace(string, 0, ((CharacterMap.StringHolder)object).getValue(), ((CharacterMap.StringHolder)object).getKey());
                    }
                    --n;
                }
            }
            return string;
        }
        return string;
    }

    private String replace(String string, int n, String string2, String string3) {
        int n2 = string.indexOf(string2, n);
        if (n2 > -1) {
            String string4 = String.valueOf(string.substring(0, n2)) + string3 + string.substring(n2 + string2.length(), string.length());
            return this.replace(string4, n2, string2, string3);
        }
        return string;
    }
}

