/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.xml.BaseNode;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PropertyNode
extends BaseNode {
    protected Object m_value;

    PropertyNode(ObjectScope objectScope, Node node) {
        super(objectScope, node);
        if (node instanceof Attr) {
            this.m_name = ((Attr)node).getName();
            this.m_value = ((Attr)node).getValue();
        } else if (node instanceof Element) {
            this.m_name = ((Element)node).getTagName();
            Element element = (Element)node;
            Node node2 = element.getFirstChild();
            if (node2 instanceof Text) {
                this.m_value = ((XMLText)node2).getNodeValue();
            }
        }
    }

    public PropertyNode(String string, String string2) {
        super(string);
        if (string2 == null) {
            string2 = "";
        }
        this.m_value = string2;
        this.initBuffer();
        this.m_buffer.append("<");
        this.m_buffer.append(string);
        this.m_buffer.append(">");
        this.m_buffer.append(BaseNode.createEscapes(string2));
        this.m_buffer.append("</");
        this.m_buffer.append(string);
        this.m_buffer.append(">");
    }

    public PropertyNode(String string, boolean bl) {
        this(string, new Boolean(bl).toString());
    }

    public PropertyNode(String string, int n) {
        this(string, new Integer(n).toString());
    }

    public PropertyNode(String string, long l) {
        this(string, new Long(l).toString());
    }

    public PropertyNode(String string, double d) {
        this(string, new Double(d).toString());
    }

    public PropertyNode(String string, char c) {
        this(string, new Character(c).toString());
    }

    public String getValueAsString() {
        if (this.m_value == null) {
            this.m_value = "";
        }
        return (String)this.m_value;
    }

    public boolean getValueAsBoolean() {
        return Boolean.valueOf((String)this.m_value);
    }

    public int getValueAsInteger() {
        return Integer.valueOf((String)this.m_value);
    }

    public double getValueAsDouble() {
        return Double.valueOf((String)this.m_value);
    }

    public long getValueAsLong() {
        return Long.valueOf((String)this.m_value);
    }

    public char getValueAsCharacter() {
        if (((String)this.m_value).length() == 0) {
            return '\u0000';
        }
        return ((String)this.m_value).charAt(0);
    }
}

