/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.xml;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.util.xml.NoSuchObjectException;
import oracle.dss.util.xml.NoSuchPropertyException;
import oracle.dss.util.xml.ObjectNode;

public class CommonHelper {
    public static Color readColor(ObjectNode objectNode) {
        if (objectNode.isReference()) {
            try {
                Color color = (Color)objectNode.getReference();
                return color;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
        }
        Color color = null;
        try {
            int n = objectNode.getPropertyValueAsInteger("rgb");
            color = new Color(n);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (color != null) {
            objectNode.registerObject(color);
        }
        return color;
    }

    public static void writeColor(ObjectNode objectNode, Color color) {
        block1: {
            if (color == null) break block1;
            if (objectNode == null) {
                objectNode = new ObjectNode(color.getClass().getName());
            }
            objectNode.addProperty("rgb", color.getRGB());
        }
    }

    public static Font readFont(ObjectNode objectNode) {
        if (objectNode.isReference()) {
            try {
                Font font = (Font)objectNode.getReference();
                return font;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
        }
        Font font = null;
        try {
            String string = objectNode.getPropertyValueAsString("name");
            int n = objectNode.getPropertyValueAsInteger("style");
            int n2 = objectNode.getPropertyValueAsInteger("size");
            font = new Font(string, n, n2);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (font != null) {
            objectNode.registerObject(font);
        }
        return font;
    }

    public static void writeFont(ObjectNode objectNode, Font font) {
        block1: {
            if (font == null) break block1;
            if (objectNode == null) {
                objectNode = new ObjectNode(font.getClass().getName());
            }
            objectNode.addProperty("name", font.getName());
            objectNode.addProperty("style", font.getStyle());
            objectNode.addProperty("size", font.getSize());
        }
    }

    public static Rectangle readRectangle(ObjectNode objectNode) {
        if (objectNode.isReference()) {
            try {
                Rectangle rectangle = (Rectangle)objectNode.getReference();
                return rectangle;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
        }
        Rectangle rectangle = null;
        try {
            int n = objectNode.getPropertyValueAsInteger("x");
            int n2 = objectNode.getPropertyValueAsInteger("y");
            int n3 = objectNode.getPropertyValueAsInteger("width");
            int n4 = objectNode.getPropertyValueAsInteger("height");
            rectangle = new Rectangle(n, n2, n3, n4);
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        if (rectangle != null) {
            objectNode.registerObject(rectangle);
        }
        return rectangle;
    }

    public static void writeRectangle(ObjectNode objectNode, Rectangle rectangle) {
        block1: {
            if (rectangle == null) break block1;
            if (objectNode == null) {
                objectNode = new ObjectNode(rectangle.getClass().getName());
            }
            objectNode.addProperty("x", rectangle.getLocation().x);
            objectNode.addProperty("y", rectangle.getLocation().y);
            objectNode.addProperty("width", rectangle.getSize().width);
            objectNode.addProperty("height", rectangle.getSize().height);
        }
    }

    public static Vector readStringVector(ObjectNode objectNode) {
        if (objectNode.isReference()) {
            try {
                Vector vector = (Vector)objectNode.getReference();
                return vector;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                return null;
            }
        }
        Vector<String> vector = new Vector<String>();
        try {
            int n = objectNode.getPropertyValueAsInteger("size");
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(objectNode.getPropertyValueAsString(String.valueOf(String.valueOf("element_")) + n2));
                ++n2;
            }
        }
        catch (NoSuchPropertyException noSuchPropertyException) {
            // empty catch block
        }
        objectNode.registerObject(vector);
        return vector;
    }

    public static void writeStringVector(ObjectNode objectNode, Vector vector) {
        if (vector != null) {
            if (objectNode == null) {
                objectNode = new ObjectNode("StringVector");
            }
            objectNode.addProperty("size", vector.size());
            int n = 0;
            while (n < vector.size()) {
                objectNode.addProperty(String.valueOf(String.valueOf("element_")) + n, (String)vector.elementAt(n));
                ++n;
            }
        }
    }
}

