/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.persistence;

import java.io.Serializable;
import java.util.BitSet;
import java.util.Date;
import oracle.dss.util.persistence.ComponentAttributes;

public class PersistableAttributes
implements Serializable {
    private BitSet m_formatUsedFlags;
    private boolean m_bUseCallback = true;
    private static final int OBJECT_NAME_BIT = 0;
    private static final int DESCRIPTION_BIT = 1;
    private static final int KEYWORDS_BIT = 2;
    private static final int APPLICATION_BIT = 3;
    private static final int DATABASE_BIT = 4;
    private static final int APPLICATION_SUBTYPE_BIT = 5;
    private static final int OBJECT_TYPE_BIT = 6;
    private static final int OBJECT_TYPE_VERSION_BIT = 7;
    private static final int TITLE_BIT = 8;
    private static final int COMP_SUBTYPE_1_BIT = 9;
    private static final int COMP_SUBTYPE_2_BIT = 10;
    private static final int COMP_SUBTYPE_3_BIT = 11;
    private static final int COMPONENT_ATTRIBUTES_BIT = 12;
    private static final int NUMBER_OF_FORMAT_BITS = 13;
    private String m_oid;
    private Date m_dateCreated;
    private Date m_dateModified;
    private Date m_dateLastAccessed;
    private String m_creator;
    private String m_modifier;
    private boolean m_userVisible;
    private String m_objFullPathName;
    private String m_name;
    private String m_desc;
    private String m_keywords;
    private String m_app;
    private String m_db;
    private String m_appSubType;
    private String m_objType;
    private int m_version = -1;
    private String m_title;
    private String m_compSubType1;
    private String m_compSubType2;
    private String m_compSubType3;
    private ComponentAttributes m_compAttrbs;
    private static BitSet NoBitsSet = new BitSet(13);

    public PersistableAttributes(String string, String string2, Date date, Date date2, String string3, String string4, boolean bl, String string5, Date date3) {
        this.m_name = string;
        this.m_oid = string2;
        this.m_objFullPathName = string5;
        this.m_dateCreated = date;
        this.m_dateModified = date2;
        this.m_dateLastAccessed = date3;
        this.m_creator = string3;
        this.m_modifier = string4;
        this.m_userVisible = bl;
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public PersistableAttributes(String string, int n, String string2, String string3, String string4, String string5) {
        this.m_objType = string;
        this.m_version = n;
        this.m_title = string2;
        this.m_compSubType1 = string3;
        this.m_compSubType2 = string4;
        this.m_compSubType3 = string5;
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public PersistableAttributes() {
        this.m_formatUsedFlags = new BitSet(13);
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public boolean isAnythingOverridden() {
        return !this.m_formatUsedFlags.equals(NoBitsSet);
    }

    public void clearUsedBits() {
        this.m_formatUsedFlags.and(NoBitsSet);
    }

    public void dump() {
        int n = 0;
        while (n < 13) {
            System.out.println(this.m_formatUsedFlags.get(n));
            ++n;
        }
    }

    public Object clone() {
        PersistableAttributes persistableAttributes = new PersistableAttributes(this.getObjectName(), this.getOID(), this.getTimeDateCreated(), this.getTimeDateModified(), this.getCreatedBy(), this.getModifiedBy(), this.getUserVisible(), this.getObjectFullPathName(), this.getTimeDateLastAccessed());
        persistableAttributes.setDescription(this.m_desc);
        persistableAttributes.setKeywords(this.m_keywords);
        persistableAttributes.setApplication(this.m_app);
        persistableAttributes.setDatabase(this.m_db);
        persistableAttributes.setApplicationSubType(this.m_appSubType);
        persistableAttributes.setObjectType(this.m_objType);
        persistableAttributes.setObjectTypeVersion(this.m_version);
        persistableAttributes.setTitle(this.m_title);
        persistableAttributes.setCompSubType1(this.m_compSubType1);
        persistableAttributes.setCompSubType2(this.m_compSubType2);
        persistableAttributes.setCompSubType3(this.m_compSubType3);
        if (this.m_compAttrbs != null) {
            persistableAttributes.setExtensibleComponentAttributes((ComponentAttributes)this.m_compAttrbs.clone());
        }
        return persistableAttributes;
    }

    public void merge(PersistableAttributes persistableAttributes) {
        PersistableAttributes persistableAttributes2 = persistableAttributes;
        this.m_bUseCallback = false;
        if (persistableAttributes2.isObjectNameUsed()) {
            this.setObjectName(persistableAttributes2.getObjectName());
        }
        if (persistableAttributes2.isDescriptionUsed()) {
            this.setDescription(persistableAttributes2.getDescription());
        }
        if (persistableAttributes2.isKeywordsUsed()) {
            this.setKeywords(persistableAttributes2.getKeywords());
        }
        if (persistableAttributes2.isApplicationUsed()) {
            this.setApplication(persistableAttributes2.getApplication());
        }
        if (persistableAttributes2.isDatabaseUsed()) {
            this.setDatabase(persistableAttributes2.getDatabase());
        }
        if (persistableAttributes2.isApplicationSubTypeUsed()) {
            this.setApplicationSubType(persistableAttributes2.getApplicationSubType());
        }
        if (persistableAttributes2.isObjectTypeUsed()) {
            this.setObjectType(persistableAttributes2.getObjectType());
        }
        if (persistableAttributes2.isObjectTypeVersionUsed()) {
            this.setObjectTypeVersion(persistableAttributes2.getObjectTypeVersion());
        }
        if (persistableAttributes2.isTitleUsed()) {
            this.setTitle(persistableAttributes2.getTitle());
        }
        if (persistableAttributes2.isCompSubType1Used()) {
            this.setCompSubType1(persistableAttributes2.getCompSubType1());
        }
        if (persistableAttributes2.isCompSubType2Used()) {
            this.setCompSubType2(persistableAttributes2.getCompSubType2());
        }
        if (persistableAttributes2.isCompSubType3Used()) {
            this.setCompSubType3(persistableAttributes2.getCompSubType3());
        }
        this.m_bUseCallback = true;
    }

    public String getOID() {
        return this.m_oid;
    }

    public String getObjectFullPathName() {
        return this.m_objFullPathName;
    }

    public Date getTimeDateCreated() {
        return this.m_dateCreated;
    }

    public Date getTimeDateModified() {
        return this.m_dateModified;
    }

    public Date getTimeDateLastAccessed() {
        return this.m_dateLastAccessed;
    }

    public String getCreatedBy() {
        return this.m_creator;
    }

    public String getModifiedBy() {
        return this.m_modifier;
    }

    public boolean getUserVisible() {
        return this.m_userVisible;
    }

    public boolean isObjectNameUsed() {
        return this.m_formatUsedFlags.get(0);
    }

    public void setObjectNameUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(0);
        } else {
            this.m_formatUsedFlags.clear(0);
        }
    }

    public String getObjectName() {
        return this.m_name;
    }

    public void setObjectName(String string) {
        this.setObjectNameUsed(true);
        this.m_name = string;
    }

    public String getObjectLabel() {
        return this.m_name;
    }

    public boolean isDescriptionUsed() {
        return this.m_formatUsedFlags.get(1);
    }

    public void setDescriptionUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(1);
        } else {
            this.m_formatUsedFlags.clear(1);
        }
    }

    public String getDescription() {
        return this.m_desc;
    }

    public void setDescription(String string) {
        this.setDescriptionUsed(true);
        this.m_desc = string;
    }

    public boolean isKeywordsUsed() {
        return this.m_formatUsedFlags.get(2);
    }

    public void setKeywordsUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(2);
        } else {
            this.m_formatUsedFlags.clear(2);
        }
    }

    public String getKeywords() {
        return this.m_keywords;
    }

    public void setKeywords(String string) {
        this.setKeywordsUsed(true);
        this.m_keywords = string;
    }

    public boolean isApplicationUsed() {
        return this.m_formatUsedFlags.get(3);
    }

    public void setApplicationUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(0);
        } else {
            this.m_formatUsedFlags.clear(0);
        }
    }

    public String getApplication() {
        return this.m_app;
    }

    public void setApplication(String string) {
        this.setApplicationUsed(true);
        this.m_app = string;
    }

    public boolean isDatabaseUsed() {
        return this.m_formatUsedFlags.get(4);
    }

    public void setDatabaseUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(4);
        } else {
            this.m_formatUsedFlags.clear(4);
        }
    }

    public String getDatabase() {
        return this.m_db;
    }

    public void setDatabase(String string) {
        this.setDatabaseUsed(true);
        this.m_db = string;
    }

    public boolean isApplicationSubTypeUsed() {
        return this.m_formatUsedFlags.get(5);
    }

    public void setApplicationSubTypeUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(5);
        } else {
            this.m_formatUsedFlags.clear(5);
        }
    }

    public String getApplicationSubType() {
        return this.m_appSubType;
    }

    public void setApplicationSubType(String string) {
        this.setApplicationSubTypeUsed(true);
        this.m_appSubType = string;
    }

    public boolean isObjectTypeUsed() {
        return this.m_formatUsedFlags.get(6);
    }

    public void setObjectTypeUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(6);
        } else {
            this.m_formatUsedFlags.clear(6);
        }
    }

    public String getObjectType() {
        return this.m_objType;
    }

    public void setObjectType(String string) {
        this.setObjectTypeUsed(true);
        this.m_objType = string;
    }

    public boolean isObjectTypeVersionUsed() {
        return this.m_formatUsedFlags.get(7);
    }

    public void setObjectTypeVersionUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(7);
        } else {
            this.m_formatUsedFlags.clear(7);
        }
    }

    public int getObjectTypeVersion() {
        return this.m_version;
    }

    public void setObjectTypeVersion(int n) {
        this.setObjectTypeVersionUsed(true);
        this.m_version = n;
    }

    public boolean isTitleUsed() {
        return this.m_formatUsedFlags.get(8);
    }

    public void setTitleUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(8);
        } else {
            this.m_formatUsedFlags.clear(8);
        }
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.setTitleUsed(true);
        this.m_title = string;
    }

    public boolean isCompSubType1Used() {
        return this.m_formatUsedFlags.get(9);
    }

    public void setCompSubType1Used(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(9);
        } else {
            this.m_formatUsedFlags.clear(9);
        }
    }

    public String getCompSubType1() {
        return this.m_compSubType1;
    }

    public void setCompSubType1(String string) {
        this.setCompSubType1Used(true);
        this.m_compSubType1 = string;
    }

    public boolean isCompSubType2Used() {
        return this.m_formatUsedFlags.get(10);
    }

    public void setCompSubType2Used(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(10);
        } else {
            this.m_formatUsedFlags.clear(10);
        }
    }

    public String getCompSubType2() {
        return this.m_compSubType2;
    }

    public void setCompSubType2(String string) {
        this.setCompSubType2Used(true);
        this.m_compSubType2 = string;
    }

    public boolean isCompSubType3Used() {
        return this.m_formatUsedFlags.get(11);
    }

    public void setCompSubType3Used(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(11);
        } else {
            this.m_formatUsedFlags.clear(11);
        }
    }

    public String getCompSubType3() {
        return this.m_compSubType3;
    }

    public void setCompSubType3(String string) {
        this.setCompSubType3Used(true);
        this.m_compSubType3 = string;
    }

    public void setExtensibleComponentAttributes(ComponentAttributes componentAttributes) {
        this.setExtensibleComponentAttributesUsed(true);
        this.m_compAttrbs = componentAttributes;
    }

    public ComponentAttributes getExtensibleComponentAttributes() {
        return this.m_compAttrbs;
    }

    public void setExtensibleComponentAttributesUsed(boolean bl) {
        if (bl) {
            this.m_formatUsedFlags.set(12);
        } else {
            this.m_formatUsedFlags.clear(12);
        }
    }

    static {
        int n = 0;
        while (n < 13) {
            NoBitsSet.clear(n);
            ++n;
        }
    }
}

