/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.gui.layout;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JViewport;
import oracle.bali.ewt.dnd.DropTarget;
import oracle.bali.ewt.dnd.DropTargetDragEvent;
import oracle.bali.ewt.dnd.DropTargetDropEvent;
import oracle.bali.ewt.dnd.DropTargetEvent;
import oracle.bali.ewt.dnd.DropTargetListener;
import oracle.bali.ewt.pivot.PivotTransfer;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.dss.util.gui.layout.Crosstab;
import oracle.dss.util.gui.layout.CrosstabScrollPane;

public class ScrollPaneDropAdapter
implements DropTargetListener {
    private CrosstabScrollPane _scrollPane;
    private Crosstab _crosstab;
    private DropTarget _paneViewTarget;
    private DropTarget _paneViewportTarget;
    private DropTarget _columnViewTarget;
    private DropTarget _columnViewportTarget;
    private DropTarget _rowViewTarget;
    private DropTarget _rowViewportTarget;

    public ScrollPaneDropAdapter(CrosstabScrollPane crosstabScrollPane, Crosstab crosstab) {
        this._scrollPane = crosstabScrollPane;
        this._crosstab = crosstab;
        this._paneViewTarget = new DropTarget((Component)this._scrollPane, (DropTargetListener)this);
        JViewport jViewport = this._scrollPane.getViewport();
        this._paneViewportTarget = new DropTarget((Component)jViewport, (DropTargetListener)this);
        Component component = jViewport.getView();
        jViewport = this._scrollPane.getColumnHeader();
        if (jViewport != null) {
            this._columnViewportTarget = new DropTarget((Component)jViewport, (DropTargetListener)this);
            component = jViewport.getView();
            if (component != null) {
                this._columnViewTarget = new DropTarget(component, (DropTargetListener)this);
            }
        }
        if ((jViewport = this._scrollPane.getRowHeader()) != null) {
            this._rowViewportTarget = new DropTarget((Component)jViewport, (DropTargetListener)this);
            component = jViewport.getView();
            if (component != null) {
                this._rowViewTarget = new DropTarget(component, (DropTargetListener)this);
            }
        }
    }

    public void cleanup() {
        if (this._paneViewTarget != null) {
            this._paneViewTarget.setActive(false);
            this._paneViewTarget.setComponent(null);
        }
        if (this._paneViewportTarget != null) {
            this._paneViewportTarget.setActive(false);
            this._paneViewportTarget.setComponent(null);
        }
        if (this._columnViewTarget != null) {
            this._columnViewTarget.setActive(false);
            this._columnViewTarget.setComponent(null);
        }
        if (this._columnViewportTarget != null) {
            this._columnViewportTarget.setActive(false);
            this._columnViewportTarget.setComponent(null);
        }
        if (this._rowViewTarget != null) {
            this._rowViewTarget.setActive(false);
            this._rowViewTarget.setComponent(null);
        }
        if (this._rowViewportTarget != null) {
            this._rowViewportTarget.setActive(false);
            this._rowViewportTarget.setComponent(null);
        }
        this._paneViewTarget = null;
        this._paneViewportTarget = null;
        this._columnViewTarget = null;
        this._columnViewportTarget = null;
        this._rowViewTarget = null;
        this._rowViewportTarget = null;
        this._scrollPane = null;
        this._crosstab = null;
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (!this._acceptDrag(dropTargetDragEvent)) {
            dropTargetDragEvent.rejectDrag();
            return;
        }
        this._setDropLocation(0);
    }

    public void dragScroll(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        this._setDropLocation(-1);
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        this._setDropLocation(-1);
        Transferable transferable = dropTargetDropEvent.getTransferable();
        Object object = null;
        try {
            object = transferable.getTransferData(PivotTransfer.DATA_FLAVOR);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            object = null;
        }
        catch (IOException iOException) {
            object = null;
        }
        if (object != null && object instanceof PivotTransfer) {
            PivotTransfer pivotTransfer = (PivotTransfer)object;
            Object object2 = pivotTransfer.getSource();
            int n = pivotTransfer.getIndex();
            Component component = this._scrollPane.getViewport().getView();
            int n2 = 0;
            this._crosstab.firePivotEvent(object2, n, component, n2);
        }
        dropTargetDropEvent.dropComplete(object != null);
    }

    private void _setDropLocation(int n) {
        this._scrollPane.setDropLocation(n);
    }

    private boolean _acceptDrag(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        if (dataFlavorArray == null) {
            return false;
        }
        int n = 0;
        while (n < dataFlavorArray.length) {
            if (TransferUtils.supportsDataFlavor((DataFlavor)dataFlavorArray[n], (DataFlavor)PivotTransfer.DATA_FLAVOR)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

