/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util.format.dateFormat;

import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

class LocaleDealer {
    private String[] MonthAbbr = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] WeekDayInFull = new String[]{null, null, null, null, null, null, null};
    private String[] WeekDayInAbbr = new String[]{null, null, null, null, null, null, null};
    private String[] MonthNameInFull = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
    private String[] AmPmUpperCase = new String[]{null, null};
    private String[] AmPmLowerCase = new String[]{null, null};
    private String[] AmPmUpperCaseWithPeriods = new String[]{null, null};
    private String[] AmPmLowerCaseWithPeriods = new String[]{null, null};
    private String[] ErasUpperCase = new String[]{null, null};
    private String[] ErasLowerCase = new String[]{null, null};
    private String[] ErasUpperCaseWithPeriods = new String[]{null, null};
    private String[] ErasLowerCaseWithPeriods = new String[]{null, null};
    private Locale theLocale = Locale.getDefault();
    private int weekDayFullMax;
    private int weekDayAbbrMax;
    private int monthFullMax;
    private int monthAbbrMax;
    private char m_groupingSeparator = (char)44;
    private ResourceBundle m_bundle;
    private static final String UTIL_BUNDLE = "oracle.dss.util.resource.UtilBundle";

    public LocaleDealer(Locale locale) {
        this.theLocale = locale;
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public LocaleDealer() {
        this._updateResourceBundle();
        this.fillWeekDays();
        this.fillMonth();
        this._fillAmPm();
        this._fillEras();
        this._fillGroupingSeparator();
    }

    public String[] getWeekDayName(boolean bl) {
        if (bl) {
            return this.WeekDayInAbbr;
        }
        return this.WeekDayInFull;
    }

    public String[] getMonthName(boolean bl) {
        if (bl) {
            return this.MonthAbbr;
        }
        return this.MonthNameInFull;
    }

    String[] getAmPm(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.AmPmLowerCaseWithPeriods;
            }
            return this.AmPmLowerCase;
        }
        if (bl2) {
            return this.AmPmUpperCaseWithPeriods;
        }
        return this.AmPmUpperCase;
    }

    String[] getEras(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.ErasLowerCaseWithPeriods;
            }
            return this.ErasLowerCase;
        }
        if (bl2) {
            return this.ErasUpperCaseWithPeriods;
        }
        return this.ErasUpperCase;
    }

    char getGroupingSeparator() {
        return this.m_groupingSeparator;
    }

    private void fillWeekDays() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE", this.theLocale);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("EEE", this.theLocale);
        boolean bl = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theLocale);
        if (bl) {
            simpleDateFormat.setCalendar(gregorianCalendar);
            simpleDateFormat2.setCalendar(gregorianCalendar);
        }
        int n = 0;
        while (n < 7) {
            gregorianCalendar = new GregorianCalendar(this.theLocale);
            gregorianCalendar.set(1998, 10, n + 1);
            Date date = gregorianCalendar.getTime();
            this.WeekDayInFull[n] = simpleDateFormat.format(date);
            if (this.WeekDayInFull[n].length() > this.weekDayFullMax) {
                this.weekDayFullMax = this.WeekDayInFull[n].length();
            }
            this.WeekDayInAbbr[n] = simpleDateFormat2.format(date);
            if (this.WeekDayInAbbr[n].length() > this.weekDayAbbrMax) {
                this.weekDayAbbrMax = this.WeekDayInAbbr[n].length();
            }
            ++n;
        }
        this.adjustLength(this.WeekDayInFull, this.weekDayFullMax, 7);
        this.adjustLength(this.WeekDayInAbbr, this.weekDayAbbrMax, 7);
    }

    private void fillMonth() {
        boolean bl;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM", this.theLocale);
        SimpleDateFormat simpleDateFormat2 = null;
        simpleDateFormat2 = this.theLocale.getLanguage().compareTo("ja") == 0 ? new SimpleDateFormat("MMM", Locale.ENGLISH) : new SimpleDateFormat("MMM", this.theLocale);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(this.theLocale);
        boolean bl2 = bl = this.theLocale.getLanguage().compareTo("th") == 0 && this.theLocale.getCountry().compareTo("TH") == 0;
        if (bl) {
            simpleDateFormat.setCalendar(gregorianCalendar);
            simpleDateFormat2.setCalendar(gregorianCalendar);
        }
        int n = 0;
        while (n < 12) {
            gregorianCalendar = new GregorianCalendar(1999, n, 1);
            Date date = gregorianCalendar.getTime();
            this.MonthNameInFull[n] = simpleDateFormat.format(date);
            if (this.MonthNameInFull[n].length() > this.monthFullMax) {
                this.monthFullMax = this.MonthNameInFull[n].length();
            }
            this.MonthAbbr[n] = simpleDateFormat2.format(date);
            if (this.MonthAbbr[n].length() > this.monthAbbrMax) {
                this.monthAbbrMax = this.MonthAbbr[n].length();
            }
            ++n;
        }
        this.adjustLength(this.MonthNameInFull, this.monthFullMax, 12);
        this.adjustLength(this.MonthAbbr, this.monthAbbrMax, 12);
    }

    private void _fillAmPm() {
        this.AmPmUpperCase = new String[2];
        this.AmPmUpperCaseWithPeriods = new String[2];
        this.AmPmLowerCase = new String[2];
        this.AmPmLowerCaseWithPeriods = new String[2];
        if (this.m_bundle != null) {
            this.AmPmUpperCase[0] = this.m_bundle.getString("AM");
            this.AmPmUpperCase[1] = this.m_bundle.getString("PM");
            this.AmPmUpperCaseWithPeriods[0] = this.m_bundle.getString("A.M.");
            this.AmPmUpperCaseWithPeriods[1] = this.m_bundle.getString("P.M.");
            this.AmPmLowerCase[0] = this.m_bundle.getString("am");
            this.AmPmLowerCase[1] = this.m_bundle.getString("pm");
            this.AmPmLowerCaseWithPeriods[0] = this.m_bundle.getString("a.m.");
            this.AmPmLowerCaseWithPeriods[1] = this.m_bundle.getString("p.m.");
        } else {
            this.AmPmUpperCase[0] = "AM";
            this.AmPmUpperCase[1] = "PM";
            this.AmPmUpperCaseWithPeriods[0] = "A.M.";
            this.AmPmUpperCaseWithPeriods[1] = "P.M.";
            this.AmPmLowerCase[0] = "am";
            this.AmPmLowerCase[1] = "pm";
            this.AmPmLowerCaseWithPeriods[0] = "a.m.";
            this.AmPmLowerCaseWithPeriods[1] = "p.m.";
        }
    }

    private void _fillEras() {
        this.ErasUpperCase = new String[2];
        this.ErasUpperCaseWithPeriods = new String[2];
        this.ErasLowerCase = new String[2];
        this.ErasLowerCaseWithPeriods = new String[2];
        if (this.m_bundle != null) {
            this.ErasUpperCase[0] = this.m_bundle.getString("BC");
            this.ErasUpperCase[1] = this.m_bundle.getString("AD");
            this.ErasUpperCaseWithPeriods[0] = this.m_bundle.getString("B.C.");
            this.ErasUpperCaseWithPeriods[1] = this.m_bundle.getString("A.D.");
            this.ErasLowerCase[0] = this.m_bundle.getString("bc");
            this.ErasLowerCase[1] = this.m_bundle.getString("ad");
            this.ErasLowerCaseWithPeriods[0] = this.m_bundle.getString("b.c.");
            this.ErasLowerCaseWithPeriods[1] = this.m_bundle.getString("a.d.");
        } else {
            this.ErasUpperCase[0] = "BC";
            this.ErasUpperCase[1] = "AD";
            this.ErasUpperCaseWithPeriods[0] = "B.C.";
            this.ErasUpperCaseWithPeriods[1] = "A.D.";
            this.ErasLowerCase[0] = "bc";
            this.ErasLowerCase[1] = "ad";
            this.ErasLowerCaseWithPeriods[0] = "b.c.";
            this.ErasLowerCaseWithPeriods[1] = "a.d.";
        }
    }

    private void _fillGroupingSeparator() {
        DecimalFormatSymbols decimalFormatSymbols = null;
        decimalFormatSymbols = this.theLocale == null ? new DecimalFormatSymbols() : new DecimalFormatSymbols(this.theLocale);
        this.m_groupingSeparator = decimalFormatSymbols.getGroupingSeparator();
    }

    private void adjustLength(String[] stringArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            int n4 = stringArray[n3].length();
            if (n4 < n) {
                int n5 = n - n4;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = n3;
                    stringArray[n7] = String.valueOf(stringArray[n7]) + " ";
                    ++n6;
                }
            }
            ++n3;
        }
    }

    private void _updateResourceBundle() {
        try {
            this.m_bundle = this.theLocale != null ? ResourceBundle.getBundle(UTIL_BUNDLE, this.theLocale) : ResourceBundle.getBundle(UTIL_BUNDLE);
        }
        catch (MissingResourceException missingResourceException) {
            this.m_bundle = null;
        }
    }
}

