/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.dss.util.Collection;
import oracle.dss.util.UpdatableSet;
import oracle.dss.util.Utility;

public class UpdatableSetImpl
implements UpdatableSet,
Serializable {
    protected Vector m_objects;
    protected int m_initialCapacity;
    protected int m_capacityIncrement;

    public UpdatableSetImpl() {
        this.m_initialCapacity = -1;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector();
    }

    public UpdatableSetImpl(int n) {
        this.m_initialCapacity = n;
        this.m_capacityIncrement = -1;
        this.m_objects = new Vector(this.m_initialCapacity);
    }

    public UpdatableSetImpl(int n, int n2) {
        this.m_initialCapacity = n;
        this.m_capacityIncrement = n2;
        this.m_objects = new Vector(this.m_initialCapacity, this.m_capacityIncrement);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof UpdatableSetImpl)) {
            return false;
        }
        UpdatableSetImpl updatableSetImpl = (UpdatableSetImpl)object;
        return Utility.compareVectors(this.m_objects, updatableSetImpl.m_objects);
    }

    public Collection duplicate() {
        Collection collection = null;
        try {
            collection = (Collection)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return collection;
    }

    protected Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        ((UpdatableSetImpl)object).m_objects = (Vector)this.m_objects.clone();
        return object;
    }

    public int size() {
        return this.m_objects.size();
    }

    public boolean isEmpty() {
        return this.m_objects.isEmpty();
    }

    public boolean includes(Object object) {
        return this.m_objects.contains(object);
    }

    public Enumeration elements() {
        return this.m_objects.elements();
    }

    public void clear() {
        this.m_objects.removeAllElements();
    }

    public void include(Object object) {
        if (!this.m_objects.contains(object)) {
            this.m_objects.addElement(object);
        }
    }

    public void removeOneOf(Object object) {
        this.m_objects.removeElement(object);
    }

    public void exclude(Object object) {
        while (this.m_objects.contains(object)) {
            this.m_objects.removeElement(object);
        }
    }

    public Object take() throws NoSuchElementException {
        Object e = this.m_objects.firstElement();
        this.m_objects.removeElementAt(0);
        return e;
    }

    public void includeElements(Enumeration enumeration) {
        Object e = null;
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (this.m_objects.contains(e)) continue;
            this.m_objects.addElement(e);
        }
    }

    public void removeElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeOneOf(enumeration.nextElement());
        }
    }

    public static void main(String[] stringArray) {
        UpdatableSetImpl updatableSetImpl = new UpdatableSetImpl();
        updatableSetImpl.include(new String("This"));
        updatableSetImpl.include(new String("is"));
        updatableSetImpl.include(new String("Spinal"));
        updatableSetImpl.include(new String("Tap"));
        System.out.println(updatableSetImpl.size());
        Enumeration enumeration = updatableSetImpl.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string);
        }
    }
}

