/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dss.util.DependentID;
import oracle.dss.util.MemberContext;
import oracle.dss.util.QDRMember;
import oracle.dss.util.RuleMemberContext;
import oracle.dss.util.Utility;
import oracle.dss.util.persistence.IDResolver;
import oracle.dss.util.persistence.ObjectScope;
import oracle.dss.util.persistence.PersistableUtilities;
import oracle.dss.util.persistence.XMLContext;
import oracle.dss.util.persistence.XMLizable;
import oracle.dss.util.xml.BaseNode;
import oracle.dss.util.xml.BaseObjectNode;
import oracle.dss.util.xml.ContainerNode;
import oracle.dss.util.xml.ObjectNode;
import oracle.dss.util.xml.PropertyNode;

public class QDR
implements Cloneable,
Serializable,
DependentID,
XMLizable {
    public static final String XML_NAME = "QDR";
    public static final String ALL_PROPERTIES = "allProperties";
    protected static final String PROBLEM_SEPARATOR = "::";
    protected static final String REPLACEMENT_SEPARATOR = "\u0001\u0001";
    private static final String MEASURE_DIM_NAME_PROPERTY = "measureDimName";
    private static final String DIM_MEMBER_PAIR_PROPERTY = "DimMemPair";
    private static final String DIMENSION_PROPERTY = "dim";
    private static final String MEMBER_PROPERTY = "mem";
    private static final String TARGET_PROPERTY = "QDRTarget";
    private static boolean DEBUG;
    private static final char PROPERTY_SEPARATOR = '_';
    private static final String PROPERTY_SEPARATOR_S;
    protected QDRMember m_target;
    protected Vector m_dimensions;
    protected Vector m_members;
    protected String m_measureDim = "";
    protected QDRMember m_memberVaries = new QDRMember(1);

    public QDR() {
        this.m_dimensions = new Vector();
        this.m_members = new Vector();
    }

    public QDR(QDR qDR) {
        this.setMeasureDim(qDR.m_measureDim);
        this.m_dimensions = (Vector)qDR.m_dimensions.clone();
        try {
            this.m_members = Utility.cloneVector(qDR.m_members);
            if (qDR.getTarget() != null) {
                this.setTarget((QDRMember)qDR.getTarget().clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
    }

    public QDR(String string) {
        this();
        this.setMeasureDim(string);
    }

    public QDR(String string, String string2, String string3) {
        this(string);
        this.addDimMemberPair(string2, string3);
    }

    public QDR(String string, String string2, QDRMember qDRMember) {
        this(string);
        this.addDimMemberPair(string2, qDRMember);
    }

    public QDR(String string, String string2) {
        this(string);
        this.setDimMemberPairs(string2);
    }

    public String getMeasureDim() {
        return this.m_measureDim;
    }

    public void setMeasureDim(String string) {
        if (string != null) {
            this.m_measureDim = string;
        }
    }

    public void addDimMemberPair(String string, String string2) {
        QDRMember qDRMember = null;
        qDRMember = string2 != null ? new QDRMember(string2) : this.m_memberVaries;
        this.addDimMemberPair(string, qDRMember);
    }

    public void addDimMemberPair(String string, QDRMember qDRMember) {
        if (string == null) {
            return;
        }
        if (qDRMember == null) {
            qDRMember = this.m_memberVaries;
        }
        if (this.isDimensionOnlyQDR()) {
            this.m_dimensions.setElementAt(string, 0);
        } else {
            int n = this.m_dimensions.indexOf(string);
            if (n >= 0) {
                this.m_members.setElementAt(qDRMember, n);
            } else {
                this.m_dimensions.addElement(string);
                this.m_members.addElement(qDRMember);
            }
        }
    }

    public QDRMember getDimMember(String string) {
        if (string == null) {
            return null;
        }
        int n = this.m_dimensions.indexOf(string);
        if (n >= 0) {
            return (QDRMember)this.m_members.elementAt(n);
        }
        return null;
    }

    public boolean isDimensionOnlyQDR() {
        return this.size() == 1 && this.m_members.elementAt(0).equals(this.m_memberVaries);
    }

    public void removeDimMemberPair(String string) {
        int n = this.m_dimensions.indexOf(string);
        if (n >= 0) {
            this.m_dimensions.removeElementAt(n);
            this.m_members.removeElementAt(n);
        }
    }

    public Enumeration getDimensions() {
        return this.m_dimensions.elements();
    }

    public int size() {
        return this.m_dimensions.size();
    }

    protected String replaceSeparator(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(256);
        int n = string2.length();
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = string.indexOf(string2, n2);
            if (n4 > -1) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(string3);
                }
                stringBuffer.append(string.substring(n2, n4));
                n2 = n4 + n;
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(string3);
            }
            stringBuffer.append(string.substring(n2, n3));
            n2 = n3;
        }
        return stringBuffer.toString();
    }

    public void setDimMemberPairs(String string) {
        if (string != null) {
            string = this.replaceSeparator(string, PROBLEM_SEPARATOR, REPLACEMENT_SEPARATOR);
            boolean bl = true;
            if (string.indexOf(59) != -1 || string.indexOf(58) != -1) {
                bl = false;
            }
            if (!bl) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ":");
                    if (stringTokenizer2.countTokens() != 2) continue;
                    String string2 = this.replaceSeparator(stringTokenizer2.nextToken(), REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR);
                    String string3 = this.replaceSeparator(stringTokenizer2.nextToken(), REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR);
                    this.addDimMemberPair(string2, new QDRMember(string3));
                }
            } else {
                QDRMember qDRMember = null;
                this.addDimMemberPair(this.replaceSeparator(string, REPLACEMENT_SEPARATOR, PROBLEM_SEPARATOR), qDRMember);
            }
        }
    }

    public String getDimMemberPairs() {
        if (this.isDimensionOnlyQDR()) {
            return (String)this.m_dimensions.elementAt(0);
        }
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_dimensions.elements();
        Enumeration enumeration2 = this.m_members.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            QDRMember qDRMember;
            String string = (String)enumeration.nextElement();
            Object e = enumeration2.nextElement();
            if (e != null && (qDRMember = (QDRMember)e).getType() == 0 && (object = qDRMember.getData()) != null) {
                if (!bl) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(string);
                stringBuffer.append(":");
                stringBuffer.append(object.toString());
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public void setTarget(QDRMember qDRMember) {
        this.m_target = qDRMember;
    }

    public QDRMember getTarget() {
        return this.m_target;
    }

    protected static boolean contains(QDR qDR, QDR qDR2) {
        QDRMember qDRMember;
        QDRMember qDRMember2;
        if (qDR == null || qDR2 == null) {
            return false;
        }
        Enumeration enumeration = qDR.getDimensions();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            qDRMember2 = (QDRMember)qDR.m_members.elementAt(n);
            if (!qDRMember2.contains(qDRMember = qDR2.getDimMember((String)enumeration.nextElement()))) {
                return false;
            }
            ++n;
        }
        qDRMember2 = qDR.getTarget();
        qDRMember = qDR2.getTarget();
        if (qDRMember2 != null || qDRMember != null) {
            if (qDRMember == null) {
                return false;
            }
            if (qDRMember2 != null && !qDRMember2.contains(qDRMember)) {
                return false;
            }
        }
        return true;
    }

    public boolean equals(QDR qDR) {
        if (qDR == null) {
            return false;
        }
        if (this.isDimensionOnlyQDR()) {
            return qDR.isDimensionOnlyQDR() && this.m_dimensions.elementAt(0).equals(qDR.m_dimensions.elementAt(0));
        }
        return QDR.contains(this, qDR) && QDR.contains(qDR, this);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof QDR) {
            return this.equals((QDR)object);
        }
        return false;
    }

    public boolean isProperSupersetOf(QDR qDR) {
        return QDR.contains(this, qDR) && !QDR.contains(qDR, this);
    }

    public boolean isProperSubsetOf(QDR qDR) {
        return QDR.contains(qDR, this) && !QDR.contains(this, qDR);
    }

    public boolean isSubsetOf(QDR qDR) {
        return QDR.contains(qDR, this);
    }

    public boolean isSupersetOf(QDR qDR) {
        return QDR.contains(this, qDR);
    }

    public int hashCode() {
        Enumeration enumeration;
        Object object;
        int n = 0;
        if (this.m_dimensions != null) {
            object = null;
            enumeration = this.m_dimensions.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object == null) continue;
                n += object.hashCode();
            }
        }
        if (this.m_members != null) {
            object = null;
            enumeration = this.m_members.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object == null) continue;
                n += object.hashCode();
            }
        }
        if (this.m_target != null) {
            n += this.m_target.hashCode();
        }
        return n;
    }

    public Object clone() {
        QDR qDR = null;
        try {
            qDR = (QDR)this.getClass().newInstance();
        }
        catch (Exception exception) {
            Object var3_4 = null;
            return var3_4;
        }
        qDR.setMeasureDim(this.m_measureDim);
        qDR.m_dimensions = (Vector)this.m_dimensions.clone();
        try {
            qDR.m_members = Utility.cloneVector(this.m_members);
            if (this.m_target != null) {
                qDR.m_target = (QDRMember)this.m_target.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return qDR;
    }

    /*
     * Unable to fully structure code
     */
    public String toString() {
        var1_1 = true;
        var2_2 = new StringBuffer();
        var3_3 = this.getMeasureDim();
        if (var3_3 != null && !var3_3.equals("")) {
            var2_2.append(var3_3);
            var2_2.append("(");
        }
        var4_4 = this.m_dimensions.elements();
        var5_5 = this.m_members.elements();
        if (var4_4 != null) ** GOTO lbl34
        return null;
lbl-1000:
        // 1 sources

        {
            var6_6 = (String)var4_4.nextElement();
            var7_7 = var5_5.nextElement();
            if (!var1_1) {
                var2_2.append(", ");
            }
            var1_1 = false;
            var2_2.append(var6_6);
            if (var7_7 == null) continue;
            var2_2.append(" ");
            if (((QDRMember)var7_7).getType() == 0) {
                var2_2.append("'");
                var2_2.append(var7_7.toString());
                var2_2.append("'");
                continue;
            }
            var2_2.append(var7_7.toString());
lbl34:
            // 4 sources

            ** while (var4_4.hasMoreElements())
        }
lbl35:
        // 1 sources

        if (var3_3 != null && !var3_3.equals("")) {
            var2_2.append(")");
        }
        return var2_2.toString();
    }

    public Object getXML(XMLContext xMLContext) {
        Object object;
        Object object2;
        Serializable serializable;
        IDResolver iDResolver = null;
        boolean bl = true;
        String string = null;
        if (xMLContext != null && (serializable = xMLContext.getScope()) != null) {
            iDResolver = (IDResolver)((ObjectScope)serializable).getObject("PersistableIDResolver");
            object2 = (Boolean)((ObjectScope)serializable).getObject(ALL_PROPERTIES);
            if (object2 != null) {
                bl = (Boolean)object2;
            }
            string = (String)((ObjectScope)serializable).getObject("MeasDimName");
        }
        serializable = new ContainerNode(XML_NAME);
        if (bl || !this.getMeasureDim().equals("")) {
            ((BaseObjectNode)serializable).addProperty(MEASURE_DIM_NAME_PROPERTY, this.getMeasureDim());
        }
        object2 = this.getDimensions();
        while (object2.hasMoreElements()) {
            object = new ObjectNode(DIM_MEMBER_PAIR_PROPERTY);
            String string2 = (String)object2.nextElement();
            ((BaseObjectNode)object).addProperty(DIMENSION_PROPERTY, string2);
            QDRMember qDRMember = this.getDimMember(string2);
            if (qDRMember != null) {
                Object object3 = qDRMember.getXML(xMLContext);
                if (object3 instanceof ObjectNode) {
                    ((ObjectNode)object).addProperty((ObjectNode)object3);
                } else {
                    ((ObjectNode)object).addContainer((ContainerNode)object3);
                }
            }
            ((ContainerNode)serializable).addContainedObject((BaseNode)object);
        }
        if (string == null) {
            string = this.m_measureDim;
        }
        PersistableUtilities.setDependentID(xMLContext, this.getQDRMeasures(string, xMLContext), false, null);
        if (this.m_target != null) {
            object2 = new ObjectNode(TARGET_PROPERTY);
            object = this.m_target.getXML(xMLContext);
            if (object instanceof ObjectNode) {
                ((ObjectNode)object2).addProperty((ObjectNode)object);
            } else {
                ((ObjectNode)object2).addContainer((ContainerNode)object);
            }
            ((ContainerNode)serializable).addContainedObject((BaseNode)object2);
        }
        return serializable;
    }

    public void setXML(XMLContext xMLContext, Object object) {
        Serializable serializable;
        Object object2;
        Object object3;
        Serializable serializable2;
        ContainerNode containerNode = (ContainerNode)object;
        PropertyNode propertyNode = containerNode.getProperty(MEASURE_DIM_NAME_PROPERTY);
        if (propertyNode != null) {
            this.m_measureDim = propertyNode.getValueAsString();
        }
        Object object4 = containerNode.getContainedObject(DIM_MEMBER_PAIR_PROPERTY);
        while (object4.hasMoreElements()) {
            serializable2 = (ObjectNode)object4.nextElement();
            propertyNode = ((BaseObjectNode)serializable2).getProperty(DIMENSION_PROPERTY);
            object3 = propertyNode.getValueAsString();
            object2 = ((ObjectNode)serializable2).getPropertyValueAsObjectNode("QDRMem", true);
            if (object2 == null) {
                object2 = ((ObjectNode)serializable2).getContainer("ListQDRMem");
            }
            if (object2 == null) continue;
            serializable = new QDRMember();
            ((QDRMember)serializable).setXML(xMLContext, object2);
            this.addDimMemberPair((String)object3, (QDRMember)serializable);
        }
        object4 = PersistableUtilities.getMeasureDimName(xMLContext);
        if (object4 == null) {
            object4 = this.m_measureDim;
        }
        if ((object3 = PersistableUtilities.getDependentID(xMLContext, (Vector)(serializable2 = this.getQDRMeasures((String)object4, xMLContext)), false, null)) != null) {
            this.setQDRMeasures((String)object4, (Vector)object3, xMLContext);
        }
        if ((object2 = containerNode.getContainedObject(TARGET_PROPERTY)) != null && object2.hasMoreElements()) {
            serializable = (ObjectNode)object2.nextElement();
            BaseObjectNode baseObjectNode = ((ObjectNode)serializable).getPropertyValueAsObjectNode("QDRMem", true);
            if (baseObjectNode == null) {
                baseObjectNode = ((ObjectNode)serializable).getContainer("ListQDRMem");
            }
            if (baseObjectNode != null) {
                QDRMember qDRMember = new QDRMember();
                qDRMember.setXML(xMLContext, baseObjectNode);
                this.setTarget(qDRMember);
            }
        } else {
            this.setTarget(null);
        }
    }

    public String getTagName() {
        return XML_NAME;
    }

    public static QDR setStateString(List list, String string) {
        QDR qDR = new QDR();
        StringTokenizer stringTokenizer = new StringTokenizer(string, PROPERTY_SEPARATOR_S);
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            if (string2 == null) {
                string2 = stringTokenizer.nextToken();
                continue;
            }
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(string3);
            MemberContext memberContext = (MemberContext)list.get(n);
            vector.addElement(memberContext.getDimID());
        }
        if (vector.size() == 0) {
            qDR.setTarget(null);
        } else if (vector.size() == 1) {
            qDR.setTarget(new QDRMember(0, vector.elementAt(0)));
        } else {
            qDR.setTarget(new QDRMember(3, vector));
        }
        if (string2 != null) {
            stringTokenizer = new StringTokenizer(string2, MemberContext.ENTRY_SEPARATOR_S);
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                int n2 = string4.indexOf(MemberContext.DIMENSION_SEPARATOR_S);
                if (n2 == -1) continue;
                int n3 = Integer.parseInt(string4.substring(n, n2));
                MemberContext memberContext = (MemberContext)list.get(n3);
                String string5 = memberContext.getDimID();
                String string6 = string4.substring(n2 + 1);
                StringTokenizer stringTokenizer2 = new StringTokenizer(string6, MemberContext.MEMBER_SEPARATOR_S);
                Vector<String> vector2 = new Vector<String>();
                while (stringTokenizer2.hasMoreTokens()) {
                    int n4 = Integer.parseInt(stringTokenizer2.nextToken());
                    String string7 = memberContext.getMemberID(n4);
                    vector2.addElement(string7);
                }
                if (vector2.size() == 0) {
                    qDR.addDimMemberPair(string5, new QDRMember(null));
                    continue;
                }
                if (vector2.size() == 1) {
                    qDR.addDimMemberPair(string5, new QDRMember(0, vector2.elementAt(0)));
                    continue;
                }
                qDR.addDimMemberPair(string5, new QDRMember(3, vector2));
            }
        }
        return qDR;
    }

    public String getStateString(List list) {
        Object object;
        Object object2;
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.m_dimensions.elements();
        if (enumeration == null) {
            return null;
        }
        int n = -1;
        Enumeration enumeration2 = this.m_members.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = enumeration2.nextElement();
            if (!bl) {
                stringBuffer.append(MemberContext.ENTRY_SEPARATOR_S);
            }
            bl = false;
            n = RuleMemberContext.addDimensionMembers(list, (String)object2);
            stringBuffer.append(n);
            if (DEBUG) {
                System.out.println(String.valueOf(object2) + ": " + n);
            }
            int n2 = -1;
            if (!(object instanceof QDRMember)) continue;
            stringBuffer.append(MemberContext.DIMENSION_SEPARATOR_S);
            stringBuffer.append(((QDRMember)object).getStateString((MemberContext)list.get(n)));
        }
        if (this.m_target != null) {
            object2 = this.m_target.getData();
            if (object2 instanceof String) {
                n = RuleMemberContext.addDimensionMembers(list, (String)object2);
                stringBuffer.append('_');
                stringBuffer.append(n);
            } else if (object2 instanceof Vector) {
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    String string = (String)object.nextElement();
                    n = RuleMemberContext.addDimensionMembers(list, string);
                    stringBuffer.append('_');
                    stringBuffer.append(n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public Vector getDependentIDs(String string) {
        if (string == null) {
            string = this.m_measureDim;
        }
        return this.getQDRMeasures(string, null);
    }

    public Vector setDependentIDs(String string, Vector vector) {
        if (string == null) {
            string = this.m_measureDim;
        }
        return this.setQDRMeasures(string, vector, null);
    }

    protected Vector getQDRMeasures(String string, XMLContext xMLContext) {
        Object object;
        Serializable serializable;
        boolean bl = false;
        if (xMLContext != null && (serializable = xMLContext.getScope()) != null && (object = serializable.getObject("migration")) != null) {
            bl = true;
        }
        serializable = null;
        object = this.getDimensions();
        bl = (string == null || string.equals("")) && bl;
        while (object.hasMoreElements()) {
            QDRMember qDRMember;
            String string2 = (String)object.nextElement();
            if (!string2.equals(string) && !bl || (qDRMember = this.getDimMember(string2)) == null || qDRMember.getType() != 0 || !(qDRMember.getData() instanceof String)) continue;
            if (serializable == null) {
                serializable = new Vector();
            }
            ((Vector)serializable).addElement(qDRMember.getData());
            if (!bl) break;
        }
        return serializable;
    }

    protected Vector setQDRMeasures(String string, Vector vector, XMLContext xMLContext) {
        if (vector != null) {
            Object object;
            Object object2;
            boolean bl = false;
            if (xMLContext != null && (object2 = xMLContext.getScope()) != null && (object = ((ObjectScope)object2).getObject("migration")) != null) {
                bl = true;
            }
            object2 = this.getDimensions();
            bl = (string == null || string.equals("")) && bl;
            while (object2.hasMoreElements()) {
                QDRMember qDRMember;
                object = (String)object2.nextElement();
                if (!((String)object).equals(string) && !bl || (qDRMember = this.getDimMember((String)object)) == null || qDRMember.getType() != 0 || !(qDRMember.getData() instanceof String)) continue;
                qDRMember.setData(vector.firstElement());
                vector.removeElementAt(0);
                if (!bl) break;
            }
        }
        return vector;
    }

    public boolean isDimensionSubsetOf(QDR qDR) {
        if (qDR == null) {
            return false;
        }
        Enumeration enumeration = this.getDimensions();
        while (enumeration.hasMoreElements()) {
            if (qDR.getDimMember((String)enumeration.nextElement()) != null) continue;
            return false;
        }
        return true;
    }

    static {
        PROPERTY_SEPARATOR_S = String.valueOf('_');
    }
}

