/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import java.io.Serializable;
import java.util.Date;
import oracle.dss.util.BIException;
import oracle.dss.util.ErrorHandler;

public class DefaultErrorHandler
implements ErrorHandler,
Serializable {
    public static final int SHOW_NONE = 0;
    public static final int SHOW_ERROR = 2;
    public static final int SHOW_LOG = 4;
    public static final int SHOW_TRACE = 8;
    public static final int SHOW_ALL = 255;
    private int m_mode = 255;

    public void setDebugMode(int n) {
        if ((n & 4) > 0 || (n & 8) > 0 || (n & 2) > 0 || n == 0 || n == 255) {
            this.m_mode = n;
        }
    }

    public int getDebugMode() {
        return this.m_mode;
    }

    public void resetDebugMode() {
        this.m_mode = 255;
    }

    public void error(Throwable throwable, String string, String string2) {
        if ((this.m_mode & 2) > 0 || this.m_mode == 255) {
            System.err.println(String.valueOf(this.getDate()) + " In " + string + "::" + string2);
            if (throwable instanceof BIException) {
                ((BIException)((Object)throwable)).getBIRootCause().printStackTrace();
            } else {
                throwable.printStackTrace();
            }
        }
    }

    public void log(String string, String string2, String string3) {
        if ((this.m_mode & 4) > 0 || this.m_mode == 255) {
            System.err.println(String.valueOf(this.getDate()) + " PROBLEM: In " + string2 + "::" + string3 + ": " + string);
        }
    }

    public void trace(String string, String string2, String string3) {
        if ((this.m_mode & 8) > 0 || this.m_mode == 255) {
            if (string2 == null && string3 == null) {
                System.err.println(string);
            } else {
                System.err.println(String.valueOf(this.getDate()) + " TRACE: In " + string2 + "::" + string3 + ": " + string);
            }
        }
    }

    protected String getDate() {
        return new Date().toString();
    }
}

