/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.util;

import oracle.dss.util.ColumnOutOfRangeException;
import oracle.dss.util.DataDirectorException;
import oracle.dss.util.DataDirectorListener;
import oracle.dss.util.DataMap;
import oracle.dss.util.EdgeOutOfRangeException;
import oracle.dss.util.LayerMetadataMap;
import oracle.dss.util.LayerOutOfRangeException;
import oracle.dss.util.MetadataMap;
import oracle.dss.util.RowOutOfRangeException;
import oracle.dss.util.SliceOutOfRangeException;

public interface DataDirector {
    public static final int COLUMN_EDGE = 0;
    public static final int ROW_EDGE = 1;
    public static final int PAGE_EDGE = 2;
    public static final int DATA_ELEMENT_EDGE = -1;
    public static final int PIVOT_EDGES = 0;
    public static final int PIVOT_SWAP = 1;
    public static final int PIVOT_MOVE_BEFORE = 2;
    public static final int PIVOT_MOVE_AFTER = 3;
    public static final int PIVOT_MOVE_TO = 4;
    public static final int NO_SUPPRESSION = 0;
    public static final int ZERO_SUPPRESSION = 1;
    public static final int NA_SUPPRESSION = 2;
    public static final int NA_ZERO_SUPPRESSION = 3;
    public static final int DRILLSTATE_NOT_DRILLABLE = 0;
    public static final int DRILLSTATE_DRILLABLE = 1;
    public static final int DRILLSTATE_IS_DRILLED = 2;
    public static final int GROUPSORT_NONE = 0;
    public static final int GROUPSORT_START = 1;
    public static final int GROUPSORT_MIDDLE = 2;
    public static final int GROUPSORT_END = 3;
    public static final int max_edge = 2;
    public static final int DRILL_REPLACE = 1;
    public static final int DRILL_COLLAPSE = 2;
    public static final int DRILL_TO_PARENT = 4;
    public static final int DRILL_TO_PARENT_AND_SIBLINGS = 8;
    public static final int DRILL_BACK = 16;
    public static final int TOTAL_SUM = 1;
    public static final int TOTAL_AVERAGE = 2;
    public static final int TOTAL_MINIMUM = 3;
    public static final int TOTAL_MAXIMUM = 4;
    public static final int TOTAL_ALL_LAYERS = -1;
    public static final int GRAND_TOTAL_LAYER = 0;
    public static final int NO_TOTALS = -2;

    public boolean pivot(int var1, int var2, int var3, int var4, int var5) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean pivotOK(int var1, int var2, int var3, int var4, int var5) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean drill(int var1, int var2, int var3, int var4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean drillOK(int var1, int var2, int var3, int var4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean drill(int var1, int var2, int[] var3, int var4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean drillOK(int var1, int var2, int[] var3, int var4) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean changeEdgeCurrentSlice(int var1, int var2) throws DataDirectorException, SliceOutOfRangeException, EdgeOutOfRangeException;

    public boolean changeEdgeCurrentHPos(int var1, int[] var2, int var3) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean reorder(int var1, int var2, int var3, int var4) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean insertValueCalc(int var1, int var2, int var3, Object var4) throws DataDirectorException, ColumnOutOfRangeException, RowOutOfRangeException;

    public boolean insertMemberCalc(int var1, int var2, int var3, int var4, Object var5) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public boolean deleteValueCalc(int var1, int var2) throws DataDirectorException, ColumnOutOfRangeException, RowOutOfRangeException;

    public boolean deleteMemberCalc(int var1, int var2, int var3) throws DataDirectorException, SliceOutOfRangeException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public void addDataDirectorListener(DataDirectorListener var1);

    public void removeDataDirectorListener(DataDirectorListener var1);

    public boolean refresh() throws DataDirectorException;

    public boolean revalidate() throws DataDirectorException;

    public void setOutline(boolean var1) throws DataDirectorException;

    public boolean isOutline();

    public void setMetadataMap(int var1, int var2, MetadataMap var3, int var4) throws DataDirectorException, LayerOutOfRangeException, EdgeOutOfRangeException;

    public void setDataMap(DataMap var1, int var2, int var3) throws DataDirectorException;

    public MetadataMap getMetadataMap(int var1, int var2) throws LayerOutOfRangeException, EdgeOutOfRangeException;

    public DataMap getDataMap();

    public MetadataMap getSupportedMetadataMap();

    public LayerMetadataMap getSupportedLayerMetadataMap();

    public DataMap getSupportedDataMap();

    public boolean isCancelable();

    public boolean cancel() throws DataDirectorException;

    public void setManualUpdate();

    public void update() throws DataDirectorException;
}

