/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGInfo;

class PNGTimeChunk
extends PNGChunk {
    PNGTimeChunk() {
    }

    int getDataLength() {
        return 7;
    }

    String getChunkType() {
        return "tIME";
    }

    byte[] getData() {
        PNGInfo pNGInfo = this.getPNGInfo();
        Date date = pNGInfo.getCreationDate();
        if (date == null) {
            return new byte[0];
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar = null;
        calendar = Locale.getDefault().getLanguage().compareTo("th") == 0 && Locale.getDefault().getCountry().compareTo("TH") == 0 ? new GregorianCalendar(timeZone) : Calendar.getInstance(timeZone);
        calendar.setTime(date);
        byte[] byArray = new byte[7];
        short s = (short)calendar.get(1);
        byArray[0] = (byte)(s >> 8);
        byArray[1] = (byte)s;
        byArray[2] = (byte)(calendar.get(2) + 1);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = (byte)calendar.get(11);
        byArray[5] = (byte)calendar.get(12);
        byArray[6] = (byte)calendar.get(13);
        return byArray;
    }

    boolean isCriticalChunk() {
        return false;
    }
}

