/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import oracle.dss.graph.pfj.png.PNGChunk;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInfo;
import oracle.dss.graph.pfj.png.PNGInvalidParameterException;

public class PNGEncoder {
    private static final byte[] pngFileSignature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static Class[] pngChunkTypes = new Class[]{Class.forName("oracle.dss.graph.pfj.png.PNGHeaderChunk"), Class.forName("oracle.dss.graph.pfj.png.PNGTimeChunk"), Class.forName("oracle.dss.graph.pfj.png.PNGTextChunk"), Class.forName("oracle.dss.graph.pfj.png.PNGDataChunk"), Class.forName("oracle.dss.graph.pfj.png.PNGEndChunk")};
    private Image pngImage;
    private String imageText;
    private PNGInfo pngInfo;
    private OutputStream pngStream;
    private PrintStream warningStream;
    private boolean isFile;

    public PNGEncoder(Image image, File file) throws PNGInvalidParameterException {
        this(image, file, null);
    }

    public PNGEncoder(Image image, OutputStream outputStream) throws PNGInvalidParameterException {
        this(image, outputStream, null);
    }

    public PNGEncoder(Image image, File file, PrintStream printStream) throws PNGInvalidParameterException {
        if (image == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, File, PrintStream)", "null Image parameter");
        }
        if (file == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, File, PrintStream)", "null File parameter");
        }
        this.warningStream = printStream;
        this.pngImage = image;
        try {
            this.pngStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            throw new PNGInvalidParameterException(this, 2, "PNGEncoder(Image, File, PrintStream)", "Invalid File parameter", iOException);
        }
        this.isFile = true;
    }

    public PNGEncoder(Image image, OutputStream outputStream, PrintStream printStream) throws PNGInvalidParameterException {
        if (image == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, OutputStream, PrintStream)", "null Image parameter");
        }
        if (outputStream == null) {
            throw new PNGInvalidParameterException(this, 0, "PNGEncoder(Image, OutputStream, PrintStream)", "null OutputStream parameter");
        }
        this.pngImage = image;
        this.pngStream = outputStream;
        this.warningStream = printStream;
    }

    private PNGEncoder() {
    }

    public void setImageText(String string) {
        this.imageText = string;
    }

    public void setPNGChunkTypes(Class[] classArray) throws PNGInvalidParameterException {
        if (classArray == null) {
            throw new PNGInvalidParameterException(this, 0, "setPNGChunkTypes(Class[])", "null parameter");
        }
        int n = classArray.length;
        if (n == 0) {
            throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", "array length == 0");
        }
        int n2 = 0;
        while (n2 < n) {
            if (classArray[n2] == null) {
                throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", String.valueOf(String.valueOf("index ")) + n2 + " in array is null");
            }
            if (!Class.forName("oracle.dss.graph.pfj.png.PNGChunk").isAssignableFrom(classArray[n2])) {
                throw new PNGInvalidParameterException(this, 1, "setPNGChunkTypes(Class[])", String.valueOf(String.valueOf("index ")) + n2 + " in array is " + " of type " + classArray[n2].getName() + "; must derive from PNGChunk");
            }
            ++n2;
        }
        pngChunkTypes = classArray;
    }

    public final void encode() throws PNGException {
        this.encode((byte)6);
    }

    public final void encode(byte by) throws PNGException {
        int n = this.pngImage.getWidth(null);
        int n2 = this.pngImage.getHeight(null);
        if (n == 0 || n2 == 0) {
            throw new PNGException(this, 3, "encode()", "image width == 0 || image height == 0");
        }
        this.pngInfo = new PNGInfo(this.pngImage, n, n2, this.imageText, new Date(), 8, by, 0, 0, 0);
        try {
            this.pngStream.write(pngFileSignature);
        }
        catch (IOException iOException) {
            throw new PNGException(this, 5, "encode()", "unable to write PNG file signature", iOException);
        }
        int n3 = pngChunkTypes.length;
        DataOutputStream dataOutputStream = new DataOutputStream(this.pngStream);
        int n4 = 0;
        while (n4 < n3) {
            PNGChunk pNGChunk = null;
            try {
                pNGChunk = (PNGChunk)pngChunkTypes[n4].newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new PNGException(this, 4, "encode()", "error instantiating PNGChunk", instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new PNGException(this, 4, "encode()", "error instantiating PNGChunk", illegalAccessException);
            }
            try {
                pNGChunk.setPNGInfo(this.pngInfo);
            }
            catch (PNGInvalidParameterException pNGInvalidParameterException) {
                // empty catch block
            }
            try {
                pNGChunk.write(dataOutputStream);
            }
            catch (PNGException pNGException) {
                if (pNGChunk.isCriticalChunk()) {
                    throw pNGException;
                }
                if (pNGException.getNestedException() instanceof IOException) {
                    throw pNGException;
                }
                this.log(String.valueOf(String.valueOf("Error writing ancillary chunk; skipping chunk: ")) + pNGChunk.getClass().getName() + "; Exception detail: " + pNGException.getMessage());
            }
            catch (Exception exception) {
                throw new PNGException(this, 7, "encode()", "unknown Exception thrown when writing chunk", exception);
            }
            ++n4;
        }
        try {
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            this.log(String.valueOf(String.valueOf("Unable to flush() the .png stream; Exception detail: ")) + iOException.toString());
        }
        if (this.isFile) {
            try {
                this.pngStream.close();
            }
            catch (IOException iOException) {
                this.log(String.valueOf(String.valueOf("Unable to close() the .png file output stream; Exception detail: ")) + iOException.toString());
            }
        }
    }

    private void log(String string) {
        if (this.warningStream != null) {
            if (string == null) {
                string = "null";
            }
            this.warningStream.println(String.valueOf(this.getClass().getName()) + ": Warning: " + string);
        }
    }
}

