/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.png;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import oracle.dss.graph.pfj.png.PNGException;
import oracle.dss.graph.pfj.png.PNGInfo;
import oracle.dss.graph.pfj.png.PNGInvalidParameterException;

abstract class PNGChunk {
    private PNGInfo pngInfo;

    PNGChunk() {
    }

    abstract int getDataLength() throws PNGException;

    abstract String getChunkType();

    abstract byte[] getData() throws PNGException;

    abstract boolean isCriticalChunk();

    final void setPNGInfo(PNGInfo pNGInfo) throws PNGInvalidParameterException {
        if (pNGInfo == null) {
            throw new PNGInvalidParameterException(this, 0, "setInfo(PNGInfo)", "null parameter");
        }
        this.pngInfo = pNGInfo;
    }

    final PNGInfo getPNGInfo() {
        return (PNGInfo)this.pngInfo.clone();
    }

    final void write(OutputStream outputStream) throws PNGException {
        if (this.pngInfo == null) {
            throw new PNGException(this, 5, "write()", "Unable to write; coding error; PNGInfo object not set with setPNGInfo()");
        }
        int n = this.getDataLength();
        if (n < 0) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data length < 0");
        }
        byte[] byArray = this.toByteArray(n);
        String string = this.getChunkType();
        if (string == null) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk type == null");
        }
        if (string.length() != 4) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk type string != 4 characters");
        }
        byte[] byArray2 = this.toAsciiArray(string);
        byte[] byArray3 = this.getData();
        if (byArray3 == null) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data == null");
        }
        if (byArray3.length != n) {
            throw new PNGException(this, 4, "write(OutputStream)", "chunk data array length != getDataLength() value");
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray2);
        cRC32.update(byArray3);
        byte[] byArray4 = this.toByteArray((int)cRC32.getValue());
        try {
            outputStream.write(byArray);
            outputStream.write(byArray2);
            outputStream.write(byArray3);
            outputStream.write(byArray4);
        }
        catch (IOException iOException) {
            throw new PNGException(this, 4, "write(OutputStream)", "error writing to stream", iOException);
        }
    }

    final byte[] toByteArray(int n) {
        return this.toByteArray(new int[]{n});
    }

    final byte[] toByteArray(int[] nArray) {
        int n = nArray.length;
        byte[] byArray = new byte[n * 4];
        this.toByteArray(nArray, 0, n, byArray, 0, false);
        return byArray;
    }

    final void toByteArray(int[] nArray, int n, int n2, byte[] byArray, int n3, boolean bl) {
        if (bl) {
            int n4 = 0;
            while (n4 < n2) {
                byArray[n3 + n4 * 4 + 0] = (byte)(nArray[n + n4] >> 16);
                byArray[n3 + n4 * 4 + 1] = (byte)(nArray[n + n4] >> 8);
                byArray[n3 + n4 * 4 + 2] = (byte)nArray[n + n4];
                byArray[n3 + n4 * 4 + 3] = (byte)(nArray[n + n4] >> 24);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 3;
                while (n6 > -1) {
                    byArray[n3 + n5 * 4 + (3 - n6)] = (byte)(nArray[n + n5] >> 8 * n6);
                    --n6;
                }
                ++n5;
            }
        }
    }

    final byte[] toAsciiArray(String string) {
        if (string == null) {
            return new byte[0];
        }
        char[] cArray = string.toCharArray();
        int n = string.length();
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return byArray;
    }
}

