/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DSurface
extends Model3DFlatFace {
    public static final int FRONT_BACK = 0;
    public static final int LEFT_RIGHT = 1;
    public static final int TOP = 2;
    public static final int BOTTOM = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    private static int[][] m_myfacesFront = new int[][]{{0, 1, 4, 3}, {1, 2, 5, 4}, {3, 4, 5}, {2, 1, 0}};
    private static int[][] m_myfacesBack = new int[][]{{2, 1, 4, 5}, {1, 0, 3, 4}, {3, 5, 4}, {0, 1, 2}};
    private boolean m_bShowSides;
    private boolean m_bShowTop;
    private int m_s;
    private int m_sNext;
    private int m_sFirst;
    private int m_sLast;
    private int m_g;
    private int m_gNext;
    private int m_gFirst;
    private int m_gLast;
    private boolean m_bFrontTriangle;

    public Model3DSurface(JChart_3D jChart_3D, IdentObj identObj, BlackBoxIF blackBoxIF, Point3d[] point3dArray, boolean bl, boolean bl2, SeriesEnumerator seriesEnumerator, GroupsEnumerator groupsEnumerator, boolean[][] blArray, boolean bl3, boolean bl4) {
        super(jChart_3D, identObj, blackBoxIF, 4, 6, blArray, bl4);
        this.m_faces = bl3 ? m_myfacesFront : m_myfacesBack;
        this.m_bShowSides = bl;
        this.m_bShowTop = bl2;
        this.m_s = identObj.getSeriesID();
        this.m_sNext = seriesEnumerator.peekAtSeriesAfter(this.m_s);
        this.m_sFirst = seriesEnumerator.getFirstSeries();
        this.m_sLast = seriesEnumerator.getLastSeries();
        PfjAssert.pfjAssert(this.m_sFirst >= 0 && this.m_sLast >= 0);
        this.m_g = identObj.getGroupID();
        this.m_gNext = groupsEnumerator.peekAtGroupAfter(this.m_g);
        this.m_gFirst = groupsEnumerator.getFirstGroup();
        this.m_gLast = groupsEnumerator.getLastGroup();
        PfjAssert.pfjAssert(this.m_gFirst >= 0 && this.m_gLast >= 0);
        this.m_bFrontTriangle = bl3;
        int n = 0;
        while (n < 6) {
            this.m_vertices[n] = new Point3d(point3dArray[n].x, point3dArray[n].y, point3dArray[n].z);
            ++n;
        }
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_vertices[0].x + (this.m_vertices[1].x - this.m_vertices[0].x) * (double)2 / (double)3, this.m_vertices[0].y, this.m_vertices[2].z + (this.m_vertices[1].z - this.m_vertices[2].z) * (double)2 / (double)3);
    }

    protected Point3d getGridLineEnd(int n, int n2, double d) {
        switch (n) {
            case 0: {
                double d2 = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                switch (n2) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + d2 * (this.m_vertices[4].y - this.m_vertices[3].y), this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[4].y + d2 * (this.m_vertices[5].y - this.m_vertices[4].y), this.m_vertices[2].z);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + d2 * (this.m_vertices[5].y - this.m_vertices[3].y), this.m_vertices[3].z - d2 * (this.m_vertices[3].z - this.m_vertices[5].z));
                        }
                        return new Point3d(d, this.m_vertices[3].y + d2 * (this.m_vertices[5].y - this.m_vertices[3].y), this.m_vertices[3].z - d2 * (this.m_vertices[3].z - this.m_vertices[5].z));
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[3].z - d2 * (this.m_vertices[3].z - this.m_vertices[5].z));
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[4].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[0].z);
                            }
                            double d3 = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[4].x + d3 * (this.m_vertices[3].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                        }
                        if (d < this.m_vertices[4].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[2].z);
                        }
                        double d4 = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + d4 * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[5].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                            }
                            double d5 = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + d5 * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (d < this.m_vertices[4].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[2].z);
                        }
                        double d6 = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z + d6 * (this.m_vertices[3].z - this.m_vertices[4].z));
                    }
                    case 2: {
                        boolean bl;
                        boolean bl2 = this.m_vertices[3].y > d;
                        boolean bl3 = this.m_vertices[4].y > d;
                        boolean bl4 = bl = this.m_vertices[5].y > d;
                        if (bl2 == bl3 && bl2 == bl) {
                            return null;
                        }
                        if (bl2 != bl) {
                            double d7 = (d - this.m_vertices[3].y) / (this.m_vertices[5].y - this.m_vertices[3].y);
                            return new Point3d(this.m_vertices[3].x + d7 * (this.m_vertices[5].x - this.m_vertices[3].x), d, this.m_vertices[3].z + d7 * (this.m_vertices[5].z - this.m_vertices[3].z));
                        }
                        if (this.m_bFrontTriangle) {
                            double d8 = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + d8 * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        double d9 = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + d9 * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 3: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                double d10 = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                switch (n2) {
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[2].x, this.m_vertices[5].y + d10 * (this.m_vertices[4].y - this.m_vertices[5].y), d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[4].y + d10 * (this.m_vertices[3].y - this.m_vertices[4].y), d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x + d10 * (this.m_vertices[0].x - this.m_vertices[2].x), this.m_vertices[5].y + d10 * (this.m_vertices[3].y - this.m_vertices[5].y), d);
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[2].x + d10 * (this.m_vertices[0].x - this.m_vertices[2].x), this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int n, int n2, double d) {
        switch (n) {
            case 0: {
                double d2 = (d - this.m_vertices[0].x) / (this.m_vertices[2].x - this.m_vertices[0].x);
                switch (n2) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[2].z);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[3].y + d2 * (this.m_vertices[4].y - this.m_vertices[3].y), this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[4].y + (1.0 - d2) * (this.m_vertices[5].y - this.m_vertices[4].y), this.m_vertices[2].z);
                    }
                    case 3: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                        }
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[2].z);
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[3].y) {
                                return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                            }
                            double d3 = (d - this.m_vertices[3].y) / (this.m_vertices[4].y - this.m_vertices[3].y);
                            return new Point3d(this.m_vertices[3].x + d3 * (this.m_vertices[4].x - this.m_vertices[3].x), d, this.m_vertices[0].z);
                        }
                        if (d < this.m_vertices[5].y) {
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[2].z);
                        }
                        double d4 = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                        return new Point3d(this.m_vertices[5].x - d4 * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            if (d < this.m_vertices[4].y) {
                                return new Point3d(this.m_vertices[2].x, d, this.m_vertices[0].z);
                            }
                            double d5 = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[4].z - d5 * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (d < this.m_vertices[3].y) {
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                        }
                        double d6 = (d - this.m_vertices[3].y) / (this.m_vertices[4].y - this.m_vertices[3].y);
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[3].z + d6 * (this.m_vertices[4].z - this.m_vertices[3].z));
                    }
                    case 2: {
                        boolean bl;
                        boolean bl2 = this.m_vertices[3].y > d;
                        boolean bl3 = this.m_vertices[4].y > d;
                        boolean bl4 = bl = this.m_vertices[5].y > d;
                        if (bl2 == bl3 && bl2 == bl) {
                            return null;
                        }
                        if (this.m_bFrontTriangle) {
                            if (bl2 != bl3) {
                                double d7 = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                                return new Point3d(this.m_vertices[4].x + d7 * (this.m_vertices[3].x - this.m_vertices[4].x), d, this.m_vertices[0].z);
                            }
                            double d8 = (d - this.m_vertices[5].y) / (this.m_vertices[4].y - this.m_vertices[5].y);
                            return new Point3d(this.m_vertices[2].x, d, this.m_vertices[5].z + d8 * (this.m_vertices[4].z - this.m_vertices[5].z));
                        }
                        if (bl2 != bl3) {
                            double d9 = (d - this.m_vertices[4].y) / (this.m_vertices[3].y - this.m_vertices[4].y);
                            return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z + d9 * (this.m_vertices[3].z - this.m_vertices[4].z));
                        }
                        double d10 = (d - this.m_vertices[4].y) / (this.m_vertices[5].y - this.m_vertices[4].y);
                        return new Point3d(this.m_vertices[4].x + d10 * (this.m_vertices[5].x - this.m_vertices[4].x), d, this.m_vertices[2].z);
                    }
                }
                break;
            }
            case 2: {
                double d11 = (d - this.m_vertices[2].z) / (this.m_vertices[0].z - this.m_vertices[2].z);
                switch (n2) {
                    case 1: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                    case 2: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[2].x, this.m_vertices[5].y + d11 * (this.m_vertices[4].y - this.m_vertices[5].y), d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[4].y + d11 * (this.m_vertices[3].y - this.m_vertices[4].y), d);
                    }
                    case 3: {
                        if (this.m_bFrontTriangle) {
                            return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                        }
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int n) {
        if (n == 2 || n == 3) {
            return 3;
        }
        return 4;
    }

    public double visibility(int n) {
        JGraphType jGraphType = this.m_chart.getPerspective().getJGraphType();
        if (jGraphType.isHoneyComb()) {
            if (n == 2 || n == 3) {
                return -1.0;
            }
            return 1.0;
        }
        if (jGraphType.isSurfaceWithSides()) {
            boolean bl = false;
            switch (n) {
                case 0: {
                    if ((!this.m_bFrontTriangle || this.m_g != this.m_gFirst) && (this.m_bFrontTriangle || this.m_gNext == -1 || this.m_gNext != this.m_gLast)) break;
                    bl = true;
                    break;
                }
                case 1: {
                    if ((this.m_bFrontTriangle || this.m_s != this.m_sFirst) && (!this.m_bFrontTriangle || this.m_sNext == -1 || this.m_sNext != this.m_sLast)) break;
                    bl = true;
                    break;
                }
                case 2: 
                case 3: {
                    if (!this.m_bShowTop) break;
                    bl = true;
                }
            }
            double d = !bl ? -1.0 : super.visibility(n);
            return d;
        }
        if (n == 2) {
            return 1.0;
        }
        return -1.0;
    }
}

