/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRectSolid
extends Model3DFlatFace {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int TOP = 2;
    public static final int BACK = 3;
    public static final int RIGHT = 4;
    public static final int BOTTOM = 5;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected int m_nPtsPerFace = 4;
    private static int[][] m_myfaces = new int[][]{{0, 1, 2, 3}, {0, 3, 7, 4}, {3, 2, 6, 7}, {4, 7, 6, 5}, {1, 5, 6, 2}, {0, 4, 5, 1}};

    public Model3DRectSolid(JChart_3D jChart_3D, IdentObj identObj, BlackBoxIF blackBoxIF, Point3d point3d, Point3d point3d2, boolean[][] blArray, boolean bl, boolean bl2) {
        super(jChart_3D, identObj, blackBoxIF, 6, 8, blArray, bl);
        this.m_origin = new Point3d(point3d);
        this.m_size = new Point3d(point3d2);
        this.m_faces = m_myfaces;
        int n = 0;
        while (n < this.m_nVertices) {
            this.m_vertices[n] = new Point3d(point3d);
            ++n;
        }
        this.m_vertices[0].z += this.m_size.z;
        this.m_vertices[1].x += this.m_size.x;
        this.m_vertices[1].z += this.m_size.z;
        this.m_vertices[2].x += this.m_size.x;
        this.m_vertices[2].y += this.m_size.y;
        this.m_vertices[2].z += this.m_size.z;
        this.m_vertices[3].y += this.m_size.y;
        this.m_vertices[3].z += this.m_size.z;
        this.m_vertices[5].x += this.m_size.x;
        this.m_vertices[6].x += this.m_size.x;
        this.m_vertices[6].y += this.m_size.y;
        this.m_vertices[7].y += this.m_size.y;
        this.m_bCanUseSimpleVisibility = bl2;
    }

    public Model3DRectSolid(Model3DRectSolid model3DRectSolid) {
        this(model3DRectSolid.m_chart, model3DRectSolid.m_id, model3DRectSolid.m_bb, model3DRectSolid.m_origin, model3DRectSolid.m_size, model3DRectSolid.m_bGridStatus, model3DRectSolid.m_bAutoshading, model3DRectSolid.m_bCanUseSimpleVisibility);
        this.m_distance = model3DRectSolid.m_distance;
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / (double)2, this.m_origin.y, this.m_origin.z + this.m_size.z / (double)2);
    }

    protected Point3d getGridLineEnd(int n, int n2, double d) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[0].z);
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[3].z);
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[4].z);
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[1].z);
                    }
                    case 5: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[3].y, d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[2].x, this.m_vertices[3].y, d);
                    }
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[3].y, d);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int n, int n2, double d) {
        switch (n) {
            case 0: {
                switch (n2) {
                    case 0: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[0].z);
                    }
                    case 1: {
                        return null;
                    }
                    case 2: {
                        return new Point3d(d, this.m_vertices[3].y, this.m_vertices[4].z);
                    }
                    case 3: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[4].z);
                    }
                    case 4: {
                        return null;
                    }
                    case 5: {
                        return new Point3d(d, this.m_vertices[0].y, this.m_vertices[4].z);
                    }
                }
                break;
            }
            case 1: {
                switch (n2) {
                    case 0: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[0].z);
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z);
                    }
                    case 2: {
                        return null;
                    }
                    case 3: {
                        return new Point3d(this.m_vertices[0].x, d, this.m_vertices[4].z);
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, d, this.m_vertices[4].z);
                    }
                    case 5: {
                        return null;
                    }
                }
                break;
            }
            case 2: {
                switch (n2) {
                    case 0: {
                        return null;
                    }
                    case 1: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                    case 2: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[3].y, d);
                    }
                    case 3: {
                        return null;
                    }
                    case 4: {
                        return new Point3d(this.m_vertices[1].x, this.m_vertices[0].y, d);
                    }
                    case 5: {
                        return new Point3d(this.m_vertices[0].x, this.m_vertices[0].y, d);
                    }
                }
            }
        }
        return null;
    }

    public double getMinZ() {
        double d = -1.7976931348623157E308;
        this.transformVertices();
        int n = 0;
        while (n < this.m_nVertices) {
            if (this.m_xVertices[n].z > d) {
                d = this.m_xVertices[n].z;
            }
            ++n;
        }
        return d;
    }

    public int getNumPtsPerFace(int n) {
        return 4;
    }

    public boolean isVisibleIpsoFacto(int n) {
        PfjAssert.pfjAssert(this.m_bCanUseSimpleVisibility);
        return n == 0 || n == 2 || n == 4;
    }
}

