/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.model3d;

import oracle.dss.graph.pfj.JChart_3D;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.model3d.Model3DFlatFace;
import oracle.dss.graph.pfj.model3d.Point3d;

public class Model3DRectPyramid
extends Model3DFlatFace {
    public static final int FRONT = 0;
    public static final int LEFT = 1;
    public static final int BACK = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    public static final int MIN_POINTS = 3;
    public static final double BY_ANGLE_SCALE = 1.0;
    protected Point3d m_origin;
    protected Point3d m_size;
    protected boolean m_bInverted;
    private static int[][] m_myfaces = new int[][]{{3, 2, 4}, {0, 3, 4}, {1, 0, 4}, {2, 1, 4}, {0, 1, 2, 3}};

    public Model3DRectPyramid(JChart_3D jChart_3D, IdentObj identObj, BlackBoxIF blackBoxIF, Point3d point3d, Point3d point3d2, boolean[][] blArray, boolean bl, boolean bl2) {
        super(jChart_3D, identObj, blackBoxIF, 5, 5, blArray, bl);
        this.m_origin = new Point3d(point3d);
        this.m_size = new Point3d(point3d2);
        this.m_bInverted = bl2;
        this.m_faces = m_myfaces;
        int n = 0;
        while (n < this.m_nVertices) {
            this.m_vertices[n] = new Point3d(point3d);
            ++n;
        }
        if (bl2) {
            this.m_vertices[0].x += this.m_size.x;
            this.m_vertices[0].y += this.m_size.y;
            this.m_vertices[1].y += this.m_size.y;
            this.m_vertices[2].y += this.m_size.y;
            this.m_vertices[2].z += this.m_size.z;
            this.m_vertices[3].x += this.m_size.x;
            this.m_vertices[3].y += this.m_size.y;
            this.m_vertices[3].z += this.m_size.z;
            this.m_vertices[4].x += this.m_size.x / (double)2;
            this.m_vertices[4].z += this.m_size.z / (double)2;
        } else {
            this.m_vertices[1].x += this.m_size.x;
            this.m_vertices[2].x += this.m_size.x;
            this.m_vertices[2].z += this.m_size.z;
            this.m_vertices[3].z += this.m_size.z;
            this.m_vertices[4].x += this.m_size.x / (double)2;
            this.m_vertices[4].y += this.m_size.y;
            this.m_vertices[4].z += this.m_size.z / (double)2;
        }
        this.calcGrids();
    }

    public Model3DRectPyramid(Model3DRectPyramid model3DRectPyramid) {
        this(model3DRectPyramid.m_chart, model3DRectPyramid.m_id, model3DRectPyramid.m_bb, model3DRectPyramid.m_origin, model3DRectPyramid.m_size, model3DRectPyramid.m_bGridStatus, model3DRectPyramid.m_bAutoshading, model3DRectPyramid.m_bInverted);
    }

    protected Point3d getCenter() {
        return new Point3d(this.m_origin.x + this.m_size.x / (double)2, this.m_origin.y + this.m_size.y / (double)2, this.m_origin.z + this.m_size.z / (double)2);
    }

    public Point3d getGridLineEnd(int n, int n2, double d) {
        double d2 = this.m_vertices[0].x;
        double d3 = this.m_vertices[4].x;
        double d4 = this.m_vertices[1].x;
        double d5 = this.m_vertices[0].y;
        double d6 = this.m_vertices[4].y;
        double d7 = this.m_vertices[0].z;
        double d8 = this.m_vertices[4].z;
        double d9 = this.m_vertices[3].z;
        double d10 = 0.0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d10 = (d - d5) / (d6 - d5);
                switch (n2) {
                    case 0: {
                        return new Point3d(d2 + (d4 - d2) * (1.0 - d10 / (double)2), d, d7 + (d9 - d7) * (1.0 - d10 / (double)2));
                    }
                    case 1: {
                        return new Point3d(d2 + (d4 - d2) * d10 / (double)2, d, d7 + (d9 - d7) * (1.0 - d10 / (double)2));
                    }
                    case 2: {
                        return new Point3d(d2 + (d4 - d2) * (1.0 - d10 / (double)2), d, d7 + (d9 - d7) * d10 / (double)2);
                    }
                    case 3: {
                        return new Point3d(d2 + (d4 - d2) * (1.0 - d10 / (double)2), d, d7 + (d9 - d7) * (1.0 - d10 / (double)2));
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
        }
        return null;
    }

    protected Point3d getGridLineStart(int n, int n2, double d) {
        double d2 = this.m_vertices[0].x;
        double d3 = this.m_vertices[1].x;
        double d4 = this.m_vertices[0].y;
        double d5 = this.m_vertices[4].y;
        double d6 = this.m_vertices[0].z;
        double d7 = this.m_vertices[3].z;
        double d8 = 0.0;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                d8 = (d - d4) / (d5 - d4);
                switch (n2) {
                    case 0: {
                        return new Point3d(d2 + (d3 - d2) * d8 / (double)2, d, d6 + (d7 - d6) * (1.0 - d8 / (double)2));
                    }
                    case 1: {
                        return new Point3d(d2 + (d3 - d2) * d8 / (double)2, d, d6 + (d7 - d6) * d8 / (double)2);
                    }
                    case 2: {
                        return new Point3d(d2 + (d3 - d2) * d8 / (double)2, d, d6 + (d7 - d6) * d8 / (double)2);
                    }
                    case 3: {
                        return new Point3d(d2 + (d3 - d2) * (1.0 - d8 / (double)2), d, d6 + (d7 - d6) * d8 / (double)2);
                    }
                    case 4: {
                        return null;
                    }
                }
                break;
            }
        }
        return null;
    }

    public int getNumPtsPerFace(int n) {
        if (n == 4) {
            return 4;
        }
        return 3;
    }
}

