/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;
import oracle.dss.graph.pfj.math.FP;

public class FitRational
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        double d2 = d / (dArray[2] + dArray[1] * d);
        if (Double.isNaN(d2)) {
            throw new AssertionException();
        }
        return d2;
    }

    public void eval(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(FP.nonzero(d));
        dArray[1] = 1.0;
        dArray[2] = 1.0 / d;
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double d) throws AssertionException {
        PfjAssert.pfjAssert(FP.nonzero(d));
        return 1.0 / d;
    }

    public double invTransformCoeff(int n, double d) {
        return d;
    }

    public String createEquation(String[] stringArray, boolean bl) throws AssertionException {
        PfjAssert.pfjAssert(stringArray.length >= NUM_COEFFS + 1);
        String string = stringArray[2];
        String string2 = String.valueOf(stringArray[1]) + " * x";
        if (bl) {
            return String.valueOf(String.valueOf("y = x / (")) + string2 + " + " + string + ")";
        }
        return String.valueOf(String.valueOf("y = x / (")) + string + " + " + string2 + ")";
    }
}

