/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.math;

import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.math.CurveFitIF;

public class FitGeometric
implements CurveFitIF {
    private static int NUM_COEFFS = 2;

    public double compute(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        double d2 = dArray[1] * Math.pow(d, dArray[2]);
        return d2;
    }

    public void eval(double d, double[] dArray) throws AssertionException {
        PfjAssert.pfjAssert(dArray.length >= NUM_COEFFS + 1);
        PfjAssert.pfjAssert(d > 0.0);
        dArray[1] = 1.0;
        dArray[2] = Math.log(d);
    }

    public int numCoeffs() {
        return NUM_COEFFS;
    }

    public double transformY(double d) throws AssertionException {
        PfjAssert.pfjAssert(d > 0.0);
        return Math.log(d);
    }

    public double invTransformCoeff(int n, double d) {
        if (n == 1) {
            return Math.exp(d);
        }
        return d;
    }

    public String createEquation(String[] stringArray, boolean bl) throws AssertionException {
        PfjAssert.pfjAssert(stringArray.length >= NUM_COEFFS + 1);
        String string = stringArray[1];
        String string2 = String.valueOf(String.valueOf("x^")) + stringArray[2];
        return String.valueOf(String.valueOf("y = ")) + string + " * " + string2;
    }
}

