/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;

public class TextBox {
    public static final int ANCHOR_LEFT = 0;
    public static final int ANCHOR_CENTER = 1;
    public static final int ANCHOR_RIGHT = 2;
    public static final int ANCHOR_TOP = 0;
    public static final int ANCHOR_BOTTOM = 2;
    private Rectangle m_r;
    private int m_nHorz;
    private int m_nVert;

    public TextBox(Rectangle rectangle, int n, int n2) {
        this.m_r = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.setAnchor(n, n2);
    }

    public void copyIntoRect(Rectangle rectangle) {
        rectangle.x = this.m_r.x;
        rectangle.y = this.m_r.y;
        rectangle.width = this.m_r.width;
        rectangle.height = this.m_r.height;
    }

    public Rectangle getRect() {
        return this.m_r;
    }

    public void setAnchor(int n, int n2) {
        if (n < 0 || n > 2) {
            n = 1;
        }
        if (n2 < 0 || n2 > 2) {
            n2 = 1;
        }
        this.m_nHorz = n;
        this.m_nVert = n2;
    }

    public void setHeight(int n) {
        if (n < 0) {
            return;
        }
        this.m_r.y -= (n - this.m_r.height) * this.m_nVert / 2;
        this.m_r.height = n;
    }

    public void setOrigin(Point point) {
        this.m_r.x = point.x;
        this.m_r.y = point.y;
    }

    public void setSize(Dimension dimension) {
        this.setHeight(dimension.height);
        this.setWidth(dimension.width);
    }

    public void setWidth(int n) {
        if (n < 0) {
            return;
        }
        this.m_r.x -= (n - this.m_r.width) * this.m_nHorz / 2;
        this.m_r.width = n;
    }
}

