/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class Detectiv
implements Serializable {
    public static final int MIN_LINEWIDTH = 4;
    public static final int INIT_CAPACITY = 4096;
    private Perspective m_Perspective;
    private Vector m_detList;
    boolean m_bExceptionalFlag;
    Rectangle m_defaultClipRect;

    public Detectiv(Perspective perspective) {
        this.m_Perspective = perspective;
        this.m_detList = new Vector(4096);
        this.m_bExceptionalFlag = false;
    }

    public DetObj findNodeOf(int n, int n2, VC vC) {
        DetObj detObj = null;
        boolean bl = false;
        int n3 = this.m_detList.size() - 1;
        while (n3 >= 0 && !bl) {
            detObj = (DetObj)this.m_detList.elementAt(n3);
            if (detObj.isPointInObj(n, n2, vC)) {
                bl = true;
            }
            --n3;
        }
        return detObj;
    }

    public DetObj findNodeOf(int n, int n2) {
        DetObj detObj = null;
        boolean bl = false;
        int n3 = this.m_detList.size() - 1;
        while (n3 >= 0 && !bl) {
            detObj = (DetObj)this.m_detList.elementAt(n3);
            if (detObj.getSeriesID() == n && detObj.getGroupID() == n2) {
                bl = true;
            }
            --n3;
        }
        return detObj;
    }

    public DetObj findNodeOf(IdentObj identObj) {
        block9: {
            IdentObj identObj2;
            int n;
            DetObj detObj;
            block8: {
                detObj = null;
                n = this.m_detList.size() - 1;
                while (n >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(n);
                    if (detObj != null && detObj.isDetectable() && (identObj2 = detObj.getIdentID()).equals(identObj)) {
                        return detObj;
                    }
                    --n;
                }
                if (identObj.getObjectID() != -3) break block8;
                n = this.m_detList.size() - 1;
                while (n >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(n);
                    if (detObj != null && detObj.isDetectable() && (identObj2 = detObj.getIdentID()).getSeriesID() == identObj.getSeriesID() && identObj2.getGroupID() == identObj.getGroupID()) {
                        return detObj;
                    }
                    --n;
                }
                n = this.m_detList.size() - 1;
                while (n >= 0) {
                    detObj = (DetObj)this.m_detList.elementAt(n);
                    if (detObj != null && detObj.isDetectable() && (identObj2 = detObj.getIdentID()).getSeriesID() == identObj.getSeriesID()) {
                        return detObj;
                    }
                    --n;
                }
                break block9;
            }
            if (!identObj.isExceptional()) break block9;
            n = this.m_detList.size() - 1;
            while (n >= 0) {
                detObj = (DetObj)this.m_detList.elementAt(n);
                if (detObj != null && detObj.isDetectable() && (identObj2 = detObj.getIdentID()).isExceptional() && identObj2.getSeriesID() == identObj.getSeriesID() && identObj2.getGroupID() == identObj.getGroupID()) {
                    return detObj;
                }
                --n;
            }
        }
        return null;
    }

    public IdentObj getExceptionalID(IdentObj identObj) {
        if (identObj == null) {
            return null;
        }
        int n = identObj.getSeriesID();
        int n2 = identObj.getGroupID();
        IdentObj identObj2 = this.m_Perspective.getExceptionalRiser(n, n2);
        return identObj2;
    }

    public Enumeration getList() {
        return this.m_detList.elements();
    }

    public Vector getVectorList() {
        return this.m_detList;
    }

    public Perspective getPerspective() {
        return this.m_Perspective;
    }

    public boolean isExceptional(IdentObj identObj) {
        IdentObj identObj2 = this.getExceptionalID(identObj);
        return identObj2 != null;
    }

    public boolean isExceptionalAllowed() {
        return this.m_Perspective.isExceptionalAllowed();
    }

    public void insertDetNode(DetObj detObj) {
        this.m_detList.addElement(detObj);
    }

    public void removeDetNode(DetObj detObj) {
        this.m_detList.removeElement(detObj);
    }

    public void paint(Graphics graphics, VC vC) {
        int n = 0;
        while (n < this.m_detList.size()) {
            DetObj detObj = (DetObj)this.m_detList.elementAt(n);
            detObj.paint(graphics, vC);
            ++n;
        }
    }

    private void releaseDetListReferences() {
        int n = this.m_detList.size() - 1;
        while (n >= 0) {
            BlackBoxIF blackBoxIF;
            DetObj detObj = (DetObj)this.m_detList.elementAt(n);
            if (detObj != null && (blackBoxIF = detObj.getBlackBox()) != null) {
                blackBoxIF.releaseReferences();
            }
            --n;
        }
    }

    public void releaseReferences() {
        this.releaseDetListReferences();
        this.m_Perspective = null;
    }

    public void resetList() {
        this.releaseDetListReferences();
        this.m_detList = new Vector(4096);
    }

    public void setDefaultClipRect(Rectangle rectangle) {
        this.m_defaultClipRect = rectangle;
    }

    public void setExceptionalFlag(boolean bl) {
        this.m_bExceptionalFlag = bl;
    }
}

