/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;

public class DetRect
extends DetObj {
    public static final float SLOP_FACTOR = 1.05f;
    public static final int PAINT_SHAPE = 0;
    public static final int LINE_AT_TOP = 1;
    public static final int LINE_AT_BOTTOM = 2;
    public static final int LINE_AT_LEFT = 3;
    public static final int LINE_AT_RIGHT = 4;
    public static final int PERFECT_SQUARE = 5;
    Rectangle m_rBounds;
    Rectangle m_rLooseBounds;
    Rectangle m_rDestBounds;
    boolean m_bLooseBounds;
    boolean m_bDotted;
    int m_draw = 0;

    public DetRect(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, boolean bl) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, false, true, false);
        this.m_bDotted = bl;
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, boolean bl, boolean bl2) {
        this(detectiv, identObj, n, n2, n3, n4, blackBoxIF, null, bl, bl2, false);
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, int n, int n2, BlackBoxIF blackBoxIF, Rectangle rectangle) {
        this(detectiv, identObj, 0, 0, n, n2, blackBoxIF, rectangle, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, Rectangle rectangle2) {
        this(detectiv, identObj, rectangle.x, rectangle.y, rectangle.width, rectangle.height, blackBoxIF, rectangle2, false, true, false);
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, Rectangle rectangle2, int n) {
        this(detectiv, identObj, rectangle.x, rectangle.y, rectangle.width, rectangle.height, blackBoxIF, rectangle2, false, true, false);
        this.m_draw = n;
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, Rectangle rectangle, BlackBoxIF blackBoxIF, boolean bl) {
        super(detectiv, identObj, blackBoxIF, null, false, true, bl);
        this.m_draw = 5;
        this.m_rDestBounds = rectangle;
    }

    public DetRect(Detectiv detectiv, IdentObj identObj, int n, int n2, int n3, int n4, BlackBoxIF blackBoxIF, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        super(detectiv, identObj, blackBoxIF, rectangle, bl, bl2);
        this.m_bLooseBounds = bl3;
        this.m_rBounds = new Rectangle(n, n2, n3, n4);
        if (bl3) {
            this.m_rLooseBounds = new Rectangle(n, n2, n3, n4);
            this.setBounds(n, n2, n3, n4);
        } else {
            this.m_rLooseBounds = this.m_rBounds;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof DetRect)) {
            return false;
        }
        DetRect detRect = (DetRect)object;
        return this.m_id.equals(detRect.m_id);
    }

    public Rectangle getBounds() {
        if (this.m_draw == 5) {
            Rectangle rectangle = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return new Rectangle(this.m_rBounds.x, this.m_rBounds.y, this.m_rBounds.width, this.m_rBounds.height);
    }

    public Rectangle getLooseBounds() {
        if (this.m_draw == 5) {
            Rectangle rectangle = this.m_Detectiv.getPerspective().getVC().destToVirt(this.m_rDestBounds);
            return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return new Rectangle(this.m_rLooseBounds.x, this.m_rLooseBounds.y, this.m_rLooseBounds.width, this.m_rLooseBounds.height);
    }

    public void hilite(Graphics graphics, VC vC) {
        if (this.m_draw == 0 || this.m_draw == 5) {
            Rectangle rectangle = null;
            rectangle = this.m_draw == 5 ? this.m_rDestBounds : vC.virtToDest(this.m_rBounds);
            graphics.setXORMode(Color.yellow);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
        } else {
            Rectangle rectangle = vC.virtToDest(this.m_rBounds);
            graphics.setXORMode(Color.yellow);
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            if (this.m_draw == 2) {
                n = rectangle.x;
                n3 = rectangle.y + rectangle.height;
                n2 = rectangle.x + rectangle.width;
                n4 = n3;
            } else if (this.m_draw == 1) {
                n = rectangle.x;
                n3 = rectangle.y;
                n2 = n + rectangle.width;
                n4 = n3;
            } else if (this.m_draw == 3) {
                n = rectangle.x;
                n3 = rectangle.y;
                n2 = rectangle.x;
                n4 = rectangle.y + rectangle.height;
            } else if (this.m_draw == 4) {
                n = rectangle.x + rectangle.width;
                n3 = rectangle.y;
                n2 = n;
                n4 = rectangle.y + rectangle.height;
            }
            graphics.drawLine(n, n3, n2, n4);
            graphics.setPaintMode();
        }
    }

    public boolean isPointInObj(int n, int n2, VC vC) {
        if (this.m_draw == 5) {
            return this.m_bDetectable && this.m_rDestBounds.contains(vC.virtToDestX(n), vC.virtToDestY(n2));
        }
        return this.m_bDetectable && this.m_rLooseBounds.contains(n, n2);
    }

    public boolean isPointInObj(Point point, VC vC) {
        return this.isPointInObj(point.x, point.y, vC);
    }

    public void paintIt(Graphics graphics, VC vC) {
        if (this.m_draw != 0 && this.m_draw != 5) {
            this.m_blackBox.paint(graphics, vC.virtToDest(this.m_rBounds), this.m_draw);
            return;
        }
        if (this.m_clipRect != null) {
            Rectangle rectangle = vC.virtToDest(this.m_clipRect);
            Shape shape = graphics.getClip();
            if (shape == null) {
                graphics.setClip(rectangle);
            }
            if (this.m_bDotted) {
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_rBounds), false, true);
            } else {
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_rBounds));
            }
            graphics.setClip(shape);
        } else {
            if (this.m_draw == 5) {
                this.m_blackBox.paint(graphics, this.m_rDestBounds);
                return;
            }
            if (this.m_bDotted) {
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_rBounds), false, true, true);
            } else {
                this.m_blackBox.paint(graphics, vC.virtToDest(this.m_rBounds));
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.m_rBounds.x = n;
        this.m_rBounds.y = n2;
        this.m_rBounds.width = n3;
        this.m_rBounds.height = n4;
        if (this.m_bLooseBounds) {
            float f = (float)n + (float)n3 / 2.0f;
            float f2 = (float)n2 + (float)n4 / 2.0f;
            float f3 = (float)n3 * 1.05f;
            float f4 = (float)n4 * 1.05f;
            this.m_rLooseBounds.x = (int)((double)f - (double)f3 / 2.0);
            this.m_rLooseBounds.y = (int)((double)f2 - (double)f4 / 2.0);
            this.m_rLooseBounds.width = (int)f3;
            this.m_rLooseBounds.height = (int)f4;
        }
    }

    public Polygon getShape(VC vC) {
        if (this.m_rDestBounds != null) {
            return this.rectToPoly(vC.destToVirt(this.m_rDestBounds));
        }
        return this.rectToPoly(this.m_rBounds);
    }
}

