/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Locale;
import oracle.bali.ewt.util.LocaleUtils;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class DetLabel
extends DetObj {
    private Rectangle m_rBounds;
    private Rectangle m_rInnerBoundsDC;
    private Dimension m_dim;
    private TextStyleObj m_TextStyle;
    private String m_szText;
    private String m_fullText;

    public DetLabel(Detectiv detectiv, IdentObj identObj, String string, Rectangle rectangle, TextStyleObj textStyleObj, BlackBoxIF blackBoxIF) {
        this(detectiv, identObj, string, rectangle, textStyleObj, blackBoxIF, false, true);
    }

    public DetLabel(Detectiv detectiv, IdentObj identObj, String string, Rectangle rectangle, TextStyleObj textStyleObj, BlackBoxIF blackBoxIF, boolean bl) {
        this(detectiv, identObj, string, rectangle, textStyleObj, blackBoxIF, bl, true);
    }

    public DetLabel(Detectiv detectiv, IdentObj identObj, String string, String string2, Rectangle rectangle, TextStyleObj textStyleObj, BlackBoxIF blackBoxIF, boolean bl) {
        this(detectiv, identObj, string, rectangle, textStyleObj, blackBoxIF, bl, true);
        this.m_fullText = string2;
    }

    public DetLabel(Detectiv detectiv, IdentObj identObj, String string, Rectangle rectangle, TextStyleObj textStyleObj, BlackBoxIF blackBoxIF, boolean bl, Rectangle rectangle2) {
        super(detectiv, identObj, blackBoxIF, rectangle2, bl, true, true);
        this.m_rBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.m_TextStyle = new TextStyleObj(textStyleObj);
        this.m_szText = string;
    }

    public DetLabel(Detectiv detectiv, IdentObj identObj, String string, Rectangle rectangle, TextStyleObj textStyleObj, BlackBoxIF blackBoxIF, boolean bl, boolean bl2) {
        super(detectiv, identObj, blackBoxIF, null, bl, bl2, true);
        this.m_rBounds = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.m_TextStyle = new TextStyleObj(textStyleObj);
        this.m_szText = string;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DetLabel)) {
            return false;
        }
        DetLabel detLabel = (DetLabel)object;
        return this.m_id.equals(detLabel.m_id);
    }

    public Rectangle getBounds() {
        return this.m_rBounds;
    }

    public String getLabelString() {
        return this.m_szText;
    }

    public String getFullText() {
        return this.m_fullText;
    }

    public void hilite(Graphics graphics, VC vC) {
        if (this.m_rInnerBoundsDC != null) {
            graphics.setXORMode(Color.yellow);
            graphics.drawRect(this.m_rInnerBoundsDC.x, this.m_rInnerBoundsDC.y, this.m_rInnerBoundsDC.width, this.m_rInnerBoundsDC.height);
            graphics.setPaintMode();
        }
    }

    public boolean isPointInObj(int n, int n2, VC vC) {
        if (this.m_rInnerBoundsDC != null) {
            return this.m_bDetectable && this.m_rInnerBoundsDC.contains(vC.virtToDestX(n), vC.virtToDestY(n2));
        }
        return false;
    }

    public boolean isPointInObj(Point point, VC vC) {
        return this.isPointInObj(point.x, point.y, vC);
    }

    public void paintIt(Graphics graphics, VC vC) {
        if (this.m_szText.length() > 0) {
            Rectangle rectangle = vC.virtToDest(this.m_rBounds);
            this.m_dim = this.m_TextStyle.preDraw(graphics, this.m_szText, rectangle, vC, null);
            this.m_rInnerBoundsDC = new Rectangle();
            Perspective perspective = this.m_Detectiv.getPerspective();
            int n = this.m_TextStyle.getHorizAlign();
            if (n == 3) {
                n = LocaleUtils.getReadingDirectionForLocale((Locale)perspective.getLocale());
                if (n == 1) {
                    n = 0;
                }
                if (n == 2) {
                    n = 2;
                }
            }
            if (this.m_TextStyle.getRotationAngle() == 0) {
                if (this.m_dim.width <= rectangle.width && this.m_dim.height <= rectangle.height) {
                    this.m_rInnerBoundsDC.width = this.m_dim.width;
                    this.m_rInnerBoundsDC.height = this.m_dim.height;
                    switch (n) {
                        case 1: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.width) / 2;
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.width);
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.x = rectangle.x;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 1: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.height) / 2;
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.y = rectangle.y;
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.height);
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rectangle;
                }
            } else if (this.m_TextStyle.getRotationAngle() == 2) {
                if (this.m_dim.width <= rectangle.height && this.m_dim.height <= rectangle.width) {
                    this.m_rInnerBoundsDC.width = this.m_dim.height;
                    this.m_rInnerBoundsDC.height = this.m_dim.width;
                    switch (n) {
                        case 1: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.width) / 2;
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.width);
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.y = rectangle.y;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 1: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.height) / 2;
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.height);
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.x = rectangle.x;
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rectangle;
                }
            } else if (this.m_TextStyle.getRotationAngle() == 1) {
                if (this.m_dim.width <= rectangle.height && this.m_dim.height <= rectangle.width) {
                    this.m_rInnerBoundsDC.width = this.m_dim.height;
                    this.m_rInnerBoundsDC.height = this.m_dim.width;
                    switch (n) {
                        case 1: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.width) / 2;
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.y = rectangle.y + (rectangle.height - this.m_dim.width);
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.y = rectangle.y;
                        }
                    }
                    switch (this.m_TextStyle.getVertAlign()) {
                        case 1: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.height) / 2;
                            break;
                        }
                        case 0: {
                            this.m_rInnerBoundsDC.x = rectangle.x;
                            break;
                        }
                        case 2: {
                            this.m_rInnerBoundsDC.x = rectangle.x + (rectangle.width - this.m_dim.height);
                        }
                    }
                } else {
                    this.m_rInnerBoundsDC = rectangle;
                }
            }
            this.m_blackBox.paint(graphics, this.m_szText, rectangle, this.m_rInnerBoundsDC, this.m_TextStyle, vC);
        }
    }

    public void setBounds(Rectangle rectangle) {
        this.m_rBounds = rectangle;
    }

    public Polygon getShape(VC vC) {
        return this.rectToPoly(this.m_rBounds);
    }
}

