/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BorderObj;
import oracle.dss.graph.pfj.draw.ColorObj;
import oracle.dss.graph.pfj.draw.FillColorObj;
import oracle.dss.graph.pfj.draw.FillGradientObj;
import oracle.dss.graph.pfj.draw.FillObj;
import oracle.dss.graph.pfj.draw.FillTextureObj;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class BlackBoxObj
implements Serializable,
BlackBoxIF {
    static final String CLASS_TEXTURE = "oracle.dss.graph.pfj.draw.FillTextureObj";
    static final String CLASS_GRADIENT = "oracle.dss.graph.pfj.draw.FillGradientObj";
    static final String CLASS_COLOR = "oracle.dss.graph.pfj.draw.FillColorObj";
    static final int SCALE_FACTOR = 50;
    private Perspective m_Perspective;
    public IdentObj m_id;
    private FillObj m_FillObj;
    private BorderObj m_BorderObj;
    private Color m_DropShadowColor;
    private Dimension m_DropShadowOffset;
    private boolean m_bTransparentBorderColor;
    private boolean m_bTransparentFillColor;
    Color m_ChartBackgroundColor;

    private BlackBoxObj() {
        this.m_BorderObj = new BorderObj(Color.black);
        this.m_FillObj = new FillColorObj(Color.white);
        this.m_DropShadowColor = Color.black;
        this.m_DropShadowOffset = null;
    }

    public BlackBoxObj(BlackBoxObj blackBoxObj) {
        this();
        this.copy(blackBoxObj);
    }

    public BlackBoxObj(Perspective perspective, IdentObj identObj) {
        this.m_Perspective = perspective;
        this.m_id = identObj;
        this.m_BorderObj = new BorderObj(perspective.getBorderColor(identObj));
        switch (perspective.getFillType(identObj)) {
            case 1: {
                this.m_FillObj = new FillColorObj(perspective.getFillColor(identObj));
                break;
            }
            case 2: {
                FillGradientObj fillGradientObj = new FillGradientObj(perspective, perspective.getGradientDirection(identObj));
                int n = perspective.getGradientNumPins(identObj);
                int n2 = 0;
                while (n2 < n) {
                    fillGradientObj.insertPin(perspective.getGradientPinPosition(identObj, n2), new ColorObj(perspective.getGradientPinLeftColor(identObj, n2)), new ColorObj(perspective.getGradientPinRightColor(identObj, n2)));
                    ++n2;
                }
                this.m_FillObj = fillGradientObj;
                break;
            }
            case 3: {
                String string = perspective.getTexture(identObj);
                Image image = perspective.getTexture(string);
                if (image != null) {
                    int n = perspective.getTextureDisplayMode(identObj);
                    int n3 = perspective.getTextureFlipMode(identObj);
                    this.m_FillObj = new FillTextureObj(perspective, image, n, n3, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(perspective.getFillColor(identObj));
                perspective.setFillType(identObj, 1);
            }
        }
        this.m_bTransparentBorderColor = this.m_Perspective.getTransparentBorderColor(identObj);
        this.m_bTransparentFillColor = this.m_Perspective.getTransparentFillColor(identObj);
        this.m_ChartBackgroundColor = perspective.getFillColor(perspective.getChartBackground());
        this.m_DropShadowColor = perspective.getShadowColor(identObj);
        this.m_DropShadowOffset = perspective.getShadowDisplay(identObj) && !this.m_bTransparentFillColor ? new Dimension(perspective.getVC().virtToDestWidth(perspective.getShadowXOffset(identObj) * 50), perspective.getVC().virtToDestHeight(perspective.getShadowYOffset(identObj) * 50)) : null;
    }

    public void copy(BlackBoxObj blackBoxObj) {
        String string = blackBoxObj.m_FillObj.getClass().getName();
        if (string.equals(CLASS_GRADIENT)) {
            this.m_FillObj = new FillGradientObj();
        } else if (string.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        } else if (string.equals(CLASS_TEXTURE)) {
            this.m_FillObj = new FillTextureObj();
        }
        this.m_FillObj.copy(blackBoxObj.m_FillObj);
        this.m_BorderObj.copy(blackBoxObj.m_BorderObj);
        this.m_Perspective = blackBoxObj.m_Perspective;
        this.m_DropShadowColor = blackBoxObj.m_DropShadowColor;
        this.m_DropShadowOffset = blackBoxObj.m_DropShadowOffset;
        this.m_id = blackBoxObj.m_id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlackBoxObj)) {
            return false;
        }
        BlackBoxObj blackBoxObj = (BlackBoxObj)object;
        boolean bl = this.m_FillObj.equals(blackBoxObj.m_FillObj);
        return bl;
    }

    public Color getBorderColor() {
        return this.m_BorderObj.getColor();
    }

    public Color getFillColor() {
        String string = this.m_FillObj.getClass().getName();
        if (string.equals(CLASS_COLOR)) {
            return ((FillColorObj)this.m_FillObj).getColor();
        }
        return Color.white;
    }

    public int getFillType() {
        String string = this.m_FillObj.getClass().getName();
        if (string.equals(CLASS_COLOR)) {
            return 1;
        }
        if (string.equals(CLASS_GRADIENT)) {
            return 2;
        }
        return 3;
    }

    public void setFillType(int n) {
        switch (n) {
            case 1: {
                this.m_FillObj = new FillColorObj(this.m_Perspective.getFillColor(this.m_id));
                break;
            }
            case 2: {
                FillGradientObj fillGradientObj = new FillGradientObj(this.m_Perspective, this.m_Perspective.getGradientDirection(this.m_id));
                int n2 = this.m_Perspective.getGradientNumPins(this.m_id);
                int n3 = 0;
                while (n3 < n2) {
                    fillGradientObj.insertPin(this.m_Perspective.getGradientPinPosition(this.m_id, n3), new ColorObj(this.m_Perspective.getGradientPinLeftColor(this.m_id, n3)), new ColorObj(this.m_Perspective.getGradientPinRightColor(this.m_id, n3)));
                    ++n3;
                }
                this.m_FillObj = fillGradientObj;
                break;
            }
            case 3: {
                String string = this.m_Perspective.getTexture(this.m_id);
                Image image = this.m_Perspective.getTexture(string);
                if (image != null) {
                    int n4 = this.m_Perspective.getTextureDisplayMode(this.m_id);
                    int n5 = this.m_Perspective.getTextureFlipMode(this.m_id);
                    this.m_FillObj = new FillTextureObj(this.m_Perspective, image, n4, n5, 0);
                    break;
                }
                this.m_FillObj = new FillColorObj(this.m_Perspective.getFillColor(this.m_id));
                this.m_Perspective.setFillType(this.m_id, 1);
            }
        }
    }

    public boolean getTransparentBorderColor() {
        return this.m_bTransparentBorderColor;
    }

    public boolean getTransparentFillColor() {
        return this.m_bTransparentFillColor;
    }

    public void setTransparentFillColor(boolean bl) {
        this.m_bTransparentFillColor = bl;
    }

    public void setTransparentBorderColor(boolean bl) {
        this.m_bTransparentBorderColor = bl;
    }

    public void paint(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n == 2) {
            n2 = rectangle.x;
            n4 = rectangle.y + rectangle.height;
            n3 = rectangle.x + rectangle.width;
            n5 = n4;
        } else if (n == 1) {
            n2 = rectangle.x;
            n4 = rectangle.y;
            n3 = n2 + rectangle.width;
            n5 = n4;
        } else if (n == 3) {
            n2 = rectangle.x;
            n4 = rectangle.y;
            n3 = rectangle.x;
            n5 = rectangle.y + rectangle.height;
        } else if (n == 4) {
            n2 = rectangle.x + rectangle.width;
            n4 = rectangle.y;
            n3 = n2;
            n5 = rectangle.y + rectangle.height;
        }
        if (!this.m_bTransparentFillColor) {
            graphics.setColor(this.m_FillObj.getColor());
            graphics.drawLine(n2, n4, n3, n5);
        }
        if (!this.m_bTransparentBorderColor) {
            graphics.setColor(this.m_BorderObj.getColor());
            graphics.drawLine(n2, n4, n3, n5);
        }
    }

    public void paint(Graphics graphics, Point point, Point point2) {
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, point, point2);
        }
    }

    public void paint(Graphics graphics, Polygon polygon) {
        if (this.m_DropShadowOffset != null) {
            Polygon polygon2 = new Polygon();
            int n = 0;
            while (n < polygon.npoints) {
                polygon2.addPoint(polygon.xpoints[n] + this.m_DropShadowOffset.width, polygon.ypoints[n] + this.m_DropShadowOffset.height);
                ++n;
            }
            graphics.setColor(this.m_DropShadowColor);
            graphics.fillPolygon(polygon2);
        }
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(graphics, (Component)this.m_Perspective, polygon);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, this.m_Perspective, polygon);
        }
    }

    public void paint(Graphics graphics, GeneralPath generalPath) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(graphics, (Component)this.m_Perspective, generalPath);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, this.m_Perspective, generalPath);
        }
    }

    public void paint(Graphics graphics, Area area) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(graphics, (Component)this.m_Perspective, area);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, this.m_Perspective, area);
        }
    }

    public void paint(Graphics graphics, Arc2D arc2D) {
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(graphics, (Component)this.m_Perspective, arc2D);
        }
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, this.m_Perspective, arc2D);
        }
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        this.paint(graphics, rectangle, false, false);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2) {
        this.paint(graphics, rectangle, bl, bl2, false);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, boolean bl3) {
        Rectangle rectangle2;
        if (this.m_DropShadowOffset != null) {
            rectangle2 = new Rectangle(rectangle.x + this.m_DropShadowOffset.width, rectangle.y + this.m_DropShadowOffset.height, rectangle.width, rectangle.height);
            graphics.setColor(this.m_DropShadowColor);
            if (bl) {
                graphics.fillOval(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            } else {
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        if (bl) {
            if (!this.m_bTransparentFillColor && !bl2) {
                this.m_FillObj.fillOval(graphics, this.m_Perspective, rectangle);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paintOval(graphics, rectangle);
            }
        } else {
            if (!this.m_bTransparentFillColor && !bl2) {
                this.m_FillObj.fillRect(graphics, this.m_Perspective, rectangle);
            }
            if (!this.m_bTransparentBorderColor) {
                rectangle2 = new Rectangle(rectangle);
                if (bl3) {
                    this.m_BorderObj.paint(graphics, rectangle2, bl3);
                } else {
                    this.m_BorderObj.paint(graphics, rectangle2);
                }
            }
        }
    }

    public void paint(Graphics graphics, String string, Rectangle rectangle, Rectangle rectangle2, TextStyleObj textStyleObj, VC vC) {
        if (!this.m_bTransparentFillColor) {
            int n = this.m_Perspective.getFillType(this.m_Perspective.getChartBackground());
            boolean bl = this.m_Perspective.getPrintingInProgress();
            this.m_FillObj.fillText(graphics, this.m_Perspective, string, rectangle, rectangle2, this.m_DropShadowColor, this.m_DropShadowOffset, textStyleObj, vC, this.m_ChartBackgroundColor, n, bl);
        }
    }

    public void paint(Graphics graphics, Point point, Point point2, int n) {
        double d = point2.x - point.x;
        double d2 = point2.y - point.y;
        double d3 = 1.57;
        double d4 = Math.atan2(d2, d);
        double d5 = 4.71;
        double d6 = (double)n * Math.cos(d4 + d3);
        double d7 = (double)n * Math.sin(d4 + d3);
        double d8 = (double)(n / 2) * Math.sin(d4 + d5);
        double d9 = (double)(n / 2) * Math.cos(d4 + d5);
        Polygon polygon = new Polygon();
        polygon.addPoint(point2.x + (int)Math.round(d9), point2.y + (int)Math.round(d8));
        polygon.addPoint(point2.x + (int)Math.round(d6) + (int)Math.round(d9), point2.y + (int)Math.round(d7) + (int)Math.round(d8));
        polygon.addPoint(point.x + (int)Math.round(d6) + (int)Math.round(d9), point.y + (int)Math.round(d7) + (int)Math.round(d8));
        polygon.addPoint(point.x + (int)Math.round(d9), point.y + (int)Math.round(d8));
        polygon.addPoint(point2.x + (int)Math.round(d9), point2.y + (int)Math.round(d8));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(new BasicStroke(1.0f, 1, 1));
        graphics2D.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
        if (!this.m_bTransparentFillColor) {
            this.m_FillObj.fillPolygon(graphics, (Component)this.m_Perspective, polygon);
        }
        this.m_FillObj.fillOval(graphics, this.m_Perspective, point.x - n / 2, point.y - n / 2, n, n);
        this.m_FillObj.fillOval(graphics, this.m_Perspective, point2.x - n / 2, point2.y - n / 2, n, n);
        if (!this.m_bTransparentBorderColor) {
            this.m_BorderObj.paint(graphics, polygon);
        }
    }

    public void paint(Graphics graphics, Point point, Point point2, int n, int n2, boolean bl) {
        if (graphics instanceof Graphics2D) {
            Stroke stroke = ((Graphics2D)graphics).getStroke();
            BasicStroke basicStroke = new BasicStroke(n, 0, 0);
            float f = 10.0f;
            if (n2 != Perspective.SOLID) {
                if (n2 == Perspective.DASH) {
                    float[] fArray;
                    if (bl) {
                        fArray = new float[]{4.0f, 2.0f, 4.0f};
                        f = 2.0f;
                        n = 2;
                    } else {
                        fArray = new float[]{f, f / (float)2};
                    }
                    basicStroke = new BasicStroke(n, 0, 0, f, fArray, 0.0f);
                } else if (n2 == Perspective.DOTTED) {
                    if (bl) {
                        n = 2;
                    }
                    if (n <= 1) {
                        n = 2;
                    }
                    float[] fArray = new float[]{n};
                    basicStroke = new BasicStroke(n, 0, 0, 1.0f, fArray, 0.0f);
                } else if (n2 == Perspective.DASH_DOT) {
                    float[] fArray;
                    if (bl) {
                        fArray = new float[]{3.0f, 1.0f, 2.0f, 1.0f, 3.0f};
                        n = 2;
                    } else {
                        fArray = new float[]{f, f / (float)2, n, f / (float)2};
                    }
                    basicStroke = new BasicStroke(n, 0, 0, 1.0f, fArray, 0.0f);
                }
            }
            ((Graphics2D)graphics).setStroke(basicStroke);
            if (!this.m_bTransparentFillColor) {
                graphics.setColor(this.getFillColor());
                graphics.drawLine(point.x, point.y, point2.x, point2.y);
            }
            if (!this.m_bTransparentBorderColor) {
                this.m_BorderObj.paint(graphics, point, point2);
            }
            ((Graphics2D)graphics).setStroke(stroke);
        } else {
            this.paint(graphics, point, point2, n);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public void setBorderColor(Color color) {
        this.m_BorderObj.setColor(color);
    }

    public void setFillColor(int n, int n2, int n3, int n4) {
        String string = this.m_FillObj.getClass().getName();
        if (!string.equals(CLASS_COLOR)) {
            this.m_FillObj = new FillColorObj();
        }
        ((FillColorObj)this.m_FillObj).setColor(n, n2, n3, n4);
    }

    public void setFillColor(Color color) {
        this.setFillColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public Color getGradientColorAt(double d) {
        String string = this.m_FillObj.getClass().getName();
        if (string.equals(CLASS_GRADIENT)) {
            return ((FillGradientObj)this.m_FillObj).getColorAt(d);
        }
        return new Color(0, 0, 0);
    }

    public void paint(Graphics graphics, Rectangle rectangle, boolean bl, boolean bl2, int n) {
        if (bl) {
            if (!this.m_bTransparentFillColor && !bl2) {
                this.m_FillObj.fillOval(graphics, this.m_Perspective, rectangle);
            }
            if (!this.m_bTransparentBorderColor) {
                Rectangle rectangle2 = new Rectangle(rectangle);
                if (n == 0) {
                    this.m_BorderObj.paintOval(graphics, rectangle2);
                } else {
                    int n2 = 0;
                    while (n2 < n) {
                        rectangle2.grow(1, 1);
                        this.m_BorderObj.paintOval(graphics, rectangle2);
                        ++n2;
                    }
                }
            }
        }
    }
}

