/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.Serializable;

public final class VC
implements Serializable {
    public static final int DEFAULT_VX = 16000;
    public static final int DEFAULT_VY = 16000;
    private double m_dvWidth;
    private double m_dvHeight;
    private double m_vdWidth;
    private double m_vdHeight;
    private double m_dvOffX;
    private double m_dvOffY;
    private double m_vdOffX;
    private double m_vdOffY;
    private int m_destWidth;
    private int m_destHeight;
    private int m_virtWidth;
    private int m_virtHeight;

    public VC(double d, double d2) {
        this(d, d2, 32000.0, 32000.0);
    }

    public VC(double d, double d2, double d3, double d4) {
        this.m_dvWidth = d3 / d;
        this.m_dvHeight = d4 / d2;
        this.m_vdWidth = d / d3;
        this.m_vdHeight = d2 / d4;
        this.m_dvOffX = -d3 / (double)2;
        this.m_dvOffY = d4 / (double)2;
        this.m_vdOffX = d / (double)2;
        this.m_vdOffY = d2 / (double)2;
        this.m_virtWidth = (int)d3;
        this.m_virtHeight = (int)d4;
        this.m_destWidth = (int)d;
        this.m_destHeight = (int)d2;
    }

    public VC(VC vC) {
        this(vC.m_destWidth, vC.m_destHeight, vC.m_virtWidth, vC.m_virtHeight);
    }

    public Point destToVirt(int n, int n2) {
        return this.destToVirt(new Point(n, n2));
    }

    public Dimension destToVirt(Dimension dimension) {
        return new Dimension((int)Math.round((double)dimension.width * this.m_dvWidth), (int)Math.round((double)dimension.height * this.m_dvHeight));
    }

    public Point destToVirt(Point point) {
        double d = this.dvX(point.x);
        double d2 = this.dvY(point.y);
        Point point2 = new Point((int)Math.round(d), (int)Math.round(d2));
        return point2;
    }

    public Polygon destToVirt(Polygon polygon) {
        Polygon polygon2 = new Polygon();
        int n = 0;
        while (n < polygon.npoints) {
            double d = this.dvX(polygon.xpoints[n]);
            double d2 = this.dvY(polygon.ypoints[n]);
            polygon2.addPoint((int)Math.round(d), (int)Math.round(d2));
            ++n;
        }
        return polygon2;
    }

    public Rectangle destToVirt(Rectangle rectangle) {
        double d = this.dvX(rectangle.x);
        double d2 = this.dvY(rectangle.y + rectangle.height);
        double d3 = (double)rectangle.width * this.m_dvWidth;
        double d4 = (double)rectangle.height * this.m_dvHeight;
        Rectangle rectangle2 = new Rectangle((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
        return rectangle2;
    }

    public int destToVirtHeight(int n) {
        return (int)Math.round((double)n * this.m_dvHeight);
    }

    public int destToVirtWidth(int n) {
        return (int)Math.round((double)n * this.m_dvWidth);
    }

    public int destToVirtX(int n) {
        return (int)Math.round(this.dvX(n));
    }

    public int destToVirtY(int n) {
        return (int)Math.round(this.dvY(n));
    }

    private double dvX(double d) {
        double d2 = d * this.m_dvWidth + this.m_dvOffX;
        return d2;
    }

    private double dvY(double d) {
        double d2 = d * -this.m_dvHeight + this.m_dvOffY;
        return d2;
    }

    public Rectangle getDestCoords() {
        return new Rectangle(0, 0, this.m_destWidth, this.m_destHeight);
    }

    public Rectangle getVirtCoords() {
        return new Rectangle(-this.m_virtWidth / 2, -this.m_virtHeight / 2, this.m_virtWidth, this.m_virtHeight);
    }

    public Dimension getVirtDimension() {
        return new Dimension(this.m_virtWidth, this.m_virtHeight);
    }

    private double vdX(double d) {
        double d2 = d * this.m_vdWidth + this.m_vdOffX;
        return d2;
    }

    private double vdY(double d) {
        double d2 = d * -this.m_vdHeight + this.m_vdOffY;
        return d2;
    }

    public Point virtToDest(int n, int n2) {
        return this.virtToDest(new Point(n, n2));
    }

    public Dimension virtToDest(Dimension dimension) {
        return new Dimension((int)Math.round((double)dimension.width * this.m_vdWidth), (int)Math.round((double)dimension.height * this.m_vdHeight));
    }

    public Point virtToDest(Point point) {
        double d = this.vdX(point.x);
        double d2 = this.vdY(point.y);
        Point point2 = new Point((int)Math.round(d), (int)Math.round(d2));
        return point2;
    }

    public Polygon virtToDest(Polygon polygon) {
        Polygon polygon2 = new Polygon();
        int n = 0;
        while (n < polygon.npoints) {
            double d = this.vdX(polygon.xpoints[n]);
            double d2 = this.vdY(polygon.ypoints[n]);
            polygon2.addPoint((int)Math.round(d), (int)Math.round(d2));
            ++n;
        }
        return polygon2;
    }

    public GeneralPath virtToDestPath(Polygon polygon) {
        GeneralPath generalPath = new GeneralPath();
        int n = 0;
        while (n < polygon.npoints) {
            float f = (float)this.vdX(polygon.xpoints[n]);
            float f2 = (float)this.vdY(polygon.ypoints[n]);
            if (n == 0) {
                generalPath.moveTo(f, f2);
            }
            generalPath.lineTo(f, f2);
            ++n;
        }
        return generalPath;
    }

    public Rectangle virtToDest(Rectangle rectangle) {
        double d = this.vdY(rectangle.y + rectangle.height);
        double d2 = this.vdY(rectangle.y);
        int n = (int)Math.round(d);
        int n2 = (int)Math.round(d2);
        int n3 = n2 - n;
        double d3 = this.vdX(rectangle.x);
        double d4 = this.vdX(rectangle.x + rectangle.width);
        int n4 = (int)Math.round(d3);
        int n5 = (int)Math.round(d4);
        int n6 = n5 - n4;
        Rectangle rectangle2 = new Rectangle(n4, n, n6, n3);
        return rectangle2;
    }

    public Rectangle virtToDestConstLength(Rectangle rectangle) {
        int n = (int)Math.round(this.vdY(rectangle.y + rectangle.height));
        int n2 = Math.round(this.virtToDestHeight(rectangle.height));
        int n3 = (int)Math.round(this.vdX(rectangle.x));
        int n4 = Math.round(this.virtToDestWidth(rectangle.width));
        Rectangle rectangle2 = new Rectangle(n3, n, n4, n2);
        return rectangle2;
    }

    public double virtToDestHeight(double d) {
        return d * this.m_vdHeight;
    }

    public int virtToDestHeight(int n) {
        return (int)Math.round((double)n * this.m_vdHeight);
    }

    public double virtToDestWidth(double d) {
        return d * this.m_vdWidth;
    }

    public int virtToDestWidth(int n) {
        return (int)Math.round((double)n * this.m_vdWidth);
    }

    public int virtToDestX(int n) {
        return (int)Math.round(this.vdX(n));
    }

    public int virtToDestY(int n) {
        return (int)Math.round(this.vdY(n));
    }

    public double destToVirtX(double d) {
        return this.dvX(d);
    }

    public double destToVirtY(double d) {
        return this.dvY(d);
    }

    public double virtToDestY(double d) {
        double d2 = d * -this.m_vdHeight + this.m_vdOffY;
        return d2;
    }
}

