/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.draw.DetObj;
import oracle.dss.graph.pfj.draw.IdentObj;

public class ScrollLegend
implements Serializable {
    protected Perspective m_Perspective;
    protected Point m_ptScrollRect;
    public Rectangle m_rOldScroll;

    public ScrollLegend(Perspective perspective) {
        this.m_Perspective = perspective;
    }

    public void mousePressedScroll(Point point) {
        this.m_ptScrollRect = point;
        this.m_rOldScroll = null;
    }

    public void drawScroller(Graphics graphics) {
        graphics.setXORMode(Color.yellow);
        if (this.m_rOldScroll != null) {
            graphics.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
        }
        graphics.setPaintMode();
    }

    public void mouseReleasedScroll(MouseEvent mouseEvent, int n, Graphics graphics) {
        if (n == 66) {
            Rectangle rectangle = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getLegendScroller()));
            this.drawScroller(graphics);
            if (this.m_rOldScroll != null) {
                int n2;
                boolean bl = this.m_Perspective.m_chart.m_Legend.isHorz();
                double d = bl ? (double)(this.m_rOldScroll.y - rectangle.y) / (double)(rectangle.height - this.m_rOldScroll.height) : (double)(this.m_rOldScroll.x - rectangle.x) / (double)(rectangle.width - this.m_rOldScroll.width);
                int n3 = (int)Math.round(d * (double)((n2 = this.m_Perspective.m_chart.m_Legend.getNumItemsInLegend()) - this.m_Perspective.getLegendSeriesCount()));
                if (n3 < 0) {
                    n3 = 0;
                }
                this.m_Perspective.setLegendSeriesStart(n3);
            }
            this.m_rOldScroll = null;
        }
    }

    public void mouseDraggedScroll(MouseEvent mouseEvent, IdentObj identObj, Graphics graphics) {
        int n;
        int n2 = n = identObj == null ? -3 : identObj.getObjectID();
        if (identObj.isLegendScrollerThumb()) {
            DetObj detObj = this.m_Perspective.m_selList.firstDetObjElement();
            PfjAssert.pfjAssert(detObj);
            Rectangle rectangle = this.m_Perspective.m_VC.virtToDest(detObj.getBounds());
            Rectangle rectangle2 = this.m_Perspective.m_VC.virtToDest(this.m_Perspective.getRect(this.m_Perspective.getLegendScroller()));
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            boolean bl = this.m_Perspective.m_chart.m_Legend.isHorz();
            if (bl) {
                int n3 = point.y - this.m_ptScrollRect.y;
                rectangle.y += n3;
                if (rectangle.y < rectangle2.y) {
                    rectangle.y = rectangle2.y;
                } else if (rectangle.y + rectangle.height > rectangle2.y + rectangle2.height) {
                    rectangle.y = rectangle2.y + rectangle2.height - rectangle.height;
                }
            } else {
                int n4 = point.x - this.m_ptScrollRect.x;
                rectangle.x += n4;
                if (rectangle.x < rectangle2.x) {
                    rectangle.x = rectangle2.x;
                } else if (rectangle.x + rectangle.width > rectangle2.x + rectangle2.width) {
                    rectangle.x = rectangle2.x + rectangle2.width - rectangle.width;
                }
            }
            graphics.setXORMode(Color.yellow);
            if (this.m_rOldScroll != null) {
                graphics.drawRect(this.m_rOldScroll.x, this.m_rOldScroll.y, this.m_rOldScroll.width, this.m_rOldScroll.height);
            }
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setPaintMode();
            this.m_rOldScroll = rectangle;
        }
    }

    public boolean keyEditOfVDR(int n) {
        boolean bl = false;
        switch (n) {
            case 37: 
            case 38: {
                this.decrementScrollOffset();
                bl = true;
                break;
            }
            case 39: 
            case 40: {
                this.incrementScrollOffset();
                bl = true;
            }
        }
        return bl;
    }

    private void decrementScrollOffset() {
        if (this.m_Perspective.getLegendSeriesStart() > 0) {
            int n = this.m_Perspective.getLegendSeriesStart() - 1;
            if (n < 0) {
                n = 0;
            }
            this.m_Perspective.setLegendSeriesStart(n);
        }
    }

    private void incrementScrollOffset() {
        int n;
        int n2;
        int n3 = this.m_Perspective.getLegendSeriesStart();
        if (n3 + (n2 = this.m_Perspective.getLegendSeriesCount()) < (n = this.m_Perspective.m_chart.m_Legend.getNumItemsInLegend())) {
            int n4 = n3 + 1;
            if (n4 < 0) {
                n4 = 0;
            }
            this.m_Perspective.setLegendSeriesStart(n4);
        }
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

