/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import oracle.dss.graph.pfj.RadixCompare;

public class RadixSort {
    private RadixCompare delegate;
    private Object[] userArray;
    private Object[] sourceArray;
    private Object[] targetArray;
    private int keyLength;
    private int[] counts;

    public static void sort(Object[] objectArray, RadixCompare radixCompare, int n) {
        RadixSort radixSort = new RadixSort();
        radixSort.delegate = radixCompare;
        radixSort.userArray = objectArray;
        radixSort.keyLength = n;
        radixSort.radixSort();
    }

    private void radixSort() {
        this.counts = new int[256];
        this.sourceArray = this.userArray;
        this.targetArray = new Object[this.userArray.length];
        int n = this.keyLength - 1;
        while (n > 0) {
            this.sortCol(n);
            Object[] objectArray = this.sourceArray;
            this.sourceArray = this.targetArray;
            this.targetArray = objectArray;
            --n;
        }
        if (this.sourceArray != this.userArray) {
            System.arraycopy(this.sourceArray, 0, this.userArray, 0, this.sourceArray.length);
        }
    }

    private void sortCol(int n) {
        int n2 = 0;
        while (n2 < this.counts.length) {
            this.counts[n2] = 0;
            ++n2;
        }
        n2 = 0;
        while (n2 < this.sourceArray.length) {
            int n3 = this.delegate.getKeyByteAt(this.sourceArray[n2], n);
            this.counts[n3] = this.counts[n3] + 1;
            ++n2;
        }
        n2 = 0;
        int n4 = 0;
        while (n4 < this.counts.length) {
            int n5 = this.counts[n4];
            this.counts[n4] = n2;
            n2 += n5;
            ++n4;
        }
        n2 = 0;
        while (n2 < this.sourceArray.length) {
            int n6 = n4 = this.delegate.getKeyByteAt(this.sourceArray[n2], n);
            this.counts[n6] = this.counts[n6] + 1;
            this.targetArray[n5] = this.sourceArray[n2];
            ++n2;
        }
    }
}

