/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class MarkerTemplate
implements Serializable {
    public static final int MARKER_TYPE_NULL = 0;
    public static final int MARKER_TYPE_RECT = 1;
    public static final int MARKER_TYPE_OVAL = 2;
    public static final int MARKER_TYPE_DIAMOND = 3;
    public static final int MARKER_TYPE_REFERENCELINE = 4;
    public static final int MARKER_TYPE_PLUS = 5;
    public static final int MARKER_TYPE_TRIANGLE_DN = 6;
    public static final int MARKER_TYPE_TRIANGLE_UP = 7;
    public static final int MARKER_TYPE_DRILL_UP = 8;
    public static final int MARKER_TYPE_BUBBLE = 9;
    public static final int MARKER_TYPE_DATALINE = 10;
    public static final int UNIT = 900;
    private static final int HALF = 450;
    private static final int THIRD = 300;
    private static final int QUARTER = 225;
    public static final Rectangle MARKER_SQUARE = new Rectangle(-900, -900, 1800, 1800);
    public static final Rectangle MARKER_LINE = new Rectangle(-900, -450, 1800, 450);
    private static final int[] MARKER_REF_X = new int[]{-900, 900, 900, -900};
    private static final int[] MARKER_REF_Y = new int[]{-1, -1, 1, 1};
    public static final Polygon MARKER_REFERENCE_LINE = new Polygon(MARKER_REF_X, MARKER_REF_Y, 4);
    private static final int nXFortyFiveDeg = (int)((double)900 * Math.cos(0.7853981633974483));
    private static final int nYFortyFiveDeg = (int)((double)900 * Math.sin(0.7853981633974483));
    private static final int[] MARKER_DEPTHCIRCLE_X = new int[]{900, nXFortyFiveDeg, 0, -nXFortyFiveDeg, -900, -nXFortyFiveDeg, 0, nXFortyFiveDeg};
    private static final int[] MARKER_DEPTHCIRCLE_Y = new int[]{0, nYFortyFiveDeg, 900, nYFortyFiveDeg, 0, -nYFortyFiveDeg, -900, -nYFortyFiveDeg};
    public static final Polygon MARKER_DEPTHCIRCLE = new Polygon(MARKER_DEPTHCIRCLE_X, MARKER_DEPTHCIRCLE_Y, 8);
    private static final int[] MARKER_DIAMOND_X = new int[]{900, 0, -900, 0};
    private static final int[] MARKER_DIAMOND_Y = new int[]{0, 900, 0, -900};
    public static final Polygon MARKER_DIAMOND = new Polygon(MARKER_DIAMOND_X, MARKER_DIAMOND_Y, 4);
    private static final int[] MARKER_PLUS_X = new int[]{900, 300, 300, -300, -300, -900, -900, -300, -300, 300, 300, 900};
    private static final int[] MARKER_PLUS_Y = new int[]{300, 300, 900, 900, 300, 300, -300, -300, -900, -900, -300, -300};
    public static final Polygon MARKER_PLUS = new Polygon(MARKER_PLUS_X, MARKER_PLUS_Y, 12);
    private static final int YVAL = (int)((double)900 * Math.sqrt(3.0) / 2.0);
    private static final int[] MARKER_TRIANGLE_DN_X = new int[]{900, 0, -900};
    private static final int[] MARKER_TRIANGLE_DN_Y = new int[]{YVAL, -YVAL, YVAL};
    public static final Polygon MARKER_TRIANGLE_DN = new Polygon(MARKER_TRIANGLE_DN_X, MARKER_TRIANGLE_DN_Y, 3);
    private static final int[] MARKER_TRIANGLE_UP_X = new int[]{900, 0, -900};
    private static final int[] MARKER_TRIANGLE_UP_Y = new int[]{-YVAL, YVAL, -YVAL};
    public static final Polygon MARKER_TRIANGLE_UP = new Polygon(MARKER_TRIANGLE_UP_X, MARKER_TRIANGLE_UP_Y, 3);
    private static final int A = 600;
    private static final int[] MARKER_PIRATE_PLUS_X = new int[]{0, -600, 600, 0, 900, 900, 0, 600, -600, 0, -900, -900};
    private static final int[] MARKER_PIRATE_PLUS_Y = new int[]{0, 900, 900, 0, 600, -600, 0, -900, -900, 0, -600, 600};
    public static final Polygon MARKER_PIRATE_PLUS = new Polygon(MARKER_PIRATE_PLUS_X, MARKER_PIRATE_PLUS_Y, 12);
    Rectangle m_rect;
    Polygon m_polygon;
    int m_markerType;
    int m_nLineWidth;
    Color m_LineColor;
    int m_nLineWidthVC;
    int m_nLineStyle;

    public MarkerTemplate() {
        this.m_markerType = 0;
    }

    public MarkerTemplate(Polygon polygon, int n) {
        this(null, polygon, n);
    }

    public MarkerTemplate(Polygon polygon) {
        this(null, polygon, 0);
    }

    public MarkerTemplate(Rectangle rectangle) {
        this(rectangle, null, 1);
    }

    public MarkerTemplate(Rectangle rectangle, int n) {
        this(rectangle, null, n);
    }

    public MarkerTemplate(Rectangle rectangle, Polygon polygon, int n) {
        this.m_rect = rectangle;
        this.m_polygon = polygon;
        this.m_markerType = n;
    }

    public MarkerTemplate(Rectangle rectangle, boolean bl) {
        this(rectangle, null, 1);
        if (bl) {
            this.m_markerType = 2;
        }
    }

    public boolean isValid() {
        boolean bl = true;
        switch (this.m_markerType) {
            case 0: {
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                if (this.m_polygon == null) {
                    bl = false;
                    break;
                }
                Rectangle rectangle = this.m_polygon.getBounds();
                if (rectangle != null && rectangle.width > 0 && rectangle.width <= 1800 && rectangle.height > 0 && rectangle.height <= 1800) break;
                bl = false;
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                if (this.m_rect != null && this.m_rect.width > 0 && this.m_rect.width <= 1800 && this.m_rect.height > 0 && this.m_rect.height <= 1800) break;
                bl = false;
                break;
            }
            case 9: {
                if (this.m_rect != null && this.m_rect.width > 0 && this.m_rect.height > 0) break;
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public String toString() {
        String string;
        switch (this.m_markerType) {
            case 0: {
                string = "Null Marker";
                break;
            }
            case 1: {
                string = String.valueOf(String.valueOf("Rect = ")) + this.m_rect;
                break;
            }
            case 2: {
                string = String.valueOf(String.valueOf("Oval whose rect = ")) + this.m_rect;
                break;
            }
            case 9: {
                string = String.valueOf(String.valueOf("Bubble whose rect = ")) + this.m_rect;
                break;
            }
            case 3: 
            case 4: 
            case 10: {
                string = String.valueOf(String.valueOf("Polygon = ")) + this.m_polygon;
                break;
            }
            case 8: {
                string = "Drill-up icon";
                break;
            }
            default: {
                string = "Unknown marker type!";
            }
        }
        return string;
    }

    public int getMarkerType() {
        return this.m_markerType;
    }

    public MarkerTemplate(Rectangle rectangle, int n, int n2, Color color) {
        this(rectangle, null, n, n2, color);
    }

    public MarkerTemplate(Rectangle rectangle, Polygon polygon, int n, int n2, Color color) {
        this.m_rect = rectangle;
        this.m_polygon = polygon;
        this.m_markerType = n;
        this.m_nLineWidth = n2;
        this.m_LineColor = color;
    }

    public MarkerTemplate(Polygon polygon, int n, int n2, Color color) {
        this.m_rect = null;
        this.m_polygon = polygon;
        this.m_markerType = n;
        this.m_nLineWidth = n2;
        this.m_LineColor = color;
    }

    public int getLineWidth() {
        return this.m_nLineWidth;
    }

    public void setLineStyle(int n) {
        this.m_nLineStyle = n;
    }

    public int getLineStyle() {
        return this.m_nLineStyle;
    }

    public void setLineWidthVC(int n) {
        this.m_nLineWidthVC = n;
    }

    public int getLineWidthVC() {
        return this.m_nLineWidthVC;
    }

    public Color getLineColor() {
        return this.m_LineColor;
    }
}

