/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.Attr;
import oracle.dss.graph.pfj.draw.IdentObj;

public class LookKeyObj
implements Serializable {
    Attr m_attr;
    IdentObj m_id;
    private int m_attrID;
    private int m_objectID;
    private int m_seriesID;
    private int m_groupID;
    private int m_stackID;
    private int m_miscID;
    private LookKeyObj m_nextKey;

    public LookKeyObj(Attr attr, IdentObj identObj) {
        this(attr, identObj, null);
    }

    public LookKeyObj(Attr attr, IdentObj identObj, LookKeyObj lookKeyObj) {
        this.m_attr = attr;
        this.m_id = identObj;
        this.m_attrID = attr.getAttrID();
        this.m_objectID = identObj.getObjectID();
        this.m_seriesID = identObj.getSeriesID();
        this.m_groupID = identObj.getGroupID();
        this.m_stackID = identObj.getStackID();
        this.m_miscID = identObj.getMiscID();
        this.m_nextKey = lookKeyObj;
    }

    public void setStackID(int n) {
        this.m_stackID = n;
    }

    public void setMiscID(int n) {
        this.m_miscID = n;
    }

    public void setGroupID(int n) {
        this.m_groupID = n;
    }

    public void setObjectID(int n) {
        this.m_objectID = n;
    }

    public void setSeriesID(int n) {
        this.m_seriesID = n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LookKeyObj)) {
            return false;
        }
        LookKeyObj lookKeyObj = (LookKeyObj)object;
        if (!this.m_attr.equals(lookKeyObj.m_attr)) {
            return false;
        }
        if (this.m_objectID != lookKeyObj.m_objectID) {
            return false;
        }
        if (this.m_seriesID != lookKeyObj.m_seriesID) {
            return false;
        }
        if (this.m_groupID != lookKeyObj.m_groupID) {
            return false;
        }
        if (this.m_stackID != lookKeyObj.m_stackID) {
            return false;
        }
        return this.m_miscID == lookKeyObj.m_miscID;
    }

    public int hashCode() {
        int n = this.m_attrID + 1000 * this.m_objectID + 1000000 * this.m_seriesID;
        return n;
    }

    public String toString() {
        return String.valueOf(String.valueOf("*** ")) + this.m_attr.toString() + this.m_id.toString();
    }

    public Attr getAttr() {
        return this.m_attr;
    }

    public IdentObj getIdentObj() {
        return this.m_id;
    }

    public LookKeyObj getNextKey() {
        return this.m_nextKey;
    }
}

