/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Rectangle;
import java.io.Serializable;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.IdentObj;

public class LegendScroller
implements Serializable {
    public static final int PRESENCE_NEVER = 0;
    public static final int PRESENCE_SOMETIMES = 1;
    public static final int PRESENCE_ALWAYS = 2;
    protected int m_nScrollerThicknessHorz = 12;
    protected int m_nScrollerThicknessVert = 8;
    protected Perspective m_Perspective;
    protected LegendObj m_Legend;
    protected Rectangle m_rFrame;
    protected Rectangle m_rScroller;
    protected boolean m_bVert;
    protected int m_nTotal;
    protected int m_nCount;
    protected int m_nStart;

    public LegendScroller(Perspective perspective, LegendObj legendObj, Rectangle rectangle, boolean bl) {
        this.m_Perspective = perspective;
        this.m_Legend = legendObj;
        this.m_rFrame = rectangle;
        this.m_bVert = bl;
        this.m_nTotal = this.m_Legend.getNumItemsInLegend();
        this.m_nCount = this.m_Legend.getSeriesCount();
        this.m_nStart = this.m_Legend.getSeriesStart();
    }

    public void calc() {
        Rectangle rectangle;
        Rectangle rectangle2;
        int n;
        int n2;
        if (this.m_rFrame == null) {
            return;
        }
        this.adjustScrollerThickness();
        IdentObj identObj = this.m_Perspective.getLegendScroller();
        IdentObj identObj2 = this.m_Perspective.getLegendScrollerThumb();
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
        BlackBoxObj blackBoxObj2 = new BlackBoxObj(this.m_Perspective, identObj2);
        int n3 = this.m_nTotal - (this.m_nStart + this.m_nCount);
        if (this.m_bVert) {
            n2 = this.m_rFrame.height;
            n = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessHorz);
            rectangle2 = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, n, n2);
        } else {
            n2 = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessVert);
            n = this.m_rFrame.width;
            rectangle2 = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, n, n2);
        }
        new DetRect(this.m_Perspective.m_Detectiv, identObj, rectangle2, (BlackBoxIF)blackBoxObj, null);
        this.m_Perspective.setRect(this.m_Perspective.getLegendScroller(), rectangle2);
        int n4 = this.m_nTotal - this.m_nCount;
        if (this.m_bVert) {
            int n5 = rectangle2.height * this.m_nCount / this.m_nTotal;
            int n6 = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessHorz);
            if (n5 < n6) {
                n5 = n6;
            }
            int n7 = n4 == 0 ? rectangle2.y + rectangle2.height - n5 / 2 : rectangle2.y + rectangle2.height - n5 / 2 - this.m_nStart * (rectangle2.height - n5) / n4;
            rectangle = new Rectangle(rectangle2.x, n7 - n5 / 2, n, n5);
        } else {
            int n8 = rectangle2.width / this.m_nCount;
            int n9 = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessVert);
            if (n8 < n9) {
                n8 = n9;
            }
            int n10 = n4 == 0 ? rectangle2.x + n8 / 2 : rectangle2.x + n8 / 2 + this.m_nStart * (rectangle2.width - n8) / n4;
            rectangle = new Rectangle(n10 - n8 / 2, rectangle2.y, n8, n2);
        }
        new DetRect(this.m_Perspective.m_Detectiv, identObj2, rectangle, (BlackBoxIF)blackBoxObj2, rectangle2);
    }

    protected void adjustScrollerThickness() {
        Rectangle rectangle = this.m_Perspective.getLegendRect();
        if (rectangle.height > 3250) {
            this.m_nScrollerThicknessVert = 10;
        }
        if (rectangle.width < 3250) {
            this.m_nScrollerThicknessHorz = 10;
        }
        if (rectangle.width < 2000) {
            this.m_nScrollerThicknessHorz = 8;
        }
    }

    public int getScrollerHeightVC() {
        int n = this.m_Perspective.m_VC.destToVirtHeight(this.m_nScrollerThicknessVert);
        return n;
    }

    public int getScrollerWidthVC() {
        int n = this.m_Perspective.m_VC.destToVirtWidth(this.m_nScrollerThicknessHorz);
        return n;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }
}

