/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ResourceBundle;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.JChart_2D_Pie;
import oracle.dss.graph.pfj.JChart_Base;
import oracle.dss.graph.pfj.JGraphType;
import oracle.dss.graph.pfj.LegendObj;
import oracle.dss.graph.pfj.MarkerObj;
import oracle.dss.graph.pfj.MarkerTemplate;
import oracle.dss.graph.pfj.MarkerTemplateArray;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.ReferenceLineObj;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetRect;
import oracle.dss.graph.pfj.draw.Detectiv;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class LegendMarkersLabels
implements Serializable {
    public static final int LEFT_OF_TEXT = 0;
    public static final int RIGHT_OF_TEXT = 1;
    public static final int ABOVE_TEXT = 2;
    public static final int BELOW_TEXT = 3;
    public static final int UNDER_TEXT = 4;
    public static final boolean LEFT_TO_RIGHT = false;
    public static final boolean RIGHT_TO_LEFT = true;
    public static final int VERT_LABEL_SPACING = 7;
    public static final int MIN_CHARS_FOR_TRUNCATION = 2;
    public int MKR_MARGIN;
    public int MIN_V_GAP;
    public int MIN_H_GAP;
    public int DOUBLE_MKR_MARGIN;
    protected static final int MIN_LABEL_HEIGHT = 1000;
    protected static final int ACCEPTABLE_TEXT_HEIGHT = 2000;
    protected static final int MIN_WIDTH_FOR_TEXT = 400;
    protected static final int MIN_HEIGHT_FOR_TEXT = 200;
    protected Perspective m_Perspective;
    protected Detectiv m_Detectiv;
    protected JChart_Base m_Chart;
    protected LegendObj m_Legend;
    protected Access m_Access;
    protected boolean m_nBiDirectionalText;
    protected Dimension m_dimMarkerCell;
    protected Dimension m_dimLabelCell;
    protected Vector m_vectStrLabels;
    protected Vector m_vectLabelID;
    protected Vector m_vectMarkerID;
    protected Vector m_vectMarkerTemplate;
    protected Vector m_vectMarkerBlackBox;
    RelativeAxisObj m_axis;
    protected boolean m_bTextAutofit;
    protected String m_szFontName;
    protected int m_nFontStyle;
    protected int m_nFontSize;
    protected int m_nFontSizeVC;
    protected int m_nMarkerPos;
    protected boolean m_bLabelsExist;
    protected TextStyleObj m_textStyle;
    protected int m_nMarkerSizePercentX;
    protected int m_nMarkerSizePercentY;
    protected boolean m_labelsTruncated;
    protected boolean m_drawLabels = true;
    protected static final int markerMargin = 3;
    protected static final int minMarkerGap = 1;

    public LegendMarkersLabels(Perspective perspective, Access access, JChart_Base jChart_Base, LegendObj legendObj) {
        this.m_Perspective = perspective;
        this.m_Access = access;
        this.m_Chart = jChart_Base;
        this.m_Detectiv = this.m_Perspective.getDetectiv();
        this.m_Legend = legendObj;
        this.MKR_MARGIN = this.m_Perspective.getVC().destToVirtWidth(3);
        this.MIN_V_GAP = this.m_Perspective.getVC().destToVirtHeight(1);
        this.MIN_H_GAP = this.m_Perspective.getVC().destToVirtWidth(1);
        this.DOUBLE_MKR_MARGIN = 2 * this.MKR_MARGIN;
    }

    public void init() {
        this.initVectors(0);
        this.m_nMarkerPos = this.m_Perspective.getLegendMarkerPosition();
        this.m_nBiDirectionalText = this.m_Perspective.getBiDirectional();
        if (this.m_nBiDirectionalText) {
            if (this.m_nMarkerPos == 0) {
                this.m_nMarkerPos = 1;
            } else if (this.m_nMarkerPos == 1) {
                this.m_nMarkerPos = 0;
            }
        }
        this.m_bTextAutofit = this.m_Perspective.getLegendTextAutofit();
        IdentObj identObj = new IdentObj(14, 0);
        boolean bl = this.m_Perspective.getFontSizeAbsolute(this.m_Perspective.getLegendText());
        if (bl) {
            this.m_nFontSize = this.m_Perspective.getFontSize(identObj);
            this.m_nFontSizeVC = this.m_Perspective.m_VC.destToVirtHeight(this.m_nFontSize);
        } else {
            this.m_nFontSizeVC = this.m_Perspective.getFontSizeVC(identObj);
            this.m_nFontSize = this.m_Perspective.m_VC.virtToDestHeight(this.m_nFontSizeVC);
        }
        this.m_nFontStyle = this.m_Perspective.getFontStyle(identObj);
        this.m_szFontName = this.m_Perspective.getFontName(identObj);
        this.m_textStyle = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_szFontName, this.m_nFontStyle, bl, this.m_nFontSize, this.m_nFontSizeVC, this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
        if (this.m_Perspective.getTextWrap(identObj)) {
            this.m_textStyle.setTextTruncate(true, -1, 2);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void calcLabels() {
        block11: {
            block10: {
                if (!this.m_bLabelsExist || !this.m_drawLabels) break block10;
                var1_1 = new IdentObj(14);
                var2_2 = new BlackBoxObj(this.m_Perspective, var1_1);
                var3_3 = this.m_Legend.getSeriesStart();
                var4_4 = this.m_Legend.getSeriesRange();
                var5_5 = this.m_Perspective.getVC();
                var6_6 = 0;
                var7_7 = this.m_Perspective.getLegendText();
                var8_8 = this.m_Perspective.getFontSizeAbsolute(var7_7) == false ? var5_5.virtToDestHeight(this.m_Perspective.getFontSizeVC(var7_7)) : this.m_Perspective.getFontSize(var7_7);
                var9_9 = TextStyleObj.getJavaFontStyle(this.m_Perspective.getFontStyle(var7_7));
                var10_10 = this.m_Perspective.getFontName(var7_7);
                var11_11 = this.m_Perspective.getGraphicsContext();
                var13_13 = var11_11.getFontMetrics(var12_12 = new Font(var10_10, var9_9, var8_8));
                var14_14 = TextStyleObj.getFontHeight(var13_13);
                var15_15 = var5_5.destToVirtHeight(var14_14);
                var16_16 = this.getDisplayLines(var15_15, var5_5);
                if (var16_16 == 0) {
                    var16_16 = 1;
                }
                var17_17 = this.m_Perspective.getTextWrap(var7_7);
                var18_18 = true;
                if (!this.m_Perspective.getFontSizeAbsolute(var7_7) && this.m_Perspective.getLegendTextAutofit()) {
                    var18_18 = false;
                }
                this.m_labelsTruncated = false;
                var19_19 = var3_3;
                while (var19_19 < var4_4) {
                    var20_20 = (String)this.m_vectStrLabels.elementAt(var19_19);
                    var21_21 = (IdentObj)this.m_vectLabelID.elementAt(var19_19);
                    var22_22 = this.m_Legend.getCellRect(var6_6);
                    var23_23 = this.calcLabelRect(var22_22);
                    ++var6_6;
                    if (var18_18 && !var17_17 && var13_13 != null && var20_20 != null && var23_23.width < var5_5.destToVirtWidth(var13_13.stringWidth(var20_20))) {
                        this.m_labelsTruncated = true;
                        var20_20 = var23_23.width < 0 ? "" : TextStyleObj.truncateText(var20_20, var13_13, 2, var5_5.virtToDestWidth(var23_23.width));
                    }
                    if (var18_18 && var17_17) {
                        var24_24 /* !! */  = new Vector<E>();
                        var25_26 = this.m_textStyle.extractLinesWordWrap(var20_20, var24_24 /* !! */ , var5_5.virtToDestWidth(var23_23.width), var13_13);
                        if (this.m_textStyle.isTextTruncated()) {
                            this.m_labelsTruncated = true;
                        }
                        if (var16_16 < var25_26) {
                            this.m_textStyle.setTextTruncate(true, var16_16, 2);
                            this.m_labelsTruncated = true;
                        }
                    }
                    if (var19_19 != var3_3) ** GOTO lbl-1000
                    var24_24 /* !! */  = new IdentObj(235);
                    if (this.m_Perspective.getDrillCallback().isDrillingEnabled() && this.m_Perspective.getTextString((IdentObj)var24_24 /* !! */ ) != null && this.m_Perspective.getDisplay((IdentObj)var24_24 /* !! */ )) {
                        var26_27 = var25_26 = this.m_textStyle.getFontStyle();
                        this.m_textStyle.setFontStyle(var25_26 |= 4);
                        new DetLabel(this.m_Detectiv, var21_21, var20_20, var23_23, this.m_textStyle, var2_2, false);
                        this.m_textStyle.setFontStyle(var26_27);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (this.m_Perspective.getDrillCallback().isDrillingEnabled()) {
                            var24_25 = this.m_Perspective.getFontStyle(var21_21) & 4;
                            this.m_textStyle.setFontStyle(this.m_textStyle.getFontStyle() & -5 | var24_25);
                        }
                        new DetLabel(this.m_Detectiv, var21_21, var20_20, var23_23, this.m_textStyle, var2_2, false);
                    }
                    ++var19_19;
                }
                break block11;
            }
            this.m_labelsTruncated = true;
        }
    }

    public void calcMarkers() {
        int n = this.m_Legend.getSeriesStart();
        int n2 = this.m_Legend.getSeriesRange();
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            IdentObj identObj = (IdentObj)this.m_vectMarkerID.elementAt(n4);
            MarkerTemplate markerTemplate = (MarkerTemplate)this.m_vectMarkerTemplate.elementAt(n4);
            BlackBoxIF blackBoxIF = (BlackBoxIF)this.m_vectMarkerBlackBox.elementAt(n4);
            this.calcOneMarker(n3, identObj, markerTemplate, blackBoxIF, n4);
            ++n3;
            ++n4;
        }
    }

    protected void calcOneMarker(int n, IdentObj identObj, MarkerTemplate markerTemplate, BlackBoxIF blackBoxIF, int n2) {
        Rectangle rectangle = this.m_Legend.getCellRect(n);
        Rectangle rectangle2 = this.calcMarkerRect(rectangle);
        if (this.m_nMarkerPos == 4) {
            new DetRect(this.m_Detectiv, identObj, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, blackBoxIF);
        } else {
            MarkerObj markerObj;
            Object object;
            Serializable serializable;
            if (markerTemplate.getMarkerType() == 4 || markerTemplate.getMarkerType() == 10) {
                serializable = this.m_Perspective.getSeries(n2);
                if (this.m_Perspective.getTransparentFillColor((IdentObj)serializable)) {
                    blackBoxIF.setTransparentBorderColor(true);
                } else {
                    blackBoxIF.setBorderColor(markerTemplate.getLineColor());
                }
            }
            int n3 = rectangle2.x + rectangle2.width / 2;
            int n4 = rectangle2.y + rectangle2.height / 2;
            serializable = new Point(n3, n4);
            if (markerTemplate.getMarkerType() == 8) {
                int n5;
                object = this.m_Perspective.getLegendText();
                if (!this.m_Perspective.getFontSizeAbsolute((IdentObj)object)) {
                    n5 = this.m_Perspective.getFontSizeVC((IdentObj)object);
                    n5 = this.m_Perspective.m_VC.virtToDestHeight(n5);
                } else {
                    n5 = this.m_Perspective.getFontSize((IdentObj)object);
                }
                Rectangle rectangle3 = new Rectangle(MarkerTemplate.MARKER_SQUARE);
                int n6 = 8;
                if (n5 >= 18) {
                    n6 = 16;
                }
                IdentObj identObj2 = new IdentObj(234);
                markerObj = new MarkerObj(this.m_Detectiv, identObj2, markerTemplate, (Point)serializable, n6, n6, blackBoxIF, null, false);
            } else {
                markerObj = new MarkerObj(this.m_Detectiv, identObj, markerTemplate, (Point)serializable, this.m_nMarkerSizePercentX, this.m_nMarkerSizePercentY, blackBoxIF, null, false);
            }
            if (markerTemplate.getMarkerType() == 4) {
                object = (String)this.m_vectStrLabels.elementAt(n2);
                markerObj.setReferenceLabel((String)object);
            }
        }
    }

    protected void calcMarkerSize() {
        int n;
        int n2 = this.m_Perspective.getLegendMarkerSize();
        int n3 = this.m_Perspective.m_VC.destToVirtWidth(n2);
        int n4 = this.m_Perspective.m_VC.destToVirtHeight(n2);
        Rectangle rectangle = new Rectangle(MarkerTemplate.MARKER_SQUARE);
        rectangle.width = n3;
        rectangle.height = n4;
        this.m_dimMarkerCell = new Dimension(rectangle.width, rectangle.height);
        Dimension dimension = this.m_Legend.getDimCell();
        int n5 = dimension.height;
        if (this.m_nMarkerPos == 2 || this.m_nMarkerPos == 3) {
            n5 = dimension.height / 2;
        }
        if (rectangle.height + this.MIN_V_GAP > n5) {
            rectangle.height = n5;
            if (rectangle.height > 2 * this.MIN_V_GAP) {
                rectangle.height = n5 - this.MIN_V_GAP;
            }
            n = this.m_Perspective.m_VC.virtToDestHeight(rectangle.height);
            rectangle.width = this.m_Perspective.m_VC.destToVirtWidth(n);
        }
        if (rectangle.width + this.MIN_H_GAP > dimension.width) {
            rectangle.width = dimension.width;
            if (rectangle.width > 2 * this.MIN_H_GAP) {
                rectangle.width = dimension.width - this.MIN_H_GAP;
            }
            n = this.m_Perspective.m_VC.virtToDestWidth(rectangle.width);
            rectangle.height = this.m_Perspective.m_VC.destToVirtHeight(n);
        }
        switch (this.m_nMarkerPos) {
            case 2: 
            case 3: {
                this.m_dimMarkerCell = new Dimension(dimension.width, dimension.height / 2);
                break;
            }
            case 0: 
            case 1: {
                this.m_dimMarkerCell = new Dimension(rectangle.width, rectangle.height);
                break;
            }
            default: {
                this.m_dimMarkerCell = new Dimension(dimension);
            }
        }
        this.calcMarkerSizePercent(rectangle);
    }

    public void calcMarkerSizePercent(Rectangle rectangle) {
        boolean bl;
        Rectangle rectangle2 = new Rectangle(MarkerTemplate.MARKER_SQUARE);
        double d = rectangle.width;
        d /= (double)rectangle2.width;
        this.m_nMarkerSizePercentX = (int)(d *= (double)100);
        double d2 = rectangle.height;
        d2 /= (double)rectangle2.height;
        this.m_nMarkerSizePercentY = (int)(d2 *= (double)100);
        if (this.m_nMarkerSizePercentX < 1) {
            this.m_nMarkerSizePercentX = 1;
        }
        if (this.m_nMarkerSizePercentY < 1) {
            this.m_nMarkerSizePercentY = 1;
        }
        if ((bl = this.m_Perspective.getSquareMarkers()) && this.m_nMarkerPos != 4) {
            double d3;
            double d4 = this.m_Perspective.m_VC.virtToDestWidth((double)this.m_nMarkerSizePercentX);
            if (d4 > (d3 = this.m_Perspective.m_VC.virtToDestHeight((double)this.m_nMarkerSizePercentY))) {
                this.m_nMarkerSizePercentX = (int)((double)this.m_nMarkerSizePercentX * d3 / d4);
            } else {
                this.m_nMarkerSizePercentY = (int)((double)this.m_nMarkerSizePercentY * d4 / d3);
            }
            if (this.m_nMarkerSizePercentX < 1) {
                this.m_nMarkerSizePercentX = 1;
            }
            if (this.m_nMarkerSizePercentY < 1) {
                this.m_nMarkerSizePercentY = 1;
            }
        }
    }

    public Rectangle calcMarkerRect(Rectangle rectangle) {
        Dimension dimension = this.m_Legend.getDimCell();
        Point point = this.calcMarkerOffsets();
        int n = rectangle.x + point.x;
        int n2 = rectangle.y + point.y;
        Rectangle rectangle2 = new Rectangle(this.m_dimMarkerCell);
        rectangle2.translate(n, n2);
        return rectangle2;
    }

    public Point calcMarkerOffsets() {
        Dimension dimension = this.m_Legend.getDimCell();
        int n = 0;
        int n2 = (dimension.height - this.m_dimMarkerCell.height) / 2;
        if (n2 < 0) {
            n2 = 0;
        }
        if (this.m_bLabelsExist) {
            switch (this.m_nMarkerPos) {
                default: {
                    break;
                }
                case 1: {
                    n = this.m_dimLabelCell.width + this.MKR_MARGIN;
                    break;
                }
                case 2: {
                    n2 = this.m_dimMarkerCell.height;
                    break;
                }
                case 3: {
                    n2 = (dimension.height / 2 - this.m_dimMarkerCell.height) / 2;
                }
                case 4: 
            }
            PfjAssert.pfjAssert(n >= 0);
            PfjAssert.pfjAssert(n2 >= 0);
        }
        return new Point(n, n2);
    }

    public void setDrawLabels(boolean bl) {
        this.m_drawLabels = bl;
    }

    public boolean isLabelsTruncated() {
        return this.m_labelsTruncated;
    }

    protected void calcLabelSize() {
        Dimension dimension = this.m_Legend.getDimCell();
        if (dimension.width < this.DOUBLE_MKR_MARGIN || dimension.height < 200) {
            this.m_bLabelsExist = false;
        } else {
            switch (this.m_nMarkerPos) {
                default: {
                    int n = dimension.width - this.m_dimMarkerCell.width - this.DOUBLE_MKR_MARGIN;
                    if (n <= 0) {
                        n = 0;
                        this.m_bLabelsExist = false;
                    }
                    this.m_dimLabelCell = new Dimension(n, dimension.height);
                    if (this.m_nBiDirectionalText) {
                        switch (this.m_textStyle.getHorizAlign()) {
                            case 0: {
                                this.m_textStyle.setHorizAlign(2);
                                break;
                            }
                            case 2: {
                                this.m_textStyle.setHorizAlign(0);
                            }
                        }
                    }
                    break;
                }
                case 2: 
                case 3: {
                    this.m_dimLabelCell = new Dimension(dimension.width - this.DOUBLE_MKR_MARGIN, dimension.height / 2);
                    break;
                }
                case 4: {
                    this.m_dimLabelCell = new Dimension(dimension.width - this.DOUBLE_MKR_MARGIN, dimension.height);
                }
            }
            Vector<String> vector = new Vector<String>(1);
            vector.addElement("THIS IS A VERY VERY LONG DUMMY LABEL SO THE TEXT BOXSIZE FOR THE LEGEND IS MAXIMIZED");
            Vector vector2 = null;
            vector2 = this.m_bTextAutofit ? this.m_vectStrLabels : this.m_vectStrLabels;
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            this.m_textStyle.formatAndAutofit(graphics, this.m_Perspective, this.m_bTextAutofit, this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), this.m_nFontSizeVC, vector2, this.m_dimLabelCell, this.m_Perspective.m_VC);
        }
    }

    private Point calcLabelOffsets() {
        Dimension dimension = this.m_Legend.getDimCell();
        int n = (dimension.width - this.m_dimLabelCell.width) / 2;
        int n2 = dimension.height / 2 - this.m_dimLabelCell.height / 2;
        switch (this.m_nMarkerPos) {
            default: {
                n = this.m_dimMarkerCell.width + this.MKR_MARGIN;
                break;
            }
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n2 = (dimension.height / 2 - this.m_dimLabelCell.height) / 2;
                break;
            }
            case 3: {
                n2 = this.m_dimMarkerCell.height;
            }
            case 4: 
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        return new Point(n, n2);
    }

    public Rectangle calcLabelRect(Rectangle rectangle) {
        Point point = this.calcLabelOffsets();
        int n = rectangle.x + point.x;
        int n2 = rectangle.y + point.y;
        Rectangle rectangle2 = new Rectangle(this.m_dimLabelCell);
        rectangle2.translate(n, n2);
        return rectangle2;
    }

    public void initVectors(int n) {
        this.m_bLabelsExist = false;
        this.m_vectStrLabels = new Vector(n);
        this.m_vectLabelID = new Vector(n);
        this.m_vectMarkerID = new Vector(n);
        this.m_vectMarkerTemplate = new Vector(n);
        this.m_vectMarkerBlackBox = new Vector(n);
    }

    public void loadReferenceLineVectors() {
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (!(jGraphType.isBLAType() || jGraphType.isPolar() || jGraphType.isRadarType() || jGraphType.isScatter() || jGraphType.isBubble() || jGraphType.isParetoType())) {
            return;
        }
        Vector vector = this.m_Perspective.getReferenceLineVector();
        if (vector != null && !vector.isEmpty()) {
            int n = 0;
            while (n < vector.size()) {
                ReferenceLineObj referenceLineObj = (ReferenceLineObj)vector.elementAt(n);
                IdentObj identObj = referenceLineObj.getIdentObj();
                int n2 = referenceLineObj.getIndex();
                int n3 = referenceLineObj.getAxisLineObjID();
                if (this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLine(identObj, n2)) && referenceLineObj.IsValidAxis() && this.m_Perspective.getDisplay(this.m_Perspective.getReferenceLineLegendText(identObj, n2))) {
                    IdentObj identObj2 = new IdentObj(248, n2, n3);
                    identObj2.setMiscID(n);
                    this.m_vectLabelID.addElement(identObj2);
                    String string = this.m_Perspective.getTextString(this.m_Perspective.getReferenceLine(identObj, n2));
                    this.m_vectStrLabels.addElement(string);
                    IdentObj identObj3 = new IdentObj(249, n2, n3);
                    identObj3.setMiscID(n);
                    this.m_vectMarkerID.addElement(identObj3);
                    BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj3);
                    Color color = this.m_Perspective.getFillColor(this.m_Perspective.getReferenceLine(identObj, n2));
                    blackBoxObj.setFillColor(color);
                    this.m_vectMarkerBlackBox.addElement(blackBoxObj);
                    MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 4, this.m_Perspective.getLineWidth(this.m_Perspective.getReferenceLine(identObj, n2)), color);
                    int n4 = markerTemplate.getLineWidth();
                    markerTemplate.setLineWidthVC(this.m_Perspective.m_VC.destToVirtWidth(n4));
                    markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(this.m_Perspective.getReferenceLine(identObj, n2)));
                    this.m_vectMarkerTemplate.addElement(markerTemplate);
                }
                ++n;
            }
        }
    }

    public void loadDrillMarker() {
        IdentObj identObj = new IdentObj(235);
        if (!this.m_Perspective.getDrillCallback().isDrillingEnabled() || this.m_Perspective.getTextString(identObj) == null || !this.m_Perspective.getDisplay(identObj)) {
            return;
        }
        this.m_vectLabelID.addElement(identObj);
        String string = this.m_Perspective.getTextString(identObj);
        this.m_vectStrLabels.addElement(string);
        IdentObj identObj2 = new IdentObj(234);
        this.m_vectMarkerID.addElement(identObj2);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj2);
        this.m_vectMarkerBlackBox.addElement(blackBoxObj);
        MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE, 8);
        this.m_vectMarkerTemplate.addElement(markerTemplate);
    }

    public void loadSeriesVectors() {
        boolean bl = false;
        JChart_2D_Pie jChart_2D_Pie = null;
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (jGraphType.isPieType()) {
            jChart_2D_Pie = (JChart_2D_Pie)this.m_Chart;
            bl = jChart_2D_Pie.getOtherPercentageFlag();
        }
        boolean bl2 = this.m_Chart.isSingleSeriesOnly();
        boolean bl3 = this.m_Perspective.getReverseSeries();
        boolean bl4 = this.m_Legend.getLegendReverse() == bl3;
        int n = this.m_Perspective.getSeriesLooping();
        SeriesEnumerator seriesEnumerator = this.m_Chart.getResetSeriesEnumerator(bl4);
        while (seriesEnumerator.hasMoreElements()) {
            int n2 = seriesEnumerator.nextSeries();
            boolean bl5 = true;
            if (jChart_2D_Pie != null) {
                boolean bl6 = bl5 = !jChart_2D_Pie.isSeriesPartOfOther(n2);
            }
            if (bl2 && n2 != 0 || !bl5) continue;
            int n3 = n2;
            String string = this.m_Perspective.getSeriesLabel(n2);
            this.m_vectStrLabels.addElement(string);
            if (string != null && !string.equals("")) {
                this.m_bLabelsExist = true;
            }
            IdentObj identObj = new IdentObj(14, n3);
            this.m_vectLabelID.addElement(identObj);
            IdentObj identObj2 = new IdentObj(13, n3);
            this.m_vectMarkerID.addElement(identObj2);
            IdentObj identObj3 = new IdentObj(-3, n3 % n);
            MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(identObj3);
            identObj3.setSeriesID(n3);
            if (jGraphType.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
                markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
            }
            this.m_vectMarkerTemplate.addElement(markerTemplate);
            BlackBoxIF blackBoxIF = this.m_Chart.assignSeriesColor(n2);
            this.m_vectMarkerBlackBox.addElement(blackBoxIF);
        }
        if (bl) {
            this.loadPieOtherVectors();
        }
    }

    private void loadPieOtherVectors() {
        if (this.m_Perspective.PFJRes == null) {
            this.m_Perspective.PFJRes = ResourceBundle.getBundle("oracle.dss.graph.pfj.TDGResources", this.m_Perspective.getLocale());
        }
        String string = this.m_Perspective.PFJRes.getString("OTHER");
        this.m_vectStrLabels.addElement(string);
        IdentObj identObj = new IdentObj(14, -1);
        this.m_vectLabelID.addElement(identObj);
        IdentObj identObj2 = new IdentObj(-3, -1);
        identObj2.setSeriesID(-1);
        MarkerTemplate markerTemplate = this.getSeriesMarkerTemplate(identObj2);
        JGraphType jGraphType = this.m_Perspective.getJGraphType();
        if (jGraphType.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
        }
        this.m_vectMarkerTemplate.addElement(markerTemplate);
        IdentObj identObj3 = new IdentObj(-3, -1);
        this.m_vectMarkerID.addElement(identObj3);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj3);
        this.m_vectMarkerBlackBox.addElement(blackBoxObj);
        this.m_bLabelsExist = true;
    }

    MarkerTemplate getSeriesMarkerTemplate(IdentObj identObj) {
        MarkerTemplate markerTemplate = null;
        boolean bl = this.m_Perspective.getUseSeriesShapes();
        if (!(this.m_Perspective.getSeriesType(identObj) != 2 && this.m_Perspective.getBaseRiserType() != 2 || this.m_Perspective.getGraphType() >= 61 && this.m_Perspective.getGraphType() <= 66 || !this.m_Perspective.getConnectLineMarkers())) {
            markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_LINE, 10, this.m_Perspective.getLineWidth(identObj), this.m_Perspective.getFillColor(identObj));
            int n = markerTemplate.getLineWidth();
            markerTemplate.setLineWidthVC(n);
            markerTemplate.setLineStyle(this.m_Perspective.getLineStyle(identObj));
            return markerTemplate;
        }
        markerTemplate = bl ? (this.m_Perspective.getMarkerShape(identObj) == 0 ? new MarkerTemplate(MarkerTemplate.MARKER_SQUARE) : (this.m_Perspective.getSeriesType(identObj) == 2 || this.m_Perspective.getBaseRiserType() == 2 && this.m_Perspective.getSeriesType(identObj) != 1 && this.m_Perspective.getSeriesType(identObj) != 3 ? this.m_Perspective.getMarkerTemplate(identObj) : new MarkerTemplate(MarkerTemplate.MARKER_SQUARE))) : new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
        return markerTemplate;
    }

    public void loadSpectralVectors() {
        boolean bl = this.m_Perspective.getExactColorByHeight();
        if (bl) {
            this.m_vectStrLabels = this.m_axis.getNumericLabels();
            int n = this.m_vectStrLabels.size();
            int n2 = 0;
            while (n2 < n) {
                IdentObj identObj = new IdentObj(14, n2);
                this.m_vectLabelID.addElement(identObj);
                ++n2;
            }
        } else {
            IdentObj identObj;
            String string;
            double d;
            double d2;
            double d3;
            Vector vector = this.m_axis.getNumericLabelsAsDouble();
            int n = vector.size();
            PfjAssert.pfjAssert(n > 1);
            int n3 = 0;
            while (n3 < n - 1) {
                d3 = (Double)vector.elementAt(n3);
                d2 = (Double)vector.elementAt(n3 + 1);
                d = (d3 + d2) / (double)2;
                if (n3 == 0) {
                    string = String.valueOf(String.valueOf("< ")) + d;
                } else {
                    double d4 = (Double)vector.elementAt(n3 - 1);
                    double d5 = (d4 + d3) / (double)2;
                    string = String.valueOf(d5) + " - " + d;
                }
                this.m_vectStrLabels.addElement(string);
                identObj = new IdentObj(14, n3);
                this.m_vectLabelID.addElement(identObj);
                ++n3;
            }
            d3 = (Double)vector.elementAt(n - 2);
            d2 = (Double)vector.elementAt(n - 1);
            d = (d3 + d2) / (double)2;
            string = String.valueOf(String.valueOf("> ")) + d;
            this.m_vectStrLabels.addElement(string);
            identObj = new IdentObj(14, n3);
            this.m_vectLabelID.addElement(identObj);
        }
        this.loadSpectralMarkerVectors();
        if (this.m_vectStrLabels.size() > 0) {
            this.m_bLabelsExist = true;
        }
    }

    public void loadSpectralMarkerVectors() {
        JChart_Base jChart_Base = this.m_Perspective.getGraphObject();
        Vector vector = this.m_axis.getNumericLabelsAsDouble();
        int n = 0;
        while (n < this.m_vectStrLabels.size()) {
            IdentObj identObj = new IdentObj(18);
            identObj.setMiscID(n);
            this.m_vectMarkerID.addElement(identObj);
            Double d = (Double)vector.elementAt(n);
            double d2 = d;
            double d3 = this.m_axis.getValueRelCoord(d2);
            BlackBoxIF blackBoxIF = jChart_Base.getBlackBox(identObj, d3);
            this.m_vectMarkerBlackBox.addElement(blackBoxIF);
            MarkerTemplate markerTemplate = new MarkerTemplate(MarkerTemplate.MARKER_SQUARE);
            this.m_vectMarkerTemplate.addElement(markerTemplate);
            ++n;
        }
    }

    public int getMinWidth() {
        int n = 0;
        if (this.m_Legend.getLayoutOrient() == 0) {
            FontMetrics fontMetrics = this.getLegendFontMetrics();
            Dimension dimension = new Dimension(0, 0);
            int n2 = 0;
            while (n2 < this.m_vectStrLabels.size()) {
                String string = (String)this.m_vectStrLabels.elementAt(n2);
                if (string != null && string.length() > 0) {
                    int n3 = fontMetrics.stringWidth(string);
                    int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading() - fontMetrics.getLeading();
                    dimension.width = Math.max(dimension.width, n3);
                    dimension.height = Math.max(dimension.height, n4);
                }
                ++n2;
            }
            n = this.m_Perspective.m_VC.destToVirtWidth(dimension.width) * 3 / 2 + this.m_Legend.DOUBLE_BOX_MARGIN_W + 200;
        }
        return n;
    }

    private FontMetrics getLegendFontMetrics() {
        Graphics graphics = this.m_Perspective.getGraphicsContext();
        if (graphics == null) {
            Image image = this.m_Perspective.createOffscreenImage(1, 1);
            graphics = image.getGraphics();
        }
        int n = 0;
        n += (this.m_nFontStyle & 1) != 0 ? 2 : 0;
        Font font = this.m_Perspective.m_fontCache.getFont(this.m_szFontName, n += (this.m_nFontStyle & 2) != 0 ? 1 : 0, this.m_nFontSize);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        return fontMetrics;
    }

    private int getDisplayLines(int n, VC vC) {
        int n2 = vC.destToVirtHeight(7);
        int n3 = this.m_Perspective.getLegendRect().height - this.m_Legend.DOUBLE_BOX_MARGIN_HT;
        int n4 = n3 - (this.m_Legend.getNumOfRows() - 1) * n2;
        int n5 = n * this.m_Legend.getNumOfRows();
        return n4 / n5;
    }

    public int getNumLabels() {
        int n = 0;
        if (this.m_vectStrLabels != null) {
            n = this.m_vectStrLabels.size();
        }
        return n;
    }

    public Vector getLabels() {
        return this.m_vectStrLabels;
    }

    public double getPinPosFromMarker(IdentObj identObj) {
        int n = identObj.getSeriesID();
        if (n == -3) {
            n = 0;
        }
        double d = this.getNumLabels() == 1 ? 1.0 : 1.0 / (double)(this.getNumLabels() - 1);
        double d2 = (double)n * d;
        PfjAssert.pfjAssert(d2 >= 0.0 && d2 <= 1.0);
        return d2;
    }

    public void setY1Axis(RelativeAxisObj relativeAxisObj) {
        this.m_axis = relativeAxisObj;
    }

    public void releaseReferences() {
        this.m_Perspective = null;
    }

    public Dimension getDimLabelCell() {
        return this.m_dimLabelCell;
    }

    public TextStyleObj getTextStyleObj() {
        return this.m_textStyle;
    }
}

