/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.io.Serializable;
import oracle.dss.graph.pfj.AxisDescriptor;
import oracle.dss.graph.pfj.CategoryIF;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;

public final class JGraphType
implements Serializable {
    static final CategoryIF LOG = Perspective.getInstance("ENGINE.JGraphType");
    static final String JCHART_3D = "JChart_3D";
    static final String JCHART_3D_SURFACE = "JChart_3D_Surf";
    static final String JCHART_2D_BLA = "JChart_2D_BLA";
    static final String JCHART_2D_HILO = "JChart_2D_Hilo";
    static final String JCHART_2D_SCAT = "JChart_2D_Scat";
    static final String JCHART_2D_SPEC = "JChart_2D_Spec";
    static final String JCHART_2D_HIST = "JChart_2D_Hist";
    static final String JCHART_2D_PIE = "JChart_2D_Pie";
    static final String JCHART_2D_PIEBAR = "JChart_2D_PieBar";
    static final String JCHART_2D_RADAR = "JChart_2D_Radar";
    static final String JCHART_2D_POLAR = "JChart_2D_Polar";
    static final String JCHART_2D_BREAKEVEN = "JChart_2D_Breakeven";
    static final String JCHART_2D_GANTT = "JChart_2D_Gantt";
    static final String JCHART_2D_PARETO = "JChart_2D_Pareto";
    static final String JCHART_2D_RESOURCE = "JChart_2D_Resource";
    static final String JCHART_2D_PPA = "JChart_2D_PPA";
    static final String JCHART_2D_BALSCORE = "JChart_2D_BalScore";
    static final String JCHART_2D_WATERFALL = "JChart_2D_Waterfall";
    public static final int ORIENT_HORZ = 1;
    public static final int ORIENT_VERT = 2;
    public static final int RESIZE_X = 0;
    public static final int RESIZE_Y = 1;
    public static final int RISER_UNSPECIFIED = 0;
    public static final int RISER_BAR = 1;
    public static final int RISER_MARKER = 2;
    public static final int RISER_AREA = 3;
    public static final int RISER_3D_BAR = 4;
    public static final int RISER_3D_FLOATING = 5;
    public static final int RISER_3D_CONN_SERIES = 6;
    public static final int RISER_3D_SURFACE = 7;
    public static final int RISER_3D_MARKER = 8;
    public static final int RISER_SLICE = 9;
    public static final int RISER_CELL = 10;
    public static final int RISER_3D_CONN_GROUPS = 11;
    public static final int PARETO_LINE_BAR = 12;
    public static final int SCALING_ABSOLUTE = 1;
    public static final int SCALING_STACKED = 2;
    public static final int SCALING_PERCENT = 3;
    public static final int SCALING_HIST = 4;
    public static final int SCALING_WATERFALL = 5;
    public static final int THREED_BAR = 0;
    public static final int THREED_PYRAMID = 1;
    public static final int THREED_OCTAGON = 2;
    public static final int THREED_CUBE = 4;
    public static final int THREED_DIAMOND = 5;
    public static final int THREED_AREASERIES = 6;
    public static final int THREED_RIBBONSERIES = 7;
    public static final int THREED_AREAGROUP = 9;
    public static final int THREED_RIBBONGROUP = 10;
    public static final int THREED_SURFACE = 12;
    public static final int THREED_SURFACESIDES = 13;
    public static final int THREED_SURFACEHONEYCOMB = 14;
    public static final int BARVERT_SIDESIDE = 17;
    public static final int BARVERT_STACKED = 18;
    public static final int BARVERT_SIDEDUAL = 19;
    public static final int BARVERT_STACKEDDUAL = 20;
    public static final int BARVERT_SIDEBIPOLAR = 21;
    public static final int BARVERT_STACKEDBIPOLAR = 22;
    public static final int BARVERT_PERCENT = 23;
    public static final int BARHORIZ_SIDESIDE = 24;
    public static final int BARHORIZ_STACKED = 25;
    public static final int BARHORIZ_SIDEDUAL = 26;
    public static final int BARHORIZ_STACKEDDUAL = 27;
    public static final int BARHORIZ_SIDEBIPOLAR = 28;
    public static final int BARHORIZ_STACKEDBIPOLAR = 29;
    public static final int BARHORIZ_PERCENT = 30;
    public static final int AREAVERT_ABS = 31;
    public static final int AREAVERT_STACKED = 32;
    public static final int AREAVERT_ABSBIPOLAR = 33;
    public static final int AREAVERT_STACKEDBIPOLAR = 34;
    public static final int AREAVERT_PERCENT = 35;
    public static final int AREAHORIZ_ABS = 36;
    public static final int AREAHORIZ_STACKED = 37;
    public static final int AREAHORIZ_ABSBIPOLAR = 38;
    public static final int AREAHORIZ_STACKEDBIPOLAR = 39;
    public static final int AREAHORIZ_PERCENT = 40;
    public static final int LINEVERT_ABS = 41;
    public static final int LINEVERT_STACKED = 42;
    public static final int LINEVERT_ABSDUAL = 43;
    public static final int LINEVERT_STACKEDDUAL = 44;
    public static final int LINEVERT_ABSBIPOLAR = 45;
    public static final int LINEVERT_STACKEDBIPOLAR = 46;
    public static final int LINEVERT_PERCENT = 47;
    public static final int LINEHORIZ_ABS = 48;
    public static final int LINEHORIZ_STACKED = 49;
    public static final int LINEHORIZ_ABSDUAL = 50;
    public static final int LINEHORIZ_STACKEDDUAL = 51;
    public static final int LINEHORIZ_ABSBIPOLAR = 52;
    public static final int LINEHORIZ_STACKEDBIPOLAR = 53;
    public static final int LINEHORIZ_PERCENT = 54;
    public static final int PIE = 55;
    public static final int PIE_RING = 56;
    public static final int PIE_MULT = 57;
    public static final int PIE_RINGMULT = 58;
    public static final int PIE_MULTPROP = 59;
    public static final int PIE_RINGMULTPROP = 60;
    public static final int SCATTER = 61;
    public static final int SCATTER_DUAL = 62;
    public static final int SCATTER_LABELS = 63;
    public static final int SCATTER_LABELSDUAL = 64;
    public static final int POLAR = 65;
    public static final int POLAR_DUAL = 66;
    public static final int RADAR_LINE = 67;
    public static final int RADAR_AREA = 68;
    public static final int RADAR_LINE_DUAL = 69;
    public static final int STOCKHILO = 73;
    public static final int STOCKHILO_DUAL = 74;
    public static final int STOCKHILO_BIPOLAR = 75;
    public static final int STOCKHILO_CLOSE = 76;
    public static final int STOCKHILO_CLOSEDUAL = 77;
    public static final int STOCKHILO_CLOSEBIPOLAR = 78;
    public static final int STOCKHILO_OPENCLOSE = 79;
    public static final int STOCKHILO_OPENCLOSEDUAL = 80;
    public static final int STOCKHILO_OPENCLOSEBIPOLAR = 81;
    public static final int STOCKHILO_VOLUME = 82;
    public static final int STOCKHILO_CLOSE_VOLUME = 88;
    public static final int STOCKHILO_OPENCLOSE_VOLUME = 83;
    public static final int STOCKHILO_CANDLE = 70;
    public static final int STOCKHILO_CANDLE_VOLUME = 71;
    public static final int STOCK_CANDLE = 72;
    public static final int STOCK_CANDLE_VOLUME = 84;
    public static final int HIST_VERT = 85;
    public static final int HIST_HORIZ = 86;
    public static final int SPECTRAL = 87;
    public static final int BUBBLE = 89;
    public static final int BUBBLE_LABELS = 90;
    public static final int BUBBLE_DUAL = 91;
    public static final int BUBBLE_LABELSDUAL = 92;
    public static final int PIE_BAR = 93;
    public static final int PIE_BAR_RING = 94;
    public static final int RESOURCE_RETURN = 95;
    public static final int PRODUCT_POSITIONING = 96;
    public static final int BALANCED_SCORECARD = 97;
    public static final int BREAKEVEN = 98;
    public static final int GANTT = 99;
    public static final int WATERFALL_VERT = 100;
    public static final int WATERFALL_HORZ = 101;
    public static final int PARETO = 102;
    public static final int BARVERT_SIDESIDE_THREEY = 103;
    public static final int BARVERT_SIDESIDE_FOURY = 104;
    public static final int BARVERT_SIDESIDE_FIVEY = 105;
    public static final JGraphType JGT_THREED_BAR = new JGraphType(0, "THREED_BAR", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_PYRAMID = new JGraphType(1, "THREED_PYRAMID", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_OCTAGON = new JGraphType(2, "THREED_OCTAGON", "JChart_3D", 4, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_CUBE = new JGraphType(4, "THREED_CUBE", "JChart_3D", 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_DIAMOND = new JGraphType(5, "THREED_DIAMOND", "JChart_3D", 5, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREASERIES = new JGraphType(6, "THREED_AREASERIES", "JChart_3D", 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONSERIES = new JGraphType(7, "THREED_RIBBONSERIES", "JChart_3D", 6, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_AREAGROUP = new JGraphType(9, "THREED_AREAGROUP", "JChart_3D", 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_RIBBONGROUP = new JGraphType(10, "THREED_RIBBONGROUP", "JChart_3D", 11, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACE = new JGraphType(12, "THREED_SURFACE", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACESIDES = new JGraphType(13, "THREED_SURFACESIDES", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_THREED_SURFACEHONEYCOMB = new JGraphType(14, "THREED_SURFACEHONEYCOMB", "JChart_3D_Surf", 7, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_BARVERT_SIDESIDE = new JGraphType(17, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_STACKED = new JGraphType(18, "BARVERT_STACKED", "JChart_2D_BLA", 1, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARVERT_SIDEDUAL = new JGraphType(19, "BARVERT_SIDEDUAL", "JChart_2D_BLA", 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDDUAL = new JGraphType(20, "BARVERT_STACKEDDUAL", "JChart_2D_BLA", 1, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_SIDEBIPOLAR = new JGraphType(21, "BARVERT_SIDEBIPOLAR", "JChart_2D_BLA", 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_STACKEDBIPOLAR = new JGraphType(22, "BARVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 1, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARVERT_PERCENT = new JGraphType(23, "BARVERT_PERCENT", "JChart_2D_BLA", 1, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDESIDE = new JGraphType(24, "BARHORIZ_SIDESIDE", "JChart_2D_BLA", 1, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_STACKED = new JGraphType(25, "BARHORIZ_STACKED", "JChart_2D_BLA", 1, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BARHORIZ_SIDEDUAL = new JGraphType(26, "BARHORIZ_SIDEDUAL", "JChart_2D_BLA", 1, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDDUAL = new JGraphType(27, "BARHORIZ_STACKEDDUAL", "JChart_2D_BLA", 1, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_SIDEBIPOLAR = new JGraphType(28, "BARHORIZ_SIDEBIPOLAR", "JChart_2D_BLA", 1, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_STACKEDBIPOLAR = new JGraphType(29, "BARHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 1, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_BARHORIZ_PERCENT = new JGraphType(30, "BARHORIZ_PERCENT", "JChart_2D_BLA", 1, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABS = new JGraphType(31, "AREAVERT_ABS", "JChart_2D_BLA", 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_STACKED = new JGraphType(32, "AREAVERT_STACKED", "JChart_2D_BLA", 3, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAVERT_ABSBIPOLAR = new JGraphType(33, "AREAVERT_ABSBIPOLAR", "JChart_2D_BLA", 3, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_STACKEDBIPOLAR = new JGraphType(34, "AREAVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 3, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAVERT_PERCENT = new JGraphType(35, "AREAVERT_PERCENT", "JChart_2D_BLA", 3, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABS = new JGraphType(36, "AREAHORIZ_ABS", "JChart_2D_BLA", 3, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_STACKED = new JGraphType(37, "AREAHORIZ_STACKED", "JChart_2D_BLA", 3, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_AREAHORIZ_ABSBIPOLAR = new JGraphType(38, "AREAHORIZ_ABSBIPOLAR", "JChart_2D_BLA", 3, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_STACKEDBIPOLAR = new JGraphType(39, "AREAHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 3, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_AREAHORIZ_PERCENT = new JGraphType(40, "AREAHORIZ_PERCENT", "JChart_2D_BLA", 3, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABS = new JGraphType(41, "LINEVERT_ABS", "JChart_2D_BLA", 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_STACKED = new JGraphType(42, "LINEVERT_STACKED", "JChart_2D_BLA", 2, false, false, 2, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEVERT_ABSDUAL = new JGraphType(43, "LINEVERT_ABSDUAL", "JChart_2D_BLA", 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDDUAL = new JGraphType(44, "LINEVERT_STACKEDDUAL", "JChart_2D_BLA", 2, true, false, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_ABSBIPOLAR = new JGraphType(45, "LINEVERT_ABSBIPOLAR", "JChart_2D_BLA", 2, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_STACKEDBIPOLAR = new JGraphType(46, "LINEVERT_STACKEDBIPOLAR", "JChart_2D_BLA", 2, true, true, 2, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEVERT_PERCENT = new JGraphType(47, "LINEVERT_PERCENT", "JChart_2D_BLA", 2, false, false, 2, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABS = new JGraphType(48, "LINEHORIZ_ABS", "JChart_2D_BLA", 2, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_STACKED = new JGraphType(49, "LINEHORIZ_STACKED", "JChart_2D_BLA", 2, false, false, 1, 2, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_LINEHORIZ_ABSDUAL = new JGraphType(50, "LINEHORIZ_ABSDUAL", "JChart_2D_BLA", 2, true, false, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDDUAL = new JGraphType(51, "LINEHORIZ_STACKEDDUAL", "JChart_2D_BLA", 2, true, false, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_ABSBIPOLAR = new JGraphType(52, "LINEHORIZ_ABSBIPOLAR", "JChart_2D_BLA", 2, true, true, 1, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_STACKEDBIPOLAR = new JGraphType(53, "LINEHORIZ_STACKEDBIPOLAR", "JChart_2D_BLA", 2, true, true, 1, 2, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_LINEHORIZ_PERCENT = new JGraphType(54, "LINEHORIZ_PERCENT", "JChart_2D_BLA", 2, false, false, 1, 3, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_PIE = new JGraphType(55, "PIE", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RING = new JGraphType(56, "PIE_RING", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULT = new JGraphType(57, "PIE_MULT", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULT = new JGraphType(58, "PIE_RINGMULT", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_MULTPROP = new JGraphType(59, "PIE_MULTPROP", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_RINGMULTPROP = new JGraphType(60, "PIE_RINGMULTPROP", "JChart_2D_Pie", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_SCATTER = new JGraphType(61, "SCATTER", "JChart_2D_Scat", DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_DUAL = new JGraphType(62, "SCATTER_DUAL", "JChart_2D_Scat", DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_SCATTER_LABELS = new JGraphType(63, "SCATTER_LABELS", "JChart_2D_Scat", DataFormat.DF_XY_LBL, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SCATTER_LABELSDUAL = new JGraphType(64, "SCATTER_LABELSDUAL", "JChart_2D_Scat", DataFormat.DF_XY_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_POLAR = new JGraphType(65, "POLAR", "JChart_2D_Polar", DataFormat.DF_XY, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_POLAR_DUAL = new JGraphType(66, "POLAR_DUAL", "JChart_2D_Polar", DataFormat.DF_XY, 2, true, false, 2, 1, AxisDescriptor.AD_XY_DY);
    public static final JGraphType JGT_RADAR_LINE = new JGraphType(67, "RADAR_LINE", "JChart_2D_Radar", 2, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_AREA = new JGraphType(68, "RADAR_AREA", "JChart_2D_Radar", 3, false, false, 2, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_RADAR_LINE_DUAL = new JGraphType(69, "RADAR_LINE_DUAL", "JChart_2D_Radar", 2, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_GANTT = new JGraphType(99, "GANTT", "JChart_2D_Gantt", DataFormat.DF_GANTT, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_STOCKHILO = new JGraphType(73, "STOCKHILO", "JChart_2D_Hilo", DataFormat.DF_HL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_DUAL = new JGraphType(74, "STOCKHILO_DUAL", "JChart_2D_Hilo", DataFormat.DF_HL, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_BIPOLAR = new JGraphType(75, "STOCKHILO_BIPOLAR", "JChart_2D_Hilo", DataFormat.DF_HL, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE = new JGraphType(76, "STOCKHILO_CLOSE", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CLOSEDUAL = new JGraphType(77, "STOCKHILO_CLOSEDUAL", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSEBIPOLAR = new JGraphType(78, "STOCKHILO_CLOSEBIPOLAR", "JChart_2D_Hilo", DataFormat.DF_HLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE = new JGraphType(79, "STOCKHILO_OPENCLOSE", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEDUAL = new JGraphType(80, "STOCKHILO_OPENCLOSEDUAL", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, true, false, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSEBIPOLAR = new JGraphType(81, "STOCKHILO_OPENCLOSEBIPOLAR", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, true, true, 2, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_VOLUME = new JGraphType(82, "STOCKHILO_VOLUME", "JChart_2D_Hilo", DataFormat.DF_HL_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CLOSE_VOLUME = new JGraphType(88, "STOCKHILO_CLOSE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_HLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_OPENCLOSE_VOLUME = new JGraphType(83, "STOCKHILO_OPENCLOSE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD_DY);
    public static final JGraphType JGT_STOCKHILO_CANDLE = new JGraphType(70, "STOCKHILO_CANDLE", "JChart_2D_Hilo", DataFormat.DF_OHLC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCKHILO_CANDLE_VOLUME = new JGraphType(71, "STOCKHILO_CANDLE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OHLC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE = new JGraphType(72, "STOCK_CANDLE", "JChart_2D_Hilo", DataFormat.DF_OC, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_STOCK_CANDLE_VOLUME = new JGraphType(84, "STOCK_CANDLE_VOLUME", "JChart_2D_Hilo", DataFormat.DF_OC_VOL, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_HIST_VERT = new JGraphType(85, "HIST_VERT", "JChart_2D_Hist", 1, false, false, 2, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_HIST_HORIZ = new JGraphType(86, "HIST_HORIZ", "JChart_2D_Hist", 1, false, false, 1, 4, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_SPECTRAL = new JGraphType(87, "SPECTRAL", "JChart_2D_Spec", 2, AxisDescriptor.AD_3D);
    public static final JGraphType JGT_BUBBLE = new JGraphType(89, "BUBBLE", "JChart_2D_Scat", DataFormat.DF_XYZ, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_LABELS = new JGraphType(90, "BUBBLE_LABELS", "JChart_2D_Scat", DataFormat.DF_XYZ_LBL, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BUBBLE_DUAL = new JGraphType(91, "BUBBLE_DUAL", "JChart_2D_Scat", DataFormat.DF_XYZ, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_BUBBLE_LABELSDUAL = new JGraphType(92, "BUBBLE_LABELSDUAL", "JChart_2D_Scat", DataFormat.DF_XYZ_LBL, 2, true, false, 2, 1, AxisDescriptor.AD_XYZ_DY);
    public static final JGraphType JGT_PIE_BAR = new JGraphType(93, "PIE_BAR", "JChart_2D_PieBar", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_PIE_BAR_RING = new JGraphType(94, "PIE_BAR_RING", "JChart_2D_PieBar", 9, AxisDescriptor.AD_PIE);
    public static final JGraphType JGT_RESOURCE_RETURN = new JGraphType(95, "RESOURCE_RETURN", "JChart_2D_Resource", DataFormat.DF_RESOURCE, 1, false, false, 2, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_PRODUCT_POSITIONING = new JGraphType(96, "PRODUCT_POSITIONING", "JChart_2D_PPA", DataFormat.DF_XYZ, 2, AxisDescriptor.AD_XYZ);
    public static final JGraphType JGT_BALANCED_SCORECARD = new JGraphType(97, "BALANCED_SCORECARD", "JChart_2D_BalScore", 1, false, false, 1, 1, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_BREAKEVEN = new JGraphType(98, "BREAKEVEN", "JChart_2D_Breakeven", DataFormat.DF_BREAKEVEN, 2, AxisDescriptor.AD_XY);
    public static final JGraphType JGT_WATERFALL_VERT = new JGraphType(100, "WATERFALL_VERT", "JChart_2D_Waterfall", DataFormat.DF_GENERAL, 1, false, false, 2, 5, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_WATERFALL_HORZ = new JGraphType(101, "WATERFALL_HORZ", "JChart_2D_Waterfall", DataFormat.DF_GENERAL, 1, false, false, 1, 5, AxisDescriptor.AD_STD);
    public static final JGraphType JGT_PARETO = new JGraphType(102, "PARETO", "JChart_2D_Pareto", 12, false, false, 2, 1, AxisDescriptor.AD_PARETO);
    public static final JGraphType JGT_BARVERT_SIDESIDE_THREEY = new JGraphType(103, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_THREEY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FOURY = new JGraphType(104, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_FOURY);
    public static final JGraphType JGT_BARVERT_SIDESIDE_FIVEY = new JGraphType(105, "BARVERT_SIDESIDE", "JChart_2D_BLA", 1, false, false, 2, 1, AxisDescriptor.AD_STD_FIVEY);
    private int m_id;
    private String m_name;
    private String m_class;
    private DataFormat m_dataformat;
    private int m_riserType;
    private boolean m_bDualY;
    private boolean m_bBipolar;
    private int m_orientation;
    private int m_scalingMethod;
    private AxisDescriptor m_axisDescriptor;

    private JGraphType(int n, String string, String string2, int n2, AxisDescriptor axisDescriptor) {
        this(n, string, string2, DataFormat.DF_GENERAL, n2, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int n, String string, String string2, int n2, boolean bl, boolean bl2, int n3, int n4, AxisDescriptor axisDescriptor) {
        this(n, string, string2, DataFormat.DF_GENERAL, n2, bl, bl2, n3, n4, axisDescriptor);
    }

    private JGraphType(int n, String string, String string2, DataFormat dataFormat, int n2, AxisDescriptor axisDescriptor) {
        this(n, string, string2, dataFormat, n2, false, false, 2, 1, axisDescriptor);
    }

    private JGraphType(int n, String string, String string2, DataFormat dataFormat, int n2, boolean bl, boolean bl2, int n3, int n4, AxisDescriptor axisDescriptor) {
        this.m_id = n;
        this.m_name = string;
        this.m_class = string2;
        this.m_dataformat = dataFormat;
        this.m_riserType = n2;
        this.m_bDualY = bl;
        this.m_bBipolar = bl2;
        this.m_orientation = n3;
        this.m_scalingMethod = n4;
        if (bl && !axisDescriptor.hasY2()) {
            LOG.warn(String.valueOf(String.valueOf(">>> DY problem: name = ")) + string);
        }
        this.m_axisDescriptor = axisDescriptor;
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean equals(int n) {
        return n == this.m_id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JGraphType)) {
            return false;
        }
        JGraphType jGraphType = (JGraphType)object;
        return this.m_id == jGraphType.m_id;
    }

    public AxisDescriptor getAxisDescriptor() {
        return this.m_axisDescriptor;
    }

    public String getChartClass() {
        return this.m_class;
    }

    public String getChartName() {
        return this.m_name;
    }

    public DataFormat getDataFormat() {
        return this.m_dataformat;
    }

    public int getIntegerGraphType() {
        return this.m_id;
    }

    public static JGraphType getJGraphType(int n) {
        JGraphType jGraphType = null;
        switch (n) {
            case 0: {
                jGraphType = JGT_THREED_BAR;
                break;
            }
            case 1: {
                jGraphType = JGT_THREED_PYRAMID;
                break;
            }
            case 2: {
                jGraphType = JGT_THREED_OCTAGON;
                break;
            }
            case 4: {
                jGraphType = JGT_THREED_CUBE;
                break;
            }
            case 5: {
                jGraphType = JGT_THREED_DIAMOND;
                break;
            }
            case 6: {
                jGraphType = JGT_THREED_AREASERIES;
                break;
            }
            case 7: {
                jGraphType = JGT_THREED_RIBBONSERIES;
                break;
            }
            case 9: {
                jGraphType = JGT_THREED_AREAGROUP;
                break;
            }
            case 10: {
                jGraphType = JGT_THREED_RIBBONGROUP;
                break;
            }
            case 12: {
                jGraphType = JGT_THREED_SURFACE;
                break;
            }
            case 13: {
                jGraphType = JGT_THREED_SURFACESIDES;
                break;
            }
            case 14: {
                jGraphType = JGT_THREED_SURFACEHONEYCOMB;
                break;
            }
            case 17: {
                jGraphType = JGT_BARVERT_SIDESIDE;
                break;
            }
            case 18: {
                jGraphType = JGT_BARVERT_STACKED;
                break;
            }
            case 19: {
                jGraphType = JGT_BARVERT_SIDEDUAL;
                break;
            }
            case 20: {
                jGraphType = JGT_BARVERT_STACKEDDUAL;
                break;
            }
            case 21: {
                jGraphType = JGT_BARVERT_SIDEBIPOLAR;
                break;
            }
            case 22: {
                jGraphType = JGT_BARVERT_STACKEDBIPOLAR;
                break;
            }
            case 23: {
                jGraphType = JGT_BARVERT_PERCENT;
                break;
            }
            case 24: {
                jGraphType = JGT_BARHORIZ_SIDESIDE;
                break;
            }
            case 25: {
                jGraphType = JGT_BARHORIZ_STACKED;
                break;
            }
            case 26: {
                jGraphType = JGT_BARHORIZ_SIDEDUAL;
                break;
            }
            case 27: {
                jGraphType = JGT_BARHORIZ_STACKEDDUAL;
                break;
            }
            case 28: {
                jGraphType = JGT_BARHORIZ_SIDEBIPOLAR;
                break;
            }
            case 29: {
                jGraphType = JGT_BARHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 30: {
                jGraphType = JGT_BARHORIZ_PERCENT;
                break;
            }
            case 31: {
                jGraphType = JGT_AREAVERT_ABS;
                break;
            }
            case 32: {
                jGraphType = JGT_AREAVERT_STACKED;
                break;
            }
            case 33: {
                jGraphType = JGT_AREAVERT_ABSBIPOLAR;
                break;
            }
            case 34: {
                jGraphType = JGT_AREAVERT_STACKEDBIPOLAR;
                break;
            }
            case 35: {
                jGraphType = JGT_AREAVERT_PERCENT;
                break;
            }
            case 36: {
                jGraphType = JGT_AREAHORIZ_ABS;
                break;
            }
            case 37: {
                jGraphType = JGT_AREAHORIZ_STACKED;
                break;
            }
            case 38: {
                jGraphType = JGT_AREAHORIZ_ABSBIPOLAR;
                break;
            }
            case 39: {
                jGraphType = JGT_AREAHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 40: {
                jGraphType = JGT_AREAHORIZ_PERCENT;
                break;
            }
            case 41: {
                jGraphType = JGT_LINEVERT_ABS;
                break;
            }
            case 42: {
                jGraphType = JGT_LINEVERT_STACKED;
                break;
            }
            case 43: {
                jGraphType = JGT_LINEVERT_ABSDUAL;
                break;
            }
            case 44: {
                jGraphType = JGT_LINEVERT_STACKEDDUAL;
                break;
            }
            case 45: {
                jGraphType = JGT_LINEVERT_ABSBIPOLAR;
                break;
            }
            case 46: {
                jGraphType = JGT_LINEVERT_STACKEDBIPOLAR;
                break;
            }
            case 47: {
                jGraphType = JGT_LINEVERT_PERCENT;
                break;
            }
            case 48: {
                jGraphType = JGT_LINEHORIZ_ABS;
                break;
            }
            case 49: {
                jGraphType = JGT_LINEHORIZ_STACKED;
                break;
            }
            case 50: {
                jGraphType = JGT_LINEHORIZ_ABSDUAL;
                break;
            }
            case 51: {
                jGraphType = JGT_LINEHORIZ_STACKEDDUAL;
                break;
            }
            case 52: {
                jGraphType = JGT_LINEHORIZ_ABSBIPOLAR;
                break;
            }
            case 53: {
                jGraphType = JGT_LINEHORIZ_STACKEDBIPOLAR;
                break;
            }
            case 54: {
                jGraphType = JGT_LINEHORIZ_PERCENT;
                break;
            }
            case 55: {
                jGraphType = JGT_PIE;
                break;
            }
            case 56: {
                jGraphType = JGT_PIE_RING;
                break;
            }
            case 57: {
                jGraphType = JGT_PIE_MULT;
                break;
            }
            case 58: {
                jGraphType = JGT_PIE_RINGMULT;
                break;
            }
            case 59: {
                jGraphType = JGT_PIE_MULTPROP;
                break;
            }
            case 60: {
                jGraphType = JGT_PIE_RINGMULTPROP;
                break;
            }
            case 93: {
                jGraphType = JGT_PIE_BAR;
                break;
            }
            case 94: {
                jGraphType = JGT_PIE_BAR_RING;
                break;
            }
            case 61: {
                jGraphType = JGT_SCATTER;
                break;
            }
            case 62: {
                jGraphType = JGT_SCATTER_DUAL;
                break;
            }
            case 63: {
                jGraphType = JGT_SCATTER_LABELS;
                break;
            }
            case 64: {
                jGraphType = JGT_SCATTER_LABELSDUAL;
                break;
            }
            case 65: {
                jGraphType = JGT_POLAR;
                break;
            }
            case 66: {
                jGraphType = JGT_POLAR_DUAL;
                break;
            }
            case 67: {
                jGraphType = JGT_RADAR_LINE;
                break;
            }
            case 68: {
                jGraphType = JGT_RADAR_AREA;
                break;
            }
            case 69: {
                jGraphType = JGT_RADAR_LINE_DUAL;
                break;
            }
            case 73: {
                jGraphType = JGT_STOCKHILO;
                break;
            }
            case 74: {
                jGraphType = JGT_STOCKHILO_DUAL;
                break;
            }
            case 75: {
                jGraphType = JGT_STOCKHILO_BIPOLAR;
                break;
            }
            case 76: {
                jGraphType = JGT_STOCKHILO_CLOSE;
                break;
            }
            case 77: {
                jGraphType = JGT_STOCKHILO_CLOSEDUAL;
                break;
            }
            case 78: {
                jGraphType = JGT_STOCKHILO_CLOSEBIPOLAR;
                break;
            }
            case 79: {
                jGraphType = JGT_STOCKHILO_OPENCLOSE;
                break;
            }
            case 80: {
                jGraphType = JGT_STOCKHILO_OPENCLOSEDUAL;
                break;
            }
            case 81: {
                jGraphType = JGT_STOCKHILO_OPENCLOSEBIPOLAR;
                break;
            }
            case 82: {
                jGraphType = JGT_STOCKHILO_VOLUME;
                break;
            }
            case 88: {
                jGraphType = JGT_STOCKHILO_CLOSE_VOLUME;
                break;
            }
            case 83: {
                jGraphType = JGT_STOCKHILO_OPENCLOSE_VOLUME;
                break;
            }
            case 70: {
                jGraphType = JGT_STOCKHILO_CANDLE;
                break;
            }
            case 71: {
                jGraphType = JGT_STOCKHILO_CANDLE_VOLUME;
                break;
            }
            case 72: {
                jGraphType = JGT_STOCK_CANDLE;
                break;
            }
            case 84: {
                jGraphType = JGT_STOCK_CANDLE_VOLUME;
                break;
            }
            case 85: {
                jGraphType = JGT_HIST_VERT;
                break;
            }
            case 86: {
                jGraphType = JGT_HIST_HORIZ;
                break;
            }
            case 87: {
                jGraphType = JGT_SPECTRAL;
                break;
            }
            case 89: {
                jGraphType = JGT_BUBBLE;
                break;
            }
            case 90: {
                jGraphType = JGT_BUBBLE_LABELS;
                break;
            }
            case 91: {
                jGraphType = JGT_BUBBLE_DUAL;
                break;
            }
            case 92: {
                jGraphType = JGT_BUBBLE_LABELSDUAL;
                break;
            }
            case 95: {
                jGraphType = JGT_RESOURCE_RETURN;
                break;
            }
            case 96: {
                jGraphType = JGT_PRODUCT_POSITIONING;
                break;
            }
            case 97: {
                jGraphType = JGT_BALANCED_SCORECARD;
                break;
            }
            case 98: {
                jGraphType = JGT_BREAKEVEN;
                break;
            }
            case 99: {
                jGraphType = JGT_GANTT;
                break;
            }
            case 100: {
                jGraphType = JGT_WATERFALL_VERT;
                break;
            }
            case 101: {
                jGraphType = JGT_WATERFALL_HORZ;
                break;
            }
            case 102: {
                jGraphType = JGT_PARETO;
                break;
            }
            case 103: {
                jGraphType = JGT_BARVERT_SIDESIDE_THREEY;
                break;
            }
            case 104: {
                jGraphType = JGT_BARVERT_SIDESIDE_FOURY;
                break;
            }
            case 105: {
                jGraphType = JGT_BARVERT_SIDESIDE_FIVEY;
            }
        }
        if (jGraphType != null && jGraphType.m_id != n) {
            PfjAssert.pfjAssert(jGraphType.m_id == n, String.valueOf(String.valueOf("graphtype ")) + n + " not found!");
        }
        return jGraphType;
    }

    public int getOrientation() {
        return this.m_orientation;
    }

    public int getRiserType() {
        return this.m_riserType;
    }

    public int getScalingMethod() {
        return this.m_scalingMethod;
    }

    public boolean getCanSwitchDirection() {
        boolean bl = false;
        if (this.getAxisDescriptor().hasX1() && this.getAxisDescriptor().hasY1()) {
            bl = true;
        }
        return bl;
    }

    public int getPreferredResizeDirection() {
        int n = 1;
        if (this.isOrientHorz()) {
            n = 0;
        }
        try {
            if (this.getAxisDescriptor().hasX1()) {
                n = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    public DataItem getPreferredResizeItem() {
        DataFormat dataFormat = this.getDataFormat();
        DataItem dataItem = DataItem.DI_GENERAL;
        try {
            if (this.getAxisDescriptor().hasX1()) {
                dataItem = dataFormat.getDataItem(0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dataItem;
    }

    public boolean is3DConnectGroups() {
        return this.getRiserType() == 11;
    }

    public boolean is3DConnectSeries() {
        return this.getRiserType() == 6;
    }

    public boolean is3DFloating() {
        return this.getRiserType() == 5;
    }

    public boolean is3DRiser() {
        return this.getRiserType() == 4;
    }

    public boolean is3DSurface() {
        return this.getRiserType() == 7;
    }

    public boolean is3DRaisedOrigin() {
        return this.is3DFloating() || this.is3DRibbonType();
    }

    public boolean is3DRibbonType() {
        return this.m_id == 7 || this.m_id == 10;
    }

    public boolean is3DType() {
        boolean bl = this.m_class.equals(JCHART_3D) || this.m_class.equals(JCHART_3D_SURFACE);
        return bl;
    }

    public boolean isBalScore() {
        return this.m_class.equals(JCHART_2D_BALSCORE);
    }

    public boolean isBipolar() {
        return this.m_bBipolar;
    }

    public boolean isDualY() {
        return this.m_bDualY;
    }

    public boolean isThreeY() {
        return this.m_id == 103;
    }

    public boolean isFourY() {
        return this.m_id == 104;
    }

    public boolean isFiveY() {
        return this.m_id == 105;
    }

    public boolean isMultiY() {
        boolean bl = this.isThreeY() || this.isFourY() || this.isFiveY();
        return bl;
    }

    public boolean isExceptionalAllowed() {
        boolean bl = true;
        if (this.isRiserArea() || this.is3DConnectGroups() || this.is3DConnectSeries() || this.is3DSurface()) {
            bl = false;
        } else if (!(!this.isRiserMarker() || this.isScatter() || this.isBubble() || this.isPolar() || this.isSpectralMap())) {
            bl = false;
        }
        if (!this.m_dataformat.equals(DataFormat.DF_GENERAL)) {
            bl = false;
        }
        return bl;
    }

    public boolean isOrientHorz() {
        boolean bl = this.m_orientation == 1;
        return bl;
    }

    public boolean isPercent() {
        return this.getScalingMethod() == 3;
    }

    public boolean isBLAType() {
        return this.m_class.equals(JCHART_2D_BLA) || this.m_class.equals(JCHART_2D_PARETO);
    }

    public boolean isLAType() {
        switch (this.m_id) {
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return true;
            }
        }
        return false;
    }

    public boolean isPieType() {
        return this.m_class.equals(JCHART_2D_PIE) || this.m_class.equals(JCHART_2D_PIEBAR);
    }

    public boolean isPieBarType() {
        return this.m_class.equals(JCHART_2D_PIEBAR);
    }

    public boolean isRadarType() {
        return this.m_class.equals(JCHART_2D_RADAR);
    }

    public boolean isResourceReturn() {
        return this.m_class.equals(JCHART_2D_RESOURCE);
    }

    public boolean isWaterfall() {
        return this.m_class.equals(JCHART_2D_WATERFALL);
    }

    public boolean isRiserArea() {
        boolean bl = this.m_riserType == 3;
        return bl;
    }

    public boolean isRiserBar() {
        boolean bl = this.m_riserType == 1;
        return bl;
    }

    public boolean isRiserUnspecified() {
        boolean bl = this.m_riserType == 0;
        return bl;
    }

    public boolean isRiserLine() {
        boolean bl = this.isRiserMarker();
        return bl && (this.isBLAType() || this.isRadarType());
    }

    public boolean isRiserMarker() {
        boolean bl = this.m_riserType == 2 || this.m_riserType == 8;
        return bl;
    }

    public boolean isScalingAbs() {
        return this.m_scalingMethod == 1;
    }

    public boolean isScalingPercent() {
        return this.m_scalingMethod == 3;
    }

    public boolean isScalingStacked() {
        return this.m_scalingMethod == 2;
    }

    public boolean isScalingWaterfall() {
        return this.m_scalingMethod == 5;
    }

    public boolean isBubble() {
        return this.m_name.equals("BUBBLE") || this.m_name.equals("BUBBLE_LABELS") || this.m_name.equals("BUBBLE_DUAL") || this.m_name.equals("BUBBLE_LABELSDUAL");
    }

    public boolean isSpectralMap() {
        return this.m_name.equals("SPECTRAL");
    }

    public boolean isPolar() {
        return this.m_name.equals("POLAR") || this.m_name.equals("POLAR_DUAL");
    }

    public boolean isHistogram() {
        return this.m_name.equals("HIST_VERT") || this.m_name.equals("HIST_HORIZ");
    }

    public boolean isHoneyComb() {
        return this.m_name.equals("THREED_SURFACEHONEYCOMB");
    }

    public boolean isSurfaceWithSides() {
        return this.m_name.equals("THREED_SURFACESIDES");
    }

    public boolean isScatter() {
        return this.m_name.equals("SCATTER") || this.m_name.equals("SCATTER_DUAL") || this.m_name.equals("SCATTER_LABELS") || this.m_name.equals("SCATTER_LABELSDUAL");
    }

    public boolean isScatterWithLabel() {
        return this.m_name.equals("SCATTER_LABELS") || this.m_name.equals("SCATTER_LABELSDUAL") || this.m_name.equals("BUBBLE_LABELS") || this.m_name.equals("BUBBLE_LABELSDUAL");
    }

    public boolean isStockCandleType() {
        return this.m_name.equals("STOCKHILO_CANDLE") || this.m_name.equals("STOCKHILO_CANDLE_VOLUME") || this.m_name.equals("STOCK_CANDLE") || this.m_name.equals("STOCK_CANDLE_VOLUME");
    }

    public boolean isStockType() {
        return this.m_class.equals(JCHART_2D_HILO);
    }

    public boolean isStockTypeWithVolume() {
        return this.m_class.equals(JCHART_2D_HILO) && (this.m_name.equals("STOCKHILO_VOLUME") || this.m_name.equals("STOCKHILO_CLOSE_VOLUME") || this.m_name.equals("STOCKHILO_OPENCLOSE_VOLUME") || this.m_name.equals("STOCKHILO_CANDLE_VOLUME") || this.m_name.equals("STOCK_CANDLE_VOLUME"));
    }

    public String toString() {
        return this.m_name;
    }

    public boolean wantDepthEffect() {
        return this.isBLAType() || this.isScatter() || this.isBubble() || this.isPolar() || this.isBalScore();
    }

    public boolean isParetoType() {
        return this.m_class.equals(JCHART_2D_PARETO);
    }
}

