/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Vector;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.DataItem;
import oracle.dss.graph.pfj.DatumObj;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Standard;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Scat
extends JChart_2D_Standard {
    static final int HORZ_QUAD_LINE = 500;
    static final int VERT_QUAD_LINE = 600;
    private static final double BUBBLE_MAX_DIAMETER_PERCENT = 0.275;
    private static final double BUBBLE_MIN_AREA_PERCENT = 5.0E-5;
    private static final int FRAME_EDGE_BUFFER = 3;
    private static final double BUBBLE_MIN_DEST_DIAMETER = 5.0;
    private static final int T1_MIN = 15;
    private static final int T1_MAX = 45;
    private static final int T2_MIN = 30;
    private static final int T2_MAX = 180;
    private static final double FLOOR_PERCENT = 0.15;
    private static final int S1_MIN = 5;
    private static final int S1_MAX = 20;
    private static final int S2_MIN = 30;
    private static final int S2_MAX = 100;
    private static final double CEIL_PERCENT = 0.005;
    private int[][] m_bubbleSizes;
    private int[][] m_bubbleSizesX;
    private int[][] m_bubbleSizesY;

    public void calc() {
        super.calc();
        if (this.m_Perspective.getConnectScatterMarkers()) {
            this.drawLines(false);
        }
        this.drawFitLines();
        this.drawQuadrantLines();
        if (this.m_nDepthRadius > 0) {
            this.drawAllMarkersWithDepth(false);
        } else {
            this.drawMarkers();
        }
        this.drawLabels();
    }

    protected void calcBubbleSizes(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        int n;
        this.m_bubbleSizesX = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizesY = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_bubbleSizes = null;
        int n2 = this.m_nTotalSeries * this.m_nTotalGroups;
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        int n3 = 0;
        int n4 = 0;
        VC vC = this.m_Perspective.getVC();
        Rectangle rectangle = this.m_Perspective.getRect(this.m_Perspective.getFrame());
        int n5 = vC.virtToDestWidth(rectangle.width);
        if (n5 < 1) {
            n5 = 1;
        }
        if ((n = vC.virtToDestHeight(rectangle.height)) < 1) {
            n = 1;
        }
        boolean bl = rectangle.height / n > rectangle.width / n5;
        this.m_bubbleSizes = bl ? this.m_bubbleSizesY : this.m_bubbleSizesX;
        double d7 = 5.0E-5;
        double d8 = d7 * (double)n5 * (double)n;
        double d9 = 0.0;
        d9 = n5 < n ? 0.275 * (double)n5 : 0.275 * (double)n;
        double d10 = Math.PI * (d9 / 2.0) * (d9 / 2.0);
        double d11 = Math.ceil(2.0 * Math.sqrt(d8 / Math.PI));
        if (d11 < (d6 = 5.0)) {
            d11 = d6;
            d8 = Math.PI * (d11 / 2.0) * (d11 / 2.0);
        }
        if (d9 < d11) {
            d5 = d9;
            d9 = d11;
            d11 = d5;
            d4 = d10;
            d10 = d8;
            d8 = d4;
        }
        d5 = 0.0;
        d4 = 0.0;
        if (bl) {
            d4 = vC.destToVirtHeight((int)Math.ceil(d11));
            d5 = vC.destToVirtHeight((int)Math.ceil(d9));
        } else {
            d4 = vC.destToVirtWidth((int)Math.ceil(d11));
            d5 = vC.destToVirtWidth((int)Math.ceil(d9));
        }
        double d12 = Math.PI * (d4 / 2.0) * (d4 / 2.0);
        double d13 = d3 = Math.PI * (d5 / 2.0) * (d5 / 2.0);
        double d14 = d12;
        double[] dArray = null;
        dArray = this._adjustBubbleSizeRangeForCount(d14, d13, d12, d3, groupsEnumerator, seriesEnumerator);
        d12 = dArray[0];
        d3 = dArray[1];
        dArray = this._adjustBubbleSizeRangeForDataRange(d14, d13, d12, d3, d, d2);
        d12 = dArray[0];
        d3 = dArray[1];
        double d15 = d3 - d12;
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            n3 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                int n6;
                n4 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalGroups);
                double d16 = this.getRelZVal(n3, n4, n2);
                double d17 = d12 + d16 * d15;
                int n7 = (int)Math.ceil(2.0 * Math.sqrt(d17 / Math.PI));
                if (bl) {
                    this.m_bubbleSizesY[n3][n4] = n7;
                    n6 = vC.virtToDestHeight(n7);
                    this.m_bubbleSizesX[n3][n4] = vC.destToVirtWidth(n6);
                    continue;
                }
                this.m_bubbleSizesX[n3][n4] = n7;
                n6 = vC.virtToDestWidth(n7);
                this.m_bubbleSizesY[n3][n4] = vC.destToVirtHeight(n6);
            }
        }
    }

    private double[] _adjustBubbleSizeRangeForCount(double d, double d2, double d3, double d4, GroupsEnumerator groupsEnumerator, SeriesEnumerator seriesEnumerator) {
        double d5 = d3;
        double d6 = d4;
        int n = this.m_nTotalSeries * this.m_nTotalGroups;
        double d7 = this._calcAverageZRelVal(groupsEnumerator, seriesEnumerator);
        int n2 = 15;
        int n3 = 45;
        int n4 = 30;
        int n5 = 180;
        double d8 = 0.15;
        int n6 = n2 + (int)((1.0 - d7) * (double)(n3 - n2));
        int n7 = n4 + (int)((1.0 - d7) * (double)(n5 - n4));
        double d9 = (1.0 - d8) / (double)(n7 - n6);
        if (n >= n7) {
            d6 = d5 + d8 * (d6 - d5);
        } else if (n >= n6) {
            d6 -= d9 * (double)(n - n6) * (d6 - d5);
        }
        int n8 = 5;
        int n9 = 20;
        int n10 = 30;
        int n11 = 100;
        double d10 = 0.005;
        int n12 = n8 + (int)((1.0 - d7) * (double)(n9 - n8));
        int n13 = n10 + (int)((1.0 - d7) * (double)(n11 - n10));
        double d11 = d10 / (double)(n13 - n12);
        if (n < n12) {
            d5 += d10 * (d6 - d5);
        } else if (n < n13) {
            d5 += (d10 - d11 * (double)(n - n12)) * (d6 - d5);
        }
        return new double[]{d5, d6};
    }

    private double[] _adjustBubbleSizeRangeForDataRange(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3;
        double d8 = d4;
        double d9 = d6 - d5;
        if (d9 != 0.0) {
            double d10;
            double d11;
            double d12;
            double d13 = d12 = d4 / d3;
            if (d6 > 0.0 && d5 > 0.0) {
                d13 = d6 / d5;
            } else if (d6 < 0.0 && d5 < 0.0) {
                d13 = d5 / d6;
            }
            if (d13 < d12 && (d11 = d4 / (d10 = d13) - d3) > 0.0) {
                d7 += d11;
            }
        } else {
            d7 = d8;
        }
        return new double[]{d7, d8};
    }

    private double getRelZVal(int n, int n2, int n3) {
        double d = this.getDataValue((int)n, (int)n2, (DataItem)DataItem.DI_XYZ_Z).m_fValue;
        double d2 = this.m_Z1Axis.getValueRelCoord(d);
        return d2;
    }

    private double _calcAverageZRelVal(GroupsEnumerator groupsEnumerator, SeriesEnumerator seriesEnumerator) {
        double d;
        int n = 0;
        int n2 = 0;
        int n3 = this.m_nTotalGroups * this.m_nTotalSeries;
        double d2 = 0.0;
        seriesEnumerator.reset();
        while (seriesEnumerator.hasMoreElements()) {
            n2 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalSeries);
            groupsEnumerator.reset();
            while (groupsEnumerator.hasMoreElements()) {
                n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                d = this.getRelZVal(n2, n, n3);
                d2 += d;
            }
        }
        d = d2 / (double)n3;
        return d;
    }

    private int _getBubbleSize(int n, int n2) {
        if (this.m_bubbleSizes != null) {
            return this.m_bubbleSizes[n][n2];
        }
        return -1;
    }

    protected int getBubbleSizeX(int n, int n2) {
        if (this.m_bubbleSizesX != null) {
            return this.m_bubbleSizesX[n][n2];
        }
        return -1;
    }

    protected int getBubbleSizeY(int n, int n2) {
        if (this.m_bubbleSizesY != null) {
            return this.m_bubbleSizesY[n][n2];
        }
        return -1;
    }

    protected void drawLabels() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vector = null;
        IdentObj identObj = this.m_Perspective.getDataText();
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n = dataFormat.getNumDataItems();
        Rectangle rectangle = this.m_Perspective.getFrameRect(true);
        if (this.m_gt.isScatterWithLabel() || this.m_bDataTextDisplay) {
            int n2;
            int n3;
            vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2]) continue;
                    vector.addElement(this.m_DataLabel[n3][n2]);
                }
            }
            Dimension dimension = new Dimension(5000, 1600);
            boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
            TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
            int n4 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n4, vector, dimension, this.m_Perspective.m_VC);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2] || this.m_DataLabel[n3][n2] == null) continue;
                    BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
                    Rectangle rectangle2 = this.calcDataValuePosition(n3, n2, dimension);
                    if (rectangle2 == null) continue;
                    IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n3, n2);
                    new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n3][n2], rectangle2, textStyleObj, (BlackBoxIF)blackBoxObj, false, rectangle);
                }
            }
        }
    }

    protected void drawQuadrantLines() {
        IdentObj identObj;
        double d;
        IdentObj identObj2 = this.m_Perspective.getQuadrantLine();
        boolean bl = this.m_gt.isBubble() ? this.m_Perspective.getDisplay(identObj2) : this.m_Perspective.getDisplay(this.m_Perspective.getScatterQuadrantLine());
        if (!bl) {
            return;
        }
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj2);
        blackBoxObj.setBorderColor(this.m_Perspective.getBorderColor(identObj2));
        int n = this.m_Perspective.getLineWidth(identObj2);
        int n2 = this.m_Perspective.getQuadrantLineCountX();
        int n3 = this.m_Perspective.getQuadrantLineCountY();
        Rectangle rectangle = this.m_Perspective.getFrameRect(true);
        int n4 = rectangle.x;
        int n5 = rectangle.x + rectangle.width;
        int n6 = rectangle.y;
        int n7 = rectangle.y + rectangle.height;
        this.m_Perspective.m_yQuad = new double[n3];
        this.m_Perspective.m_xQuad = new double[n2];
        int n8 = 0;
        while (n8 < n3) {
            int n9;
            double d2 = this.m_Perspective.getQuadLineValueY(n8);
            if (d2 == 1.234567E301) {
                n9 = n6 + (n8 + 1) * rectangle.height / (n3 + 1);
                d = (this.m_Y1Axis.getMaxValue() - this.m_Y1Axis.getMinValue()) / (double)(n3 + 1);
                this.m_Perspective.m_yQuad[n8] = this.m_Y1Axis.getMinValue() + (double)(n8 + 1) * d;
            } else {
                n9 = n6 + (int)(this.m_Y1Axis.getValueRelCoord(d2) * (double)rectangle.height);
                this.m_Perspective.m_yQuad[n8] = d2;
            }
            identObj = new IdentObj(identObj2);
            identObj.setMiscID(n8 + 500);
            new DetLine(this.m_Detectiv, identObj, n4, n9, n5, n9, blackBoxObj, this.m_rClip, n);
            ++n8;
        }
        n8 = 0;
        while (n8 < n2) {
            int n10;
            double d3 = this.m_Perspective.getQuadLineValueX(n8);
            if (d3 == 1.234567E301) {
                n10 = n4 + (n8 + 1) * rectangle.width / (n2 + 1);
                d = (this.m_X1Axis.getMaxValue() - this.m_X1Axis.getMinValue()) / (double)(n2 + 1);
                this.m_Perspective.m_xQuad[n8] = this.m_X1Axis.getMinValue() + (double)(n8 + 1) * d;
            } else {
                n10 = n4 + (int)(this.m_X1Axis.getValueRelCoord(d3) * (double)rectangle.width);
                this.m_Perspective.m_xQuad[n8] = d3;
            }
            identObj = new IdentObj(identObj2);
            identObj.setMiscID(n8 + 600);
            new DetLine(this.m_Detectiv, identObj, n10, n6, n10, n7, blackBoxObj, this.m_rClip, n);
            ++n8;
        }
    }

    protected Point getCoords(int n, int n2) {
        Point point = !this.m_bHorz ? new Point(this.m_numXCoords[n][n2], this.m_numYCoords[n][n2]) : new Point(this.m_numYCoords[n][n2], this.m_numXCoords[n][n2]);
        return point;
    }

    public Point2D getDataValuesXY(int n, int n2) throws AssertionException {
        double d = this.getXValue(n, n2);
        double d2 = this.getYValue(n, n2);
        return new Point2D.Double(d, d2);
    }

    public String getLabelValue(int n, int n2) {
        DataItem dataItem = this.m_gt.isBubble() ? DataItem.DI_XYZ_LBL_LBL : DataItem.DI_XY_LBL_LBL;
        String string = this.m_Access.getDataAsString(n, n2, dataItem);
        return string;
    }

    public double getLabelXValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_LBL_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getLabelYValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_LBL_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public int getMarkerSize(int n, int n2) {
        if (this.m_gt.isBubble()) {
            return this._getBubbleSize(n, n2);
        }
        return super.getMarkerSize(n, n2);
    }

    protected Point getVCPositionsXY(int n, double d, double d2) throws AssertionException {
        RelativeAxisObj relativeAxisObj = this.m_X1Axis;
        RelativeAxisObj relativeAxisObj2 = this.whichAxisForSeries(n, null);
        int n2 = (int)relativeAxisObj.getValueCoord(d);
        int n3 = (int)relativeAxisObj2.getValueCoord(d2);
        return new Point(n2, n3);
    }

    public double getXValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_XValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_X;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_YValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getXYZ_ZValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XYZ_Z;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public double getYValue(int n, int n2) throws AssertionException {
        DataItem dataItem = DataItem.DI_XY_Y;
        DatumObj datumObj = this.getDataValue(n, n2, dataItem);
        if (datumObj.m_bOK) {
            return datumObj.m_fValue;
        }
        throw new AssertionException();
    }

    public boolean wantLegend() {
        return true;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        boolean bl = this.m_gt.isBubble();
        String string2 = string;
        string2 = this.ReplaceMacro(string2, "[X]", stringArray[0]);
        string2 = this.ReplaceMacro(string2, "[Y]", stringArray[1]);
        if (bl) {
            string2 = this.ReplaceMacro(string2, "[SIZE]", stringArray[2]);
        }
        return string2;
    }
}

