/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.DataFormat;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.JChart_2D_Circular;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLabel;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;

public class JChart_2D_Radar
extends JChart_2D_Circular {
    public void calc() {
        super.calc();
        if (this.m_nBaseType == 2) {
            if (this.m_Perspective.getConnectLineMarkers()) {
                this.drawLines(true);
            }
            this.drawMarkers();
        } else {
            this.drawRisers();
        }
        if (this.m_Perspective.getTransparentMarkers()) {
            this.drawTransparentMarkers(2);
        }
        this.drawLabels();
    }

    public boolean wantLegend() {
        return true;
    }

    protected String processDataTextTemplate(String[] stringArray, String string) {
        String string2 = string;
        return string2;
    }

    protected void drawLabels() {
        SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
        GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
        Vector<String> vector = null;
        IdentObj identObj = this.m_Perspective.getDataText();
        DataFormat dataFormat = this.m_Access.getDataFormat();
        int n = dataFormat.getNumDataItems();
        Rectangle rectangle = this.m_Perspective.getFrameRect(true);
        if (this.m_bDataTextDisplay) {
            int n2;
            int n3;
            vector = new Vector<String>(this.m_nSeries * this.m_nGroups);
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2]) continue;
                    vector.addElement(this.m_DataLabel[n3][n2]);
                }
            }
            Dimension dimension = new Dimension(5000, 1600);
            boolean bl = this.m_Perspective.getFontSizeAbsolute(identObj);
            TextStyleObj textStyleObj = new TextStyleObj(this.m_Perspective.m_fontCache, this.m_Perspective.getFontName(identObj), this.m_Perspective.getFontStyle(identObj), bl, this.m_Perspective.getFontSize(identObj), this.m_Perspective.getFontSizeVC(identObj), this.m_Perspective.getTextRotation(identObj), this.m_Perspective.getTextJustHoriz(identObj), this.m_Perspective.getTextJustVert(identObj), false, false, this.m_Perspective.getTextWrap(identObj));
            int n4 = bl ? this.m_Perspective.m_VC.destToVirtHeight(this.m_Perspective.getFontSize(identObj)) : this.m_Perspective.getFontSizeVC(identObj);
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            textStyleObj.formatAndAutofit(graphics, this.m_Perspective, this.m_Perspective.getAutofit(new IdentObj(260, -3, -3)), this.m_Perspective.getTextAutofitMin(), this.m_Perspective.getTextAutofitMax(), n4, vector, dimension, this.m_Perspective.m_VC);
            seriesEnumerator.reset();
            while (seriesEnumerator.hasMoreElements()) {
                n3 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_nTotalSeries);
                groupsEnumerator.reset();
                while (groupsEnumerator.hasMoreElements()) {
                    n2 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_nTotalGroups);
                    if (!this.m_dataOK[n3][n2] || this.m_DataLabel[n3][n2] == null) continue;
                    BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj);
                    Rectangle rectangle2 = this.calcDataValuePosition(n3, n2, dimension);
                    if (rectangle2 == null) continue;
                    IdentObj identObj2 = new IdentObj(identObj.getObjectID(), n3, n2);
                    new DetLabel(this.m_Detectiv, identObj2, this.m_DataLabel[n3][n2], rectangle2, textStyleObj, (BlackBoxIF)blackBoxObj, false, rectangle);
                }
            }
        }
    }

    protected Rectangle calcDataValuePosition(int n, int n2, Dimension dimension) {
        int n3 = dimension.width;
        int n4 = dimension.height;
        int n5 = this.m_numXCoords[n][n2];
        int n6 = this.m_numYCoords[n][n2];
        Rectangle rectangle = new Rectangle(n5, n6, n3, n4);
        return rectangle;
    }

    protected void drawLines(boolean bl) {
        SeriesEnumerator seriesEnumerator = this.getResetSeriesEnumerator();
        GroupsEnumerator groupsEnumerator = this.getResetGroupsEnumerator();
        int n = 0;
        int n2 = 0;
        int n3 = Perspective.SOLID;
        boolean bl2 = false;
        while (seriesEnumerator.hasMoreElements()) {
            Point point;
            Point point2;
            BlackBoxIF blackBoxIF;
            int n4 = seriesEnumerator.nextSeries();
            PfjAssert.pfjAssert(n4 >= 0 && n4 < this.m_nTotalSeries);
            if (this.m_seriesTypes[n4] != 2) continue;
            IdentObj identObj = new IdentObj(-3, n4);
            groupsEnumerator.reset();
            if (groupsEnumerator.hasMoreElements()) {
                bl2 = true;
            }
            while (groupsEnumerator.hasMoreElements()) {
                n = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n >= 0 && n < this.m_nTotalGroups);
                if (!groupsEnumerator.hasMoreElements()) continue;
                int n5 = groupsEnumerator.peekAtNextGroup();
                if (this.m_Perspective.isTimeAxis() && this.m_Perspective.getDateFrequency() == 3 && !this.m_dataOK[n4][n5]) {
                    while (groupsEnumerator.hasMoreElements() && !this.m_dataOK[n4][n5]) {
                        n5 = groupsEnumerator.nextGroup();
                        n5 = groupsEnumerator.peekAtNextGroup();
                    }
                }
                PfjAssert.pfjAssert(n5 >= 0 && n5 < this.m_nTotalGroups);
                if (!this.m_dataOK[n4][n] || !this.m_dataOK[n4][n5]) continue;
                blackBoxIF = this.assignSeriesColor(n4, n);
                blackBoxIF.setTransparentBorderColor(false);
                if (blackBoxIF.getFillColor() != null) {
                    blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
                }
                point2 = this.getCoords(n4, n);
                point = this.getCoords(n4, n5);
                n2 = this.m_Perspective.getLineWidth(identObj);
                n3 = this.m_Perspective.getLineStyle(identObj);
                boolean bl3 = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bl4 = this.m_Access.m_DataStorage.isMissingDataFilledIn(n4, n);
                    int n6 = this.m_Perspective.getNumMissingDataSegments();
                    if (bl4 && n6 != 0) {
                        this.drawMissingLineData(n6, point2, point, n4, n, blackBoxIF, n2, n3);
                        bl3 = false;
                    }
                }
                if (!bl3 || blackBoxIF.getTransparentFillColor()) continue;
                new DetLine(this.m_Detectiv, new IdentObj(258, n4, n), point2.x, point2.y, point.x, point.y, blackBoxIF, null, n2, n3);
            }
            if (!bl || !this.m_dataOK[n4][0] || !this.m_dataOK[n4][n] || !bl2) continue;
            point2 = this.getCoords(n4, n);
            point = this.getCoords(n4, 0);
            blackBoxIF = this.assignSeriesColor(n4, n);
            if (blackBoxIF.getFillColor() != null) {
                blackBoxIF.setBorderColor(blackBoxIF.getFillColor());
            }
            n2 = this.m_Perspective.getLineWidth(identObj);
            n3 = this.m_Perspective.getLineStyle(identObj);
            if (blackBoxIF.getTransparentFillColor()) continue;
            new DetLine(this.m_Detectiv, new IdentObj(258, n4, n), point2.x, point2.y, point.x, point.y, blackBoxIF, null, n2, n3);
        }
    }
}

