/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.pfj;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import oracle.dss.graph.pfj.Access;
import oracle.dss.graph.pfj.AssertionException;
import oracle.dss.graph.pfj.AxisTemplate;
import oracle.dss.graph.pfj.GroupsEnumerator;
import oracle.dss.graph.pfj.MinMaxObj;
import oracle.dss.graph.pfj.Perspective;
import oracle.dss.graph.pfj.PfjAssert;
import oracle.dss.graph.pfj.RelativeAxisObj;
import oracle.dss.graph.pfj.SeriesEnumerator;
import oracle.dss.graph.pfj.VC;
import oracle.dss.graph.pfj.draw.BlackBoxIF;
import oracle.dss.graph.pfj.draw.BlackBoxObj;
import oracle.dss.graph.pfj.draw.DetLine;
import oracle.dss.graph.pfj.draw.IdentObj;
import oracle.dss.graph.pfj.draw.TextStyleObj;
import oracle.dss.graph.pfj.math.FP;

public class Axis2DObj
extends RelativeAxisObj {
    private static final int TITLE_HEIGHT = 3;
    private static final int TITLE_HEIGHT_STAGGER = 4;
    protected static final int kAUTOSKIP = 1;
    protected static final int kMANUALSKIP = 2;
    protected static final int MAX_TITLE_SIZE = 1300;
    protected static final int TITLE_AXISLABEL_DISTANCE = 50;
    private static final int TICKSIZE = 250;
    private static final double TICK_DEPTH_FACTOR = 1.15;
    public static final int LABEL_BOUNDS_MARGIN = 300;
    public static final int LABEL_MARGIN_INSIDE = 5;
    public static final int LABEL_MARGIN_OUTSIDE = 10;
    public static final int VERTICAL_LABEL_GAP = 5;
    private static final int DEFAULT_LABEL_VERT_MARGIN = 100;
    private static final int DEFAULT_LABEL_HORZ_MARGIN = 100;
    static final int BACK_WALL = 0;
    static final int LEFT_WALL = 700;
    static final int RIGHT_WALL = 800;
    static final int BOTTOM_WALL = 900;
    static final int GRID_OFFSET = 0;
    static final int TICK_OFFSET = 10000;
    static final int RIGHT_EDGE = 16000;
    static final int RIGHT_MARGIN = 15900;
    static final int LEFT_EDGE = -16000;
    static final int LEFT_MARGIN = -15900;
    static final int BOTTOM_EDGE = -16000;
    static final int BOTTOM_MARGIN = -15900;
    static final int TOP_EDGE = 16000;
    static final int TOP_MARGIN = 15900;
    protected boolean m_bVertScale;
    protected boolean m_bDisplayOnCalc;
    protected boolean m_bLabelStagger;
    Rectangle m_rLegend;
    Rectangle m_rTitle;
    Rectangle m_rSubTitle;
    Rectangle m_rFootnote;
    protected int m_axisLengthVC;
    protected int m_axisOrgVC;
    protected Point m_frameDepthOffset;
    protected Rectangle m_rFrame;

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate axisTemplate, int n, boolean bl, boolean bl2) {
        super(perspective, access, axisTemplate, n, bl2);
        this.initVariables(bl, true);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate axisTemplate, int n, boolean bl, boolean bl2, int n2, int n3) {
        super(perspective, access, axisTemplate, n, bl2, n2, n3);
        this.initVariables(bl, true);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate axisTemplate, MinMaxObj minMaxObj, boolean bl, boolean bl2, int n, int n2, boolean bl3) {
        super(perspective, access, axisTemplate, minMaxObj, bl2, n, n2);
        this.initVariables(bl, bl3);
    }

    public Axis2DObj(Perspective perspective, Access access, AxisTemplate axisTemplate, MinMaxObj minMaxObj, boolean bl, boolean bl2, int n, int n2) {
        this(perspective, access, axisTemplate, minMaxObj, bl, bl2, n, n2, true);
    }

    protected void adjustTitlePosPass1(int n, Vector vector, Rectangle rectangle) {
        if (this.m_bVertScale) {
            if (this.m_gt.isPieBarType()) {
                this.adjustTitleRightmost(vector, rectangle);
            } else {
                switch (n) {
                    case 0: {
                        this.adjustTitleLeftmost(vector, rectangle);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.adjustTitleRightmost(vector, rectangle);
                    }
                }
            }
        } else {
            switch (n) {
                case 1: 
                case 2: {
                    this.adjustTitleHighest(vector, rectangle);
                    break;
                }
                case 0: {
                    this.adjustTitleLowest(vector, rectangle);
                }
            }
        }
    }

    protected void adjustTitleLowest(Vector vector, Rectangle rectangle) {
        int n = 16000;
        int n2 = 0;
        while (n2 < vector.size()) {
            Rectangle rectangle2 = (Rectangle)vector.elementAt(n2);
            n = Math.min(n, rectangle2.y);
            ++n2;
        }
        rectangle.y = n - rectangle.height - this.m_Perspective.m_VC.destToVirtHeight(10);
        if (rectangle.y < -16000) {
            rectangle.y = -15900;
        }
    }

    protected void adjustTitleHighest(Vector vector, Rectangle rectangle) {
        int n = -16000;
        int n2 = 0;
        while (n2 < vector.size()) {
            Rectangle rectangle2 = (Rectangle)vector.elementAt(n2);
            n = Math.max(n, rectangle2.y + rectangle2.height);
            ++n2;
        }
        rectangle.y = n + this.m_Perspective.m_VC.destToVirtHeight(10);
        if (rectangle.y + rectangle.height > 16000) {
            rectangle.y = 15900 - rectangle.height;
        }
    }

    protected void adjustTitleLeftmost(Vector vector, Rectangle rectangle) {
        int n = 16000;
        int n2 = 0;
        while (n2 < vector.size()) {
            Rectangle rectangle2 = (Rectangle)vector.elementAt(n2);
            n = Math.min(n, rectangle2.x);
            ++n2;
        }
        rectangle.x = n - rectangle.width - this.m_Perspective.m_VC.destToVirtWidth(10);
        if (rectangle.x < -16000) {
            rectangle.x = -15900;
        }
    }

    protected void adjustTitleRightmost(Vector vector, Rectangle rectangle) {
        int n = -16000;
        int n2 = 0;
        while (n2 < vector.size()) {
            Rectangle rectangle2 = (Rectangle)vector.elementAt(n2);
            n = Math.max(n, rectangle2.x + rectangle2.width);
            ++n2;
        }
        rectangle.x = n + this.m_Perspective.m_VC.destToVirtWidth(10);
        if (rectangle.x + rectangle.width > 16000) {
            rectangle.x = 15900 - rectangle.width;
        }
    }

    protected void adjustTitlePosPass2(IdentObj identObj, int n, Rectangle rectangle, Dimension dimension) {
    }

    public void calc() {
        IdentObj identObj;
        boolean bl;
        double d = 0.0;
        this.initAxis();
        super.calc();
        if (this.m_Perspective.getAxesPreviewMode()) {
            return;
        }
        if (this.m_bNumericAxis && this.m_Perspective.getDisplay(this.m_template.getZeroLine()) && this.isZeroInRange() && !this.isLogScale()) {
            this.calcZeroLine();
        }
        if ((bl = this.m_Perspective.getNonZeroBaseline(identObj = this.getAxisIdentObj())) && this.m_gt.isScalingAbs() && !this.m_gt.isBubble() && !this.m_gt.isScatter() && !this.m_gt.isStockType() && !this.m_gt.isParetoType()) {
            d = this.m_Perspective.getNonZeroBaselineValue(identObj);
            if (this.isLogScale() && d < 0.0) {
                bl = false;
            }
            if (bl && this.m_bNumericAxis) {
                this.calcNonZeroLine(identObj);
            }
        }
    }

    public void calcAxisBody() {
        if (!this.m_bDisplayOnCalc) {
            return;
        }
        if (!this.m_Perspective.getDisplay(this.m_template.getBody())) {
            return;
        }
        int n = this.getAxisSide();
        Rectangle rectangle = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, this.m_template.getBody());
        int n2 = this.m_Perspective.getLineWidth(this.m_template.getBody());
        if (this.m_bVertScale) {
            if (n == 0 || n == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), rectangle.x - this.m_frameDepthOffset.x, this.m_axisOrgVC - this.m_frameDepthOffset.y, rectangle.x - this.m_frameDepthOffset.x, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.y, blackBoxObj, null, n2);
            }
            if (n == 1 || n == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), rectangle.x + rectangle.width, this.m_axisOrgVC, rectangle.x + rectangle.width, this.m_axisOrgVC + this.m_axisLengthVC, blackBoxObj, null, n2);
            }
        } else {
            if (n == 0 || n == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), this.m_axisOrgVC - this.m_frameDepthOffset.x, rectangle.y - this.m_frameDepthOffset.y, this.m_axisOrgVC + this.m_axisLengthVC - this.m_frameDepthOffset.x, rectangle.y - this.m_frameDepthOffset.y, blackBoxObj, null, n2);
            }
            if (n == 1 || n == 2) {
                new DetLine(this.m_Perspective.getDetectiv(), this.m_template.getBody(), this.m_axisOrgVC, rectangle.y + rectangle.height, this.m_axisOrgVC + this.m_axisLengthVC, rectangle.y + rectangle.height, blackBoxObj, null, n2);
            }
        }
    }

    protected void calcMajorGridLine(IdentObj identObj, double d, BlackBoxIF blackBoxIF) {
        int n = this.m_Perspective.getGridStyle(this.m_template.getMajor());
        if (this.m_Perspective.getGraphType() == 102) {
            boolean bl;
            boolean bl2 = bl = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY2Axis().getObjectID();
            if (bl) {
                n = 3;
            }
        }
        this.calcLineOnFrame(n, d, identObj, blackBoxIF, this.m_Perspective.getLineWidth(this.m_template.getMajor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
    }

    protected void calcMinorGridLine(IdentObj identObj, double d, BlackBoxIF blackBoxIF) {
        if (FP.between(d, 0.0, 1.0)) {
            this.calcLineOnFrame(this.m_Perspective.getGridStyle(this.m_template.getMinor()), d, identObj, blackBoxIF, this.m_Perspective.getLineWidth(this.m_template.getMinor()), this.m_Perspective.getLineStyle(this.m_template.getMajor()));
        }
    }

    protected void calcZeroLine() {
        if (!this.m_bNumericAxis) {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
        this.calcLineOnFrame(0, this.getValueRelCoord(0.0), this.m_template.getZeroLine(), new BlackBoxObj(this.m_Perspective, this.m_template.getZeroLine()), this.m_Perspective.getLineWidth(this.m_template.getZeroLine()), this.m_Perspective.getLineStyle(this.m_template.getZeroLine()));
    }

    public void calcNonZeroLine(IdentObj identObj) {
        IdentObj identObj2;
        IdentObj identObj3;
        if (this.m_bNumericAxis) {
            IdentObj identObj4 = null;
            switch (identObj.getObjectID()) {
                case 2004: {
                    identObj4 = this.m_Perspective.getY1AxisLine();
                    break;
                }
                case 2005: {
                    identObj4 = this.m_Perspective.getY2AxisLine();
                    break;
                }
                case 2003: {
                    identObj4 = this.m_Perspective.getX1AxisLine();
                }
            }
            identObj3 = new IdentObj(253, identObj4.getObjectID(), identObj.getObjectID());
            identObj2 = this.m_Perspective.getNonZeroBaseLineZeroLine(identObj);
            if (!this.m_Perspective.getDisplay(identObj2) || this.m_gt.isRiserLine()) {
                return;
            }
        } else {
            throw new AssertionException("Numerical method called by ordinal axis");
        }
        double d = this.m_Perspective.getNonZeroBaselineValue(identObj);
        BlackBoxObj blackBoxObj = new BlackBoxObj(this.m_Perspective, identObj2);
        blackBoxObj.setBorderColor(this.m_Perspective.getFillColor(this.m_Perspective.getNonZeroBaseLineZeroLine(identObj)));
        this.calcLineOnFrame(0, this.getValueRelCoord(d), identObj3, blackBoxObj, this.m_Perspective.getLineWidth(identObj2), this.m_Perspective.getLineStyle(identObj2));
    }

    protected boolean doDisplayOnCalc() {
        return this.m_bDisplayOnCalc;
    }

    protected boolean isVertical() {
        return this.m_bVertScale;
    }

    protected int getAxisSide() {
        return this.m_Perspective.getAxisSide(this.m_template.getAxis());
    }

    protected boolean isAxisLabelVisible(int n) {
        return true;
    }

    public double getBaseCoord() {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getBaseRelCoord() * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(int n) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(n) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getCenterCoord(double d) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(d) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getHighCoord(int n, int n2) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getHighRelCoord(n, n2) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    protected void getLabelAndTitlePos(int n, int n2, Vector vector, Vector vector2, Vector vector3, Rectangle rectangle, boolean bl, int n3, int n4, int n5, TextStyleObj textStyleObj) {
        Rectangle rectangle2 = this.getSpaceAvailableForLabel(n, this.m_Perspective.m_VC, null);
        boolean bl2 = this.m_bLabelStagger && n2 > 1;
        boolean bl3 = this.m_frameDepthOffset.x >= 0;
        Dimension dimension = this.calcTitleSpace(n, bl2, rectangle2, rectangle);
        if (this.isO1WithNestedLabels() && dimension.height != 0) {
            rectangle2 = this.getSpaceAvailableForLabel(n, this.m_Perspective.m_VC, dimension);
        }
        int n6 = this.getTitleRotation(this.m_template, n);
        int n7 = dimension.height;
        if (n7 > 0) {
            n7 = this.isVertical() ? (n7 += this.m_Perspective.m_VC.destToVirtWidth(10)) : (n7 += this.m_Perspective.m_VC.destToVirtHeight(10));
        }
        this.calcLabelAlignments(n, n2, vector3);
        this.calcLabelPositions(n, n2, vector2, rectangle2, n7, bl2, vector);
        this.calcTitleBox(n, rectangle2, dimension, bl3, rectangle);
    }

    protected void calcLabelPositions(int n, int n2, Vector vector, Rectangle rectangle, int n3, boolean bl, Vector vector2) {
        int n4;
        boolean bl2 = this.m_frameDepthOffset.x >= 0;
        boolean bl3 = this.m_frameDepthOffset.x < 0;
        IdentObj identObj = this.m_template.getLabel();
        int[] nArray = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            double d = (Double)vector.elementAt(n5);
            nArray[n5] = (int)this.scaleToVC(d);
            if (this.m_bVertScale) {
                if (n == 0 && bl2 || n == 1 && bl3) {
                    int n6 = n5;
                    nArray[n6] = nArray[n6] - this.m_frameDepthOffset.y;
                }
            } else if ((bl2 || bl3) && n == 0) {
                int n7 = n5;
                nArray[n7] = nArray[n7] - this.m_frameDepthOffset.x;
            }
            ++n5;
        }
        n5 = !this.m_Perspective.getFontSizeAbsolute(identObj) ? this.m_Perspective.getVC().virtToDestHeight(this.m_Perspective.getFontSizeVC(identObj)) : this.m_Perspective.getFontSize(identObj);
        int n8 = this.m_Perspective.getTextRotation(identObj);
        boolean bl4 = n8 == 2 || n8 == 1;
        int n9 = this.m_bVertScale && !bl4 || !this.m_bVertScale && bl4 ? 5 : TextStyleObj.calcAxisLabelGap(n5);
        n9 = this.m_bVertScale ? this.m_Perspective.getVC().destToVirtHeight(n9) : this.m_Perspective.getVC().destToVirtWidth(n9);
        if (n2 > 1) {
            n4 = Math.abs(nArray[1] - nArray[0]) - n9;
            if (bl) {
                n4 *= 2;
            }
        } else {
            n4 = this.m_bVertScale ? rectangle.height : rectangle.width;
        }
        boolean bl5 = false;
        vector2.removeAllElements();
        int n10 = 0;
        while (n10 < n2) {
            Rectangle rectangle2 = new Rectangle(0, 0, 0, 0);
            if (this.m_bVertScale) {
                rectangle2.y = nArray[n10] - n4 / 2;
                rectangle2.height = n4;
                rectangle2.width = rectangle.width - n3;
                if (bl) {
                    rectangle2.width /= 2;
                    rectangle2.x = rectangle.x;
                    if (!bl5 && n == 0 || bl5 && n == 1) {
                        rectangle2.x += rectangle2.width;
                    }
                } else {
                    rectangle2.x = rectangle.x;
                }
                if (n == 0) {
                    rectangle2.x += n3;
                }
            } else {
                rectangle2.x = this.m_nNestingLevel == 1 ? nArray[n10] : nArray[n10] - n4 / 2;
                rectangle2.width = n4;
                rectangle2.height = rectangle.height - n3;
                if (bl) {
                    rectangle2.height /= 2;
                    rectangle2.y = rectangle.y;
                    if (!bl5 && n == 0 || bl5 && n == 1) {
                        rectangle2.y += rectangle2.height;
                    }
                } else {
                    rectangle2.y = rectangle.y;
                }
                if (n == 0) {
                    rectangle2.y += n3;
                }
            }
            vector2.addElement(rectangle2);
            bl5 = !bl5;
            ++n10;
        }
    }

    private void calcLabelAlignments(int n, int n2, Vector vector) {
        Integer n3 = new Integer(3);
        n3 = n == 0 ? (this.m_bVertScale ? new Integer(5) : new Integer(3)) : (this.m_bVertScale ? new Integer(1) : new Integer(7));
        int n4 = 0;
        while (n4 < n2) {
            vector.insertElementAt(n3, n4);
            ++n4;
        }
    }

    private Dimension calcTitleSpace(int n, boolean bl, Rectangle rectangle, Rectangle rectangle2) {
        Dimension dimension = new Dimension(0, 0);
        IdentObj identObj = this.getTitle();
        String string = this.m_Perspective.getTextString(identObj);
        if (this.m_Perspective.getDisplay(identObj) && string.length() != 0) {
            TextStyleObj textStyleObj = this.getTitleTextStyle(n);
            int n2 = this.getTitleFontSizeVC();
            int n3 = this.m_Perspective.m_VC.virtToDestHeight(n2);
            Graphics graphics = this.m_Perspective.getGraphicsContext();
            Dimension dimension2 = new Dimension(16000, 16000);
            dimension2 = this.m_Perspective.m_VC.virtToDest(dimension2);
            Dimension dimension3 = textStyleObj.getTextSizeDC(graphics, string, n3, this.m_Perspective.m_VC, dimension2, null);
            if (this.isVertical()) {
                dimension.width = this.m_Perspective.m_VC.destToVirtHeight(dimension3.width);
                dimension.height = this.m_Perspective.m_VC.destToVirtWidth(dimension3.height);
            } else {
                dimension.width = this.m_Perspective.m_VC.destToVirtWidth(dimension3.width);
                dimension.height = this.m_Perspective.m_VC.destToVirtHeight(dimension3.height);
            }
        }
        return dimension;
    }

    private void calcTitleBox(int n, Rectangle rectangle, Dimension dimension, boolean bl, Rectangle rectangle2) {
        if (rectangle2 != null) {
            if (this.m_bVertScale) {
                if (this.isNumericAxis()) {
                    rectangle2.y = (int)Math.min(this.getMinCoord(), this.getMaxCoord());
                    rectangle2.height = (int)Math.abs(this.getMaxCoord() - this.getMinCoord());
                } else {
                    rectangle2.y = Math.min(this.m_axisOrgVC, this.m_axisOrgVC + this.m_axisLengthVC);
                    rectangle2.height = Math.abs(this.m_axisLengthVC);
                }
                if (n == 0 && bl) {
                    rectangle2.y -= this.m_frameDepthOffset.y;
                }
                rectangle2.width = dimension.height;
                rectangle2.x = n == 0 ? rectangle.x : rectangle.x + rectangle.width - dimension.height;
            } else {
                if (this.isNumericAxis()) {
                    rectangle2.x = (int)Math.min(this.getMinCoord(), this.getMaxCoord());
                    rectangle2.width = (int)Math.abs(this.getMaxCoord() - this.getMinCoord());
                } else {
                    rectangle2.x = Math.min(this.m_axisOrgVC, this.m_axisOrgVC + this.m_axisLengthVC);
                    rectangle2.width = Math.abs(this.m_axisLengthVC);
                }
                if (n == 0) {
                    rectangle2.x -= this.m_frameDepthOffset.x;
                }
                rectangle2.height = dimension.height;
                rectangle2.y = n == 0 ? rectangle.y : rectangle.y + rectangle.height - dimension.height;
            }
        }
    }

    protected Vector getLabels() {
        if (this.m_bNumericAxis) {
            return this.getNumericLabels();
        }
        int n = this.getNumLabels();
        Vector vector = new Vector(n);
        if (this.useSeriesLabels()) {
            SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
            while (seriesEnumerator.hasMoreElements()) {
                int n2 = seriesEnumerator.nextSeries();
                PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Access.getNumTotalSeries());
                vector.addElement(this.m_Perspective.getSeriesLabel(n2));
            }
        } else if (this.isO1WithNestedLabels()) {
            vector = this.m_cbO1Labels.getAllLabels(this.m_nNestingLevel);
        } else {
            GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
            while (groupsEnumerator.hasMoreElements()) {
                int n3 = groupsEnumerator.nextGroup();
                PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_Access.getNumTotalGroups());
                vector.addElement(this.m_Perspective.getGroupLabel(n3));
            }
        }
        return vector;
    }

    protected Vector getLabelIdents() {
        Vector<IdentObj> vector;
        block4: {
            vector = null;
            if (this.m_bNumericAxis) break block4;
            int n = this.getNumLabels();
            vector = new Vector<IdentObj>(n);
            if (this.useSeriesLabels()) {
                SeriesEnumerator seriesEnumerator = new SeriesEnumerator(this.m_Perspective, this.m_Access, true);
                while (seriesEnumerator.hasMoreElements()) {
                    int n2 = seriesEnumerator.nextSeries();
                    PfjAssert.pfjAssert(n2 >= 0 && n2 < this.m_Access.getNumTotalSeries());
                    vector.addElement(new IdentObj(-3, n2));
                }
            } else {
                GroupsEnumerator groupsEnumerator = new GroupsEnumerator(this.m_Perspective, this.m_Access, true);
                while (groupsEnumerator.hasMoreElements()) {
                    int n3 = groupsEnumerator.nextGroup();
                    PfjAssert.pfjAssert(n3 >= 0 && n3 < this.m_Access.getNumTotalGroups());
                    vector.addElement(new IdentObj(-3, -3, n3));
                }
            }
        }
        return vector;
    }

    public double getLowCoord(double d, double d2) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(d, d2) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getLowCoord(int n, int n2) {
        if (!this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(n, n2) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    protected boolean getMajorGridDisplay(AxisTemplate axisTemplate) {
        return this.m_Perspective.getDisplay(axisTemplate.getMajor());
    }

    protected boolean getMinorGridDisplay(AxisTemplate axisTemplate) {
        return this.m_Perspective.getDisplay(axisTemplate.getMinor());
    }

    public Rectangle getSpaceAvailableForLabel(int n, VC vC, Dimension dimension) {
        Rectangle rectangle = this.getSpaceAvailable(n, vC);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.isO1WithNestedLabels()) {
            rectangle2 = this.getNestedO1SpaceAvailableForLabel(rectangle2, dimension);
        }
        return rectangle2;
    }

    private Rectangle getNestedO1SpaceAvailableForLabel(Rectangle rectangle, Dimension dimension) {
        int n;
        double d = 0.0;
        if (dimension != null) {
            n = this.m_Perspective.m_VC.destToVirtHeight(10);
            rectangle.height -= dimension.height + n;
            rectangle.y += dimension.height + n;
        }
        if (this.m_cbO1Labels != null && (n = this.m_cbO1Labels.getNumLevels()) > 1) {
            if (this.m_bNestedLabelBrackets) {
                d = 0.5;
            }
            double d2 = (double)n + (double)(n - 1) * d;
            if (this.m_bVertScale) {
                double d3 = (double)rectangle.width / d2;
                int n2 = (int)(d3 * d);
                rectangle.width = (int)d3;
                rectangle.x += (rectangle.width + n2) * (n - 1 - this.m_nNestingLevel);
            } else {
                double d4 = (double)rectangle.height / d2;
                int n3 = (int)(d4 * d);
                rectangle.height = (int)d4;
                rectangle.y += (rectangle.height + n3) * (n - 1 - this.m_nNestingLevel);
            }
        }
        return rectangle;
    }

    private Rectangle getSpaceAvailable(int n, VC vC) {
        Rectangle rectangle;
        IdentObj identObj;
        IdentObj identObj2;
        IdentObj identObj3;
        Rectangle rectangle2 = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
        Dimension dimension = vC.getVirtDimension();
        boolean bl = this.m_frameDepthOffset.x >= 0;
        boolean bl2 = this.m_frameDepthOffset.x < 0;
        Rectangle rectangle3 = null;
        Rectangle rectangle4 = null;
        Rectangle rectangle5 = null;
        Rectangle rectangle6 = null;
        IdentObj identObj4 = this.m_Perspective.getLegendArea();
        if (this.m_Perspective.getDisplay(identObj4)) {
            rectangle3 = this.m_Perspective.getRect(identObj4);
        }
        if (this.m_Perspective.getDisplay(identObj3 = this.m_Perspective.getTitle())) {
            rectangle4 = this.m_Perspective.getRect(identObj3);
        }
        if (this.m_Perspective.getDisplay(identObj2 = this.m_Perspective.getSubtitle())) {
            rectangle5 = this.m_Perspective.getRect(identObj2);
        }
        if (this.m_Perspective.getDisplay(identObj = this.m_Perspective.getFootnote())) {
            rectangle6 = this.m_Perspective.getRect(identObj);
        }
        if (n == 0) {
            if (this.m_bVertScale) {
                int n2;
                int n3;
                if (bl) {
                    rectangle2.x -= this.m_frameDepthOffset.x;
                    rectangle2.width += this.m_frameDepthOffset.x;
                    rectangle2.y -= this.m_frameDepthOffset.y;
                }
                rectangle = new Rectangle(-dimension.width / 2, rectangle2.y - 100, rectangle2.x + dimension.width / 2, rectangle2.height + 200);
                if (rectangle3 != null && rectangle3.x + rectangle3.width < rectangle.x + rectangle.width && rectangle3.y + rectangle3.height > rectangle.y && rectangle3.y < rectangle.y + rectangle.height) {
                    n3 = rectangle3.x + rectangle3.width;
                    n2 = rectangle.x + rectangle.width - n3;
                    rectangle.x = n3;
                    rectangle.width = n2;
                }
                n3 = this.m_Perspective.m_VC.destToVirtWidth(5);
                n2 = this.m_Perspective.m_VC.destToVirtWidth(10);
                rectangle.x += n2;
                rectangle.width -= n3 + n2;
            } else {
                int n4;
                if (bl || bl2) {
                    rectangle2.x -= this.m_frameDepthOffset.x;
                    rectangle2.width += this.m_frameDepthOffset.x;
                    rectangle2.y -= this.m_frameDepthOffset.y;
                }
                rectangle = new Rectangle(rectangle2.x - 100, -dimension.height / 2, rectangle2.width + 200, dimension.height / 2 + rectangle2.y);
                int n5 = rectangle.y;
                if (rectangle3 != null && rectangle3.y + rectangle3.height < rectangle.y + rectangle.height && rectangle3.x + rectangle3.width > rectangle.x && rectangle3.x < rectangle.x + rectangle.width) {
                    n5 = rectangle3.y + rectangle3.height;
                }
                if (rectangle6 != null && rectangle6.y + rectangle6.height < rectangle.y + rectangle.height && (n4 = rectangle6.y + rectangle6.height) > n5) {
                    n5 = n4;
                }
                rectangle.height -= n5 - rectangle.y;
                rectangle.y = n5;
                n4 = this.m_Perspective.m_VC.destToVirtHeight(5);
                int n6 = this.m_Perspective.m_VC.destToVirtHeight(10);
                int n7 = this.m_Perspective.getAdditionalBottomAxisMargin();
                if (n7 > 0) {
                    n4 += n7;
                }
                rectangle.y += n6;
                rectangle.height -= n4 + n6;
            }
        } else if (this.m_bVertScale) {
            if (bl2) {
                rectangle2.width -= this.m_frameDepthOffset.x;
                rectangle2.y -= this.m_frameDepthOffset.y;
            }
            rectangle = new Rectangle(rectangle2.x + rectangle2.width, rectangle2.y - 100, dimension.width / 2 - rectangle2.x - rectangle2.width, rectangle2.height + 200);
            if (rectangle3 != null && rectangle3.x > rectangle.x && rectangle3.y + rectangle3.height > rectangle.y && rectangle3.y < rectangle.y + rectangle.height) {
                rectangle.width = rectangle3.x - rectangle.x;
            }
            int n8 = this.m_Perspective.m_VC.destToVirtWidth(5);
            int n9 = this.m_Perspective.m_VC.destToVirtWidth(10);
            rectangle.x += n8;
            rectangle.width -= n8 + n9;
        } else {
            rectangle = new Rectangle(rectangle2.x - 100, rectangle2.y + rectangle2.height, rectangle2.width + 200, dimension.width / 2 - (rectangle2.y + rectangle2.height));
            int n10 = rectangle.y + rectangle.height;
            if (rectangle3 != null && rectangle3.y > rectangle.y && rectangle3.x + rectangle3.width > rectangle.x && rectangle3.x < rectangle.x + rectangle.width) {
                n10 = rectangle3.y;
            }
            if (rectangle4 != null && rectangle4.y > rectangle.y && rectangle4.y < n10) {
                n10 = rectangle4.y;
            }
            if (rectangle5 != null && rectangle5.y > rectangle.y && rectangle5.y < n10) {
                n10 = rectangle5.y;
            }
            rectangle.height = n10 - rectangle.y;
            int n11 = this.m_Perspective.m_VC.destToVirtHeight(5);
            int n12 = this.m_Perspective.m_VC.destToVirtHeight(10);
            rectangle.y += n11;
            rectangle.height -= n11 + n12;
        }
        return rectangle;
    }

    protected int getTitleRotation(AxisTemplate axisTemplate, int n) {
        IdentObj identObj = this.getTitle();
        int n2 = this.m_Perspective.getTextRotation(identObj);
        if (!this.m_Perspective.getMoveAxisTitles()) {
            n2 = n == 0 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(identObj) == 2 ? 2 : 1) : (n == 1 && this.m_bVertScale ? (this.m_Perspective.getTextRotation(identObj) == 1 ? 1 : 2) : 0);
        }
        return n2;
    }

    public double getValueCoord(double d) {
        if (this.m_bNumericAxis) {
            return (double)this.m_axisOrgVC + this.getValueRelCoord(d) * (double)this.m_axisLengthVC;
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public double getValueFromCoord(int n) {
        if (this.m_bNumericAxis) {
            return this.getValueFromRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Numerical method called by ordinal axis");
    }

    public int getGroupAboveCoord(int n) {
        if (!this.m_bNumericAxis) {
            return this.getGroupAboveRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    public int getGroupBelowCoord(int n) {
        if (!this.m_bNumericAxis) {
            return this.getGroupBelowRelCoord(((double)n - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new AssertionException("Ordinal Axis method call on numerical axis");
    }

    private void initAxis() {
        if (this.m_bVertScale) {
            this.m_axisLengthVC = this.m_rFrame.height;
            this.m_axisOrgVC = this.m_rFrame.y;
        } else {
            this.m_axisLengthVC = this.m_rFrame.width;
            this.m_axisOrgVC = this.m_rFrame.x;
        }
    }

    private void initVariables(boolean bl, boolean bl2) {
        boolean bl3 = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY1Axis().getObjectID();
        boolean bl4 = this.m_template.getAxis().getObjectID() == this.m_Perspective.getY2Axis().getObjectID();
        this.m_bVertScale = bl;
        this.m_axisLengthVC = 0;
        this.m_axisOrgVC = 0;
        this.m_frameDepthOffset = this.m_Perspective.getFrameDepthOffset();
        this.m_bLabelStagger = this.m_Perspective.getLabelStagger(this.m_template.getLabel());
        this.m_rLegend = this.m_Perspective.getRect(new IdentObj(12));
        this.m_rTitle = this.m_Perspective.getRect(new IdentObj(5));
        this.m_rSubTitle = this.m_Perspective.getRect(new IdentObj(4));
        this.m_rFootnote = this.m_Perspective.getRect(new IdentObj(3));
        this.m_bDisplayOnCalc = bl2;
        this.m_rFrame = this.m_Perspective.getFrameRect(false);
        if ((bl3 || bl4) && this.m_Perspective.isGroupScrollerPresent()) {
            if (this.m_bVertScale) {
                int n = this.m_Perspective.m_VC.destToVirtHeight(8);
                this.m_rFrame.y += n;
                this.m_rFrame.height -= n;
            } else {
                int n = this.m_Perspective.m_VC.destToVirtWidth(12);
                this.m_rFrame.x += n;
                this.m_rFrame.width -= n;
            }
        }
    }

    Rectangle getFrameRect() {
        return this.m_rFrame;
    }

    protected boolean isPolarAxis() {
        return false;
    }

    protected double scaleToVC(double d) {
        double d2 = (double)this.m_axisOrgVC + d * (double)this.m_axisLengthVC;
        return d2;
    }

    private boolean hasDepth() {
        return this.m_Perspective.getDepthRadius() > 0;
    }

    protected void calcLineOnFrame(int n, double d, IdentObj identObj, BlackBoxIF blackBoxIF, int n2) {
        this.calcLineOnFrame(n, d, identObj, blackBoxIF, n2, Perspective.SOLID);
    }

    protected void calcLineOnFrame(int n, double d, IdentObj identObj, BlackBoxIF blackBoxIF, int n2, int n3) {
        block59: {
            boolean bl;
            boolean bl2;
            int n4;
            int n5;
            int n6;
            boolean bl3;
            boolean bl4;
            Rectangle rectangle;
            int n7;
            block58: {
                n7 = (int)this.scaleToVC(d);
                rectangle = new Rectangle(this.m_rFrame.x, this.m_rFrame.y, this.m_rFrame.width, this.m_rFrame.height);
                int n8 = this.getAxisSide();
                bl4 = n8 == 0 || n8 == 2;
                bl3 = n8 == 1 || n8 == 2;
                n6 = this.m_bVertScale ? rectangle.x : rectangle.y;
                n5 = (this.m_bVertScale ? rectangle.width : rectangle.height) + n6;
                n4 = 0;
                if (n2 > 1 && identObj.getObjectID() == 253) {
                    n4 = 100;
                }
                if (this.m_Perspective.getDepthRadius() == 0) {
                    if (this.m_frameDepthOffset.x == 0) {
                        bl2 = false;
                        bl = false;
                    } else {
                        bl2 = this.m_frameDepthOffset.x > 0;
                        bl = this.m_frameDepthOffset.x < 0;
                    }
                } else {
                    bl2 = this.m_frameDepthOffset.x >= 0;
                    boolean bl5 = bl = this.m_frameDepthOffset.x < 0;
                }
                if (!this.m_bDisplayOnCalc) {
                    return;
                }
                if (!this.m_bVertScale) break block58;
                rectangle.y -= 2000;
                rectangle.height += 4000;
                switch (n) {
                    case 0: {
                        IdentObj identObj2 = new IdentObj(identObj);
                        int n9 = identObj.getMiscID();
                        identObj2.setMiscID(0 + n9);
                        new DetLine(this.m_Perspective.getDetectiv(), identObj2, n6, n7 + n4, n5, n7 + n4, blackBoxIF, rectangle, n2, n3);
                        if (bl2) {
                            Rectangle rectangle2 = new Rectangle(n6 - this.m_frameDepthOffset.x, rectangle.y, this.m_frameDepthOffset.x, rectangle.height);
                            identObj2 = new IdentObj(identObj);
                            n9 = identObj.getMiscID();
                            identObj2.setMiscID(700 + n9);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj2, n6, n7, n6 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, blackBoxIF, rectangle2, n2, n3);
                            break;
                        }
                        if (bl) {
                            Rectangle rectangle3 = new Rectangle(n5, rectangle.y, -this.m_frameDepthOffset.x, rectangle.height);
                            identObj2 = new IdentObj(identObj);
                            n9 = identObj.getMiscID();
                            identObj2.setMiscID(800 + n9);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj2, n5, n7, n5 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, blackBoxIF, rectangle3, n2, n3);
                            break;
                        }
                        break block59;
                    }
                    case 1: {
                        Rectangle rectangle4;
                        IdentObj identObj3 = new IdentObj(identObj);
                        int n10 = identObj.getMiscID();
                        identObj3.setMiscID(0 + n10);
                        new DetLine(this.m_Perspective.getDetectiv(), identObj3, n6, n7, n5, n7, blackBoxIF, rectangle, n2, n3);
                        if (bl4) {
                            if (bl2) {
                                identObj3 = new IdentObj(identObj);
                                n10 = identObj.getMiscID();
                                identObj3.setMiscID(10700 + n10);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj3, n6, n7, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n6), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), blackBoxIF, null, n2, n3);
                            } else {
                                identObj3 = new IdentObj(identObj);
                                n10 = identObj.getMiscID();
                                identObj3.setMiscID(10000 + n10);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj3, n6, n7, n6 - 250, n7, blackBoxIF, null, n2, n3);
                            }
                        } else if (bl2) {
                            rectangle4 = new Rectangle(n6 - this.m_frameDepthOffset.x, rectangle.y, this.m_frameDepthOffset.x, rectangle.height);
                            identObj3 = new IdentObj(identObj);
                            n10 = identObj.getMiscID();
                            identObj3.setMiscID(700 + n10);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj3, n6, n7, n6 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, blackBoxIF, rectangle4, n2, n3);
                        }
                        if (bl3) {
                            if (bl) {
                                identObj3 = new IdentObj(identObj);
                                n10 = identObj.getMiscID();
                                identObj3.setMiscID(10800 + n10);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj3, n5, n7, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n5), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), blackBoxIF, null, n2, n3);
                                break;
                            }
                            identObj3 = new IdentObj(identObj);
                            n10 = identObj.getMiscID();
                            identObj3.setMiscID(10000 + n10);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj3, n5, n7, n5 + 250, n7, blackBoxIF, null, n2, n3);
                            break;
                        }
                        if (bl) {
                            rectangle4 = new Rectangle(n5, rectangle.y, -this.m_frameDepthOffset.x, rectangle.height);
                            identObj3 = new IdentObj(identObj);
                            n10 = identObj.getMiscID();
                            identObj3.setMiscID(800 + n10);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj3, n5, n7, n5 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, blackBoxIF, rectangle4, n2, n3);
                            break;
                        }
                        break block59;
                    }
                    case 2: {
                        int n11;
                        IdentObj identObj4;
                        if (bl4) {
                            if (bl2) {
                                identObj4 = new IdentObj(identObj);
                                n11 = identObj.getMiscID();
                                identObj4.setMiscID(10700 + n11);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj4, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n6), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n7), -this.m_frameDepthOffset.x + n6, -this.m_frameDepthOffset.y + n7, blackBoxIF, null, n2, n3);
                            } else {
                                identObj4 = new IdentObj(identObj);
                                n11 = identObj.getMiscID();
                                identObj4.setMiscID(10000 + n11);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj4, n6, n7, n6 + 250, n7, blackBoxIF, null, n2, n3);
                            }
                        }
                        if (bl3) {
                            if (bl) {
                                identObj4 = new IdentObj(identObj);
                                n11 = identObj.getMiscID();
                                identObj4.setMiscID(10800 + n11);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj4, n5 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n5), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n7), blackBoxIF, null, n2, n3);
                                break;
                            }
                            identObj4 = new IdentObj(identObj);
                            n11 = identObj.getMiscID();
                            identObj4.setMiscID(10000 + n11);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj4, n5, n7, n5 - 250, n7, blackBoxIF, null, n2, n3);
                            break;
                        }
                        break block59;
                    }
                    case 3: {
                        int n12;
                        IdentObj identObj5;
                        if (bl4) {
                            if (bl2) {
                                identObj5 = new IdentObj(identObj);
                                n12 = identObj.getMiscID();
                                identObj5.setMiscID(10700 + n12);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj5, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n6), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), -this.m_frameDepthOffset.x + n6, -this.m_frameDepthOffset.y + n7, blackBoxIF, null, n2, n3);
                            } else {
                                identObj5 = new IdentObj(identObj);
                                n12 = identObj.getMiscID();
                                identObj5.setMiscID(10000 + n12);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj5, n6, n7, n6 - 250, n7, blackBoxIF, null, n2, n3);
                            }
                        }
                        if (bl3) {
                            if (bl) {
                                identObj5 = new IdentObj(identObj);
                                n12 = identObj.getMiscID();
                                identObj5.setMiscID(10800 + n12);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj5, n5 - this.m_frameDepthOffset.x, n7 - this.m_frameDepthOffset.y, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n5), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), blackBoxIF, null, 0, n3);
                                break;
                            }
                            identObj5 = new IdentObj(identObj);
                            n12 = identObj.getMiscID();
                            identObj5.setMiscID(10000 + n12);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj5, n5, n7, n5 + 250, n7, blackBoxIF, null, n2, n3);
                            break;
                        }
                        break block59;
                    }
                    case 4: {
                        int n13;
                        IdentObj identObj6;
                        if (bl4) {
                            if (bl2) {
                                identObj6 = new IdentObj(identObj);
                                n13 = identObj.getMiscID();
                                identObj6.setMiscID(10700 + n13);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj6, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n6), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n6), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n7), blackBoxIF, null, n2, n3);
                            } else {
                                identObj6 = new IdentObj(identObj);
                                n13 = identObj.getMiscID();
                                identObj6.setMiscID(10000 + n13);
                                new DetLine(this.m_Perspective.getDetectiv(), identObj6, n6 + 250, n7, n6 - 250, n7, blackBoxIF, null, n2, n3);
                            }
                        }
                        if (!bl3) break;
                        if (bl) {
                            identObj6 = new IdentObj(identObj);
                            n13 = identObj.getMiscID();
                            identObj6.setMiscID(10800 + n13);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj6, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n5), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n7), (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n5), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n7), blackBoxIF, null, n2, n3);
                            break;
                        }
                        identObj6 = new IdentObj(identObj);
                        n13 = identObj.getMiscID();
                        identObj6.setMiscID(10000 + n13);
                        new DetLine(this.m_Perspective.getDetectiv(), identObj6, n5 - 250, n7, n5 + 250, n7, blackBoxIF, null, n2, n3);
                    }
                }
                break block59;
            }
            rectangle.x -= 2000;
            rectangle.width += 4000;
            switch (n) {
                case 0: {
                    IdentObj identObj7 = new IdentObj(identObj);
                    int n14 = identObj.getMiscID();
                    identObj7.setMiscID(0 + n14);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj7, n7 - n4, n6, n7 - n4, n5, blackBoxIF, rectangle, n2, n3);
                    if (!bl2 && !bl) break;
                    Rectangle rectangle5 = new Rectangle(rectangle.x - this.m_frameDepthOffset.x, n6 - this.m_frameDepthOffset.y, rectangle.width + this.m_frameDepthOffset.x, this.m_frameDepthOffset.y);
                    identObj7 = new IdentObj(identObj);
                    n14 = identObj.getMiscID();
                    identObj7.setMiscID(700 + n14);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj7, n7, n6, n7 - this.m_frameDepthOffset.x, n6 - this.m_frameDepthOffset.y, blackBoxIF, rectangle5, n2, n3);
                    break;
                }
                case 1: {
                    IdentObj identObj8 = new IdentObj(identObj);
                    int n15 = identObj.getMiscID();
                    identObj8.setMiscID(0 + n15);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj8, n7, n6, n7, n5, blackBoxIF, rectangle, n2, n3);
                    if (bl4) {
                        if (bl2 || bl) {
                            identObj8 = new IdentObj(identObj);
                            n15 = identObj.getMiscID();
                            identObj8.setMiscID(10700 + n15);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj8, n7, n6, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n7), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n6), blackBoxIF, null, n2, n3);
                        } else {
                            identObj8 = new IdentObj(identObj);
                            n15 = identObj.getMiscID();
                            identObj8.setMiscID(10000 + n15);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj8, n7, n6, n7, n6 - 250, blackBoxIF, null, n2, n3);
                        }
                    } else if (bl2 || bl) {
                        identObj8 = new IdentObj(identObj);
                        n15 = identObj.getMiscID();
                        identObj8.setMiscID(900 + n15);
                        new DetLine(this.m_Perspective.getDetectiv(), identObj8, n7, n6, n7 - this.m_frameDepthOffset.x, n6 - this.m_frameDepthOffset.y, blackBoxIF, null, n2, n3);
                    }
                    if (!bl3) break;
                    identObj8 = new IdentObj(identObj);
                    n15 = identObj.getMiscID();
                    identObj8.setMiscID(10800 + n15);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj8, n7, n5, n7, n5 + 250, blackBoxIF, null, n2, n3);
                    break;
                }
                case 2: {
                    int n16;
                    IdentObj identObj9;
                    if (bl4) {
                        if (bl2 || bl) {
                            identObj9 = new IdentObj(identObj);
                            n16 = identObj.getMiscID();
                            identObj9.setMiscID(10700 + n16);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj9, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n7), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n6), -this.m_frameDepthOffset.x + n7, -this.m_frameDepthOffset.y + n6, blackBoxIF, null, n2, n3);
                        } else {
                            identObj9 = new IdentObj(identObj);
                            n16 = identObj.getMiscID();
                            identObj9.setMiscID(10000 + n16);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj9, n7, n6, n7, n6 + 250, blackBoxIF, null, n2, n3);
                        }
                    }
                    if (!bl3) break;
                    identObj9 = new IdentObj(identObj);
                    n16 = identObj.getMiscID();
                    identObj9.setMiscID(10800 + n16);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj9, n7, n5, n7, n5 - 250, blackBoxIF, null, n2, n3);
                    break;
                }
                case 3: {
                    int n17;
                    IdentObj identObj10;
                    if (bl4) {
                        if (bl2 || bl) {
                            identObj10 = new IdentObj(identObj);
                            n17 = identObj.getMiscID();
                            identObj10.setMiscID(10700 + n17);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj10, -this.m_frameDepthOffset.x + n7, -this.m_frameDepthOffset.y + n6, (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n7), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n6), blackBoxIF, null, n2, n3);
                        } else {
                            identObj10 = new IdentObj(identObj);
                            n17 = identObj.getMiscID();
                            identObj10.setMiscID(10000 + n17);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj10, n7, n6, n7, n6 - 250, blackBoxIF, null, n2, n3);
                        }
                    }
                    if (!bl3) break;
                    identObj10 = new IdentObj(identObj);
                    n17 = identObj.getMiscID();
                    identObj10.setMiscID(10800 + n17);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj10, n7, n5, n7, n5 + 250, blackBoxIF, null, n2, n3);
                    break;
                }
                case 4: {
                    int n18;
                    IdentObj identObj11;
                    if (bl4) {
                        if (bl2 || bl) {
                            identObj11 = new IdentObj(identObj);
                            n18 = identObj.getMiscID();
                            identObj11.setMiscID(10700 + n18);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj11, (int)(-((double)this.m_frameDepthOffset.x) / 1.15 + (double)n7), (int)(-((double)this.m_frameDepthOffset.y) / 1.15 + (double)n6), (int)(-1.15 * (double)this.m_frameDepthOffset.x + (double)n7), (int)(-1.15 * (double)this.m_frameDepthOffset.y + (double)n6), blackBoxIF, null, n2, n3);
                        } else {
                            identObj11 = new IdentObj(identObj);
                            n18 = identObj.getMiscID();
                            identObj11.setMiscID(10000 + n18);
                            new DetLine(this.m_Perspective.getDetectiv(), identObj11, n7, n6 + 250, n7, n6 - 250, blackBoxIF, null, n2, n3);
                        }
                    }
                    if (!bl3) break;
                    identObj11 = new IdentObj(identObj);
                    n18 = identObj.getMiscID();
                    identObj11.setMiscID(10800 + n18);
                    new DetLine(this.m_Perspective.getDetectiv(), identObj11, n7, n5 - 250, n7, n5 + 250, blackBoxIF, null, n2, n3);
                }
            }
        }
    }

    protected void adjustLabelPos(int n, int n2, Vector vector) {
        boolean bl;
        boolean bl2 = bl = this.m_bLabelStagger && n2 > 1;
        if (bl) {
            boolean bl3 = false;
            Rectangle rectangle = (Rectangle)vector.elementAt(0);
            int n3 = vector.size();
            int n4 = 0;
            while (n4 < n3) {
                Rectangle rectangle2 = (Rectangle)vector.elementAt(n4);
                if (bl3) {
                    if (this.m_bVertScale) {
                        rectangle2.x = n == 0 ? rectangle.x - rectangle.width : rectangle.x + rectangle.width;
                    } else {
                        rectangle2.y = n == 0 ? rectangle.y - rectangle.height : rectangle.y + rectangle.height;
                    }
                }
                bl3 = !bl3;
                ++n4;
            }
        }
    }

    protected int getTitleJustVert(IdentObj identObj, int n) {
        return this.m_Perspective.getTextJustVert(identObj);
    }

    protected int getTitleJustHoriz(IdentObj identObj, int n) {
        return this.m_Perspective.getTextJustHoriz(identObj);
    }
}

