/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.managers;

import oracle.dss.dataView.DataviewCommon;
import oracle.dss.dataView.managers.RuleManager;
import oracle.dss.dataView.managers.ViewFormat;
import oracle.dss.graph.GraphFormatManager;
import oracle.dss.rules.Mergeable;
import oracle.dss.rules.ResolutionService;
import oracle.dss.rules.RuleBundle;
import oracle.dss.rules.RuleContext;
import oracle.dss.util.DataComponentInfo;
import oracle.dss.util.QDR;
import oracle.dss.util.xml.ObjectNode;

public class GraphRuleFormatter
extends RuleManager
implements GraphFormatManager {
    protected ViewFormat m_viewFormat;

    public void dataSourceChanged() {
    }

    private int _getPowerOfTen(double d) {
        int n;
        block4: {
            double d2;
            block3: {
                d2 = d >= 0.0 ? d : -d;
                n = 0;
                if (d2 < 1.0E-15) {
                    return 0;
                }
                if (!(d2 >= (double)10)) break block3;
                while (d2 >= (double)10) {
                    ++n;
                    d2 /= (double)10;
                }
                break block4;
            }
            if (!(d2 < 1.0)) break block4;
            while (d2 < 1.0) {
                --n;
                d2 *= (double)10;
            }
        }
        return n;
    }

    private int _getScaleFactorPowerOfTen(int n) {
        switch (n) {
            case 1: {
                return 3;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 12;
            }
            case 5: {
                return 15;
            }
        }
        return 0;
    }

    public String formatAxisValue(double d, ViewFormat viewFormat, double d2, double d3, int n, boolean bl) {
        ViewFormat viewFormat2;
        ViewFormat viewFormat3 = new ViewFormat();
        RuleContext ruleContext = new RuleContext();
        ruleContext.put("NUMBER_VALUE", new Double(d));
        ruleContext.put("COMPONENT_TYPE", new Integer(n));
        ruleContext.put("ISPERCENT", new Boolean(bl));
        double d4 = d3 < 0.0 && -d3 > d2 ? -d3 : d2;
        int n2 = this._getPowerOfTen(d4);
        if (bl) {
            n2 += 2;
            viewFormat3.setNumberType(2);
        } else if (n2 <= 1) {
            viewFormat3.setScaleFactor(0);
            viewFormat3.setDecimalDigit(1 - n2);
        } else if (n2 >= 16) {
            viewFormat3.setScaleFactor(5);
            viewFormat3.setDecimalDigit(0);
        } else {
            switch ((n2 - 1) / 3 * 3) {
                case 3: {
                    viewFormat3.setScaleFactor(1);
                    break;
                }
                case 6: {
                    viewFormat3.setScaleFactor(2);
                    break;
                }
                case 9: {
                    viewFormat3.setScaleFactor(3);
                    break;
                }
                case 12: {
                    viewFormat3.setScaleFactor(4);
                    break;
                }
                case 15: {
                    viewFormat3.setScaleFactor(5);
                    break;
                }
                default: {
                    viewFormat3.setScaleFactor(0);
                }
            }
            viewFormat3.setDecimalDigit(0);
        }
        viewFormat3.merge(viewFormat);
        viewFormat3.setView(viewFormat.getView());
        viewFormat3.setLocale(viewFormat.getLocale());
        try {
            viewFormat2 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat3, this.getBundles());
        }
        catch (ClassCastException classCastException) {
            String string = new Double(d).toString();
            return string;
        }
        if (viewFormat2 == null) {
            return new Double(d).toString();
        }
        return viewFormat2.DoubleToString(d);
    }

    public String formatAxisValue(double d, ViewFormat viewFormat, double d2, double d3, double d4, int n, boolean bl, boolean bl2, double d5) {
        boolean bl3;
        ViewFormat viewFormat2;
        ViewFormat viewFormat3 = new ViewFormat();
        if (bl) {
            viewFormat3.setNumberType(2);
        }
        viewFormat3.merge(viewFormat);
        viewFormat3.setView(viewFormat.getView());
        viewFormat3.setLocale(viewFormat.getLocale());
        RuleContext ruleContext = new RuleContext();
        ruleContext.put("NUMBER_VALUE", new Double(d));
        ruleContext.put("COMPONENT_TYPE", new Integer(n));
        ruleContext.put("ISPERCENT", new Boolean(bl));
        ViewFormat viewFormat4 = viewFormat2 = viewFormat3;
        try {
            if (this.m_bundles != null) {
                viewFormat2 = viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_bundles);
            }
            if (this.m_uiBundle != null && viewFormat2 != null) {
                viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_uiBundle);
            }
        }
        catch (ClassCastException classCastException) {
            String string = new Double(d).toString();
            return string;
        }
        if (viewFormat4 == null) {
            return new Double(d).toString();
        }
        boolean bl4 = !viewFormat4.isScaleFactorUsed();
        boolean bl5 = bl3 = !viewFormat4.isDecimalDigitUsed();
        if (!bl && (bl4 || bl3)) {
            if (!bl2) {
                this.formatLinearScaleAxisValue(d3, d2, d4, viewFormat4, bl4, bl3);
            } else {
                this.formatLogScaleAxisValue(d5, d, viewFormat4, bl4, bl3);
            }
        }
        return viewFormat4.DoubleToString(d);
    }

    protected void formatLinearScaleAxisValue(double d, double d2, double d3, ViewFormat viewFormat, boolean bl, boolean bl2) {
        int n;
        double d4 = d < 0.0 && -d > d2 ? -d : d2;
        int n2 = this._getPowerOfTen(d4);
        int n3 = viewFormat.getScaleFactor();
        int n4 = viewFormat.getDecimalDigit();
        if (bl) {
            if (n2 <= 1) {
                n3 = 0;
            } else if (n2 >= 16) {
                n3 = 5;
            } else {
                n = (n2 - 1) / 3 * 3;
                switch (n) {
                    case 3: {
                        n3 = 1;
                        break;
                    }
                    case 6: {
                        n3 = 2;
                        break;
                    }
                    case 9: {
                        n3 = 3;
                        break;
                    }
                    case 12: {
                        n3 = 4;
                        break;
                    }
                    case 15: {
                        n3 = 5;
                        break;
                    }
                    default: {
                        n3 = 0;
                    }
                }
            }
        }
        if (bl2) {
            double d5;
            int n5;
            n = this._getScaleFactorPowerOfTen(n3);
            n4 = n - (n5 = this._getPowerOfTen(d3));
            if (n4 < 0) {
                n4 = 0;
            }
            double d6 = d3;
            double d7 = d5 = d < d2 ? d : d2;
            if (n > 0) {
                d6 *= Math.pow(10.0, -n);
                d5 *= Math.pow(10.0, -n);
            }
            double d8 = 1.0;
            if (n4 > 0) {
                d8 = Math.pow(10.0, -n4);
            }
            double d9 = Math.rint(d6 / d8) * d8;
            double d10 = d6 - d9;
            double d11 = Math.rint(d5 / d8) * d8;
            double d12 = d5 - d11;
            if (Math.abs(d12) >= 0.1 * d8) {
                ++n4;
            } else if (Math.abs(d10) >= 0.001 * d8) {
                int n6;
                double d13;
                double d14 = d2 - d;
                if (d > d2) {
                    d14 = d - d2;
                }
                if ((d13 = Math.abs(d10 * (double)(n6 = (int)Math.floor(d14 / d3)) + d12)) >= 0.1 * d8) {
                    ++n4;
                }
            }
            if (bl) {
                while (n3 != 0 && n4 > 2) {
                    n4 -= 3;
                    switch (n3) {
                        case 1: {
                            n3 = 0;
                            break;
                        }
                        case 2: {
                            n3 = 1;
                            break;
                        }
                        case 3: {
                            n3 = 2;
                            break;
                        }
                        case 4: {
                            n3 = 3;
                            break;
                        }
                        case 5: {
                            n3 = 4;
                        }
                    }
                }
            }
        }
        if (bl) {
            viewFormat.setScaleFactor(n3);
        }
        if (bl2) {
            if (n4 >= 0) {
                viewFormat.setDecimalDigit(n4);
            } else {
                viewFormat.setDecimalDigit(0);
            }
        }
    }

    protected void formatLogScaleAxisValue(double d, double d2, ViewFormat viewFormat, boolean bl, boolean bl2) {
        if (d == (double)10 || d == Math.E) {
            if (bl) {
                if (d == (double)10 && d2 >= (double)1000) {
                    viewFormat.setScaleFactor(1);
                } else {
                    viewFormat.setScaleFactor(0);
                }
            }
            if (bl2) {
                int n = this._getPowerOfTen(d2);
                int n2 = this._getScaleFactorPowerOfTen(viewFormat.getScaleFactor());
                int n3 = n2 - n;
                if (n3 > 0) {
                    viewFormat.setDecimalDigit(n3);
                } else {
                    viewFormat.setDecimalDigit(0);
                }
            }
        } else if (d == (double)2) {
            if (bl) {
                viewFormat.setScaleFactor(0);
            }
            if (bl2) {
                int n;
                int n4;
                int n5 = (int)Math.rint(Math.log(d2) / Math.log(2.0));
                if (n5 > 0) {
                    n5 = 0;
                }
                if ((n4 = (n = this._getScaleFactorPowerOfTen(viewFormat.getScaleFactor())) - n5) > 0) {
                    viewFormat.setDecimalDigit(n4);
                } else {
                    viewFormat.setDecimalDigit(0);
                }
            }
        }
    }

    public String formatPieValue(double d, ViewFormat viewFormat, boolean bl, QDR qDR, boolean bl2) {
        ViewFormat viewFormat2;
        ViewFormat viewFormat3 = new ViewFormat();
        RuleContext ruleContext = new RuleContext();
        ruleContext.put("NUMBER_VALUE", new Double(d));
        ruleContext.put("ISPERCENT", new Boolean(bl));
        if (qDR != null) {
            ruleContext.put("QDR", qDR);
        }
        int n = this._getPowerOfTen(d);
        if (bl) {
            n += 2;
            viewFormat3.setNumberType(2);
        }
        if (n <= 0) {
            viewFormat3.setScaleFactor(0);
            viewFormat3.setDecimalDigit(3 - n);
        } else if (n <= 2) {
            viewFormat3.setScaleFactor(0);
            viewFormat3.setDecimalDigit(3 - n);
        } else if (n >= 16) {
            viewFormat3.setScaleFactor(5);
            if (n - 15 < 3) {
                viewFormat3.setDecimalDigit(3 - (n - 15));
            } else {
                viewFormat3.setDecimalDigit(0);
            }
        } else {
            int n2 = (n - 1) / 3 * 3;
            switch (n2) {
                case 3: {
                    viewFormat3.setScaleFactor(1);
                    break;
                }
                case 6: {
                    viewFormat3.setScaleFactor(2);
                    break;
                }
                case 9: {
                    viewFormat3.setScaleFactor(3);
                    break;
                }
                case 12: {
                    viewFormat3.setScaleFactor(4);
                    break;
                }
                case 15: {
                    viewFormat3.setScaleFactor(5);
                    break;
                }
                default: {
                    viewFormat3.setScaleFactor(0);
                }
            }
            viewFormat3.setDecimalDigit(3 - (n - n2));
        }
        viewFormat3.merge(viewFormat);
        viewFormat3.setView(viewFormat.getView());
        viewFormat3.setLocale(viewFormat.getLocale());
        ViewFormat viewFormat4 = viewFormat2 = viewFormat3;
        try {
            if (this.m_bundles != null) {
                viewFormat2 = viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_bundles);
            }
            if (this.m_uiBundle != null && viewFormat2 != null) {
                viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_uiBundle);
            }
        }
        catch (ClassCastException classCastException) {
            String string = new Double(d).toString();
            return string;
        }
        if (viewFormat4 == null) {
            return new Double(d).toString();
        }
        return viewFormat4.DoubleToString(d);
    }

    public String formatDataValue(double d, ViewFormat viewFormat, int n, int n2, int n3, boolean bl, QDR qDR, boolean bl2) {
        ViewFormat viewFormat2;
        ViewFormat viewFormat3 = new ViewFormat();
        RuleContext ruleContext = new RuleContext();
        ruleContext.put("NUMBER_VALUE", new Double(d));
        ruleContext.put("POSITION", new DataComponentInfo(n3, n2));
        ruleContext.put("COMPONENT_TYPE", new Integer(n));
        ruleContext.put("ISPERCENT", new Boolean(bl));
        if (qDR != null) {
            ruleContext.put("QDR", qDR);
        }
        int n4 = this._getPowerOfTen(d);
        if (bl) {
            n4 += 2;
            viewFormat3.setNumberType(2);
        }
        if (n4 <= 0) {
            viewFormat3.setScaleFactor(0);
            viewFormat3.setDecimalDigit(3 - n4);
        } else if (n4 <= 2) {
            viewFormat3.setScaleFactor(0);
            viewFormat3.setDecimalDigit(3 - n4);
        } else if (n4 >= 16) {
            viewFormat3.setScaleFactor(5);
            if (n4 - 15 < 3) {
                viewFormat3.setDecimalDigit(3 - (n4 - 15));
            } else {
                viewFormat3.setDecimalDigit(0);
            }
        } else {
            int n5 = (n4 - 1) / 3 * 3;
            switch (n5) {
                case 3: {
                    viewFormat3.setScaleFactor(1);
                    break;
                }
                case 6: {
                    viewFormat3.setScaleFactor(2);
                    break;
                }
                case 9: {
                    viewFormat3.setScaleFactor(3);
                    break;
                }
                case 12: {
                    viewFormat3.setScaleFactor(4);
                    break;
                }
                case 15: {
                    viewFormat3.setScaleFactor(5);
                    break;
                }
                default: {
                    viewFormat3.setScaleFactor(0);
                }
            }
            viewFormat3.setDecimalDigit(3 - (n4 - n5));
        }
        viewFormat3.merge(viewFormat);
        viewFormat3.setView(viewFormat.getView());
        viewFormat3.setLocale(viewFormat.getLocale());
        ViewFormat viewFormat4 = viewFormat2 = viewFormat3;
        try {
            if (this.m_bundles != null) {
                viewFormat2 = viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_bundles);
            }
            if (this.m_uiBundle != null && viewFormat2 != null) {
                viewFormat4 = (ViewFormat)ResolutionService.resolveRules(ruleContext, (Mergeable)viewFormat2, this.m_uiBundle);
            }
        }
        catch (ClassCastException classCastException) {
            String string = new Double(d).toString();
            return string;
        }
        if (viewFormat4 == null) {
            return new Double(d).toString();
        }
        return viewFormat4.DoubleToString(d);
    }

    public Object formatDataValue(DataviewCommon dataviewCommon, Object object, int n, int n2, int[] nArray, ViewFormat viewFormat) {
        return null;
    }

    public ObjectNode getXML(boolean bl, DataviewCommon dataviewCommon) {
        return this.getXML(bl, "FormatManager", dataviewCommon);
    }

    public void setUIBundle(DataviewCommon dataviewCommon, RuleBundle ruleBundle) {
        super.setUIBundle(dataviewCommon, ruleBundle);
        if (dataviewCommon != null) {
            dataviewCommon.dataFormatChanged();
            dataviewCommon.repaint();
        }
    }
}

