/*
 * Decompiled with CFR 0.152.
 */
package oracle.dss.graph.gui;

import java.awt.Color;
import java.awt.Font;
import oracle.dss.graph.UIGraphFont;

public class UIGraphFontAdapter
implements UIGraphFont {
    private Font m_font;
    private int fontStyle;
    private Color fontColor;
    private int fontSize;
    private String fontFace;
    private boolean fontBold;
    private boolean fontItalic;
    private boolean fontUnderline;
    private boolean fontStyleChanged;
    private boolean fontColorChanged;
    private boolean fontSizeChanged;
    private boolean fontTypefaceChanged;
    private boolean fontBoldChanged;
    private boolean fontItalicChanged;
    private boolean fontUnderlineChanged;

    public int getGraphFontStyle() {
        return this.fontStyle;
    }

    public void setGraphFontStyle(int n) {
        switch (n) {
            default: {
                this.setFontBold(false);
                this.setFontItalic(false);
                this.setUnderline(false);
                break;
            }
            case 1: {
                this.setFontBold(false);
                this.setFontItalic(true);
                this.setUnderlineChanged(false);
                break;
            }
            case 2: {
                this.setFontBold(true);
                this.setFontItalic(false);
                this.setUnderline(false);
                break;
            }
            case 3: {
                this.setFontBold(true);
                this.setFontItalic(true);
                this.setUnderline(false);
                break;
            }
            case 4: {
                this.setFontBold(false);
                this.setFontItalic(false);
                this.setUnderline(true);
                break;
            }
            case 5: {
                this.setFontBold(false);
                this.setFontItalic(true);
                this.setUnderline(true);
                break;
            }
            case 6: {
                this.setFontBold(true);
                this.setFontItalic(false);
                this.setUnderline(true);
                break;
            }
            case 7: {
                this.setFontBold(true);
                this.setFontItalic(true);
                this.setUnderline(true);
            }
        }
        this.setGraphFontStyleChanged(true);
        this.fontStyle = n;
    }

    public boolean isGraphFontStyleChanged() {
        return this.fontStyleChanged;
    }

    public void setGraphFontStyleChanged(boolean bl) {
        this.fontStyleChanged = bl;
    }

    public Color getGraphFontColor() {
        return this.fontColor;
    }

    public void setGraphFontColor(Color color) {
        this.setGraphFontColorChanged(true);
        this.fontColor = color;
    }

    public boolean isGraphFontColorChanged() {
        return this.fontColorChanged;
    }

    public void setGraphFontColorChanged(boolean bl) {
        this.fontColorChanged = bl;
    }

    public void setGraphFontSize(int n) {
        this.setGraphFontSizeChanged(true);
        this.fontSize = n;
    }

    public int getGraphFontSize() {
        return this.fontSize;
    }

    public boolean isGraphFontSizeChanged() {
        return this.fontSizeChanged;
    }

    public void setGraphFontSizeChanged(boolean bl) {
        this.fontSizeChanged = bl;
    }

    public void setGraphFontTypeface(String string) {
        this.setGraphFontTypefaceChanged(true);
        this.fontFace = string;
    }

    public String getGraphFontTypeface() {
        return this.fontFace;
    }

    public boolean isGraphFontTypefaceChanged() {
        return this.fontTypefaceChanged;
    }

    public void setGraphFontTypefaceChanged(boolean bl) {
        this.fontTypefaceChanged = bl;
    }

    public boolean isFontBold() {
        return this.fontBold;
    }

    public void setFontBold(boolean bl) {
        this.setFontBoldChanged(true);
        this.fontStyle = bl ? (this.fontStyle |= 2) : (this.fontStyle &= 0xFFFFFFFD);
        this.fontBold = bl;
    }

    public boolean isFontBoldChanged() {
        return this.fontBoldChanged;
    }

    public void setFontBoldChanged(boolean bl) {
        this.fontBoldChanged = bl;
    }

    public boolean isFontItalic() {
        return this.fontItalic;
    }

    public void setFontItalic(boolean bl) {
        this.setFontItalicChanged(true);
        this.fontStyle = bl ? (this.fontStyle |= 1) : (this.fontStyle &= 0xFFFFFFFE);
        this.fontItalic = bl;
    }

    public boolean isFontItalicChanged() {
        return this.fontItalicChanged;
    }

    public void setFontItalicChanged(boolean bl) {
        this.fontItalicChanged = bl;
    }

    public boolean isUnderline() {
        return this.fontUnderline;
    }

    public void setUnderline(boolean bl) {
        this.setUnderlineChanged(true);
        this.fontStyle = bl ? (this.fontStyle |= 4) : (this.fontStyle &= 0xFFFFFFFB);
        this.fontUnderline = bl;
    }

    public boolean isUnderlineChanged() {
        return this.fontUnderlineChanged;
    }

    public void setUnderlineChanged(boolean bl) {
        this.fontUnderlineChanged = bl;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        int n = 0;
        switch (font.getStyle()) {
            case 0: {
                n = 0;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 3;
                break;
            }
        }
        int n2 = this.getGraphFontStyle() & 4 | n;
        this.setGraphFontSize(font.getSize());
        this.setGraphFontStyle(n2);
        this.setGraphFontTypeface(font.getName());
    }

    public Font getFont() {
        int n = 0;
        switch (this.getGraphFontStyle()) {
            case 0: 
            case 4: {
                n = 0;
                break;
            }
            case 2: 
            case 6: {
                n = 1;
                break;
            }
            case 1: 
            case 5: {
                n = 2;
                break;
            }
            case 3: 
            case 7: {
                n = 3;
                break;
            }
        }
        return new Font(this.getGraphFontTypeface(), n, this.getGraphFontSize());
    }

    protected void cleanUp() {
        this.m_font = null;
        this.fontColor = null;
        this.fontFace = null;
    }
}

